/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.core.business;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ArrayStatusNotOkException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class CoreUIBusObject {
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject;

    public void setJobDesc(MethodCallStatus mcs, String desc) {
        ArrayList jobs = mcs.getJobs();
        if (jobs != null) {
            for (int i = 0; i < jobs.size(); ++i) {
                try {
                    JobInterface job = (JobInterface)jobs.get(i);
                    Trace.verbose((Object)this, (String)"setJobDesc", (String)desc);
                    job.setDescription(desc);
                    job.save();
                    job.reload();
                    jobs.set(i, job);
                    continue;
                }
                catch (Exception e) {
                    Trace.verbose((Object)this, (String)"setJobDesc", (Throwable)e);
                }
            }
            mcs.setJobs((List)jobs);
        }
    }

    public boolean hasErrorsInMethodCallStatuses(List methodCallStatuses) {
        String methodName = "hasErrorsInMethodCallStatuses";
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject = CoreUIBusObject.class$("com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject")) : class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject), (String)methodName);
        for (int i = 0; i < methodCallStatuses.size(); ++i) {
            if (!this.hasErrorsInMethodCallStatus((MethodCallStatus)methodCallStatuses.get(i))) continue;
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject = CoreUIBusObject.class$("com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject")) : class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject), (String)methodName, (String)"Found errors in status object!");
            return true;
        }
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject = CoreUIBusObject.class$("com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject")) : class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject), (String)methodName, (String)"No errors found in status objects");
        return false;
    }

    public boolean hasErrorsInMethodCallStatus(MethodCallStatus status) {
        String methodName = "hasErrorsInMethodCallStatus";
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject = CoreUIBusObject.class$("com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject")) : class$com$sun$netstorage$array$mgmt$cfg$ui$core$business$CoreUIBusObject), (String)methodName);
        if (status == null) {
            return false;
        }
        return status != null && status.getReturnCode() != 0;
    }

    public void handleNotification(List statuses, String email) throws ConfigMgmtException {
        String methodName = "handleNotification";
        Trace.methodBegin((Object)this, (String)methodName);
        for (int i = 0; i < statuses.size(); ++i) {
            ArrayList jobs;
            MethodCallStatus currentStatus = (MethodCallStatus)statuses.get(i);
            int returnCode = currentStatus.getReturnCode();
            if (returnCode != 0 || email == null || (jobs = currentStatus.getJobs()) == null) continue;
            for (int j = 0; j < jobs.size(); ++j) {
                JobInterface job = (JobInterface)jobs.get(j);
                if (job.getPercentComplete() == 100) continue;
                job.setNotifyEmail(email);
            }
        }
    }

    public void validateName(String name) throws BadParameterException {
        String methodName = "validateName";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to validate name = " + name));
        Validate.objectName(null, (String)name);
        Validate.validateNameLength((String)name, (int)this.getAllowedNameLength());
    }

    public void validateDescription(String desc, String objectName) throws BadParameterException {
        String methodName = "validateDescription";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to validate desc = " + desc));
        if (desc == null || desc.trim().length() == 0 && desc.length() <= this.getAllowedDescLength(objectName)) {
            return;
        }
        Validate.validateNameLength((String)desc, (int)this.getAllowedDescLength(objectName), (String)"error.bizobj.descriptionTooLongMaxLength");
        if (objectName == null) {
            Validate.objectName((String)Validate.ARRAY_DESC_OBJECT, (String)desc);
        } else {
            Validate.objectName((String)objectName, (String)desc);
        }
    }

    public String getIllegalNameCharacterPattern() {
        return ".*[,]+.*";
    }

    public String getIllegalDescCharacterPattern() {
        return ".*[&]+.*";
    }

    public int getAllowedNameLength() {
        return 16;
    }

    public int getAllowedDescLength(String objectName) {
        int maxLength = 16;
        if (objectName != null) {
            if (objectName.equals(Validate.ARRAY_DESC_OBJECT)) {
                maxLength = 39;
            } else if (objectName.equals(Validate.INITIATOR_DESC_OBJECT)) {
                maxLength = 64;
            }
        }
        return maxLength;
    }

    public T4Interface findArrayByName(ConfigContext configContext, String name) throws ItemNotFoundException, ArrayStatusNotOkException, ConfigMgmtException {
        T4s arrayBizObj = new T4s();
        T4Interface array = arrayBizObj.getArrayByName(configContext, name);
        if (array == null) {
            throw new ItemNotFoundException(name);
        }
        if (array.getHealthStatus() != 2) {
            throw new ArrayStatusNotOkException(array.getHealthStatus() + "");
        }
        return array;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

