/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.core.action;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.actions.RARPEntry;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.CoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import com.sun.netstorage.array.mgmt.cfg.util.RARPUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;

public abstract class AdminCoreAction
extends CoreAction {
    private static String MENU_ITEM = ".item3";

    protected String getMenuItemId() {
        return MENU_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        return MenuData.ROOT_MENU + this.getMenuItemId() + this.getMenuSubItemId();
    }

    protected void checkForActiveJobs(HttpServletRequest argReq, UserMessages messages, ArrayList arrayNames) {
        try {
            ConfigContext configContext = this.getConfigContext(argReq);
            Jobs jobs = (Jobs)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs");
            List jobList = jobs.getOutstandingJobsListForArrays(configContext, arrayNames);
            int cnt = jobList == null ? 0 : jobList.size();
            Trace.verbose((Object)((Object)this), (String)"checkForActiveJobs", (String)("There are " + cnt + " active jobs"));
            if (cnt > 0) {
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(1, "admin.general.activejobswarning"));
                this.setListContext(argReq, "ActiveJobList", jobList);
            } else {
                argReq.getSession().removeAttribute("ActiveJobList");
            }
        }
        catch (ConfigMgmtException cme) {
            this.handleSystemError(argReq, cme);
        }
    }

    protected void checkForActiveUsers(HttpServletRequest argReq, UserMessages messages) {
        Trace.methodBegin((Object)((Object)this), (String)"checkForActiveUsers");
        ConfigContext configContext = this.getConfigContext(argReq);
        Admin admin = (Admin)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Admin");
        List activeUserList = admin.getActiveUsersList(configContext);
        int cnt = activeUserList == null ? 0 : activeUserList.size();
        Trace.verbose((Object)((Object)this), (String)"checkForActiveUsers", (String)("There are " + cnt + " active users"));
        if (cnt > 1) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(1, "admin.general.activeuserswarning"));
            argReq.getSession().setAttribute("ActiveUsersListProperty", (Object)activeUserList);
        } else {
            argReq.getSession().removeAttribute("ActiveUsersListProperty");
        }
    }

    protected void checkForRarpEntries(HttpServletRequest argReq, UserMessages messages, ArrayList arrays) {
        Trace.methodBegin((Object)((Object)this), (String)"checkForRarpEntries");
        ConfigContext configContext = this.getConfigContext(argReq);
        boolean resetLabelsOnAllArrays = true;
        ArrayList<RARPEntry> rarpEntries = new ArrayList<RARPEntry>();
        String badIpList = "";
        if (arrays != null && arrays.size() > 0) {
            Iterator t4iterator = arrays.iterator();
            while (t4iterator.hasNext()) {
                T4Interface t4 = (T4Interface)t4iterator.next();
                String t4hostName = t4.getName();
                String t4ip = IPUtil.lookUpIP((String)t4hostName);
                String t4mac = RARPUtil.searchEthersFile((int)1, (String)t4hostName);
                if (!t4.isFeatureSupported(6)) {
                    rarpEntries.add(new RARPEntry(t4ip, t4mac));
                }
                if (t4mac != null || t4.isFeatureSupported(6)) continue;
                resetLabelsOnAllArrays = false;
                badIpList = badIpList + " " + t4ip + ",";
            }
        }
        if (rarpEntries.size() > 0) {
            if (!resetLabelsOnAllArrays) {
                badIpList = badIpList.substring(0, badIpList.length() - 1);
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(1, "admin.general.rarpentrieswarning", badIpList));
            }
            argReq.getSession().setAttribute("RarpEntryList", rarpEntries);
        } else {
            argReq.getSession().removeAttribute("RarpEntryList");
        }
    }

    protected String[] parseTokens(String string, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(string, delimiters);
        String[] result = new String[tokenizer.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tokenizer.nextToken().trim();
        }
        return result;
    }
}

