/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.access.business.BindingInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ArrayStatusNotOkException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.BOComparators;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Bindings;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class Volumes
extends CoreUIBusObject {
    private ManageStorageVolumesInterface manageVolInt = ManageStorageVolumesFactory.getManager();

    public List list(ConfigContext configContext, SearchFilter searchFilter) throws ConfigMgmtException {
        this.manageVolInt.init(configContext, searchFilter);
        return this.manageVolInt.getItemList();
    }

    public List listByArray(ConfigContext configContext, T4Interface array) throws ConfigMgmtException {
        return this.list(configContext, null, array);
    }

    public List listByArrayName(ConfigContext context, String arrayName) throws Exception {
        return this.list(context, null, this.findArrayByName(context, arrayName));
    }

    public List list(TrayInterface tray) {
        String methodName = "list";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayList allVolumesInTray = new ArrayList();
        try {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to get list of volumes for tray = " + tray.getId()));
            List pools = tray.getRaidGroups();
            for (int j = 0; j < pools.size(); ++j) {
                RaidGroupInterface pool = (RaidGroupInterface)pools.get(j);
                List volumes = pool.getVolumes();
                allVolumesInTray.addAll(volumes);
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)this, (String)("Exception trying to get a list of volumes for tray = " + tray.getId()), (Throwable)ex);
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Returning all volumes in tray; size = " + allVolumesInTray.size()));
        return allVolumesInTray;
    }

    public List list(ConfigContext configContext, SearchFilter searchFilter, T4Interface currentT4) throws ConfigMgmtException {
        this.manageVolInt.setScope((InstanceWrapper)currentT4);
        return this.list(configContext, searchFilter);
    }

    public List list(int[] array, List volumesList) {
        String methodName = "list(array, list)";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayList<StorageVolumeInterface> volumes = new ArrayList<StorageVolumeInterface>();
        if (volumesList == null || array == null) {
            Trace.verbose((Object)this, (String)methodName, (String)"No index array or volume list given");
            return volumes;
        }
        try {
            Trace.verbose((Object)this, (String)methodName, (String)("Volume list size = " + volumesList.size()));
            for (int i = 0; i < array.length; ++i) {
                Trace.verbose((Object)this, (String)methodName, (String)("Trying to get volume at index = " + array[i]));
                StorageVolumeInterface vol = (StorageVolumeInterface)volumesList.get(array[i]);
                volumes.add(vol);
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)this, (String)"Exception trying to get volumes list", (Throwable)ex);
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Returning " + volumes.size() + " volumes"));
        return volumes;
    }

    public int[] getAvailableLUNNumbers(ConfigContext context, T4Interface currentT4) throws CoreUIBusException {
        try {
            this.manageVolInt.init(context, null);
            return this.manageVolInt.getAvailableLUNNumbers(currentT4);
        }
        catch (Exception e) {
            throw new CoreUIBusException(e.toString());
        }
    }

    public MethodCallStatus createVolume(ConfigContext context, String name, String arrayName, String poolName, BigInteger size, String volumePermissions, int lun, String volumeGroup) throws Exception {
        String methodName = "createVolume";
        Trace.methodBegin((Object)this, (String)methodName);
        this.validateName(name);
        this.checkRequestedVolumeSize(size);
        T4Interface array = this.findArrayByName(context, arrayName);
        List volumes = this.list(context, null, array);
        this.checkIfVolumeCountOverMax(array, volumes);
        try {
            if (this.findNamedVolume(name, volumes) != null) {
                throw new BadParameterException(name, "error.resourceAlreadyExists");
            }
        }
        catch (ItemNotFoundException e) {
            Trace.verbose((Object)this, (String)methodName, (String)(name + " is not current used, so it is a valid name."));
        }
        StoragePools poolsBizObj = new StoragePools();
        RaidGroupInterface pool = poolsBizObj.findPool(context, arrayName, poolName);
        if (pool == null) {
            throw new ItemNotFoundException(poolName);
        }
        this.checkIfEnoughStorageCapacityAvailable(size, pool);
        lun = this.validateLun(context, lun, array);
        this.manageVolInt.init(context, null);
        MethodCallStatus mcs = this.manageVolInt.createVolume(name, arrayName, poolName, size, volumePermissions, lun, volumeGroup);
        return mcs;
    }

    private int validateLun(ConfigContext context, int lun, T4Interface array) throws CoreUIBusException, BadParameterException {
        int[] availableLUNs = this.getAvailableLUNNumbers(context, array);
        boolean lunFound = false;
        if (availableLUNs != null) {
            if (lun < 0 && availableLUNs.length > 0) {
                lun = availableLUNs[0];
                lunFound = true;
            }
            for (int i = 0; i < availableLUNs.length && !lunFound; ++i) {
                if (availableLUNs[i] != lun) continue;
                lunFound = true;
            }
        }
        if (!lunFound) {
            throw new BadParameterException(new Integer(lun).toString(), "error.lunUnavailable");
        }
        return lun;
    }

    public void checkIfEnoughStorageCapacityAvailable(BigInteger requestedSize, RaidGroupInterface pool) throws ConfigMgmtException, BadParameterException {
        if (requestedSize.compareTo(pool.getAvailableCapacity()) > 0) {
            throw new BadParameterException(requestedSize.toString(), "error.insufficientDiskSpace");
        }
    }

    public void checkRequestedVolumeSize(BigInteger size) throws BadParameterException {
        if (size.compareTo(Constants.StorageSize.MIN_VOLUME_SIZE) < 0) {
            throw new BadParameterException(size.toString(), "error.volumes.volumeSizeTooSmall");
        }
    }

    public void checkIfVolumeCountOverMax(T4Interface array, List volumes) throws BadParameterException, ConfigMgmtException {
        if (volumes != null && volumes.size() > array.getMaxNumberOfVolumes()) {
            throw new BadParameterException("", "error.volumes.numberOfVolumexExceededMaximum");
        }
    }

    public void removeFromVolumeGroup(ConfigContext configContext, StorageVolumeInterface volumeInterface, String volumeGroup) throws Exception {
        VolumeGroups volGroupBusObj = new VolumeGroups();
        VolumeGroupInterface volumeGroupInterface = volGroupBusObj.getVolumeGroupInterface(configContext, this.findArrayByName(configContext, volumeInterface.getT4Name()), volumeGroup);
        volumeGroupInterface.deleteVolumeFromGroup(volumeInterface);
        Trace.verbose((Object)this, (String)"removeFromVolumeGroup", (String)("Removed volume = " + volumeInterface.getName() + " from volume group = " + volumeGroupInterface.getName()));
    }

    public void addToVolumeGroups(ConfigContext configContext, StorageVolumeInterface volumeInterface, String[] volumeGroups) throws ConfigMgmtException, ItemNotFoundException, ArrayStatusNotOkException {
        VolumeGroups volGroupBusObj = new VolumeGroups();
        for (int i = 0; i < volumeGroups.length; ++i) {
            VolumeGroupInterface volumeGroupInterface = volGroupBusObj.getVolumeGroupInterface(configContext, this.findArrayByName(configContext, volumeInterface.getT4Name()), volumeGroups[i]);
            volumeGroupInterface.addVolumeToGroup(volumeInterface);
            Trace.verbose((Object)this, (String)"addToVolumeGroup", (String)("Added volume = " + volumeInterface.getName() + " to volume group = " + volumeGroupInterface.getName()));
        }
    }

    public List deleteItems(List storageVolumeInterfaces, int[] selectedItems) throws ConfigMgmtException {
        ArrayList<MethodCallStatus> returnStatuses = new ArrayList<MethodCallStatus>();
        for (int i = 0; i < selectedItems.length; ++i) {
            StorageVolumeInterface svi = (StorageVolumeInterface)storageVolumeInterfaces.get(selectedItems[i]);
            svi.removeFromAllGroups();
            MethodCallStatus statusResult = svi.delete();
            returnStatuses.add(statusResult);
            if (statusResult.getReturnCode() == 0) continue;
            return returnStatuses;
        }
        return returnStatuses;
    }

    public List deleteItems(List storageVolumeInterfaces) throws ConfigMgmtException {
        Trace.methodBegin((Object)this, (String)"deleteItems; 1 param");
        ArrayList<MethodCallStatus> returnStatuses = new ArrayList<MethodCallStatus>();
        for (int i = 0; i < storageVolumeInterfaces.size(); ++i) {
            StorageVolumeInterface svi = (StorageVolumeInterface)storageVolumeInterfaces.get(i);
            svi.removeFromAllGroups();
            String volName = svi.getName();
            MethodCallStatus statusResult = svi.delete();
            returnStatuses.add(statusResult);
            if (statusResult.getReturnCode() == 0) continue;
            return returnStatuses;
        }
        return returnStatuses;
    }

    public MethodCallStatus delete(StorageVolumeInterface volume) throws ConfigMgmtException {
        Trace.methodBegin((Object)this, (String)"delete(volume)");
        volume.removeFromAllGroups();
        String name = volume.getName();
        Trace.verbose((Object)this, (String)"delete(volume)", (String)("Trying to delete volume = " + name));
        MethodCallStatus mcs = volume.delete();
        return mcs;
    }

    public void deleteVolume(ConfigContext context, String arrayName, String volumeName) throws Exception {
        String methodName = "delete";
        Trace.methodBegin((Object)this, (String)"delete");
        T4Interface array = this.findArrayByName(context, arrayName);
        Trace.verbose((Object)this, (String)methodName, (String)("Got the array = " + arrayName));
        this.manageVolInt.setScope((InstanceWrapper)array);
        List volumes = this.listByArray(context, array);
        if (volumes != null) {
            Trace.verbose((Object)this, (String)methodName, (String)"Got the list of volumes for the given array");
            StorageVolumeInterface volume = this.findNamedVolume(volumeName, volumes);
            Trace.verbose((Object)this, (String)methodName, (String)("Found volume with the given name = " + volumeName));
            volume.removeFromAllGroups();
            volume.delete();
        }
    }

    public StorageVolumeInterface findNamedVolume(String name, List toFilter) throws ItemNotFoundException {
        StorageVolumeInterface volume = null;
        volume = (StorageVolumeInterface)FilterUtil.findNamedObject((String)name, (List)toFilter, (NameBasedComparator)BOComparators.VOLUME_COMPARATOR);
        if (volume == null) {
            throw new ItemNotFoundException(name);
        }
        return volume;
    }

    public void modifyVolume(ConfigContext context, String arrayName, String oldName, String newName, String volumePermissions) throws Exception {
        Trace.methodBegin((Object)this, (String)"modify");
        T4Interface array = this.findArrayByName(context, arrayName);
        List volumeList = this.listByArray(context, array);
        StorageVolumeInterface storageVolumeInterface = this.findNamedVolume(oldName, volumeList);
        storageVolumeInterface.setVolumePermissions(volumePermissions);
        storageVolumeInterface.save();
    }

    public Enumeration getAffectedVolumesForInitiatorRemoval(ConfigContext config, T4Interface t4, InitiatorGroupInterface ig) throws Exception {
        String methodName = "getAffectedVolumesForInitiatorRemoval";
        Trace.methodBegin((Object)this, (String)methodName);
        Bindings bindBusObj = new Bindings();
        List allBindings = bindBusObj.listForIg(config, null, ig);
        Hashtable<String, StorageVolumeInterface> affectedVols = new Hashtable<String, StorageVolumeInterface>();
        for (int i = 0; i < allBindings.size(); ++i) {
            BindingInterface bi = (BindingInterface)allBindings.get(i);
            VolumeGroupInterface vgi = bi.getVolumeGroup();
            List volumes = vgi.getVolumes();
            if (volumes == null) continue;
            for (int j = 0; j < volumes.size(); ++j) {
                StorageVolumeInterface vol = (StorageVolumeInterface)volumes.get(j);
                affectedVols.put(vol.getName(), vol);
            }
        }
        return affectedVols.keys();
    }

    public StorageVolumeInterface getVolumeByName(ConfigContext context, T4Interface array, String name) throws ItemNotFoundException, ConfigMgmtException {
        String methodName = "getVolumeByName";
        Trace.methodBegin((Object)this, (String)methodName);
        List volumes = this.list(context, null, array);
        Trace.verbose((Object)this, (String)methodName, (String)("Searching for volumes with name = " + name));
        StorageVolumeInterface volume = this.findNamedVolume(name, volumes);
        Trace.verbose((Object)this, (String)methodName, (String)"Found volume with given name!");
        return volume;
    }

    public List getVolumesWithNoMembership(ConfigContext context, T4Interface array) throws ConfigMgmtException {
        ManageStorageVolumesInterface manageVolInt = ManageStorageVolumesFactory.getManager();
        manageVolInt.setRestriction(0);
        manageVolInt.setScope((InstanceWrapper)array);
        manageVolInt.init(context, null);
        return manageVolInt.getItemList();
    }

    public int getAllowedNameLength() {
        return 12;
    }
}

