/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.access.business.BindingInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageVolumeGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageVolumeGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.MultipleMembershipNotAllowed;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.BOComparators;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Bindings;
import com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroupWrapper;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;

public class VolumeGroups
extends CoreUIBusObject {
    private ManageVolumeGroupsInterface manageVolGroupInt = ManageVolumeGroupsFactory.getManager();

    public List list(ConfigContext configContext, SearchFilter searchFilter) throws ConfigMgmtException {
        this.manageVolGroupInt.init(configContext, searchFilter);
        return this.manageVolGroupInt.getItemList();
    }

    public List listForArray(ConfigContext configContext, T4Interface array) throws ConfigMgmtException {
        this.manageVolGroupInt.setScope((InstanceWrapper)array);
        this.manageVolGroupInt.init(configContext, null);
        return this.manageVolGroupInt.getItemList();
    }

    public int indexFromName(String name, List list) throws IndexOutOfBoundsException {
        if (list == null || name == null) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!name.equals(((VolumeGroupInterface)list.get(i)).getName())) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean volumeGroupExists(ConfigContext context, String vgName, T4Interface array) {
        String methodName = "volumeGroupExists";
        Trace.methodBegin((Object)this, (String)methodName);
        boolean exists = false;
        try {
            exists = CIMObjectWrapper.doesNamedInstanceExistByIpAddr((CIMOMHandleWrapper)context.getClient(), (String)array.getClusterName(), (String)"SunStorEdge_6120AuthorizationViewSCSIController", (String)vgName);
        }
        catch (Exception cme) {
            Trace.verbose((Object)this, (String)"Error trying to determine if volume group exists; return false", (Throwable)cme);
            exists = false;
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Result if " + vgName + " exists: " + exists));
        return exists;
    }

    public VolumeGroupInterface getVolumeGroupInterface(ConfigContext configContext, T4Interface array, String name) throws ConfigMgmtException, ItemNotFoundException {
        String methodName = "getVolumeGroupInterface(array,name)";
        Trace.methodBegin((Object)this, (String)methodName);
        VolumeGroupInterface vgi = null;
        try {
            List volumeGroupList = this.listForArray(configContext, array);
            vgi = (VolumeGroupInterface)FilterUtil.findNamedObject((String)name, (List)volumeGroupList, (NameBasedComparator)BOComparators.VOLUME_GROUP_COMPARATOR);
            if (vgi == null) {
                Trace.verbose((Object)this, (String)methodName, (String)("Volume Group; " + name + " not found"));
                throw new ItemNotFoundException(name);
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)this, (String)"Exception trying to get vg by name", (Throwable)ex);
            throw new ItemNotFoundException(name);
        }
        return vgi;
    }

    public void removeVolumeFromGroup(VolumeGroupInterface volumeGroup, StorageVolumeInterface volume) throws ConfigMgmtException {
        String methodName = "removeVolumeFromGroup";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to remove volume " + volume.getName() + " from volume group " + volumeGroup.getName()));
        volumeGroup.deleteVolumeFromGroup(volume);
    }

    public void removeVolumesToGroup(VolumeGroupInterface volGroup, List volumesList) throws ConfigMgmtException {
        String methodName = "removeVolumesToGroup";
        Trace.methodBegin((Object)this, (String)methodName);
        if (volumesList != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to remove " + volumesList.size() + " from the volume group " + volGroup.getName()));
            for (int i = 0; i < volumesList.size(); ++i) {
                this.removeVolumeFromGroup(volGroup, (StorageVolumeInterface)volumesList.get(i));
            }
        }
    }

    public void addVolumeToGroup(VolumeGroupInterface volGroup, StorageVolumeInterface volume) throws ConfigMgmtException {
        String methodName = "addVolumeToGroup";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to add volume " + volume.getName() + " to volume group " + volGroup.getName()));
        volGroup.addVolumeToGroup(volume);
    }

    public void addVolumesToGroup(VolumeGroupInterface volGroup, List volumesList) throws ConfigMgmtException, MultipleMembershipNotAllowed {
        String methodName = "addVolumesToGroup";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayList<String> volumesAlreadyMembers = null;
        MultipleMembershipNotAllowed lmme = null;
        if (volumesList != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to add " + volumesList.size() + " to the volume group " + volGroup.getName()));
            for (int i = 0; i < volumesList.size(); ++i) {
                try {
                    this.addVolumeToGroup(volGroup, (StorageVolumeInterface)volumesList.get(i));
                    continue;
                }
                catch (MultipleMembershipNotAllowed mme) {
                    lmme = mme;
                    if (volumesAlreadyMembers == null) {
                        volumesAlreadyMembers = new ArrayList<String>();
                    }
                    volumesAlreadyMembers.add(((StorageVolumeInterface)volumesList.get(i)).getName());
                }
            }
        }
        if (volumesAlreadyMembers != null) {
            String[] volMem = new String[volumesAlreadyMembers.size()];
            for (int i = 0; i < volumesAlreadyMembers.size(); ++i) {
                volMem[i] = (String)volumesAlreadyMembers.get(i);
            }
            throw new MultipleMembershipNotAllowed("multiple.membership.exception", volMem, "Multiple membership", lmme);
        }
    }

    public void delete(VolumeGroupInterface volGroup) throws ConfigMgmtException {
        String methodName = "delete(VolumeGroup)";
        Trace.methodBegin((Object)this, (String)methodName);
        if (volGroup != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to delete volume group = " + volGroup.getName()));
            volGroup.delete();
        }
    }

    public void delete(ConfigContext context, String volGroupName, String arrayName) throws Exception {
        String methodName = "delete(context, String, String)";
        Trace.methodBegin((Object)this, (String)methodName);
        T4Interface array = this.findArrayByName(context, arrayName);
        if (array != null) {
            if (!this.volumeGroupExists(context, volGroupName, array)) {
                Trace.verbose((Object)this, (String)methodName, (String)"Volume group doesn't exists");
                throw new ItemNotFoundException(volGroupName);
            }
            Trace.verbose((Object)this, (String)methodName, (String)"Found volume group to delete");
            this.delete(this.getVolumeGroupInterface(context, array, volGroupName));
        }
    }

    public void delete(List groups) throws ConfigMgmtException {
        String methodName = "delete(List)";
        Trace.methodBegin((Object)this, (String)methodName);
        if (groups != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to delete " + groups.size() + " volume groups"));
            for (int i = 0; i < groups.size(); ++i) {
                VolumeGroupInterface volGrp = (VolumeGroupInterface)groups.get(i);
                volGrp.delete();
            }
        }
    }

    public void createVolumeGroup(ConfigContext context, String name, T4Interface t4, List volumes, List initiatorGroups, List access) throws Exception {
        String methodName = "createVolumeGroup";
        Trace.methodBegin((Object)this, (String)methodName);
        this.validateName(name);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to create new volume group = " + name));
        if (this.volumeGroupExists(context, name, t4)) {
            Trace.verbose((Object)this, (String)methodName, (String)"Volume group already exists!");
            throw new BadParameterException(name, "error.resourceAlreadyExists");
        }
        this.manageVolGroupInt.init(context, null);
        this.manageVolGroupInt.createVolumeGroup(name, t4, volumes, initiatorGroups, access);
    }

    public List getVgsToAssociate(ConfigContext context, InitiatorGroupInterface ig, T4Interface array) throws Exception {
        String methodName = "getVgsToAssociate";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("current array to get bindings for = " + array.getName()));
        Bindings bindingBusObj = new Bindings();
        List allVGs = this.listForArray(context, array);
        List currentBindings = bindingBusObj.listForIg(context, null, ig);
        for (int i = allVGs.size() - 1; i >= 0; --i) {
            VolumeGroupInterface vg = (VolumeGroupInterface)allVGs.get(i);
            for (int j = 0; j < currentBindings.size(); ++j) {
                BindingInterface bind = (BindingInterface)currentBindings.get(j);
                VolumeGroupInterface vgInBind = bind.getVolumeGroup();
                Trace.verbose((Object)this, (String)methodName, (String)("VG = " + vg.getName()));
                Trace.verbose((Object)this, (String)methodName, (String)("VG in bind = " + vgInBind.getName()));
                if (!vgInBind.getName().equals(vg.getName())) continue;
                Trace.verbose((Object)this, (String)methodName, (String)("Found vg already assoc with ig!continue = " + vg.getName()));
                Object o = allVGs.remove(i);
                if (o != null) {
                    Trace.verbose((Object)this, (String)methodName, (String)("Removed vg = " + ((VolumeGroupInterface)o).getName()));
                    continue;
                }
                Trace.verbose((Object)this, (String)methodName, (String)"No removal");
            }
        }
        return allVGs;
    }

    public Collection getPossibleVgsToAddTo(ConfigContext context, T4Interface array, StorageVolumeInterface volume) {
        String methodName = "getPossibleVgsToAddTo";
        Trace.methodBegin((Object)this, (String)methodName);
        Hashtable<String, VolumeGroupInterface> possVgs = new Hashtable<String, VolumeGroupInterface>();
        try {
            List allVgs = this.listForArray(context, array);
            Trace.verbose((Object)this, (String)methodName, (String)("allVgs size = " + allVgs.size()));
            String vgsForVol = volume.getVolumeGroup();
            Trace.verbose((Object)this, (String)methodName, (String)("vgsForVol  =" + vgsForVol));
            for (int i = 0; i < allVgs.size(); ++i) {
                VolumeGroupInterface vgi = (VolumeGroupInterface)allVgs.get(i);
                Trace.verbose((Object)this, (String)methodName, (String)("Adding vg to possibles = " + vgi.getName()));
                if (vgi.getName().equals(vgsForVol)) continue;
                possVgs.put(vgi.getName(), vgi);
            }
            return possVgs.values();
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)this, (String)"Exception", (Throwable)cme);
            return possVgs.values();
        }
        catch (Exception ex) {
            Trace.verbose((Object)this, (String)"Exception", (Throwable)ex);
            return possVgs.values();
        }
    }

    public List getVgWrapperList(ConfigContext context, Collection vgList) {
        String methodName = "getVgWrapperList";
        Trace.methodBegin((Object)this, (String)methodName);
        Bindings bindingsBusObj = new Bindings();
        ArrayList<VolumeGroupWrapper> wrappers = new ArrayList<VolumeGroupWrapper>();
        if (vgList != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Have a vg list to convert; size = " + vgList.size()));
            Object[] list = vgList.toArray();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    VolumeGroupWrapper vgw = new VolumeGroupWrapper();
                    VolumeGroupInterface vgi = (VolumeGroupInterface)list[i];
                    vgw.setVolumeGroup(vgi);
                    try {
                        vgw.setAssocInitiatorGroups(bindingsBusObj.list(context, null, vgi));
                        wrappers.add(vgw);
                        continue;
                    }
                    catch (ConfigMgmtException cme) {
                        Trace.verbose((Object)this, (String)"Exception trying to get bindings list", (Throwable)cme);
                    }
                }
            }
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Returning " + wrappers.size() + " wrappers"));
        return wrappers;
    }
}

