/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import com.sun.netstorage.array.mgmt.cfg.ui.business.JobsQueue;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.business.TrayForProfile;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Trays
extends CoreUIBusObject {
    private ManageTraysInterface trayManager = ManageTraysFactory.getManager();

    public List list(ConfigContext configContext, SearchFilter searchFilter) throws CoreUIBusException {
        try {
            this.trayManager.init(configContext, searchFilter);
            return this.trayManager.getItemList();
        }
        catch (Exception e) {
            throw new CoreUIBusException(e.toString());
        }
    }

    public List list(ConfigContext configContext, SearchFilter searchFilter, T4Interface t4) throws CoreUIBusException {
        try {
            this.trayManager.setScope((InstanceWrapper)t4);
            this.trayManager.init(configContext, searchFilter);
            return this.trayManager.getItemList();
        }
        catch (Exception e) {
            throw new CoreUIBusException(e.toString());
        }
    }

    public int indexFromName(String name, List list) throws IndexOutOfBoundsException {
        if (list == null || name == null) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!name.equals(((TrayInterface)list.get(i)).getId())) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    public List createDiskNumberList(int minNum, int maxNum) {
        String methodName = "createDiskNumberList";
        Trace.methodBegin((Object)this, (String)methodName);
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.verbose((Object)this, (String)methodName, (String)("Creating disk list from (" + minNum + ") to (" + maxNum + ")"));
        }
        ArrayList<Integer> disks = new ArrayList<Integer>();
        for (int i = minNum; i <= maxNum; ++i) {
            disks.add(new Integer(i));
        }
        return disks;
    }

    public boolean isRaid5ValidForAllTrays(List trays) {
        String methodName = "isRaid5ValidForAllTrays";
        Trace.methodBegin((Object)this, (String)methodName);
        try {
            Iterator it = trays.iterator();
            while (it.hasNext()) {
                TrayInterface t = (TrayInterface)it.next();
                List availableDisks = t.getDisksAvailableForPool(false);
                if (availableDisks == null || availableDisks.size() > 2) continue;
                return false;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)this, (String)methodName, (String)"Unable to determine if raid 5 is valid for all trays");
        }
        return true;
    }

    public boolean canAnyTrayHaveDedicatedHs(List trays) {
        String methodName = "canAnyTrayHaveDedicatedHs";
        Trace.methodBegin((Object)this, (String)methodName);
        try {
            Iterator it = trays.iterator();
            while (it.hasNext()) {
                TrayInterface t = (TrayInterface)it.next();
                PoolBreakdownForTray breakdownObj = t.getPoolBreakdownForTray(1, 2, 1, true);
                if (!breakdownObj.canBeSupported()) continue;
                Trace.verbose((Object)this, (String)methodName, (String)"Found at least one tray that can support dedHS");
                return true;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)this, (String)methodName, (String)"Unable to determine if all trays can have a dedicated hot spare");
        }
        Trace.verbose((Object)this, (String)methodName, (String)"Looped through all trays and found no tray that can support dedHS");
        return false;
    }

    public int getNumPoolsAvailableToCreate(TrayInterface tray, StorageProfile profile) throws ConfigMgmtException {
        String methodName = "getNumPoolsAvailableToCreate";
        Trace.methodBegin((Object)this, (String)methodName);
        int maxPools = 0;
        int minDataDrives = profile.getMinNeededDataDrives();
        boolean usesDedHS = profile.getDedicatedHotSpare() == 1;
        PoolBreakdownForTray pb = tray.getPoolBreakdownForTray(2, minDataDrives * 2, profile.getRaidLevel(), usesDedHS);
        maxPools = pb != null && pb.canBeSupported() ? 2 : 1;
        Trace.verbose((Object)this, (String)methodName, (String)("Returning (" + maxPools + ") allowed to be created"));
        return maxPools;
    }

    public List getTraysWithSpace(T4Interface currentT4) {
        String methodName = "getTraysWithSpace(array)";
        ArrayList<TrayInterface> traysWithSpace = new ArrayList<TrayInterface>();
        try {
            List trays = currentT4.getTrays();
            Iterator it = trays.iterator();
            while (it.hasNext()) {
                TrayInterface t = (TrayInterface)it.next();
                List availableDisks = t.getDisksAvailableForPool(false);
                if (availableDisks == null || availableDisks.isEmpty()) continue;
                traysWithSpace.add(t);
            }
            Trace.verbose((Object)this, (String)methodName, (String)("Returning " + traysWithSpace.size() + " trays with space"));
        }
        catch (Exception e) {
            Trace.error((Object)this, (ConfigMgmtException)new ConfigMgmtException(e));
        }
        return traysWithSpace;
    }

    public List getTraysForProfile(List trays, StorageProfile profile) throws Exception {
        String methodName = "getTraysForProfile";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayList<TrayForProfile> traysOkForProfile = new ArrayList<TrayForProfile>();
        Trace.verbose((Object)this, (String)methodName, (String)("Checking trays to apply profile = " + profile.getName()));
        boolean usesDedHS = profile.getDedicatedHotSpare() == 1;
        Iterator it = trays.iterator();
        while (it.hasNext()) {
            TrayForProfile trayForProfile = new TrayForProfile();
            TrayInterface t = (TrayInterface)it.next();
            if (!profile.canBeAppliedToTray(t)) continue;
            trayForProfile.setTray(t);
            trayForProfile.setPossibleDisksToAssign(this.createDiskNumberList(profile.getMinNeededDataDrives(), t.getDisksAvailableForPool(usesDedHS).size()));
            trayForProfile.setMaxPoolsAvailable(this.getNumPoolsAvailableToCreate(t, profile));
            traysOkForProfile.add(trayForProfile);
        }
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.verbose((Object)this, (String)methodName, (String)("Returning ( " + traysOkForProfile.size() + " ) trays ok for given profile"));
        }
        return traysOkForProfile;
    }

    public List getPossibleDestinationTrays(TrayInterface sourceTray, List trayList) throws CoreUIBusException {
        String methodName = "getPossibleDestinationTrays";
        Trace.methodBegin((Object)this, (String)methodName);
        String sourceId = sourceTray.getId();
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to get possible destinations for source = " + sourceId));
        ArrayList<TrayInterface> possibles = new ArrayList<TrayInterface>();
        try {
            Trace.verbose((Object)this, (String)methodName, (String)("Tray List size to get destinations from = " + trayList.size()));
            for (int i = 0; i < trayList.size(); ++i) {
                TrayInterface tray = (TrayInterface)trayList.get(i);
                Trace.verbose((Object)this, (String)methodName, (String)("On Tray (to check if can be destination) = " + tray.getId()));
                if (sourceId.equals(tray.getId()) || !sourceTray.areDisksCompatible(tray)) continue;
                possibles.add(tray);
                Trace.verbose((Object)this, (String)methodName, (String)("Adding tray = " + tray.getId() + " to the list of possibles"));
            }
            return possibles;
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)this, (String)methodName, (String)"**** Config Exception trying to get tray possibles ****");
            throw new CoreUIBusException(cme.toString());
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)methodName, (String)"**** Exception trying to get tray possibles ****");
            throw new CoreUIBusException(e.toString());
        }
    }

    public List cloneTray(TrayInterface sourceTray, TrayInterface destTray) throws ConfigMgmtException {
        String methodName = "cloneTray";
        Trace.methodBegin((Object)this, (String)methodName);
        Volumes volBusObj = new Volumes();
        StoragePools poolBusObj = new StoragePools();
        Trays trayBusObj = new Trays();
        ArrayList<MethodCallStatus> results = new ArrayList<MethodCallStatus>();
        Object error = null;
        List affectedPools = destTray.getRaidGroups();
        List poolStatuses = poolBusObj.deleteItems(affectedPools);
        results.addAll(poolStatuses);
        if (this.hasErrorsInMethodCallStatuses(poolStatuses)) {
            Trace.verbose((Object)this, (String)methodName, (String)"Found an error in pool delete statuses; returning");
            return results;
        }
        destTray.reload();
        JobsQueue jq = JobsQueue.getInstance(destTray.getT4Name(), destTray.getConfigContext());
        MethodCallStatus mcs = jq.addCreateStuffForCTJob(sourceTray, destTray);
        if (mcs != null) {
            results.add(mcs);
        }
        return results;
    }

    public TrayInterface getTrayByName(ConfigContext context, T4Interface array, String name) throws ConfigMgmtException {
        String methodName = "getTrayByName";
        Trace.methodBegin((Object)this, (String)methodName);
        List trays = null;
        try {
            trays = this.list(context, null, array);
        }
        catch (CoreUIBusException cbe) {
            Trace.verbose((Object)this, (String)"Exception trying to get the full list of trays", (Throwable)cbe);
        }
        if (trays != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Searching for trays with name = " + name));
            for (int i = 0; i < trays.size(); ++i) {
                TrayInterface tray = (TrayInterface)trays.get(i);
                if (tray == null || !tray.getId().equals(name)) continue;
                Trace.verbose((Object)this, (String)methodName, (String)"Found tray with given name!");
                return tray;
            }
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Unable to find tray with name = " + name));
        return null;
    }

    public String validateAction(TrayInterface tray, String action, List trayList) throws Exception {
        String key = null;
        Trace.verbose((Object)this, (String)"validateAction", (String)("action is " + action));
        Trace.verbose((Object)this, (String)"validateAction", (String)("tray type is " + tray.getTrayType()));
        Trace.verbose((Object)this, (String)"validateAction", (String)("tray state is " + tray.getState()));
        if (tray.getTrayType() != 17) {
            key = "error.trayAction.notController";
        } else if (action.indexOf("unconf") != -1) {
            if (tray.getState() != 3) {
                key = "error.trayAction.notDisabled";
            }
        } else if (action.indexOf("disable") != -1) {
            if (tray.getState() != 2) {
                key = "error.trayAction.notEnabled";
            } else {
                int cnt = 0;
                Iterator it = trayList.iterator();
                while (it.hasNext()) {
                    TrayInterface t = (TrayInterface)it.next();
                    if (t.getTrayType() != 17 || t.getState() != 2) continue;
                    ++cnt;
                }
                Trace.verbose((Object)this, (String)"validateAction", (String)("number of controllers found: " + cnt));
                if (cnt < 2) {
                    key = "error.trayAction.noAlternateController";
                }
            }
        } else if (action.indexOf("enable") != -1 && tray.getState() != 3) {
            key = "error.trayAction.notDisabled";
        }
        Trace.verbose((Object)this, (String)"validateAction", (String)("return key is " + key));
        return key;
    }

    public List getAllControllers(T4Interface array) throws ConfigMgmtException {
        String methodName = "getAllControllers";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayList<TrayInterface> controllerTrays = new ArrayList<TrayInterface>();
        if (array == null) {
            Trace.verbose((Object)this, (String)methodName, (String)"No array given to get the controllers for");
            return controllerTrays;
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to get controllers on array = " + array.getName()));
        List trays = array.getTrays();
        Iterator traysIterator = trays.iterator();
        while (traysIterator.hasNext()) {
            TrayInterface tray = (TrayInterface)traysIterator.next();
            if (tray.getTrayType() != 17) continue;
            controllerTrays.add(tray);
        }
        return controllerTrays;
    }

    public TrayInterface getControllerToMove(ConfigContext context, T4Interface array) throws ConfigMgmtException {
        String methodName = "getControllerToMove";
        Trace.methodBegin((Object)this, (String)methodName);
        List controllerTrays = this.getAllControllers(array);
        Iterator ti = controllerTrays.iterator();
        while (ti.hasNext()) {
            Trace.verbose((Object)this, (String)methodName, (String)(" tray id = " + ((TrayInterface)ti.next()).getId()));
        }
        Collections.sort(controllerTrays, new TrayIdComparator());
        if (controllerTrays.size() > 0) {
            Trace.verbose((Object)this, (String)methodName, (String)("Found controller tray with largest id - " + ((TrayInterface)controllerTrays.get(0)).getId()));
            return (TrayInterface)controllerTrays.get(0);
        }
        Trace.verbose((Object)this, (String)methodName, (String)"No controller tray found.");
        return null;
    }

    private class TrayIdComparator
    implements Comparator {
        private TrayIdComparator() {
        }

        public int compare(Object element1, Object element2) {
            String id1 = "";
            String id2 = "";
            if (element1 instanceof TrayInterface && element2 instanceof TrayInterface) {
                id1 = ((TrayInterface)element1).getId();
                id2 = ((TrayInterface)element2).getId();
            }
            Integer int1 = new Integer(id1);
            Integer int2 = new Integer(id2);
            return int1.compareTo(int2) * -1;
        }
    }
}

