/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.admin.business.ArrayRegistration;
import com.sun.netstorage.array.mgmt.cfg.admin.business.ManageArrayRegistrationsFactory;
import com.sun.netstorage.array.mgmt.cfg.admin.business.ManageArrayRegistrationsInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.FeatureNotSupportedException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.TooManyCIMInstanceException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Initiators;
import com.sun.netstorage.array.mgmt.cfg.ui.business.JobsQueue;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class T4s
extends CoreUIBusObject {
    private ManageT4sInterface t4Manager = ManageT4sFactory.getManager();
    private ManageArrayRegistrationsInterface regManager = ManageArrayRegistrationsFactory.getManager();

    public List list(ConfigContext configContext, SearchFilter searchFilter) throws ConfigMgmtException {
        try {
            this.t4Manager.init(configContext, searchFilter);
            return this.t4Manager.getItemList();
        }
        catch (Exception e) {
            throw new ConfigMgmtException(e);
        }
    }

    public int indexFromName(String name, List list) throws IndexOutOfBoundsException {
        if (list == null || name == null) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!name.equals(((T4Interface)list.get(i)).getName())) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    public T4Interface getArrayByIP(ConfigContext context, String ip) {
        String methodName = "getArrayByIP";
        Trace.methodBegin((Object)this, (String)methodName);
        try {
            this.t4Manager.init(context, null);
            return this.t4Manager.getT4ByIP(ip);
        }
        catch (ConfigMgmtException cbe) {
            Trace.error((Object)this, (ConfigMgmtException)cbe);
            Trace.verbose((Object)this, (String)methodName, (String)("Unable to find array with ip = " + ip));
            return null;
        }
    }

    public T4Interface getArrayByName(ConfigContext context, String name) {
        String methodName = "getArrayByName";
        Trace.methodBegin((Object)this, (String)methodName);
        Object arrays = null;
        try {
            this.t4Manager.init(context, null);
            return this.t4Manager.getT4ByName(name);
        }
        catch (ConfigMgmtException cbe) {
            Trace.error((Object)this, (ConfigMgmtException)cbe);
            Trace.verbose((Object)this, (String)methodName, (String)("Unable to find array with name = " + name));
            return null;
        }
    }

    public List getPossibleDestinationT4s(T4Interface sourceT4, List t4List) throws CoreUIBusException {
        String methodName = "getPossibleDestinationT4s";
        Trace.methodBegin((Object)this, (String)methodName);
        String sourceName = sourceT4.getName();
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to get possible destinations for source = " + sourceName));
        ArrayList possibles = new ArrayList();
        try {
            Trace.verbose((Object)this, (String)methodName, (String)("T4 List size to get destinations from = " + t4List.size()));
            return this.t4Manager.getPossibleDuplicateArrays(sourceT4, t4List);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, (ConfigMgmtException)cme);
            throw new CoreUIBusException(cme.toString());
        }
        catch (Exception e) {
            Trace.error((Object)this, (ConfigMgmtException)new ConfigMgmtException(e));
            throw new CoreUIBusException(e.toString());
        }
    }

    public MethodCallStatus cloneT4(T4Interface sourceT4, T4Interface destT4) throws CoreUIBusException {
        try {
            return destT4.cloneFrom(sourceT4);
        }
        catch (ConfigMgmtException ce) {
            Trace.error((Object)this, (ConfigMgmtException)ce);
            throw new CoreUIBusException(ce.toString());
        }
    }

    public List cloneT4(ConfigContext context, T4Interface sourceT4, T4Interface destT4) throws ConfigMgmtException {
        String methodName = "cloneT4(context, src, dest)";
        Trace.methodBegin((Object)this, (String)methodName);
        this.checkArrayHealth(sourceT4);
        this.checkArrayHealth(destT4);
        List results = this.clearArrayForDuplication(context, destT4);
        if (this.hasErrorsInMethodCallStatuses(results)) {
            Trace.verbose((Object)this, (String)methodName, (String)"Errors found trying to clear out dest array");
            return results;
        }
        JobsQueue jq = JobsQueue.getInstance(destT4.getName(), context);
        MethodCallStatus mcs = jq.addCreateStuffForCAJob(sourceT4, destT4);
        results.add(mcs);
        return results;
    }

    public List getVolumesOnT4(T4Interface argT4) throws ConfigMgmtException {
        Volumes vols = new Volumes();
        return vols.listByArray(argT4.getConfigContext(), argT4);
    }

    public List save(int oldSegmentSize, T4Interface arrayToSave) throws ConfigMgmtException, BadParameterException {
        String methodName = "save";
        Trace.methodBegin((Object)this, (String)methodName);
        boolean isDestructive = false;
        this.validateDescription(arrayToSave.getDescription(), Validate.ARRAY_DESC_OBJECT);
        if (Trace.isTraceEnabled((Object)this)) {
            this.traceArraySettings(arrayToSave);
        }
        String newDescription = arrayToSave.getDescription();
        int newBlockSize = arrayToSave.getBlockSize();
        int newReadahead = arrayToSave.getReadaheadMode();
        String ondgMode = arrayToSave.getOndgMode();
        boolean newDiskScrubbing = false;
        if (arrayToSave.isFeatureSupported(1)) {
            newDiskScrubbing = arrayToSave.isDiskScrubbing();
        }
        int newArrayHotSpares = 0;
        if (arrayToSave.isFeatureSupported(3)) {
            newArrayHotSpares = arrayToSave.getAhsPoolSize();
        }
        int newReconRate = arrayToSave.getDiskReconRate();
        String newFailover = arrayToSave.getFailoverMode();
        String newCacheMode = arrayToSave.getCacheMode();
        this.checkArrayHealth(arrayToSave);
        ArrayList results = new ArrayList();
        if (this.isDestructiveSave(oldSegmentSize, newBlockSize)) {
            Trace.verbose((Object)this, (String)methodName, (String)"This is a DESTRUCTIVE save!");
            isDestructive = true;
            List clearResults = this.clearArray(arrayToSave);
            results.addAll(clearResults);
            if (this.hasErrorsInMethodCallStatuses(clearResults)) {
                Trace.verbose((Object)this, (String)methodName, (String)"Got an error trying to clear array");
                return results;
            }
            arrayToSave.setBlockSize(newBlockSize);
        }
        arrayToSave.setDescription(newDescription);
        arrayToSave.setReadaheadMode(newReadahead);
        arrayToSave.setDiskReconRate(newReconRate);
        arrayToSave.setOndgMode(ondgMode);
        if (arrayToSave.isFeatureSupported(3)) {
            arrayToSave.setAhsPoolSize(newArrayHotSpares);
        }
        if (arrayToSave.isFeatureSupported(1)) {
            arrayToSave.setDiskScrubbing(newDiskScrubbing);
        }
        if (!"Unsupported".equals(newFailover)) {
            arrayToSave.setFailoverMode(newFailover);
        }
        arrayToSave.setCacheMode(newCacheMode);
        if (Trace.isTraceEnabled((Object)this)) {
            this.traceArraySettings(arrayToSave);
        }
        if (isDestructive) {
            Trace.verbose((Object)this, (String)"save", (String)"Send operation to queue");
            arrayToSave.setBlockSize(newBlockSize);
            JobsQueue jq = JobsQueue.getInstance(arrayToSave.getName(), arrayToSave.getConfigContext());
            jq.addSaveArraySettingsJob(arrayToSave);
        } else {
            arrayToSave.save();
            arrayToSave.reload();
        }
        return results;
    }

    private void traceArraySettings(T4Interface arrayToSave) throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException, FeatureNotSupportedException {
        String methodName = "traceArraySettings";
        StringBuffer arBuf = new StringBuffer("\nArray Settings:");
        arBuf.append("\n\tDescription:").append(arrayToSave.getDescription());
        arBuf.append("\n\tBlock Size:").append(arrayToSave.getBlockSize());
        arBuf.append("\n\tRead Ahead:").append(arrayToSave.getReadaheadMode());
        if (arrayToSave.isFeatureSupported(1)) {
            arBuf.append("\n\tDisk Scrubbing:").append(arrayToSave.isDiskScrubbing());
        }
        if (arrayToSave.isFeatureSupported(3)) {
            arBuf.append("\n\tDisk Scrubbing:").append(arrayToSave.getAhsPoolSize());
        }
        arBuf.append("\n\tDisk Recon Rate:").append(arrayToSave.getDiskReconRate());
        arBuf.append("\n\tDisk Recon Rate:").append(arrayToSave.getFailoverMode());
        arBuf.append("\n\tDisk Recon Rate:").append(arrayToSave.getCacheMode());
        arBuf.append("\n\tONDG Mode:").append(arrayToSave.getOndgMode());
        Trace.verbose((Object)this, (String)"traceArraySettings", (String)arBuf.toString());
    }

    public void save(T4Interface arrayToSave) throws ConfigMgmtException, BadParameterException {
        String methodName = "save(array)";
        Trace.methodBegin((Object)this, (String)methodName);
        this.checkArrayHealth(arrayToSave);
        this.validateDescription(arrayToSave.getDescription(), Validate.ARRAY_DESC_OBJECT);
        arrayToSave.save();
        arrayToSave.reload();
    }

    public boolean isDestructiveSave(int oldSegment, int newSegment) {
        String methodName = "isDestructiveSave";
        Trace.methodBegin((Object)this, (String)methodName);
        if (oldSegment != newSegment) {
            Trace.verbose((Object)this, (String)methodName, (String)"Segment Sizes are NOT equal");
            Trace.verbose((Object)this, (String)methodName, (String)("old block size = " + oldSegment));
            Trace.verbose((Object)this, (String)methodName, (String)("new block size = " + newSegment));
            return true;
        }
        return false;
    }

    public boolean isReadaheadChange(int oldReadaheadMode, int newReadaheadMode) {
        boolean newRa;
        String methodName = "isReadaheadChange";
        Trace.methodBegin((Object)this, (String)methodName);
        boolean result = false;
        boolean oldRa = oldReadaheadMode == 0;
        boolean bl = newRa = newReadaheadMode == 0;
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.verbose((Object)this, (String)methodName, (String)("Old readahead mode = " + oldReadaheadMode));
            Trace.verbose((Object)this, (String)methodName, (String)("New readahead mode = " + newReadaheadMode));
            Trace.verbose((Object)this, (String)methodName, (String)("Old readahead BOOLEAN mode = " + oldRa));
            Trace.verbose((Object)this, (String)methodName, (String)("New readahead BOOLEAN mode = " + newRa));
        }
        if (!(oldRa && newRa || !oldRa && !newRa)) {
            Trace.verbose((Object)this, (String)methodName, (String)"Readahead modes are different");
            result = true;
        }
        return result;
    }

    private List clearArray(T4Interface array) throws ConfigMgmtException {
        String methodName = "clearArray";
        Trace.methodBegin((Object)this, (String)methodName);
        StoragePools poolBusObj = new StoragePools();
        Trace.verbose((Object)this, (String)methodName, (String)("Get the list of trays in array:" + array.getName()));
        array.reload();
        List allTrays = array.getTrays();
        Trace.verbose((Object)this, (String)methodName, (String)("Number of trays returned:" + allTrays.size()));
        ArrayList results = new ArrayList();
        for (int i = 0; i < allTrays.size(); ++i) {
            TrayInterface tray = (TrayInterface)allTrays.get(i);
            List pools = tray.getRaidGroups();
            List poolStatuses = poolBusObj.deleteItems(pools);
            results.addAll(poolStatuses);
            if (!this.hasErrorsInMethodCallStatuses(poolStatuses)) continue;
            Trace.verbose((Object)this, (String)methodName, (String)("Got an error trying to delete pools for tray = " + tray.getId()));
            return results;
        }
        return results;
    }

    private List clearArrayForDuplication(ConfigContext context, T4Interface array) throws ConfigMgmtException {
        String methodName = "clearArrayForDuplication";
        Trace.methodBegin((Object)this, (String)methodName);
        Initiators iniBusObj = new Initiators();
        InitiatorGroups iniGrpBusObj = new InitiatorGroups();
        VolumeGroups volGrpBusObj = new VolumeGroups();
        List results = new ArrayList();
        results = this.clearArray(array);
        if (this.hasErrorsInMethodCallStatuses(results)) {
            Trace.verbose((Object)this, (String)methodName, (String)"Got an error trying to clear the array");
            return results;
        }
        List initiators = iniBusObj.listForArray(context, array);
        iniBusObj.delete(initiators);
        List initiatorGroups = iniGrpBusObj.listForArray(context, array);
        iniGrpBusObj.delete(initiatorGroups);
        List volumeGroups = volGrpBusObj.listForArray(context, array);
        volGrpBusObj.delete(volumeGroups);
        array.reload();
        return results;
    }

    public void validateIP(String ipAddr) throws BadParameterException {
        String methodName = "validateIP";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to validate ip = " + ipAddr));
        if (ipAddr != null) {
            ipAddr = ipAddr.trim();
        }
        if (ipAddr == null || "".equals(ipAddr)) {
            throw new BadParameterException(ipAddr, "error.ipAddressNotSpecified");
        }
        if (!Validate.ipAddress((String)ipAddr)) {
            throw new BadParameterException(ipAddr, "error.ipAddressInvalidFormat");
        }
    }

    public void createRegistration(ConfigContext context, SearchFilter filter, String ipAddr, String rootPass, boolean persistPassword) throws ConfigMgmtException, BadParameterException {
        String methodName = "createRegistration";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to create registration for ip = " + ipAddr));
        this.validateIP(ipAddr);
        ArrayRegistration ar = new ArrayRegistration();
        ar.setIPAddress(ipAddr);
        ar.setPassword(rootPass);
        ar.setPersistPassword(persistPassword);
        Trace.verbose((Object)this, (String)methodName, (String)("Full array reg object to create = " + ar.toString()));
        this.regManager.create(context, ar);
    }

    public List listRegistration(ConfigContext configContext, SearchFilter filter) throws ConfigMgmtException {
        String methodName = "listRegistration";
        Trace.methodBegin((Object)this, (String)methodName);
        this.regManager.init(configContext, filter);
        return this.regManager.getItemList();
    }

    public void clearRegistrationPassword(ConfigContext context, SearchFilter filter, ArrayRegistration array) throws Exception {
        String methodName = "clearRegistrationPassword";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to clear password for array reg= " + array.toString()));
        array.setPassword("");
        array.setPersistPassword(false);
        Trace.verbose((Object)this, (String)methodName, (String)("Values after resetting array reg: " + array.toString()));
        this.saveRegistration(context, array);
    }

    public void clearAllNonPersistentAccountPasswords(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        String methodName = "clearAllNonPersistentAccountPasswords";
        Trace.methodBegin((Object)this, (String)methodName);
        try {
            List allAccounts = this.listRegistration(context, filter);
            if (allAccounts != null) {
                Trace.verbose((Object)this, (String)methodName, (String)("Trying to clear passwords for " + allAccounts.size() + " Accounts"));
                for (int i = 0; i < allAccounts.size(); ++i) {
                    ArrayRegistration acct = (ArrayRegistration)allAccounts.get(i);
                    if (acct == null || acct.getPersistPassword()) continue;
                    Trace.verbose((Object)this, (String)methodName, (String)("Clearing password for acct: " + acct.getIPAddress() + "; it is not set to persist password"));
                    this.clearRegistrationPassword(context, filter, acct);
                }
            }
        }
        catch (Exception ex) {
            ConfigMgmtException cme = new ConfigMgmtException(ex);
            Trace.error((Object)this, (ConfigMgmtException)cme);
            throw cme;
        }
    }

    public void changePassword(ConfigContext context, SearchFilter filter, ArrayRegistration arrayReg, String newPassword) throws Exception {
        String methodName = "changePassword";
        Trace.methodBegin((Object)this, (String)methodName);
        if (newPassword == null) {
            newPassword = "";
        }
        int result = this.regManager.changePassword(context, arrayReg, newPassword);
        this.regManager.reload(arrayReg);
        switch (result) {
            case 2: {
                throw new ItemNotFoundException(arrayReg.getIPAddress());
            }
            case 4: {
                throw new Exception();
            }
        }
    }

    public void saveRegistration(ConfigContext context, ArrayRegistration arrayReg) throws Exception {
        String methodName = "saveRegistration";
        Trace.methodBegin((Object)this, (String)methodName);
        this.regManager.save(context, arrayReg);
    }

    public void removeRegistration(ConfigContext context, SearchFilter filter, ArrayRegistration array) throws Exception {
        String methodName = "removeRegistration";
        Trace.methodBegin((Object)this, (String)methodName);
        if (array != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to de-register = " + array.toString()));
            this.regManager.remove(context, array);
        }
    }

    public void removeRegistration(ConfigContext context, List arrays) throws Exception {
        String methodName = "removeRegistration(arrays)";
        Trace.methodBegin((Object)this, (String)methodName);
        if (arrays != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Have " + arrays.size() + " arrays to remove"));
            for (int i = 0; i < arrays.size(); ++i) {
                ArrayRegistration array = (ArrayRegistration)arrays.get(i);
                this.removeRegistration(context, null, array);
            }
        }
    }

    public void checkArrayHealth(T4Interface array) throws ConfigMgmtException {
        String methodName = "checkArrayHealth";
        Trace.methodBegin((Object)this, (String)methodName);
        if (array != null) {
            int health = array.getHealthStatus();
            Trace.verbose((Object)this, (String)methodName, (String)("Array health = " + health));
            if (health != 2) {
                Trace.verbose((Object)this, (String)methodName, (String)"Array health no ok!");
                throw new ConfigMgmtException("T4_NOT_HEALTHY_EXCEPTION", "Array Health not OK");
            }
        }
    }

    public boolean areAllArraysUnhealthy(List arrays, ArrayList healthList) {
        String methodName = "areAllArraysUnhealthy";
        Trace.methodBegin((Object)this, (String)methodName);
        boolean result = true;
        if (arrays == null || arrays.size() == 0) {
            return result;
        }
        try {
            int health = 0;
            for (int i = 0; i < arrays.size(); ++i) {
                T4Interface t4 = (T4Interface)arrays.get(i);
                health = t4.getHealthStatus();
                Trace.verbose((Object)this, (String)methodName, (String)(t4.getName() + " t4 status = " + health));
                healthList.add(new Integer(health));
            }
            for (int j = 0; j < healthList.size(); ++j) {
                health = (Integer)healthList.get(j);
                if (health == 2) {
                    Trace.verbose((Object)this, (String)methodName, (String)"Found at least one healthy array; return false for all unhealthy");
                    return false;
                }
                result = true;
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)this, (String)"Exception trying to determine if all arrays are unhealthy", (Throwable)ex);
        }
        Trace.verbose((Object)this, (String)methodName, (String)("result = " + result));
        return result;
    }

    public int getFirstHealthyArrayIndex(List arrays) {
        String methodName = "getFirstHealthyArrayIndex";
        Trace.methodBegin((Object)this, (String)methodName);
        try {
            for (int i = 0; i < arrays.size(); ++i) {
                T4Interface t4 = (T4Interface)arrays.get(i);
                if (t4.getHealthStatus() != 2) continue;
                Trace.verbose((Object)this, (String)methodName, (String)("Found the first healthy array; return index = " + i));
                return i;
            }
            Trace.verbose((Object)this, (String)methodName, (String)"No healthy arrays found, return -1");
            return -1;
        }
        catch (Exception ex) {
            Trace.verbose((Object)this, (String)"Exception trying to get healthy array index", (Throwable)ex);
            return -1;
        }
    }

    public int getNumberOfHealthyArrays(List arrays) {
        String methodName = "getNumberOfHealthyArrays";
        Trace.methodBegin((Object)this, (String)methodName);
        int result = 0;
        if (arrays == null) {
            Trace.verbose((Object)this, (String)methodName, (String)"List of arrays to check is null, return 0 healthy");
            return result;
        }
        try {
            for (int i = 0; i < arrays.size(); ++i) {
                T4Interface t4 = (T4Interface)arrays.get(i);
                if (t4.getHealthStatus() != 2) continue;
                ++result;
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)this, (String)"Exception trying to get  the number of healthy arrays", (Throwable)ex);
            return result;
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Returning number of health arrays: " + result));
        return result;
    }

    public ArrayRegistration getCorrespondingArrayReg(ConfigContext context, T4Interface t4, boolean checkT4Health) throws Exception {
        String methodName = "getCorrespondingArrayReg";
        Trace.methodBegin((Object)this, (String)methodName);
        if (checkT4Health) {
            Trace.verbose((Object)this, (String)methodName, (String)"Checking T4 health...");
            this.checkArrayHealth(t4);
        }
        return this.findArrayRegByName(context, t4.getName());
    }

    public boolean isTransientPasswordNeeded(ConfigContext context, T4Interface array) throws Exception {
        String methodName = "isTransientPasswordNeeded";
        Trace.methodBegin((Object)this, (String)methodName);
        boolean result = false;
        ArrayRegistration arrayReg = this.getCorrespondingArrayReg(context, array, true);
        Trace.verbose((Object)this, (String)methodName, (String)("Found corresponding array registration: " + arrayReg.toString()));
        if (arrayReg.getHealthStatus() == 6) {
            Trace.verbose((Object)this, (String)methodName, (String)"Account status is error, need password");
            result = true;
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Is transient password needed? = " + result));
        return result;
    }

    public boolean isPasswordValid(ConfigContext context, T4Interface array, String password, boolean persist) throws Exception {
        String methodName = "isPasswordValid(4 params)";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayRegistration arrayReg = this.getCorrespondingArrayReg(context, array, true);
        Trace.verbose((Object)this, (String)methodName, (String)("Found corresponding array registration: " + arrayReg.toString()));
        arrayReg.setPassword(password);
        Trace.verbose((Object)this, (String)methodName, (String)("Should persist? - " + persist));
        arrayReg.setPersistPassword(persist);
        this.saveRegistration(context, arrayReg);
        this.regManager.reload(arrayReg);
        if (arrayReg.getHealthStatus() != 2) {
            Trace.verbose((Object)this, (String)methodName, (String)"Account after reload is ! OK");
            return false;
        }
        Trace.verbose((Object)this, (String)methodName, (String)"Password is valid!");
        return true;
    }

    public boolean isPasswordValid(ConfigContext context, T4Interface array, String password) throws Exception {
        String methodName = "isPasswordValid";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayRegistration arrayReg = this.getCorrespondingArrayReg(context, array, true);
        Trace.verbose((Object)this, (String)methodName, (String)("Found corresponding array registration: " + arrayReg.toString()));
        arrayReg.setPassword(password);
        this.saveRegistration(context, arrayReg);
        this.regManager.reload(arrayReg);
        if (arrayReg.getHealthStatus() != 2) {
            Trace.verbose((Object)this, (String)methodName, (String)"Account after reload is ! OK");
            return false;
        }
        Trace.verbose((Object)this, (String)methodName, (String)"Password is valid!");
        return true;
    }

    public void reloadArrayRegistration(ArrayRegistration ar) throws ConfigMgmtException {
        String methodName = "reloadArrayRegistration()";
        Trace.methodBegin((Object)this, (String)methodName);
        if (ar != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to reload array reg = " + ar.getIPAddress()));
            this.regManager.reload(ar);
        } else {
            Trace.verbose((Object)this, (String)methodName, (String)"Unable to reload null registration");
        }
    }

    public ArrayRegistration findArrayRegByName(ConfigContext context, String name) throws Exception {
        String methodName = "findArrayRegByName";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to find array reg with name = " + name));
        String ipAddr = IPUtil.lookUpIP((String)name);
        Trace.verbose((Object)this, (String)methodName, (String)("IP address for given name = " + ipAddr));
        ArrayRegistration arrayReg = null;
        try {
            arrayReg = this.regManager.getArrayRegByIP(context, ipAddr);
        }
        catch (ConfigMgmtException e) {
            if ("CIM_ERR_ACCESS_DENIED".equals(e.getEmbededException().getMessage())) {
                throw e;
            }
            throw new ItemNotFoundException(name);
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Found corresponding array registration: " + arrayReg.toString()));
        return arrayReg;
    }

    public void refreshArrays(ConfigContext context, List arrays) throws Exception {
        String methodName = "refreshArrays";
        Trace.methodBegin((Object)this, (String)methodName);
        if (arrays == null) {
            Trace.verbose((Object)this, (String)methodName, (String)"Array list given is null; get new list");
            arrays = this.list(context, null);
        }
        Iterator arrayIterator = arrays.iterator();
        while (arrayIterator.hasNext()) {
            T4Interface t4 = (T4Interface)arrayIterator.next();
            this.refreshArray(t4);
        }
    }

    public void refreshArray(T4Interface array) throws Exception {
        String methodName = "refreshArray";
        Trace.methodBegin((Object)this, (String)methodName);
        try {
            this.checkArrayHealth(array);
        }
        catch (ConfigMgmtException cme) {
            array.refreshProviderCache();
        }
    }
}

