/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageRaidGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageRaidGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.PoolInitializationException;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StoragePools
extends CoreUIBusObject {
    private ManageRaidGroupsInterface poolsManager = ManageRaidGroupsFactory.getManager();

    public List list(ConfigContext configContext) throws CoreUIBusException {
        try {
            this.poolsManager.init(configContext, null);
            return this.poolsManager.getItemList();
        }
        catch (Exception e) {
            throw new CoreUIBusException(e.toString());
        }
    }

    public List list(ConfigContext configContext, SearchFilter search) throws CoreUIBusException {
        try {
            this.poolsManager.init(configContext, search);
            return this.poolsManager.getItemList();
        }
        catch (Exception e) {
            throw new CoreUIBusException(e.toString());
        }
    }

    public List getPoolsInT4(ConfigContext configContext, String arrayName) throws ConfigMgmtException, CoreUIBusException {
        String methodName = "getPoolsInT4";
        Trace.methodBegin((Object)this, (String)methodName);
        T4s t4s = new T4s();
        T4Interface t4 = t4s.getArrayByName(configContext, arrayName);
        if (t4 == null) {
            return null;
        }
        return this.getPoolsInT4(configContext, t4);
    }

    public List getPoolsInT4(ConfigContext config, T4Interface t4) throws CoreUIBusException {
        String methodName = "getPoolsInT4";
        Trace.methodBegin((Object)this, (String)methodName);
        try {
            this.poolsManager.setScope((InstanceWrapper)t4);
            this.poolsManager.init(config, null);
            return this.poolsManager.getItemList();
        }
        catch (ConfigMgmtException ce) {
            Trace.verbose((Object)this, (String)"Exception trying to get pools in a T4", (Throwable)ce);
            throw new CoreUIBusException(ce.getMessage());
        }
    }

    public void validateName(String poolName, T4Interface t4, ConfigContext cc, List allPools) throws ConfigMgmtException, BadParameterException {
        super.validateName(poolName);
        try {
            if (allPools == null) {
                allPools = this.getPoolsInT4(cc, t4);
            }
        }
        catch (CoreUIBusException ce) {
            ConfigMgmtException cme = new ConfigMgmtException(ce.getMessage(), "Failed to list pools", (Exception)ce);
            cme.addExceptionContext((Object)("poolName:" + poolName));
            cme.addExceptionContext((Object)("Array:" + t4));
            cme.addExceptionContext((Object)("ConfigContext:" + cc));
            throw cme;
        }
        if (allPools != null) {
            Iterator it = allPools.iterator();
            while (it.hasNext()) {
                RaidGroupInterface rg = (RaidGroupInterface)it.next();
                if (!rg.getName().equals(poolName)) continue;
                throw new BadParameterException(poolName, "error.resourceAlreadyExists");
            }
        }
    }

    public List getPossibleDataDrives(TrayInterface tray, int raidLevel, int hotspare) throws CoreUIBusException {
        int i;
        String methodName = "getPossibleDataDrives(3 param)";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayList<Integer> drives = new ArrayList<Integer>();
        int maxNum = 0;
        try {
            int totalTrayDrives = tray.getNumberOfDrives();
            Trace.verbose((Object)this, (String)methodName, (String)("Total drives in Tray = " + totalTrayDrives));
            Trace.verbose((Object)this, (String)methodName, (String)("Hotspare value = " + hotspare));
            List pools = tray.getRaidGroups();
            if (pools != null) {
                Trace.verbose((Object)this, (String)methodName, (String)("This tray has " + pools.size() + " existing pool(s)"));
                int poolSize = pools.size();
                if (poolSize == 1) {
                    RaidGroupInterface pool1 = (RaidGroupInterface)pools.get(0);
                    ArrayList driveNums = tray.getMaxContigDrive(pool1);
                    Trace.verbose((Object)this, (String)methodName, (String)("Max contig drives size = " + driveNums.size()));
                    maxNum = tray.isDepop() ? driveNums.size() - hotspare : driveNums.size();
                } else if (poolSize == 0) {
                    maxNum = tray.isDepop() ? totalTrayDrives - hotspare : totalTrayDrives;
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)this, (String)"Exception trying to get maximum number of data drives", (Throwable)cme);
            throw new CoreUIBusException(cme.getMessage());
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"General Exception trying to get maximum number of data drives", (Throwable)e);
            throw new CoreUIBusException(e.getMessage());
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Maximum number for data drives = " + maxNum));
        if (raidLevel == 5) {
            for (i = 3; i <= maxNum; ++i) {
                drives.add(new Integer(i));
            }
        } else {
            for (i = 2; i <= maxNum; ++i) {
                drives.add(new Integer(i));
            }
        }
        return drives;
    }

    public List getPossibleDataDrives(TrayInterface tray, int poolDrives, int hotspare, int raidLevel) throws CoreUIBusException {
        int i;
        String methodName = "getPossibleDataDrives";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayList<Integer> drives = new ArrayList<Integer>();
        int hotspareUsage = 0;
        int maxNum = 0;
        try {
            switch (tray.getHotSpareDriveUsage()) {
                case 0: 
                case 2: {
                    hotspareUsage = 1;
                    break;
                }
                case -1: 
                case 1: {
                    hotspareUsage = 0;
                }
            }
            int totalTrayDrives = tray.getNumberOfDrives();
            Trace.verbose((Object)this, (String)methodName, (String)("Total drives in Tray = " + totalTrayDrives));
            maxNum = tray.isDepop() ? totalTrayDrives - poolDrives - hotspareUsage : totalTrayDrives - poolDrives - hotspare;
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)this, (String)"Exception trying to get maximum number of data drives", (Throwable)cme);
            throw new CoreUIBusException(cme.getMessage());
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"General Exception trying to get maximum number of data drives", (Throwable)e);
            throw new CoreUIBusException(e.getMessage());
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Maximum number for data drives = " + maxNum));
        if (raidLevel == 5) {
            for (i = 3; i <= maxNum; ++i) {
                drives.add(new Integer(i));
            }
        } else {
            for (i = 2; i <= maxNum; ++i) {
                drives.add(new Integer(i));
            }
        }
        return drives;
    }

    public List getPossibleDataDrives(int raidLevel, int maxAvail) {
        String methodName = "getPossibleDataDrives";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayList<Integer> drives = new ArrayList<Integer>();
        if (raidLevel == 5) {
            for (int i = 3; i <= maxAvail; ++i) {
                drives.add(new Integer(i));
            }
        } else {
            for (int i = 2; i <= maxAvail; ++i) {
                drives.add(new Integer(i));
            }
        }
        return drives;
    }

    public List deleteItems(List raidGroupInterfaces) throws ConfigMgmtException {
        String methodName = "deleteItems";
        Trace.methodBegin((Object)this, (String)methodName);
        if (raidGroupInterfaces == null) {
            Trace.verbose((Object)this, (String)methodName, (String)"No pools given to delete!");
            return null;
        }
        Volumes volBusObj = new Volumes();
        Trace.verbose((Object)this, (String)methodName, (String)("trying to delete " + raidGroupInterfaces.size() + " pools"));
        ArrayList<MethodCallStatus> returnStatuses = new ArrayList<MethodCallStatus>();
        for (int i = 0; i < raidGroupInterfaces.size(); ++i) {
            RaidGroupInterface rgi = (RaidGroupInterface)raidGroupInterfaces.get(i);
            List volStatuses = volBusObj.deleteItems(rgi.getVolumes());
            returnStatuses.addAll(volStatuses);
            if (this.hasErrorsInMethodCallStatuses(volStatuses)) {
                Trace.verbose((Object)this, (String)methodName, (String)"Found an error in volume delete statuses; returning");
                return returnStatuses;
            }
            String name = rgi.getName();
            Trace.verbose((Object)this, (String)methodName, (String)("Deleting pool [" + name + "]"));
            MethodCallStatus rgStatus = rgi.delete();
            returnStatuses.add(rgStatus);
            if (rgStatus.getReturnCode() == 0) continue;
            Trace.verbose((Object)this, (String)methodName, (String)("Found error when deleting pool = " + name));
            return returnStatuses;
        }
        return returnStatuses;
    }

    public List delete(RaidGroupInterface pool) throws ConfigMgmtException {
        String methodName = "delete(pool)";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayList<RaidGroupInterface> poolList = new ArrayList<RaidGroupInterface>();
        poolList.add(pool);
        return this.deleteItems(poolList);
    }

    public List deletePool(ConfigContext context, String arrayName, String poolName) throws ConfigMgmtException {
        String methodName = "delete";
        Trace.methodBegin((Object)this, (String)methodName);
        T4s t4BusObj = new T4s();
        T4Interface array = t4BusObj.getArrayByName(context, arrayName);
        ArrayList<RaidGroupInterface> poolsToDelete = new ArrayList<RaidGroupInterface>();
        poolsToDelete.add(this.findPool(context, arrayName, poolName));
        array.reload();
        return this.deleteItems(poolsToDelete);
    }

    public List getOnlinePoolNames(List pools) throws Exception {
        String methodName = "getOnlinePoolNames";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayList<String> onlinePools = new ArrayList<String>();
        Iterator poolsIterator = pools.iterator();
        while (poolsIterator.hasNext()) {
            RaidGroupInterface pool = (RaidGroupInterface)poolsIterator.next();
            if (!"online".equals(pool.getStatus())) continue;
            onlinePools.add(pool.getName());
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Returning (" + onlinePools.size() + ") online pools"));
        return onlinePools;
    }

    public List initializePools(T4Interface array, List pools) throws Exception {
        String methodName = "initializePools";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayList<MethodCallStatus> returnStatuses = new ArrayList<MethodCallStatus>();
        if (pools == null || pools.isEmpty()) {
            Trace.verbose((Object)this, (String)methodName, (String)"Pools list given is null or empty, returning with no action performed");
            return returnStatuses;
        }
        String[] args = new String[2];
        try {
            args[0] = ((RaidGroupInterface)pools.get(0)).getName();
            args[1] = array.getName();
            T4s t4BusObj = new T4s();
            t4BusObj.checkArrayHealth(array);
        }
        catch (ConfigMgmtException cme) {
            LogAPI.staticLog((String)"POOL_INITIALIZE_ERROR_DEGRADED", (String[])args, (String[])new String[0]);
            throw cme;
        }
        ArrayList<String> onlineErrors = new ArrayList<String>();
        ArrayList<String> generalErrors = new ArrayList<String>();
        MethodCallStatus status = null;
        Iterator poolsIterator = pools.iterator();
        while (poolsIterator.hasNext()) {
            RaidGroupInterface pool = (RaidGroupInterface)poolsIterator.next();
            args[0] = pool.getName();
            try {
                if ("online".equals(pool.getStatus())) {
                    onlineErrors.add(pool.getName());
                } else {
                    status = pool.initialize();
                    returnStatuses.add(status);
                }
            }
            catch (ConfigMgmtException c) {
                if (c.getEmbededException().toString().equals("CIM_ERR_ACCESS_DENIED")) {
                    throw c;
                }
                generalErrors.add(pool.getName());
                LogAPI.staticLog((String)"POOL_INITIALIZE_ERROR", (String[])args, (String[])new String[0]);
            }
            if (this.hasErrorsInMethodCallStatus(status)) {
                LogAPI.staticLog((String)"POOL_INITIALIZE_ERROR", (String[])args, (String[])new String[0]);
                continue;
            }
            if (Jobs.hasJobsInMethodCallStatuses(returnStatuses)) continue;
            LogAPI.staticLog((String)"POOL_INITIALIZE_REQUEST", (String[])args, (String[])new String[0]);
        }
        if (!onlineErrors.isEmpty() || !generalErrors.isEmpty()) {
            PoolInitializationException pie = new PoolInitializationException("Errors during initialization", onlineErrors, generalErrors);
            throw pie;
        }
        return returnStatuses;
    }

    public void changeStatus(ConfigContext context, String arrayName, String poolName, String status) throws ConfigMgmtException {
        String methodName = "changeStatus";
        Trace.methodBegin((Object)this, (String)methodName);
        RaidGroupInterface rg = this.findPool(context, arrayName, poolName);
        if (rg != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Found pool with name = " + poolName));
            if (status.equals("online")) {
                this.changeStatus(rg, "online");
            } else if (status.equals("offline")) {
                this.changeStatus(rg, "offline");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changeStatus(RaidGroupInterface pool, String status) throws ConfigMgmtException {
        String methodName = "changeStatus";
        Trace.methodBegin((Object)this, (String)methodName);
        if (pool == null) return;
        Trace.verbose((Object)this, (String)methodName, (String)("trying to change pool status for pool = " + pool.getName() + " to status = " + status));
        ConfigMgmtException localE = null;
        try {
            try {
                pool.changeStatus(status);
            }
            catch (ConfigMgmtException cme) {
                localE = cme;
                throw cme;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                pool.reload();
                throw throwable;
            }
            catch (ConfigMgmtException me) {
                if (localE == null) throw me;
                throw localE;
            }
        }
        try {}
        catch (ConfigMgmtException me) {
            if (localE == null) throw me;
            throw localE;
        }
        pool.reload();
        String[] args = new String[]{pool.getName()};
        if (status.equals("offline")) {
            LogAPI.staticLog((String)"POOL_OFFLINE", (String[])args, (String[])new String[0]);
            return;
        }
        if (!status.equals("online")) return;
        LogAPI.staticLog((String)"POOL_ONLINE", (String[])args, (String[])new String[0]);
    }

    public void changeStatusToOfflineForGroup(List poolsList) throws ConfigMgmtException {
        String methodName = "changeStatusToOfflineForGroup";
        Trace.methodBegin((Object)this, (String)methodName);
        String[] args = new String[1];
        Iterator poolsIterator = poolsList.iterator();
        while (poolsIterator.hasNext()) {
            RaidGroupInterface pool = (RaidGroupInterface)poolsIterator.next();
            args[0] = pool.getName();
            String currentStatus = pool.getStatus();
            Trace.verbose((Object)this, (String)methodName, (String)("Current status ( " + currentStatus + " ) for pool ( " + args[0] + " )"));
            if (!"online".equals(currentStatus)) continue;
            this.changeStatus(pool, "offline");
            LogAPI.staticLog((String)"POOL_OFFLINE", (String[])args, (String[])new String[0]);
        }
    }

    public void changeStatusToOnlineForGroup(List poolsList) throws ConfigMgmtException {
        String methodName = "changeStatusToOnlineForGroup";
        Trace.methodBegin((Object)this, (String)methodName);
        String[] args = new String[1];
        Iterator poolsIterator = poolsList.iterator();
        while (poolsIterator.hasNext()) {
            RaidGroupInterface pool = (RaidGroupInterface)poolsIterator.next();
            args[0] = pool.getName();
            String currentStatus = pool.getStatus();
            Trace.verbose((Object)this, (String)methodName, (String)("Current status ( " + currentStatus + " ) for pool ( " + args[0] + " )"));
            if (!"offline".equals(currentStatus)) continue;
            this.changeStatus(pool, "online");
            LogAPI.staticLog((String)"POOL_ONLINE", (String[])args, (String[])new String[0]);
        }
    }

    public RaidGroupInterface findPool(ConfigContext context, String arrayName, String poolName) throws ConfigMgmtException {
        String methodName = "findPool";
        Trace.methodBegin((Object)this, (String)methodName);
        T4s t4BusObj = new T4s();
        T4Interface array = t4BusObj.getArrayByName(context, arrayName);
        if (array != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Got the array = " + arrayName));
            List pools = array.getRaidGroups();
            if (pools != null) {
                for (int i = 0; i < pools.size(); ++i) {
                    RaidGroupInterface rg = (RaidGroupInterface)pools.get(i);
                    Trace.verbose((Object)this, (String)methodName, (String)("Pool to compare = " + rg.getName()));
                    if (!rg.getName().equals(poolName)) continue;
                    return rg;
                }
            }
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Unable to find pool with name = " + poolName));
        return null;
    }

    public RaidGroupInterface findPool(String poolName, List poolsToSearch) throws ConfigMgmtException {
        String methodName = "findPool(poolName, poolsToSearch)";
        Trace.methodBegin((Object)this, (String)methodName);
        RaidGroupInterface result = null;
        if (poolsToSearch == null) {
            Trace.verbose((Object)this, (String)methodName, (String)"No pools were given to search through; returning null");
            return null;
        }
        Iterator poolsIterator = poolsToSearch.iterator();
        while (poolsIterator.hasNext()) {
            RaidGroupInterface pool = (RaidGroupInterface)poolsIterator.next();
            if (!poolName.equals(pool.getName())) continue;
            Trace.verbose((Object)this, (String)methodName, (String)("Found pool with matching name - " + poolName));
            result = pool;
        }
        return result;
    }

    public MethodCallStatus createRaidGroup(ConfigContext context, T4Interface t4, TrayInterface tray, String poolName, List disks, StorageProfile profile, int spare) throws ConfigMgmtException, BadParameterException, CoreUIBusException {
        boolean allowChanges;
        String methodName = "createRaidGroup(profile)";
        Trace.methodBegin((Object)this, (String)methodName);
        T4s t4BusObj = new T4s();
        boolean isSegmentSizeChanging = t4BusObj.isDestructiveSave(t4.getBlockSize(), profile.getSegmentSize());
        boolean isReadaheadChanging = t4BusObj.isReadaheadChange(t4.getReadaheadMode(), profile.getReadaheadMode());
        List allPools = this.getPoolsInT4(context, t4);
        boolean bl = allowChanges = (allPools == null || allPools.isEmpty()) && t4.getQueuedPoolData().getNumQueuedPools() == 0;
        if (isSegmentSizeChanging || isReadaheadChanging) {
            Trace.verbose((Object)this, (String)methodName, (String)"Segment size or readahead is changing...");
            if (!allowChanges) {
                String key = "";
                if (isReadaheadChanging && isSegmentSizeChanging) {
                    key = profile.getSegmentSize() + ", " + profile.getReadaheadMode() + "can't be changed";
                } else if (isReadaheadChanging) {
                    key = profile.getReadaheadMode() + "can't be changed";
                } else if (isSegmentSizeChanging) {
                    key = profile.getSegmentSize() + "can't be changed";
                }
                Trace.verbose((Object)this, (String)methodName, (String)"Trying to change segment size and/or readahead when it is NOT allowed");
                throw new BadParameterException(key, "ACTION_NOT_SUPPORTED");
            }
            Trace.verbose((Object)this, (String)methodName, (String)"Changes are allowed, saving t4...");
            t4.setBlockSize(profile.getSegmentSize());
            t4.setReadaheadMode(profile.getReadaheadMode());
            t4BusObj.save(t4);
        }
        MethodCallStatus result = tray.createRAIDGroup(poolName, disks, profile, spare == 1);
        String[] args = new String[]{poolName, t4.getName()};
        LogAPI.staticLog((String)"POOL_CREATE_REQUEST", (String[])args, (String[])new String[0]);
        tray.reload();
        return result;
    }

    public int getAllowedNameLength() {
        return 12;
    }

    public void applyDifferentProfile(ConfigContext context, T4Interface t4, RaidGroupInterface pool, StorageProfile newProfile) throws BadParameterException, ConfigMgmtException, CoreUIBusException {
        boolean allowChanges;
        String methodName = "applyDifferentProfile";
        Trace.methodBegin((Object)this, (String)methodName);
        T4s t4BusObj = new T4s();
        boolean isReadaheadChanging = t4BusObj.isReadaheadChange(t4.getReadaheadMode(), newProfile.getReadaheadMode());
        Trace.verbose((Object)this, (String)methodName, (String)("Is read ahead changing = " + isReadaheadChanging));
        List allPools = this.getPoolsInT4(context, t4);
        boolean bl = allowChanges = allPools != null && allPools.size() == 1 && t4.getQueuedPoolData().getNumQueuedPools() == 0;
        if (isReadaheadChanging) {
            Trace.verbose((Object)this, (String)methodName, (String)"Readahead is changing...");
            if (!allowChanges) {
                Trace.verbose((Object)this, (String)methodName, (String)"Trying to change readahead when it is NOT allowed");
                throw new BadParameterException("" + newProfile.getReadaheadMode(), "ACTION_NOT_SUPPORTED");
            }
            Trace.verbose((Object)this, (String)methodName, (String)"Changes are allowed, saving t4 with read ahead mode...");
            t4.setReadaheadMode(newProfile.getReadaheadMode());
            t4BusObj.save(t4);
        }
        Trace.verbose((Object)this, (String)methodName, (String)"Now applying new profile...");
        pool.applyNewProfile(newProfile, false);
    }

    public int getIndexOf(String poolName, List pools) {
        String methodName = "getIndexOf";
        Trace.methodBegin((Object)this, (String)methodName);
        int result = -1;
        if (poolName == null || pools == null) {
            Trace.verbose((Object)this, (String)methodName, (String)"No list of pools given to search through");
            return result;
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to find index of pool - " + poolName));
        for (int i = 0; i < pools.size(); ++i) {
            RaidGroupInterface rg = (RaidGroupInterface)pools.get(i);
            if (!poolName.equals(rg.getName())) continue;
            result = i;
            Trace.verbose((Object)this, (String)methodName, (String)("Found matching pool at index = " + result));
            return result;
        }
        return result;
    }
}

