/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Initiators;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Trays;
import com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Search
extends CoreUIBusObject {
    public List search(ConfigContext context, int objectType, String searchField, String searchText, boolean isExact, boolean isCaseSensitive) {
        String methodName = "search";
        Trace.methodBegin((Object)this, (String)methodName);
        List results = new ArrayList();
        SearchFilter filter = null;
        try {
            switch (objectType) {
                case 0: {
                    Trace.verbose((Object)this, (String)methodName, (String)"Searching for array");
                    if ("Name".equals(searchField)) {
                        Trace.verbose((Object)this, (String)methodName, (String)"Searching by name");
                        filter = new SearchFilter("Name", searchText, isExact, isCaseSensitive);
                    } else if ("Description".equals(searchField)) {
                        Trace.verbose((Object)this, (String)methodName, (String)"Searching by description");
                        filter = new SearchFilter("Caption", searchText, isExact, isCaseSensitive);
                    }
                    T4s t4BusObj = new T4s();
                    results = t4BusObj.list(context, filter);
                    break;
                }
                case 1: {
                    Trace.verbose((Object)this, (String)methodName, (String)"Searching for tray");
                    if ("Name".equals(searchField)) {
                        Trace.verbose((Object)this, (String)methodName, (String)"Searching by name");
                        String patternedSearchText = searchText;
                        patternedSearchText = isExact ? ":" + searchText + "$" : ":\\w*" + searchText;
                        filter = new SearchFilter("Tag", Pattern.compile(patternedSearchText, 66));
                    } else if ("Description".equals(searchField)) {
                        Trace.verbose((Object)this, (String)methodName, (String)"Searching by description");
                        filter = new SearchFilter("Description", searchText, isExact, isCaseSensitive);
                    }
                    Trays trayBusObj = new Trays();
                    results = trayBusObj.list(context, filter);
                    break;
                }
                case 2: {
                    Trace.verbose((Object)this, (String)methodName, (String)("Searching for pool " + searchField));
                    if ("Name".equals(searchField)) {
                        Trace.verbose((Object)this, (String)methodName, (String)"Searching by name");
                        filter = new SearchFilter("ElementName", searchText, isExact, isCaseSensitive);
                    } else if ("ProfileName".equals(searchField)) {
                        Trace.verbose((Object)this, (String)methodName, (String)"Searching by profile name");
                        filter = new SearchFilter("Description", searchText, isExact, isCaseSensitive);
                    }
                    StoragePools poolBusObj = new StoragePools();
                    results = poolBusObj.list(context, filter);
                    break;
                }
                case 3: {
                    Trace.verbose((Object)this, (String)methodName, (String)"Searching for volume");
                    filter = new SearchFilter("OtherIdentifyingInfo", searchText, isExact, isCaseSensitive);
                    Volumes volBusObj = new Volumes();
                    results = volBusObj.list(context, filter);
                    break;
                }
                case 4: {
                    Trace.verbose((Object)this, (String)methodName, (String)"Searching for volume group");
                    filter = new SearchFilter("ElementName", searchText, isExact, isCaseSensitive);
                    VolumeGroups vgBusObj = new VolumeGroups();
                    results = vgBusObj.list(context, filter);
                    break;
                }
                case 6: {
                    Trace.verbose((Object)this, (String)methodName, (String)"Searching for initiator group");
                    filter = new SearchFilter("ElementName", searchText, isExact, isCaseSensitive);
                    InitiatorGroups igBusObj = new InitiatorGroups();
                    results = igBusObj.list(context, filter);
                    break;
                }
                case 5: {
                    Trace.verbose((Object)this, (String)methodName, (String)"Searching for initiator");
                    if ("World Wide Name".equals(searchField)) {
                        Trace.verbose((Object)this, (String)methodName, (String)"Searching by wwn");
                        filter = new SearchFilter("StorageID", searchText, isExact, isCaseSensitive);
                    } else if ("Description".equals(searchField)) {
                        Trace.verbose((Object)this, (String)methodName, (String)"Searching by description");
                        filter = new SearchFilter("ElementName", searchText, isExact, isCaseSensitive);
                    }
                    Initiators iniBusObj = new Initiators();
                    results = iniBusObj.list(context, filter);
                }
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)this, (String)"Exception trying to search", (Throwable)ex);
            return results;
        }
        return results;
    }
}

