/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfiles;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class Profiles
extends CoreUIBusObject {
    private ManageStorageProfiles profilesManager = ManageStorageProfiles.getInstance();

    public List listAll(ConfigContext configContext) throws CoreUIBusException {
        return this.list(configContext, 0);
    }

    public List list(ConfigContext configContext, int filter) throws CoreUIBusException {
        List returnList = new ArrayList();
        try {
            returnList = this.profilesManager.getItemList(configContext, filter);
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"list", (String)e.getMessage());
            throw new CoreUIBusException(e.toString());
        }
        return returnList;
    }

    public List getDuplicateProfiles(ConfigContext context, StorageProfile profile) throws ConfigMgmtException {
        String methodName = "getDuplicateProfiles";
        Trace.methodBegin((Object)this, (String)methodName);
        String profileName = profile.getName();
        try {
            this.profilesManager.getProfile(profileName);
            throw new ConfigMgmtException("error.objectAlreadyExists", "Profile with name already exists.");
        }
        catch (ItemNotFoundException infe) {
            Trace.verbose((Object)this, (String)"getDuplicateProfiles", (String)"Swallowing the ItemNotFoundException   - no profiles with specified name exists. ");
            return profile.getProfilesWithDuplicateSettings(context);
        }
    }

    public void validateNameAndDesc(StorageProfile profile) throws ConfigMgmtException, BadParameterException {
        if (profile.getName() == null || profile.getName().trim().length() == 0) {
            throw new ConfigMgmtException("storage.mgmt.profile.create.error.noname", "Name not entered.");
        }
        this.validateProfileName(profile.getName());
        this.validateDescription(profile.getDescription(), Validate.PROFILE_DESC_OBJECT);
    }

    private void validateProfileName(String name) throws BadParameterException {
        String methodName = "validateProfileName";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to validate name = " + name));
        Validate.objectName((String)Validate.PROFILE_NAME_OBJECT, (String)name);
        Validate.validateNameLength((String)name, (int)this.getAllowedNameLength());
    }

    public void createProfile(ConfigContext context, StorageProfile profileToCreate) throws ConfigMgmtException, BadParameterException {
        String methodName = "createProfile";
        Trace.methodBegin((Object)this, (String)methodName);
        this.validateNameAndDesc(profileToCreate);
        profileToCreate.save(context);
        LogAPI.staticLog((String)"POOL_PROFILE_CREATE", (String[])new String[]{profileToCreate.getName()}, (String[])new String[0]);
    }

    public void deleteProfile(ConfigContext context, StorageProfile profileToDelete) throws ConfigMgmtException {
        String methodName = "deleteProfile";
        Trace.methodBegin((Object)this, (String)methodName);
        profileToDelete.delete(context);
        LogAPI.staticLog((String)"POOL_PROFILE_DELETE", (String[])new String[]{profileToDelete.getName()}, (String[])new String[0]);
    }

    public boolean areAllArraysHealthy(ConfigContext context) {
        String methodName = "areAllArraysHealthy";
        Trace.methodBegin((Object)this, (String)methodName);
        boolean result = false;
        try {
            ManageT4sInterface t4Manager = ManageT4sFactory.getManager();
            t4Manager.init(context, null);
            result = t4Manager.areAllArraysHealthy();
        }
        catch (ConfigMgmtException cfe) {
            result = false;
        }
        return result;
    }

    public List getProfilesToImport(ConfigContext argContext, String theXml) throws ConfigMgmtException, Exception {
        String methodName = "importXml";
        Trace.methodBegin((Object)this, (String)methodName);
        List foundProfiles = new ArrayList();
        foundProfiles = this.profilesManager.getXmlContentsForImport(argContext, theXml);
        return foundProfiles;
    }

    public String getIllegalNameCharacterPattern() {
        return ".*[\\s,]+.*";
    }

    public int getAllowedNameLength() {
        return 32;
    }

    public int getAllowedDescLength(String objectName) {
        return 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String loadUrl(String url) {
        StringBuffer result;
        block12: {
            String methodName = "loadUrl";
            Trace.methodBegin((Object)this, (String)methodName);
            result = new StringBuffer("");
            BufferedReader br = null;
            URL theUrl = new URL(url);
            br = new BufferedReader(new InputStreamReader(theUrl.openStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                result.append(line);
            }
            Object var8_8 = null;
            try {
                if (br != null) {
                    br.close();
                }
                break block12;
            }
            catch (Exception e2) {}
            break block12;
            {
                catch (Exception e) {
                    Object var8_9 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block12;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result.toString();
    }

    public StorageProfile getOrCreateMatchingProfile(ConfigContext context, String oldProfileName, String newProfileName, T4Interface t4) throws Exception {
        StorageProfile newProfile;
        String methodName = "getOrCreateMatchingProfile";
        Trace.methodBegin((Object)this, (String)methodName);
        StorageProfile currentProfile = this.profilesManager.getProfile(oldProfileName);
        List matchingProfiles = this.profilesManager.getMatchingProfilesForReadaheadChange(currentProfile, t4);
        int newReadAhead = Integer.parseInt(t4.getReadaheadMode() == 0 ? "1" : "0");
        if (newProfileName == null) {
            Trace.verbose((Object)this, (String)methodName, (String)"No new profile name given");
            if (matchingProfiles != null && !matchingProfiles.isEmpty()) {
                Trace.verbose((Object)this, (String)methodName, (String)"Found first matching profile");
                return (StorageProfile)matchingProfiles.get(0);
            }
            Trace.verbose((Object)this, (String)methodName, (String)"No existing matching found; create new");
            StorageProfile newProfile2 = new StorageProfile(this.profilesManager.createNewProfileName(currentProfile.getRaidLevel()), "", currentProfile.getRaidLevel(), currentProfile.getSegmentSize(), newReadAhead, currentProfile.getNumberOfDrives(), currentProfile.getDedicatedHotSpare(), currentProfile.getArrayType());
            Trace.verbose((Object)this, (String)methodName, (String)"Creating new profile ...");
            this.createProfile(context, newProfile2);
            return newProfile2;
        }
        try {
            newProfile = this.profilesManager.getProfile(newProfileName);
            if (matchingProfiles.contains(newProfile)) {
                Trace.verbose((Object)this, (String)methodName, (String)"Found a matching profile; no need to create new profile");
                return newProfile;
            }
        }
        catch (ItemNotFoundException infe) {
            Trace.verbose((Object)this, (String)methodName, (String)"Swallow exception since will create new profile");
        }
        Trace.verbose((Object)this, (String)methodName, (String)"No existing matching found; create new");
        newProfile = new StorageProfile(newProfileName, "", currentProfile.getRaidLevel(), currentProfile.getSegmentSize(), newReadAhead, currentProfile.getNumberOfDrives(), currentProfile.getDedicatedHotSpare(), currentProfile.getArrayType());
        Trace.verbose((Object)this, (String)methodName, (String)"Creating new profile ...");
        this.createProfile(context, newProfile);
        return newProfile;
    }
}

