/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.admin.business.NetworkAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConnectionFactory;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.Locale;

public class NetSettingsSaverThread
extends Thread {
    private NetworkAdminInterface networkInterface;
    private boolean useDynamicIp;
    private boolean networkParamsChanged;
    private String arrayName;
    private boolean domainChanged;
    private String userName;
    private String password;
    private Locale locale;

    public NetSettingsSaverThread(boolean useDynamicIp, boolean networkParamsChanged, NetworkAdminInterface networkInterface, String arrayName, ConfigContext configContext) {
        this.useDynamicIp = useDynamicIp;
        this.networkInterface = networkInterface;
        this.networkParamsChanged = networkParamsChanged;
        this.arrayName = arrayName;
        this.userName = configContext.getUser();
        this.password = configContext.getPasswordCredential().getUserPassword();
        this.locale = configContext.getLocale();
    }

    public NetSettingsSaverThread(boolean useDynamicIp, boolean networkParamsChanged, NetworkAdminInterface networkInterface, String arrayName, ConfigContext configContext, boolean domainChanged) {
        this(useDynamicIp, networkParamsChanged, networkInterface, arrayName, configContext);
        this.domainChanged = domainChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block27: {
            ConfigContext context;
            String[] domainArg;
            String[] args;
            boolean isMR3;
            block26: {
                Trace.verbose((Object)this, (String)"run", (String)"Starting the thread to change network settings");
                isMR3 = Repository.getRepository().getConfigInteger() >= 3;
                args = new String[]{this.networkInterface.getIpAddress(), this.networkInterface.getGatewayIp(), this.networkInterface.getNetmask(), this.networkInterface.getDnsAddress()};
                domainArg = new String[]{this.networkInterface.getDomainName()};
                context = null;
                context = ConnectionFactory.getConfigContext((String)this.userName, (String)this.password, (Locale)this.locale);
                this.networkInterface.setConfigContext(context);
                this.networkInterface.save();
                if (this.useDynamicIp) {
                    String logString;
                    if (isMR3) {
                        logString = "FIREWALL_NETWORK_SETTINGS_CHANGE_DHCP";
                    } else {
                        logString = "ARRAY_NETWORK_SETTINGS_CHANGE_RARP";
                        args[0] = this.arrayName;
                    }
                    LogAPI.staticLog((String)logString, (String[])args, (String[])new String[0]);
                } else if (this.networkParamsChanged) {
                    String logString;
                    if (isMR3) {
                        logString = "FIREWALL_NETWORK_SETTINGS_CHANGE_FIXED_IP";
                    } else {
                        logString = "ARRAY_NETWORK_SETTINGS_CHANGE_FIXED_IP";
                        args[3] = this.arrayName;
                    }
                    LogAPI.staticLog((String)logString, (String[])args, (String[])new String[0]);
                }
                if (!this.domainChanged) break block26;
                LogAPI.staticLog((String)"DOMAIN_NAME_CHANGE", (String[])domainArg, (String[])new String[0]);
            }
            Object var8_9 = null;
            try {
                if (context != null && isMR3) {
                    context.getClient().close();
                }
                break block27;
            }
            catch (Exception e2) {}
            break block27;
            {
                catch (Exception e) {
                    if (this.useDynamicIp) {
                        String logString;
                        if (isMR3) {
                            logString = "FIREWALL_NETWORK_SETTINGS_CHANGE_DHCP_ERROR";
                        } else {
                            logString = "ARRAY_NETWORK_SETTINGS_CHANGE_RARP_ERROR";
                            args[0] = this.arrayName;
                        }
                        LogAPI.staticLog((String)logString, (String[])args, (String[])new String[0]);
                    } else if (this.networkParamsChanged) {
                        String logString;
                        args[0] = this.networkInterface.getIpAddress();
                        if (isMR3) {
                            logString = "FIREWALL_NETWORK_SETTINGS_CHANGE_FIXED_IP_ERROR";
                        } else {
                            logString = "ARRAY_NETWORK_SETTINGS_CHANGE_FIXED_IP_ERROR";
                            args[1] = this.arrayName;
                        }
                        LogAPI.staticLog((String)logString, (String[])args, (String[])new String[0]);
                    }
                    if (this.domainChanged) {
                        LogAPI.staticLog((String)"DOMAIN_NAME_CHANGE_ERROR", (String[])domainArg, (String[])new String[0]);
                    }
                    Object var8_10 = null;
                    try {
                        if (context != null && isMR3) {
                            context.getClient().close();
                        }
                        break block27;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (context != null && isMR3) {
                        context.getClient().close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Trace.verbose((Object)this, (String)"run", (String)"Done");
    }
}

