/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.admin.business.NetworkAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.SystemTimeAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.UserInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.cfg.ui.business.AdminReportComponent;
import com.sun.netstorage.array.mgmt.cfg.ui.business.AdminReportComponentAttribute;
import com.sun.netstorage.array.mgmt.cfg.ui.business.AdminReports;
import com.sun.netstorage.array.mgmt.cfg.ui.business.AdminUsers;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class M1M2AdminReports
extends AdminReports {
    public M1M2AdminReports(Locale locale) {
        super(locale);
    }

    public AdminReportComponent buildReport(ConfigContext configContext, SearchFilter searchFilter, Locale locale) throws CoreUIBusException {
        AdminReportComponent report = new AdminReportComponent("array-config", null);
        report.addSubComponent(this.buildUserListComponent(configContext));
        try {
            List allKnownT4s = this.findAllKnownT4s(configContext, searchFilter);
            if (allKnownT4s != null) {
                Iterator t4Iterator = allKnownT4s.iterator();
                while (t4Iterator.hasNext()) {
                    T4Interface array = (T4Interface)t4Iterator.next();
                    AdminReportComponent arrayComponent = this.buildT4Component(configContext, array);
                    arrayComponent.addSubComponent(this.buildAdminComponent(configContext, array));
                    report.addSubComponent(arrayComponent);
                }
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"buildReport", (Throwable)e);
            report.setReportException(e);
        }
        try {
            report.addSubComponent(this.buildProfilesComponent(configContext));
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"buildReport exception building profile component", (Throwable)e);
            report.setReportException(e);
        }
        return report;
    }

    protected AdminReportComponent buildAdminComponent(ConfigContext configContext, T4Interface array) throws Exception {
        AdminReportComponent adminComponent = new AdminReportComponent("admin", "report.admin.title");
        adminComponent.addSubComponent(this.buildNetworkComponent(configContext, array));
        adminComponent.addSubComponent(this.buildTimeComponent(configContext, array));
        return adminComponent;
    }

    protected AdminReportComponent buildNetworkComponent(ConfigContext configContext, T4Interface array) {
        AdminReportComponent networkComponent = new AdminReportComponent("network", "report.admin.network.title");
        try {
            Admin adminBizObj = new Admin();
            NetworkAdminInterface networkAdmin = adminBizObj.getNetworkAdminInterface(configContext);
            networkAdmin.setScope((InstanceWrapper)array);
            networkAdmin.init(configContext);
            String ipAssignment = networkAdmin.isRarp() ? "rarp" : "fixed";
            networkComponent.addAttribute(new AdminReportComponentAttribute("ip-assignment", "report.admin.network.ipassignment.label", ipAssignment, true, "admin.network"));
            networkComponent.addAttribute(new AdminReportComponentAttribute("ip", "report.admin.network.ip.label", networkAdmin.getIpAddress(), false, null));
            networkComponent.addAttribute(new AdminReportComponentAttribute("gateway", "report.admin.network.gateway.label", networkAdmin.getGatewayIp(), false, null));
            networkComponent.addAttribute(new AdminReportComponentAttribute("netmask", "report.admin.network.netmask.label", networkAdmin.getNetmask(), false, null));
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"_buildNetworkComponent", (Throwable)e);
        }
        return networkComponent;
    }

    protected AdminReportComponent buildTimeComponent(ConfigContext configContext, T4Interface array) {
        AdminReportComponent timeComponent = new AdminReportComponent("time", "report.admin.time.title");
        try {
            Admin adminBizObj = new Admin();
            SystemTimeAdminInterface timeAdmin = adminBizObj.getSystemTimeAdminInterface(configContext);
            timeAdmin.setScope((InstanceWrapper)array);
            timeAdmin.init(configContext);
            timeComponent.addAttribute(new AdminReportComponentAttribute("current-system-time", "report.admin.time.currentsystemtime.label", Convert.dateTimeToString((Date)timeAdmin.getTime(), (TimeZone)TimeZone.getDefault(), (int)2, (Locale)configContext.getLocale()), false, null));
            timeComponent.addAttribute(new AdminReportComponentAttribute("time-zone", "report.admin.time.timezone.label", timeAdmin.getCurrentTimeZone().getDisplayName(configContext.getLocale()), false, null));
            AdminReportComponent timeSettingsComponent = new AdminReportComponent("settings", "report.admin.time.settings.title");
            AdminReportComponent timeNtpSettingsComponent = new AdminReportComponent("ntp", "report.admin.time.settings.ntp.title");
            String ntpIp = timeAdmin.getNtpServerIp() != null ? timeAdmin.getNtpServerIp() : "";
            timeNtpSettingsComponent.addAttribute(new AdminReportComponentAttribute("ntp-ip", "report.admin.time.settings.ntp.ntpip.label", ntpIp, false, null));
            timeSettingsComponent.addSubComponent(timeNtpSettingsComponent);
            timeComponent.addSubComponent(timeSettingsComponent);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"_buildTimeComponent", (Throwable)e);
        }
        return timeComponent;
    }

    protected AdminReportComponent buildUserListComponent(ConfigContext configContext) {
        AdminReportComponent userListComponent = new AdminReportComponent("userlist", "report.admin.userlist.title");
        userListComponent.addAttribute(new AdminReportComponentAttribute("username-label", "admin.users.list.username", "", false, null));
        userListComponent.addAttribute(new AdminReportComponentAttribute("role-label", "admin.users.list.role", "", false, null));
        try {
            AdminUsers adminUsers = new AdminUsers();
            List userList = adminUsers.getUserList(configContext, null);
            if (userList != null) {
                Iterator userIterator = userList.iterator();
                while (userIterator.hasNext()) {
                    UserInterface user = (UserInterface)userIterator.next();
                    userListComponent.addAttribute(new AdminReportComponentAttribute("user", user.getRole().getKey(), user.getName(), false, null));
                }
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"_buildUserListComponent", (Throwable)e);
        }
        return userListComponent;
    }

    public static void main(String[] args) {
        Locale locale = Locale.getDefault();
        M1M2AdminReports reportGenerator = new M1M2AdminReports(locale);
        Repository.getRepository().setTestEnvironment(true);
        try {
            AdminReportComponent report = reportGenerator.buildReport(null, null, locale);
        }
        catch (CoreUIBusException e) {
            e.printStackTrace();
        }
    }
}

