/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConnectionFactory;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.InvalidCredentials;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class JobsQueue
extends TimerTask
implements Constants.SupportedFeature {
    private static HashMap myQueues = new HashMap();
    private ConfigContext configContext;
    private String arrayName;
    private String arrayIP;
    Vector queuedJobs;
    public static final int CREATE_STUFF_FOR_CLONE_TRAY = 1;
    public static final int CREATE_STUFF_FOR_CLONE_ARRAY = 2;
    public static final int SAVE_ARRAY_SETTINGS_JOB = 3;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$ui$business$JobsQueue;

    private JobsQueue(String array, ConfigContext cc) {
        Trace.constructor((Object)this);
        this.queuedJobs = new Vector();
        this.arrayName = array;
        this.arrayIP = IPUtil.lookUpIP((String)this.arrayName);
        this.configContext = cc;
        Repository.getRepository().getTimer().schedule((TimerTask)this, 15000L, 15000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized JobsQueue getInstance(String array, ConfigContext cc) {
        JobsQueue jq = null;
        HashMap hashMap = myQueues;
        synchronized (hashMap) {
            jq = (JobsQueue)myQueues.get(array);
            if (jq == null) {
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$JobsQueue == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$business$JobsQueue = JobsQueue.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.JobsQueue")) : class$com$sun$netstorage$array$mgmt$cfg$ui$business$JobsQueue), (String)"getInstance", (String)("creating JobsQueue for array: " + array));
                jq = new JobsQueue(array, cc);
                myQueues.put(array, jq);
            }
        }
        return jq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MethodCallStatus checkAndSend() {
        CIMOMHandleWrapper h22;
        MethodCallStatus methodCallStatus;
        ConfigContext lCC;
        block8: {
            CIMOMHandleWrapper h22;
            Jobs realJobs = new Jobs();
            List realJobList = null;
            lCC = null;
            try {
                try {
                    SearchFilter sf = new SearchFilter("InstanceID", Pattern.compile("^" + this.arrayIP + ":"));
                    lCC = ConnectionFactory.getConfigContext((String)this.configContext.getUser(), (String)this.configContext.getPasswordCredential().getUserPassword(), (Locale)this.configContext.getLocale());
                    realJobList = realJobs.getOutstandingJobsList(lCC, sf);
                }
                catch (InvalidCredentials ce) {
                    Trace.verbose((Object)this, (String)"checkAndSend", (Throwable)ce);
                }
                catch (ConfigMgmtException cme) {
                    Trace.verbose((Object)this, (String)"checkAndSend", (Throwable)cme);
                }
                if (realJobList != null && realJobList.size() != 0) break block8;
                Trace.verbose((Object)this, (String)"checkAndSend", (String)"######## No jobs detected on provider side");
                methodCallStatus = this.sendJob(lCC);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                block9: {
                    CIMOMHandleWrapper h22;
                    Object var6_9 = null;
                    if (lCC == null || (h22 = lCC.getClient()) == null) break block9;
                    h22.close();
                }
                throw throwable;
            }
            if (lCC != null && (h22 = lCC.getClient()) != null) {
                h22.close();
            }
            return methodCallStatus;
        }
        methodCallStatus = null;
        Object var6_8 = null;
        if (lCC != null && (h22 = lCC.getClient()) != null) {
            h22.close();
        }
        return methodCallStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        if (this.queuedJobs.size() == 0) {
            HashMap hashMap = myQueues;
            synchronized (hashMap) {
                Trace.verbose((Object)this, (String)"run", (String)("Terminating as no more jobs for: " + this.arrayName));
                myQueues.remove(this.arrayName);
                this.cancel();
                return;
            }
        }
        this.checkAndSend();
    }

    public synchronized Vector getQueuedJobs() {
        if (this.queuedJobs == null || this.queuedJobs.size() == 0) {
            return new Vector();
        }
        return (Vector)this.queuedJobs.clone();
    }

    private synchronized MethodCallStatus sendJob(ConfigContext lCC) {
        ArrayList realJobList;
        Trace.methodBegin((Object)this, (String)"sendJob");
        MethodCallStatus mcs = new MethodCallStatus();
        mcs.setReturnCode(0);
        if (this.queuedJobs == null || this.queuedJobs.size() == 0) {
            Trace.verbose((Object)this, (String)"sendJob", (String)"There are no jobs queued for execution");
            return null;
        }
        QueuedJob qj = (QueuedJob)this.queuedJobs.elementAt(0);
        switch (qj.getJobType()) {
            case 1: {
                mcs = this.createStuffForCT(qj, lCC);
                break;
            }
            case 2: {
                mcs = this.createStuffForCA(qj, lCC);
                break;
            }
            case 3: {
                mcs = this.saveArraySettings(qj, lCC);
            }
        }
        if (mcs != null && (realJobList = mcs.getJobs()) != null) {
            for (int i = 0; i < realJobList.size(); ++i) {
                JobInterface rj = (JobInterface)realJobList.get(i);
                if (qj.getNotifyEmail() == null) continue;
                Trace.verbose((Object)this, (String)"sendJob", (String)("call rj.setNotifyEmail " + qj.getNotifyEmail()));
                rj.setNotifyEmail(qj.getNotifyEmail());
                try {
                    rj.save();
                    continue;
                }
                catch (Exception e) {
                    Trace.verbose((Object)this, (String)"sendJob", (String)"failed to save job email");
                    Trace.verbose((Object)this, (String)"sendJob", (Throwable)e);
                }
            }
        }
        this.queuedJobs.remove(0);
        Trace.verbose((Object)this, (String)"sendJob", (String)("Queue size: " + this.queuedJobs.size()));
        return mcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MethodCallStatus addJob(QueuedJob arg) {
        HashMap hashMap = myQueues;
        synchronized (hashMap) {
            Trace.verbose((Object)this, (String)"addJob", (String)"Adding job to a queue in master list");
            if (!myQueues.containsKey(this.arrayName)) {
                JobsQueue jq = new JobsQueue(this.arrayName, this.configContext);
                myQueues.put(this.arrayName, jq);
            }
            this.queuedJobs.add(arg);
        }
        MethodCallStatus mcs = new MethodCallStatus();
        mcs.setReturnCode(0);
        mcs.addJobToList((JobInterface)arg);
        if (this.queuedJobs.size() == 1) {
            Trace.verbose((Object)this, (String)"addJob", (String)"There are no queued jobs - send immediately");
            MethodCallStatus mcs2 = this.checkAndSend();
            if (mcs2 != null) {
                mcs = mcs2;
            }
        }
        return mcs;
    }

    public MethodCallStatus addSaveArraySettingsJob(T4Interface array) throws ConfigMgmtException {
        Trace.methodBegin((Object)this, (String)"addSaveArraySettingsJobs");
        QueuedJob qj = new QueuedJob(3);
        int bs = array.getBlockSize();
        Trace.verbose((Object)this, (String)"addSaveArraySettingsJobs", (String)("saving blockSize=" + bs));
        qj.setArg(array.getClusterName());
        qj.setArg(array.getDescription());
        qj.setArg(new Integer(array.getDiskReconRate()));
        qj.setArg(array.getFailoverMode());
        qj.setArg(new Integer(bs));
        qj.setArg(new Integer(array.getReadaheadMode()));
        qj.setArg(array.getCacheMode());
        if (array.isFeatureSupported(1)) {
            qj.setArg(new Boolean(array.isDiskScrubbing()));
        }
        if (array.isFeatureSupported(3)) {
            qj.setArg(new Integer(array.getAhsPoolSize()));
        }
        qj.setArg(array.getOndgMode());
        return this.addJob(qj);
    }

    private MethodCallStatus saveArraySettings(QueuedJob qj, ConfigContext lCC) {
        Trace.methodBegin((Object)this, (String)"saveArraySettings");
        MethodCallStatus mcs = new MethodCallStatus();
        mcs.setReturnCode(0);
        try {
            Vector arrayL = qj.getArgs();
            ManageT4sInterface mt4 = ManageT4sFactory.getManager();
            mt4.init(lCC, null);
            T4Interface t4 = mt4.getT4ByIP((String)arrayL.get(0));
            Trace.verbose((Object)this, (String)"saveArraySettings", (String)("Original block size was: " + t4.getBlockSize()));
            int argIndex = 1;
            t4.setDescription((String)arrayL.get(argIndex++));
            t4.setDiskReconRate(((Integer)arrayL.get(argIndex++)).intValue());
            t4.setFailoverMode((String)arrayL.get(argIndex++));
            t4.setBlockSize(((Integer)arrayL.get(argIndex++)).intValue());
            t4.setReadaheadMode(((Integer)arrayL.get(argIndex++)).intValue());
            t4.setCacheMode((String)arrayL.get(argIndex++));
            if (t4.isFeatureSupported(1)) {
                t4.setDiskScrubbing(((Boolean)arrayL.get(argIndex++)).booleanValue());
            }
            if (t4.isFeatureSupported(3)) {
                t4.setAhsPoolSize(((Integer)arrayL.get(argIndex++)).intValue());
            }
            t4.setOndgMode((String)arrayL.get(argIndex++));
            t4.save();
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"saveArraySettings", (Throwable)e);
        }
        return mcs;
    }

    public MethodCallStatus addCreateStuffForCAJob(Object sourceArray, Object destArray) throws ConfigMgmtException {
        QueuedJob qj = new QueuedJob(2);
        qj.setArg(((T4Interface)sourceArray).getClusterName());
        qj.setArg(((T4Interface)destArray).getClusterName());
        return this.addJob(qj);
    }

    private MethodCallStatus createStuffForCA(QueuedJob qj, ConfigContext lCC) {
        Trace.methodBegin((Object)this, (String)"createStuffForCA");
        Vector args = qj.getArgs();
        MethodCallStatus mcs = null;
        try {
            String sourceArrayIP = (String)args.get(0);
            String destArrayIP = (String)args.get(1);
            ManageT4sInterface mt4 = ManageT4sFactory.getManager();
            mt4.init(lCC, null);
            T4Interface sourceArray = mt4.getT4ByIP(sourceArrayIP);
            mt4.init(lCC, null);
            T4Interface destArray = mt4.getT4ByIP(destArrayIP);
            mcs = destArray.cloneFrom(sourceArray);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"createStuffForCA", (Throwable)e);
        }
        return mcs;
    }

    public MethodCallStatus addCreateStuffForCTJob(Object sourceTray, Object destTray) throws ConfigMgmtException {
        QueuedJob qj = new QueuedJob(1);
        String srcT4IP = Repository.getRepository().getIpAddress(((TrayInterface)sourceTray).getT4Name());
        qj.setArg(srcT4IP);
        qj.setArg(((TrayInterface)sourceTray).getId());
        String destT4IP = Repository.getRepository().getIpAddress(((TrayInterface)destTray).getT4Name());
        qj.setArg(destT4IP);
        qj.setArg(((TrayInterface)destTray).getId());
        return this.addJob(qj);
    }

    private MethodCallStatus createStuffForCT(QueuedJob qj, ConfigContext lCC) {
        Trace.methodBegin((Object)this, (String)"createStuffForCT");
        Vector args = qj.getArgs();
        MethodCallStatus mcs = null;
        try {
            TrayInterface sourceTray = this.getTrayInterface(lCC, (String)args.get(0), (String)args.get(1));
            TrayInterface destTray = this.getTrayInterface(lCC, (String)args.get(2), (String)args.get(3));
            destTray.setConfigContext(lCC);
            sourceTray.setConfigContext(lCC);
            mcs = destTray.cloneFrom(sourceTray);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"createStuffForCT", (Throwable)e);
        }
        return mcs;
    }

    private TrayInterface getTrayInterface(ConfigContext lCC, String arrayIP, String trayID) throws ConfigMgmtException {
        ManageT4sInterface mt4 = ManageT4sFactory.getManager();
        mt4.init(lCC, null);
        T4Interface sourceArray = mt4.getT4ByIP(arrayIP);
        if (sourceArray == null) {
            throw new ConfigMgmtException("Zero CIM Instances Returned for array", "ZERO_CIM_INSTANCE_RETURNED");
        }
        ManageTraysInterface mTray = ManageTraysFactory.getManager();
        mTray.setScope((InstanceWrapper)sourceArray);
        SearchFilter sf = new SearchFilter("Tag", Pattern.compile(":" + trayID + "$"));
        mTray.init(lCC, sf);
        List trays = mTray.getItemList();
        if (trays == null || trays.size() == 0) {
            throw new ConfigMgmtException("Zero CIM Instances Returned for Tray", "ZERO_CIM_INSTANCE_RETURNED");
        }
        TrayInterface tray = (TrayInterface)trays.get(0);
        return tray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class QueuedJob
    implements JobInterface,
    Constants.JobProperties,
    Constants.OperationalStatusValues {
        private int jobType;
        private Vector args;
        private String description;
        private String jobStatus;
        private String email;
        private String array;
        boolean isDeleted = false;
        boolean isKilled = false;
        private CIMObjectPath path;

        public QueuedJob(int p2) {
            this.jobType = p2;
            this.args = new Vector();
        }

        public void setConfigContext(ConfigContext argCC) {
        }

        public void setArg(Object arg) {
            this.args.add(arg);
        }

        public Vector getArgs() {
            return this.args;
        }

        public int getJobType() {
            return this.jobType;
        }

        public void setJobType(int jobType) {
            this.jobType = jobType;
        }

        public String getId() {
            return "127.0.0.1";
        }

        public String getName() {
            return "";
        }

        public String getDescription() {
            return this.description;
        }

        public int getPercentComplete() {
            return 0;
        }

        public Date getStartTime() {
            return null;
        }

        public Date getEndTime() {
            return null;
        }

        public String getNotifyEmail() {
            return this.email;
        }

        public void setNotifyEmail(String email) {
            this.email = email;
        }

        public String getArray() {
            return this.array;
        }

        public void save() throws ConfigMgmtException {
        }

        public void delete() throws ConfigMgmtException {
            this.isDeleted = true;
        }

        public void kill() throws ConfigMgmtException {
            this.isKilled = true;
        }

        public int getErrorCode() {
            return 0;
        }

        public String getErrorDescription() {
            return "";
        }

        public void setDescription(String argDesc) {
            this.description = argDesc;
        }

        public CIMObjectPath getObjectPath() {
            return this.path;
        }

        public CIMInstance getInstance() {
            return null;
        }

        public boolean isActive() {
            return true;
        }

        public Integer getStatus() {
            return new Integer(0);
        }

        public String getStatusKey() {
            return "dormant";
        }

        public void reload() throws ConfigMgmtException {
        }

        public String getSortKey() {
            return this.getId();
        }

        public void setArray(String array) {
            this.array = array;
        }

        public String getJobStatus() {
            return "Queued";
        }

        public void setPercentComplete(int percentComplete) {
        }

        public void setJobStatus(String jobStatus) {
        }

        public void setTaskResult(int taskIndex, String result, boolean success) {
        }

        public String getTaskResult(int taskIndex) {
            return "";
        }

        public int getTaskFailureCount() {
            return 0;
        }

        public Vector getTaskResults() {
            return new Vector();
        }

        public String getTask(int taskIndex) {
            return "";
        }

        public Vector getTasks() {
            return new Vector();
        }

        public boolean isResultTypeSuccess(int taskIndex) {
            return false;
        }

        public Vector getTaskResultTypes() {
            return new Vector();
        }

        public boolean isUIJob() {
            return false;
        }

        public String getUIJobStatus(String successStr, String pendingStr, String sepStr, String delimitStr) {
            String status = new String();
            return status;
        }
    }
}

