/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerFactory;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.BOComparators;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class Jobs
extends CoreUIBusObject {
    private JobManagerInterface jobManager = JobManagerFactory.create();
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs;

    public List getOutstandingJobsListForArrays(ConfigContext configContext, ArrayList arrayNames) throws ConfigMgmtException {
        SearchFilter sf = null;
        if (arrayNames != null && arrayNames.size() > 0) {
            String pattern = "^(";
            Iterator t4iterator = arrayNames.iterator();
            while (t4iterator.hasNext()) {
                String t4ip = IPUtil.lookUpIP((String)((String)t4iterator.next()));
                if (pattern.length() > 3) {
                    pattern = pattern + "|";
                }
                StringTokenizer st = new StringTokenizer(t4ip, ".");
                boolean first = true;
                while (st.hasMoreTokens()) {
                    if (!first) {
                        pattern = pattern + "\\.";
                    }
                    pattern = pattern + st.nextToken();
                    first = false;
                }
            }
            pattern = pattern + ")";
            Trace.verbose((Object)this, (String)"checkForActiveJobs", (String)("job filter pattern is: " + pattern));
            sf = new SearchFilter("InstanceID", Pattern.compile(pattern));
        }
        return this.getOutstandingJobsList(configContext, sf);
    }

    public List getOutstandingJobsList(ConfigContext configContext, SearchFilter filter) throws ConfigMgmtException {
        this.jobManager.setShowAllJobs(false);
        this.jobManager.init(configContext, filter);
        return this.jobManager.getItemList();
    }

    public List getAllJobsList(ConfigContext configContext, SearchFilter filter) throws ConfigMgmtException {
        this.jobManager.setShowAllJobs(true);
        this.jobManager.init(configContext, filter);
        return this.jobManager.getItemList();
    }

    public JobInterface getJobById(List jobList, String jobId) throws ConfigMgmtException, IndexOutOfBoundsException {
        for (int i = 0; i < jobList.size(); ++i) {
            if (!((JobInterface)jobList.get(i)).getId().equals(jobId)) continue;
            return (JobInterface)jobList.get(i);
        }
        throw new IndexOutOfBoundsException();
    }

    private JobInterface findJob(String jobName, List jobs) throws Exception {
        JobInterface job = null;
        try {
            job = (JobInterface)FilterUtil.findNamedObject((String)jobName, (List)jobs, (NameBasedComparator)BOComparators.JOB_COMPARATOR);
        }
        catch (Exception e) {
            throw new Exception("error.objectNotFound");
        }
        return job;
    }

    public List deleteJobs(List jobList, int[] selectedItems) {
        ArrayList<JobInterface> returnFailures = new ArrayList<JobInterface>();
        for (int i = 0; i < selectedItems.length; ++i) {
            JobInterface job = (JobInterface)jobList.get(selectedItems[i]);
            try {
                job.delete();
                continue;
            }
            catch (ConfigMgmtException e) {
                returnFailures.add(job);
            }
        }
        return returnFailures;
    }

    public List deleteJobs(List jobList) {
        ArrayList<JobInterface> returnFailures = new ArrayList<JobInterface>();
        for (int i = 0; i < jobList.size(); ++i) {
            JobInterface job = (JobInterface)jobList.get(i);
            try {
                job.delete();
                continue;
            }
            catch (ConfigMgmtException e) {
                returnFailures.add(job);
            }
        }
        return returnFailures;
    }

    public List killJobs(List jobList, int[] selectedItems) {
        ArrayList<JobInterface> returnFailures = new ArrayList<JobInterface>();
        for (int i = 0; i < selectedItems.length; ++i) {
            JobInterface job = (JobInterface)jobList.get(selectedItems[i]);
            try {
                job.kill();
                continue;
            }
            catch (ConfigMgmtException e) {
                returnFailures.add(job);
            }
        }
        return returnFailures;
    }

    public List killJobs(List jobList) {
        ArrayList<JobInterface> returnFailures = new ArrayList<JobInterface>();
        for (int i = 0; i < jobList.size(); ++i) {
            JobInterface job = (JobInterface)jobList.get(i);
            try {
                job.kill();
                continue;
            }
            catch (ConfigMgmtException e) {
                returnFailures.add(job);
            }
        }
        return returnFailures;
    }

    public static boolean hasJobsInMethodCallStatuses(List methodCallStatuses) {
        String methodName = "hasJobsInMethodCallStatuses(list)";
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs = Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs")) : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName);
        if (methodCallStatuses == null) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs = Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs")) : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)"No status object list given; return false for no jobs");
            return false;
        }
        for (int i = 0; i < methodCallStatuses.size(); ++i) {
            MethodCallStatus methodCallStatus = (MethodCallStatus)methodCallStatuses.get(i);
            ArrayList jobs = methodCallStatus.getJobs();
            if (jobs == null || jobs.size() <= 0) continue;
            for (int j = 0; j < jobs.size(); ++j) {
                JobInterface job = (JobInterface)jobs.get(j);
                if (job.isActive()) {
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs = Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs")) : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)"Job is ACTIVE; return true for jobs");
                    return true;
                }
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)"Found JOB, but it is not active");
            }
        }
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs = Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs")) : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)"No JOBS found in status objects");
        return false;
    }

    public static boolean saveNotificationEmail(List methodCallStatuses, String notificationEmail, ConfigContext argCC) throws ConfigMgmtException {
        String methodName = "saveNotificationEmail";
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs = Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs")) : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)"saveNotificationEmail");
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs = Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs")) : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)("email to save is " + notificationEmail));
        if (methodCallStatuses == null) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs = Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs")) : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)"No method call statuses given; return false for save email");
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs = Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs")) : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)"email NOT saved... maybe job already completed");
            return false;
        }
        boolean returnValue = false;
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs = Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs")) : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)("Have " + methodCallStatuses.size() + " status objects to save email"));
        for (int i = 0; i < methodCallStatuses.size(); ++i) {
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)("On call status = " + i));
            MethodCallStatus methodCallStatus = (MethodCallStatus)methodCallStatuses.get(i);
            ArrayList jobs = methodCallStatus.getJobs();
            if (jobs != null && jobs.size() > 0) {
                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)("Have " + jobs.size() + " jobs in this status"));
                for (int j = 0; j < jobs.size(); ++j) {
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)("On JOB = " + j));
                    JobInterface job = (JobInterface)jobs.get(j);
                    if (job.isActive()) {
                        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)("Job id:" + job.getId() + " still active; set email"));
                        returnValue = true;
                        job.setConfigContext(argCC);
                        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)"Set notification email");
                        job.setNotifyEmail(notificationEmail);
                        try {
                            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)"Save!");
                            job.save();
                            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)"Reload!");
                            job.reload();
                            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)("After setting email = " + notificationEmail + " and save"));
                            continue;
                        }
                        catch (ConfigMgmtException cme) {
                            if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs))) {
                                Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)"Jobs notification save failed becauce the job is already complete; exception is OK; try to reload the job and check status again.");
                            }
                            job.reload();
                            if (!job.isActive()) continue;
                            Trace.error((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs = Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs")) : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (ConfigMgmtException)cme);
                            throw cme;
                        }
                    }
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)"Job is inactive; don't set notification");
                }
                continue;
            }
            Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs == null ? Jobs.class$("com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs") : class$com$sun$netstorage$array$mgmt$cfg$ui$business$Jobs), (String)methodName, (String)"No jobs found in status");
        }
        return returnValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

