/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.access.business.BindingInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Bindings;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class Initiators
extends CoreUIBusObject {
    private ManageInitiatorsInterface iniManager = ManageInitiatorsFactory.getManager();

    public List list(ConfigContext configContext, SearchFilter searchFilter) throws CoreUIBusException {
        try {
            this.iniManager.init(configContext, searchFilter);
            return this.iniManager.getItemList();
        }
        catch (Exception e) {
            throw new CoreUIBusException(e.toString());
        }
    }

    public List listForArray(ConfigContext configContext, T4Interface array) throws ConfigMgmtException {
        this.iniManager.setScope((InstanceWrapper)array);
        this.iniManager.init(configContext, null);
        return this.iniManager.getItemList();
    }

    public void createInitiator(ConfigContext configContext, T4Interface array, String wwn, String description, List initiatorGroups) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin((Object)this, (String)"createInitiator");
        this.iniManager.init(configContext, null);
        Trace.verbose((Object)this, (String)"createInitiator", (String)"validateName");
        this.validateName(wwn);
        Trace.verbose((Object)this, (String)"createInitiator", (String)"validateDescription");
        this.validateDescription(description, Validate.INITIATOR_DESC_OBJECT);
        Trace.verbose((Object)this, (String)"createInitiator", (String)"verify that wwn does NOT exist");
        if (CIMObjectWrapper.doesNamedInstanceExistByIpAddr((CIMOMHandleWrapper)configContext.getClient(), (String)array.getClusterName(), (String)"SunStorEdge_6120StorageHardwareID", (String)wwn)) {
            Trace.verbose((Object)this, (String)"createInitiator", (String)(wwn + " already exists"));
            throw new BadParameterException(wwn, "error.resourceAlreadyExists");
        }
        Trace.verbose((Object)this, (String)"createInitiator", (String)"call manager.create");
        this.iniManager.createInitiator(array, wwn, description, initiatorGroups);
        Trace.verbose((Object)this, (String)"createInitiator", (String)"Initiator creaton COMPLETE!");
    }

    public void saveInitiator(InitiatorInterface iniToSave) throws BadParameterException, ConfigMgmtException {
        String methodName = "saveInitiator";
        Trace.methodBegin((Object)this, (String)methodName);
        String description = iniToSave.getDescription();
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to validate new description = " + description));
        this.validateDescription(description, Validate.INITIATOR_DESC_OBJECT);
        Trace.verbose((Object)this, (String)methodName, (String)("Got valid description; try to save the initiator = " + iniToSave.getWWN()));
        iniToSave.save();
    }

    public void removeInitiatorFromAllGroups(ConfigContext configContext, int index) throws CoreUIBusException {
        try {
            ManageInitiatorsInterface initiatorsInt = ManageInitiatorsFactory.getManager();
            this.iniManager.init(configContext, null);
        }
        catch (ConfigMgmtException cme) {
            throw new CoreUIBusException(cme.toString());
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new CoreUIBusException(iobe.toString());
        }
    }

    public void delete(InitiatorInterface ini) throws ConfigMgmtException {
        String methodName = "delete";
        Trace.methodBegin((Object)this, (String)methodName);
        if (ini != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to delete initiator = " + ini.getWWN()));
            String arrayName = ini.getT4Name();
            String wwn = ini.getWWN();
            ini.delete();
            LogAPI.staticLog((String)"INITIATOR_DELETE", (String[])new String[]{wwn, arrayName}, (String[])new String[0]);
        }
    }

    public void delete(List inis) throws ConfigMgmtException {
        String methodName = "delete(List)";
        Trace.methodBegin((Object)this, (String)methodName);
        if (inis != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to delete " + inis.size() + " initiator groups"));
            for (int i = 0; i < inis.size(); ++i) {
                InitiatorInterface ini = (InitiatorInterface)inis.get(i);
                ini.delete();
            }
        }
    }

    public List extractDeleteSelection(List initiators, String[] inisToDelete, T4Interface currentT4, ConfigContext configContext) throws BadParameterException, IllegalStateException, ConfigMgmtException {
        String methodName = "delete";
        Trace.methodBegin((Object)this, (String)"delete");
        if (inisToDelete == null || inisToDelete.length < 1) {
            Trace.verbose((Object)this, (String)"delete", (String)"No initiators selected to delete");
            throw new BadParameterException("inisToDelete", "error.none.selected");
        }
        if (initiators == null) {
            Trace.verbose((Object)this, (String)"delete", (String)"Passed list was null, get new list");
            initiators = this.listForArray(configContext, currentT4);
        }
        if (initiators == null) {
            Trace.verbose((Object)this, (String)"delete", (String)"No initiators in the system");
            throw new IllegalStateException("error.no.object");
        }
        ArrayList<InitiatorInterface> iniObjsToDelete = new ArrayList<InitiatorInterface>(inisToDelete.length);
        int[] iniIndices = Convert.stringArrayToIntArray((String[])inisToDelete);
        for (int i = 0; i < iniIndices.length; ++i) {
            InitiatorInterface iniToRemove = (InitiatorInterface)initiators.get(iniIndices[i]);
            Trace.verbose((Object)this, (String)"delete", (String)("Selected initiator to remove = " + iniToRemove.getWWN()));
            iniObjsToDelete.add(iniToRemove);
        }
        return iniObjsToDelete;
    }

    public InitiatorInterface getInitiatorByName(ConfigContext configContext, T4Interface array, String name) throws ConfigMgmtException {
        String methodName = "getInitiatorByName";
        Trace.methodBegin((Object)this, (String)methodName);
        List initiators = this.listForArray(configContext, array);
        if (initiators != null) {
            if (initiators.size() >= 128) {
                Trace.verbose((Object)this, (String)methodName, (String)"128 initiators reached - prevent creation");
                throw new ConfigMgmtException("max.initiators.reached", "Maximum number of initiators reached");
            }
            Trace.verbose((Object)this, (String)methodName, (String)("Searching for initiators with name = " + name));
            for (int i = 0; i < initiators.size(); ++i) {
                InitiatorInterface ini = (InitiatorInterface)initiators.get(i);
                if (ini == null || !ini.getWWN().equals(name)) continue;
                Trace.verbose((Object)this, (String)methodName, (String)"Found initiator with given name!");
                return ini;
            }
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Unable to find initiator with name = " + name));
        return null;
    }

    public List getInitiatorsInGroups(List igList) throws ConfigMgmtException {
        String methodName = "getInitiatorsInGroups";
        Trace.methodBegin((Object)this, (String)methodName);
        ArrayList<InitiatorInterface> affectedInitiators = new ArrayList<InitiatorInterface>();
        Hashtable<String, InitiatorInterface> iniTable = new Hashtable<String, InitiatorInterface>();
        if (igList != null) {
            for (int i = 0; i < igList.size(); ++i) {
                InitiatorGroupInterface ig = (InitiatorGroupInterface)igList.get(i);
                ArrayList inis = ig.getInitiators();
                if (inis == null) continue;
                for (int j = 0; j < inis.size(); ++j) {
                    InitiatorInterface ini = (InitiatorInterface)inis.get(j);
                    iniTable.put(ini.getWWN(), ini);
                }
            }
        }
        Enumeration e = iniTable.elements();
        while (e.hasMoreElements()) {
            affectedInitiators.add((InitiatorInterface)e.nextElement());
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Returning " + affectedInitiators.size() + " affectedInitiators"));
        return affectedInitiators;
    }

    public List getInitiatorsForVolume(ConfigContext context, StorageVolumeInterface volume) throws ConfigMgmtException {
        String methodName = "getInitiatorsForVolume";
        Trace.methodBegin((Object)this, (String)methodName);
        if (volume == null) {
            Trace.verbose((Object)this, (String)methodName, (String)"Null volume given to get initiators for");
            return null;
        }
        String volumeGroup = volume.getVolumeGroup();
        ArrayList<InitiatorGroupInterface> iniGroups = new ArrayList<InitiatorGroupInterface>();
        Bindings bindBusObj = new Bindings();
        if (volumeGroup != null && !volumeGroup.trim().equals("")) {
            VolumeGroups vgs = new VolumeGroups();
            T4s t4 = new T4s();
            try {
                T4Interface t4int = t4.findArrayByName(context, volume.getT4Name());
                VolumeGroupInterface vgi = vgs.getVolumeGroupInterface(context, t4int, volumeGroup);
                List bindings = bindBusObj.list(context, null, vgi);
                for (int j = 0; j < bindings.size(); ++j) {
                    BindingInterface bind = (BindingInterface)bindings.get(j);
                    iniGroups.add(bind.getInitiatorGroup());
                }
            }
            catch (Exception e) {
                Trace.error((Object)this, (ConfigMgmtException)new ConfigMgmtException(e));
            }
        }
        return this.getInitiatorsInGroups(iniGroups);
    }

    public List getInitiatorsForVolumesList(ConfigContext context, List volumesList) throws ConfigMgmtException {
        String methodName = "getInitiatorsForVolumesList";
        Trace.methodBegin((Object)this, (String)methodName);
        Hashtable<String, InitiatorInterface> iniTable = new Hashtable<String, InitiatorInterface>();
        if (volumesList != null) {
            for (int i = 0; i < volumesList.size(); ++i) {
                StorageVolumeInterface svi = (StorageVolumeInterface)volumesList.get(i);
                List inisForVol = this.getInitiatorsForVolume(context, svi);
                for (int j = 0; j < inisForVol.size(); ++j) {
                    InitiatorInterface ini = (InitiatorInterface)inisForVol.get(j);
                    iniTable.put(ini.getWWN(), ini);
                }
            }
        }
        ArrayList<InitiatorInterface> initiators = new ArrayList<InitiatorInterface>();
        Enumeration e = iniTable.elements();
        while (e.hasMoreElements()) {
            initiators.add((InitiatorInterface)e.nextElement());
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Returning " + initiators.size() + " initiators for volume list"));
        return initiators;
    }

    public void validateName(String name) throws BadParameterException {
        String methodName = "validateName";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to validate name = " + name));
        if (name == null || "".equals(name)) {
            Trace.verbose((Object)this, (String)methodName, (String)"Name is null; or empty");
            throw new BadParameterException(name, "error.bizobj.noName");
        }
        if (!name.matches("[a-fA-F0-9]+")) {
            Trace.verbose((Object)this, (String)methodName, (String)"Name contains an invalid character");
            throw new BadParameterException(name, "error.bizobj.invalidCharacter");
        }
        if (name.length() != this.getAllowedNameLength()) {
            Trace.verbose((Object)this, (String)methodName, (String)"wwn length is incorrect");
            throw new BadParameterException(name, "error.bizobj.incorrectWWNLength");
        }
    }
}

