/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.access.business.BindingInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.BOComparators;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Bindings;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import java.util.List;

public class InitiatorGroups
extends CoreUIBusObject {
    private ManageInitiatorGroupsInterface iniGroupsManager = ManageInitiatorGroupsFactory.getManager();

    public List list(ConfigContext configContext, SearchFilter searchFilter) throws ConfigMgmtException {
        this.iniGroupsManager.init(configContext, searchFilter);
        return this.iniGroupsManager.getItemList();
    }

    public List listForArray(ConfigContext configContext, T4Interface array) throws ConfigMgmtException {
        this.iniGroupsManager.setScope((InstanceWrapper)array);
        this.iniGroupsManager.init(configContext, null);
        return this.iniGroupsManager.getItemList();
    }

    public void createInitiatorGroup(ConfigContext context, String initGroupName, T4Interface array, List initiators) throws ConfigMgmtException, BadParameterException, Exception {
        String methodName = "createInitiatorGroup";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to create new ig = " + initGroupName));
        Trace.verbose((Object)this, (String)methodName, (String)(" creating new ig on array = " + array.getName()));
        Trace.verbose((Object)this, (String)methodName, (String)(" adding " + initiators.size() + " to the new ig"));
        this.iniGroupsManager.init(context, null);
        this.validateName(initGroupName);
        if (CIMObjectWrapper.doesNamedInstanceExistByIpAddr((CIMOMHandleWrapper)context.getClient(), (String)array.getClusterName(), (String)"SunStorEdge_6120SystemSpecificCollection", (String)initGroupName)) {
            Trace.verbose((Object)this, (String)methodName, (String)(initGroupName + " already exists"));
            throw new BadParameterException(initGroupName, "error.resourceAlreadyExists");
        }
        this.iniGroupsManager.createInitiatorGroup(initGroupName, array, initiators);
    }

    public void delete(InitiatorGroupInterface iniGrp) throws ConfigMgmtException {
        String methodName = "delete(InitiatorGroup)";
        Trace.methodBegin((Object)this, (String)methodName);
        if (iniGrp != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to delete initiator group = " + iniGrp.getName()));
            iniGrp.delete();
        }
    }

    public void delete(ConfigContext context, String initiatorGroupName, String arrayName) throws Exception {
        String methodName = "delete(context,String,String)";
        Trace.methodBegin((Object)this, (String)methodName);
        T4Interface array = this.findArrayByName(context, arrayName);
        InitiatorGroupInterface igi = this.getInitiatorGroupInterface(context, array, initiatorGroupName);
        this.delete(igi);
    }

    public void delete(List groups) throws ConfigMgmtException {
        String methodName = "delete(List)";
        Trace.methodBegin((Object)this, (String)methodName);
        if (groups != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to delete " + groups.size() + " initiator groups"));
            for (int i = 0; i < groups.size(); ++i) {
                InitiatorGroupInterface iniGrp = (InitiatorGroupInterface)groups.get(i);
                iniGrp.delete();
            }
        }
    }

    public List getIgsToAssociate(ConfigContext context, VolumeGroupInterface vg, T4Interface array) throws Exception {
        String methodName = "getIgsToAssociate";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("current array to get bindings for = " + array.getName()));
        Bindings bindingBusObj = new Bindings();
        List allIGs = this.listForArray(context, array);
        List currentBindings = bindingBusObj.list(context, null, vg);
        for (int j = 0; j < currentBindings.size(); ++j) {
            BindingInterface bind = (BindingInterface)currentBindings.get(j);
            InitiatorGroupInterface igInBind = bind.getInitiatorGroup();
            if (!allIGs.contains(igInBind)) continue;
            Trace.verbose((Object)this, (String)methodName, (String)("Found ig already assoc with vg; = " + igInBind.getName()));
            if (!allIGs.remove(igInBind)) continue;
            Trace.verbose((Object)this, (String)methodName, (String)("Removed ig = " + igInBind.getName()));
        }
        return allIGs;
    }

    public int indexFromName(String name, List list) throws IndexOutOfBoundsException {
        if (list == null || name == null) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!name.equals(((InitiatorGroupInterface)list.get(i)).getName())) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    public InitiatorGroupInterface getInitiatorGroupInterface(ConfigContext configContext, T4Interface array, String initGroupName) throws Exception {
        String methodName = "getInitiatorGroupInterface(context, array, name)";
        Trace.methodBegin((Object)this, (String)methodName);
        InitiatorGroupInterface initGroup = null;
        List iniGroupList = this.listForArray(configContext, array);
        initGroup = (InitiatorGroupInterface)FilterUtil.findNamedObject((String)initGroupName, (List)iniGroupList, (NameBasedComparator)BOComparators.INIT_GROUP_COMPARATOR);
        if (initGroup == null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Initiator group: " + initGroupName + " not found"));
            throw new ItemNotFoundException(initGroupName);
        }
        return initGroup;
    }

    public void addInitiatorToGroup(InitiatorGroupInterface iniGroup, InitiatorInterface initiator) throws ConfigMgmtException {
        String methodName = "addInitiatorToGroup";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to add initiator " + initiator.getWWN() + " to initiator group " + iniGroup.getName()));
        iniGroup.addInitiatorToGroup(initiator);
    }

    public void addInitiatorsToGroup(InitiatorGroupInterface iniGroup, List initiatorsList) throws ConfigMgmtException {
        String methodName = "addInitiatorsToGroup";
        Trace.methodBegin((Object)this, (String)methodName);
        if (initiatorsList != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to add " + initiatorsList.size() + " to the initiator group " + iniGroup.getName()));
            for (int i = 0; i < initiatorsList.size(); ++i) {
                this.addInitiatorToGroup(iniGroup, (InitiatorInterface)initiatorsList.get(i));
            }
        }
    }

    public void removeInitiatorsFromGroup(InitiatorGroupInterface iniGroup, List initiatorsList) throws ConfigMgmtException {
        String methodName = "removeInitiatorsFromGroup";
        Trace.methodBegin((Object)this, (String)methodName);
        if (initiatorsList != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Trying to remove " + initiatorsList.size() + " from the initiator group " + iniGroup.getName()));
            for (int i = 0; i < initiatorsList.size(); ++i) {
                iniGroup.deleteInitiatorFromGroup((InitiatorInterface)initiatorsList.get(i));
            }
        }
    }

    public void importInitiatorGroups(ConfigContext context, List importToT4s, T4Interface importFromT4, List initiatorGroups) throws ConfigMgmtException {
        String methodName = "importInitiatorGroups";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Trying to import igs from array = " + importFromT4.getName()));
        this.iniGroupsManager.init(context, null);
        if (Trace.isTraceEnabled((Object)this) && initiatorGroups != null) {
            Trace.verbose((Object)this, (String)methodName, (String)("Number of IGs:" + initiatorGroups.size()));
        }
        this.iniGroupsManager.importInitiatorGroups(importToT4s, importFromT4, initiatorGroups);
    }

    public String getIllegalNameCharacterPattern() {
        return ".*[\\s,]+.*";
    }

    public int getAllowedNameLength() {
        return 15;
    }
}

