/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.actions.WizardContent;
import com.sun.netstorage.array.mgmt.cfg.ui.business.HttpServletReqWrapper;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Trays;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.AdminExpansionForm;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;

public class ArrayUnconfigurationThread
extends Thread {
    private int currentStep;
    HttpServletReqWrapper req;
    private boolean threadDone;
    private String currentErrorMessage;
    private TrayInterface controllerTray;
    private WizardContent wc;
    private AdminExpansionForm form;
    private boolean isAddExpansion;
    private boolean shouldSkip;

    public ArrayUnconfigurationThread(WizardContent wc, ActionForm form, HttpServletRequest argReq, boolean isAdd) {
        this.wc = wc;
        this.form = (AdminExpansionForm)form;
        this.req = new HttpServletReqWrapper(argReq);
        this.isAddExpansion = isAdd;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public boolean isLastStepDone() {
        String methodName = "isLastStepDone";
        Trace.methodBegin((Object)this, (String)methodName);
        String lastStep = "" + (this.form.getRemoveStepMessageKeys().length - 1);
        if (this.isAddExpansion) {
            lastStep = "" + (this.form.getAddStepMessageKeys().length - 1);
        }
        Trace.verbose((Object)this, (String)methodName, (String)("Last step = " + lastStep));
        String status = this.form.getStepStatus(lastStep);
        if (status.indexOf("complete") != -1) {
            Trace.verbose((Object)this, (String)methodName, (String)"Last step is DONE!");
            return true;
        }
        Trace.verbose((Object)this, (String)methodName, (String)"Last step is not done yet");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.setThreadStart();
            this.performArrayUnconfiguration();
        }
        catch (Throwable t) {
            Trace.verbose((Object)this, (String)"run", (Throwable)t);
            this.form.setHasErrors(true);
            this.form.setErrorMessageKey(this.currentErrorMessage);
        }
        finally {
            Trace.verbose((Object)this, (String)"run", (String)"Thread is DONE");
            this.setThreadDone();
        }
    }

    protected void setThreadStart() {
        this.threadDone = false;
    }

    protected void setThreadDone() {
        this.threadDone = true;
    }

    public boolean isThreadDone() {
        return this.threadDone;
    }

    private void performArrayUnconfiguration() throws Exception {
        T4Interface array;
        String methodName = "performArrayUnconfiguration";
        Trace.methodBegin((Object)this, (String)methodName);
        this.shouldSkip = this.form.getShouldSkipSteps();
        this.form.setControllerToMove(this.getTrayController());
        try {
            this.currentStep = 0;
            this.updateStepToRunningStatus(this.currentStep);
            this.offlinePools();
            Trace.verbose((Object)this, (String)methodName, (String)"Offline pools a success; set step 0 status to complete");
            this.updateStepToCompletedStatus(this.currentStep);
        }
        catch (Exception ex) {
            Trace.verbose((Object)this, (String)methodName, (String)"Exception trying to offline pools");
            this.updateStepToErrorStatus(this.currentStep);
            this.currentErrorMessage = "expansion.error.offlinepools";
            throw ex;
        }
        if (!this.shouldSkip) {
            try {
                this.currentStep = 1;
                this.updateStepToRunningStatus(this.currentStep);
                this.disableController();
                Trace.verbose((Object)this, (String)methodName, (String)"Disabling of controller a success; set step 1 status to complete");
                this.updateStepToCompletedStatus(this.currentStep);
            }
            catch (Exception ex) {
                Trace.verbose((Object)this, (String)methodName, (String)"Exception trying to disable controller");
                this.currentErrorMessage = "CAN_NOT_DISABLE_CONTROLLER".equals(ex.getMessage()) ? "expansion.error.disablecontroller.othernotenabled" : "expansion.error.disablecontroller";
                this.updateStepToErrorStatus(this.currentStep);
                throw ex;
            }
            try {
                this.currentStep = 2;
                this.updateStepToRunningStatus(this.currentStep);
                this.unconfigureController();
                Trace.verbose((Object)this, (String)methodName, (String)"Unconfiguration of controller a success; set step 2 status to complete");
                this.updateStepToCompletedStatus(this.currentStep);
            }
            catch (Exception ex) {
                Trace.verbose((Object)this, (String)methodName, (String)"Exception trying to unconfigure controller");
                this.updateStepToErrorStatus(this.currentStep);
                this.currentErrorMessage = "expansion.error.unconfigurecontroller";
                throw ex;
            }
        }
        if (!this.isAddExpansion) {
            Trace.verbose((Object)this, (String)methodName, (String)"We are removing an expansion tray, reset labels");
            try {
                this.currentStep = 3;
                if (this.shouldSkip) {
                    this.currentStep -= 2;
                }
                this.updateStepToRunningStatus(this.currentStep);
                array = this.wc.getCurrentT4(this.req);
                if (array != null) {
                    Trace.verbose((Object)this, (String)methodName, (String)("Trying to reset labels = " + array.getName()));
                    array.resetLabels(true);
                }
                Trace.verbose((Object)this, (String)methodName, (String)"Reset of labels a success; set step 3 status to complete");
                this.updateStepToCompletedStatus(this.currentStep);
            }
            catch (Exception ex) {
                Trace.verbose((Object)this, (String)methodName, (String)"Exception trying to reset labels");
                this.updateStepToErrorStatus(this.currentStep);
                this.currentErrorMessage = "remove.expansion.error.resetlabels";
                throw ex;
            }
        }
        try {
            this.currentStep = this.isAddExpansion ? 3 : 4;
            if (this.shouldSkip) {
                this.currentStep -= 2;
            }
            this.updateStepToRunningStatus(this.currentStep);
            array = this.wc.getCurrentT4(this.req);
            if (array != null) {
                Trace.verbose((Object)this, (String)methodName, (String)("Trying to shutdown array = " + array.getName()));
                array.shutdown();
            }
            Trace.verbose((Object)this, (String)methodName, (String)"Shutdown of array a success; set step 3 status to complete");
            this.updateStepToCompletedStatus(this.currentStep);
        }
        catch (Exception ex) {
            Trace.verbose((Object)this, (String)methodName, (String)"Exception trying to shutdown array");
            this.updateStepToErrorStatus(this.currentStep);
            this.currentErrorMessage = "expansion.error.shutdownarray";
            throw ex;
        }
    }

    private void offlinePools() throws Exception {
        String methodName = "offlinePools";
        Trace.methodBegin((Object)this, (String)methodName);
        StoragePools poolsBusObj = (StoragePools)this.wc.getUIBusinessObj(this.req, "com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools");
        List poolsOnArray = poolsBusObj.getPoolsInT4(this.wc.getConfigContext(this.req), this.wc.getCurrentT4(this.req));
        if (poolsOnArray != null) {
            poolsBusObj.changeStatusToOfflineForGroup(poolsOnArray);
        }
    }

    private void disableController() throws Exception {
        String methodName = "disableController";
        Trace.methodBegin((Object)this, (String)methodName);
        TrayInterface trayToMove = this.getTrayController();
        if (trayToMove != null) {
            Trays traysBusObj = (Trays)this.wc.getUIBusinessObj(this.req, "com.sun.netstorage.array.mgmt.cfg.ui.business.Trays");
            List allControllers = traysBusObj.getAllControllers(this.wc.getCurrentT4(this.req));
            Iterator traysIterator = allControllers.iterator();
            while (traysIterator.hasNext()) {
                TrayInterface t = (TrayInterface)traysIterator.next();
                if (trayToMove.getId() == t.getId() || t.getState() != 3) continue;
                Trace.verbose((Object)this, (String)methodName, (String)"Other tray is disabled, cannot disable controller tray to move");
                throw new Exception("CAN_NOT_DISABLE_CONTROLLER");
            }
            Trace.verbose((Object)this, (String)methodName, (String)("Controller tray to disable current state = " + trayToMove.getState()));
            if (trayToMove.getState() == 2) {
                Trace.verbose((Object)this, (String)methodName, (String)"controller tray is enabled, try to disable...");
                trayToMove.enable(false);
            }
        }
    }

    private void unconfigureController() throws Exception {
        String methodName = "unconfigureController";
        Trace.methodBegin((Object)this, (String)methodName);
        if (this.getTrayController() != null && !"offline".equals(this.getTrayController().getStatus())) {
            Trace.verbose((Object)this, (String)methodName, (String)"controller tray is not offline, try to unconfigure...");
            this.getTrayController().unconfigure();
        }
    }

    private void updateStepToCompletedStatus(int stepNumber) {
        this.updateStepStatus(stepNumber, "expansion.unconfigure.status.complete", AdminExpansionForm.COMPLETE_ICON_PATH);
    }

    private void updateStepToRunningStatus(int stepNumber) {
        this.updateStepStatus(stepNumber, "expansion.unconfigure.status.running", AdminExpansionForm.RUNNING_ICON_PATH);
    }

    private void updateStepToErrorStatus(int stepNumber) {
        this.updateStepStatus(stepNumber, "expansion.unconfigure.status.error", AdminExpansionForm.ERROR_ICON_PATH);
    }

    private void updateStepStatus(int stepNumber, String stepStatusKey, String stepStatusIconPath) {
        String methodName = "updateStepStatus";
        Trace.methodBegin((Object)this, (String)methodName);
        Trace.verbose((Object)this, (String)methodName, (String)("Updating step (" + stepNumber + ") to status message key (" + stepStatusKey + ") to status icon path (" + stepStatusIconPath + ")"));
        this.form.setStepStatus(stepNumber, stepStatusKey);
        this.form.setStepStatusIcon(stepNumber, stepStatusIconPath);
    }

    private TrayInterface getTrayController() {
        if (this.controllerTray == null) {
            try {
                Trays traysBusObj = (Trays)this.wc.getUIBusinessObj(this.req, "com.sun.netstorage.array.mgmt.cfg.ui.business.Trays");
                this.controllerTray = traysBusObj.getControllerToMove(this.wc.getConfigContext(this.req), this.wc.getCurrentT4(this.req));
            }
            catch (Exception e) {
                Trace.verbose((Object)this, (String)"getTrayController", (String)"Exception trying to get tray controller");
            }
        }
        return this.controllerTray;
    }
}

