/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.util.HttpArrayMessage;
import com.sun.netstorage.array.mgmt.cfg.util.ObjectLoadThread;
import com.sun.netstorage.array.mgmt.cfg.util.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ArrayLoadThread
extends ObjectLoadThread {
    private static final String PROP_FILE = "/opt/se6x20/resources/StorEdge_6120.properties";
    private static final String T4_FILE_KEY = "navTreeFile";
    private static final String TRAYS_NODE = "trays";
    private static final String TRAY_NODE = "tray";
    private static final String POOL_NODE = "pool";
    private static final String VOLUME_NODE = "volume";
    private static final String VOL_GRPS_NODE = "volume-groups";
    private static final String VOL_GRP_NODE = "group";
    private static final String INITIATORS_NODE = "initiators";
    private static final String INITIATOR_NODE = "initiator";
    private static final String IGS_NODE = "initiator-groups";
    private static final String IG_NODE = "group";
    T4Interface t4;
    HttpServletRequest request;

    public ArrayLoadThread(T4Interface argT4, HttpServletRequest argReq) {
        this.t4 = argT4;
        this.request = argReq;
    }

    public void run() {
        block4: {
            try {
                Trace.verbose((Object)((Object)this), (String)"run", (String)"check array health");
                if (this.t4.getHealthStatus() != 2) break block4;
                Trace.verbose((Object)((Object)this), (String)"run", (String)"array health ok");
                this.request.setAttribute(this.t4.getName() + "_HEALTH_OK", (Object)"OK");
                String fileName = "/treedata.htm";
                try {
                    Properties prop = new Properties();
                    FileInputStream fis = new FileInputStream(PROP_FILE);
                    prop.load(fis);
                    fileName = "/" + prop.getProperty(T4_FILE_KEY, "treedata.htm");
                }
                catch (Exception e) {
                    Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(e));
                }
                Trace.verbose((Object)((Object)this), (String)"arrayLoadThread", (String)"Get file from array");
                HttpArrayMessage data = new HttpArrayMessage(this.t4.getClusterName(), fileName);
                String treeData = data.getTokenFile();
                Trace.verbose((Object)((Object)this), (String)"arrayLoadThread", (String)"parse document");
                DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dbfactory.newDocumentBuilder();
                byte[] bytes = treeData.getBytes();
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                Document document = builder.parse(in);
                Trace.verbose((Object)((Object)this), (String)"arrayLoadThread", (String)"File parsed - generate objects");
                this.buildObjects(document.getDocumentElement());
                Trace.verbose((Object)((Object)this), (String)"arrayLoadThread", (String)"Objects generated");
            }
            catch (Exception ex) {
                ConfigMgmtException cme = new ConfigMgmtException();
                cme.addExceptionContext((Object)ex);
                Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            }
        }
        this.setComplete(true);
    }

    private void buildObjects(Element root) throws Exception {
        String t4Name = this.t4.getName();
        this.createTraysPoolsVols(root, t4Name);
        Element rootVgNode = XMLUtils.findElement((Element)root, (String)VOL_GRPS_NODE);
        List vgNodes = XMLUtils.listNamedChildElements((Element)rootVgNode, (String)"group");
        ArrayList vgs = new ArrayList(100);
        ArrayList vgVols = new ArrayList(10);
        this.createTwoLevels(t4Name, vgNodes, vgs, vgVols, VOLUME_NODE, "name", "_tree_vgs_" + t4Name, "_tree_volumes__tree_vgs_");
        this.createList(t4Name, INITIATOR_NODE, "wwn", "_tree_initiators_", XMLUtils.findElement((Element)root, (String)INITIATORS_NODE), "");
        List iniGNodes = XMLUtils.listNamedChildElements((Element)XMLUtils.findElement((Element)root, (String)IGS_NODE), (String)"group");
        ArrayList iniGs = new ArrayList(20);
        ArrayList iniForIg = new ArrayList(20);
        this.createTwoLevels(t4Name, iniGNodes, iniGs, iniForIg, INITIATOR_NODE, "wwn", "_tree_igs_" + t4Name, "_tree_initiators__tree_igs_");
    }

    private void createTraysPoolsVols(Element root, String t4Name) throws Exception {
        List trayNodes = XMLUtils.listNamedChildElements((Element)XMLUtils.findElement((Element)root, (String)TRAYS_NODE), (String)TRAY_NODE);
        ArrayList<String> allTrays = new ArrayList<String>(6);
        HashMap<String, String> allTrayTypes = new HashMap<String, String>(6);
        ArrayList allPools = new ArrayList(12);
        ArrayList allVols = new ArrayList(64);
        int trayNodesSize = trayNodes.size();
        for (int i = 0; trayNodes != null && i < trayNodesSize; ++i) {
            Element trayNode = (Element)trayNodes.get(i);
            String trayId = trayNode.getAttribute("id");
            allTrays.add(trayId);
            allTrayTypes.put(trayId, trayNode.getAttribute("type"));
            ArrayList trayPools = new ArrayList(2);
            List poolNodes = XMLUtils.listNamedChildElements((Element)trayNode, (String)POOL_NODE);
            ArrayList poolVols = new ArrayList(40);
            this.createTwoLevels(t4Name, poolNodes, trayPools, poolVols, VOLUME_NODE, "name", "_tree_pools_under_array__tree_trays_" + trayId + t4Name, "_tree_volumes__tree_pools_under_array_");
            allPools.addAll(trayPools);
            allVols.addAll(poolVols);
        }
        this.setTraysPoolsVolLists(t4Name, allTrays, allTrayTypes, allPools, allVols);
    }

    private void setTraysPoolsVolLists(String t4Name, List allTrays, HashMap allTrayTypes, List allPools, List allVols) {
        this.sortAndSet("_tree_trays_" + t4Name, allTrays, false);
        ArrayList<String> allTT = new ArrayList<String>(6);
        int allTraysSize = allTrays.size();
        for (int i = 0; i < allTraysSize; ++i) {
            allTT.add((String)allTrayTypes.get((String)allTrays.get(i)));
        }
        this.request.setAttribute("_tree_trays__TYPES_" + t4Name, allTT);
        this.sortAndSet("_tree_pools_under_array_" + t4Name, allPools, true);
        this.sortAndSet("_tree_volumes_" + t4Name, allVols, true);
    }

    private void sortAndSet(String listName, List list, boolean ascending) {
        Collections.sort(list, new StringComparator(this.request.getLocale(), ascending));
        this.request.setAttribute(listName, (Object)list);
    }

    private void createTwoLevels(String t4Name, List nodes, List topLevelNames, List secondLevelNames, String secondLevelNodeNames, String attrName, String topLevelListName, String secondLevelListName) throws Exception {
        int nodesSize = nodes.size();
        for (int i = 0; nodes != null && i < nodesSize; ++i) {
            Element node = (Element)nodes.get(i);
            String name = node.getAttribute("name");
            topLevelNames.add(name);
            secondLevelNames.addAll(this.createList(t4Name, secondLevelNodeNames, attrName, secondLevelListName, node, name));
            Trace.verbose((Object)((Object)this), (String)"createTwoLevels", (String)("Second level lit size:" + secondLevelNames.size()));
        }
        this.sortAndSet(topLevelListName, topLevelNames, true);
    }

    private List createList(String t4Name, String nodeNames, String attrName, String listName, Element fromNode, String parentNodeName) throws Exception {
        List nodes = XMLUtils.listNamedChildElements((Element)fromNode, (String)nodeNames);
        ArrayList<String> nameList = new ArrayList<String>(40);
        int nodesSize = nodes.size();
        for (int j = 0; nodes != null && j < nodesSize; ++j) {
            Element el = (Element)nodes.get(j);
            nameList.add(el.getAttribute(attrName));
        }
        this.sortAndSet(listName + parentNodeName + t4Name, nameList, true);
        return nameList;
    }

    public class StringComparator
    implements Comparator {
        Collator collator = null;
        boolean ascending = true;

        StringComparator(Locale loc, boolean asc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
            this.ascending = asc;
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = this.collator.getCollationKey(element1.toString());
            CollationKey key2 = this.collator.getCollationKey(element2.toString());
            int res = this.ascending ? key1.compareTo(key2) : key2.compareTo(key1);
            return res;
        }
    }
}

