/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.access.business.BindingInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageBindingsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageBindingsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.FirewallAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.GeneralAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.NetworkAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.SystemTimeAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.FiberChannelPortInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfiles;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.cfg.ui.business.AdminReportComponent;
import com.sun.netstorage.array.mgmt.cfg.ui.business.AdminReportComponentAttribute;
import com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Initiators;
import com.sun.netstorage.array.mgmt.cfg.ui.business.OverallHealth;
import com.sun.netstorage.array.mgmt.cfg.ui.business.SPDate;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class AdminReports
extends CoreUIBusObject {
    private static final String GB_LOCALIZATION_KEY = "size.GB";
    private final String localizedGB;
    private Admin adminBizObj = new Admin();
    private Locale locale;

    public AdminReports(Locale locale) {
        this.locale = locale;
        this.localizedGB = ResourceBundle.getBundle("ApplicationResources", locale).getString(GB_LOCALIZATION_KEY);
    }

    public AdminReportComponent buildReport(ConfigContext configContext, SearchFilter searchFilter, Locale locale) throws CoreUIBusException {
        AdminReportComponent arrayConfig = new AdminReportComponent("array-config", null);
        try {
            arrayConfig.addAttribute(this.buildHealthAttribute(configContext));
            List allKnownT4s = this.findAllKnownT4s(configContext, searchFilter);
            if (allKnownT4s != null) {
                Iterator t4Iterator = allKnownT4s.iterator();
                while (t4Iterator.hasNext()) {
                    T4Interface array = (T4Interface)t4Iterator.next();
                    arrayConfig.addSubComponent(this.buildT4Component(configContext, array));
                }
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"buildReport exception building T4 component", (Throwable)e);
            arrayConfig.setReportException(e);
        }
        try {
            arrayConfig.addSubComponent(this.buildProfilesComponent(configContext));
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"buildReport exception building profile component", (Throwable)e);
            arrayConfig.setReportException(e);
        }
        try {
            arrayConfig.addSubComponent(this.buildAdminComponent(configContext));
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"buildReport exception building admin component", (Throwable)e);
            arrayConfig.setReportException(e);
        }
        return arrayConfig;
    }

    protected List findAllKnownT4s(ConfigContext configContext, SearchFilter searchFilter) throws ConfigMgmtException {
        T4s t4BizObj = new T4s();
        return t4BizObj.list(configContext, searchFilter);
    }

    protected List findAllProfiles(ConfigContext configContext) throws ConfigMgmtException {
        return ManageStorageProfiles.getInstance().getItemList(configContext, 0);
    }

    protected AdminReportComponent buildT4Component(ConfigContext context, T4Interface array) throws Exception {
        AdminReportComponent t4Component = new AdminReportComponent("array", "report.array.title");
        try {
            int health = array.getHealthStatus();
            boolean isHealthy = true;
            if (health != 2) {
                isHealthy = false;
            }
            t4Component.addAttribute(new AdminReportComponentAttribute("name", "report.array.name.label", array.getName(), false, null));
            t4Component.addAttribute(new AdminReportComponentAttribute("firmware-version", "report.array.firmware.label", isHealthy ? array.getFirmwareVersion() : "", false, null));
            t4Component.addAttribute(new AdminReportComponentAttribute("health", "report.array.health.label", health, true, "array.health.code"));
            String description = isHealthy && array.getDescription() != null ? array.getDescription() : "";
            t4Component.addAttribute(new AdminReportComponentAttribute("description", "report.array.description.label", description, false, null));
            t4Component.addAttribute(new AdminReportComponentAttribute("segment-size", "report.array.segmentsize.label", isHealthy ? "" + array.getBlockSize() : "", true, "array.segmentSize"));
            String readaheadMode = array.getReadaheadMode() != 0 ? "1" : "0";
            t4Component.addAttribute(new AdminReportComponentAttribute("readahead", "report.array.readahead.label", isHealthy ? readaheadMode : "", true, "array.readahead"));
            t4Component.addAttribute(new AdminReportComponentAttribute("disk-recon-rate", "report.array.diskreconrate.label", isHealthy ? "" + array.getDiskReconRate() : "", true, "array.diskrecon"));
            t4Component.addAttribute(new AdminReportComponentAttribute("failover-mode", "report.array.failovermode.label", isHealthy ? array.getFailoverMode() : "", true, "array.failover"));
            t4Component.addAttribute(new AdminReportComponentAttribute("cache-mode", "report.array.cachemode.label", isHealthy ? array.getCacheMode() : "", true, "array.cachemode"));
            if (isHealthy) {
                if (array.isFeatureSupported(3)) {
                    t4Component.addAttribute(new AdminReportComponentAttribute("hotspare-pool-size", "report.array.hotspare.poolsize.label", "" + array.getAhsPoolSize(), false, null));
                } else {
                    t4Component.addAttribute(new AdminReportComponentAttribute("hotspare-pool-size", "report.array.hotspare.poolsize.label", "firmware", true, "not.supported"));
                }
                if (array.isFeatureSupported(1) && isHealthy) {
                    t4Component.addAttribute(new AdminReportComponentAttribute("diskscrubbing", "report.array.diskscrubbing.label", array.isDiskScrubbing() ? "enabled" : "disabled", true, "array.diskscrubbing"));
                } else {
                    t4Component.addAttribute(new AdminReportComponentAttribute("diskscrubbing", "report.array.diskscrubbing.label", "firmware", true, "not.supported"));
                }
            } else {
                t4Component.addAttribute(new AdminReportComponentAttribute("hotspare-pool-size", "report.array.hotspare.poolsize.label", "", false, null));
                t4Component.addAttribute(new AdminReportComponentAttribute("diskscrubbing", "report.array.diskscrubbing.label", "", true, "array.diskscrubbing"));
            }
            if (isHealthy) {
                Initiators initiatorsBO;
                List initiators;
                InitiatorGroups initGroupsBO;
                List initGroups;
                VolumeGroups volGroupsBO;
                List volumeGroups;
                FiberChannelPortInterface port = array.getFiberChannelPort();
                t4Component.addAttribute(new AdminReportComponentAttribute("fc-topology", "report.array.fc.topology.label", port != null ? "" + port.getTopology() : "", true, "topology"));
                t4Component.addAttribute(new AdminReportComponentAttribute("fc-port-speed", "report.array.fc.portSpeed.label", port != null ? "" + port.getPreferredSpeed() : "", true, "fc.speed"));
                List trays = array.getTrays();
                Iterator trayIterator = trays.iterator();
                if (trayIterator != null) {
                    while (trayIterator.hasNext()) {
                        TrayInterface tray = (TrayInterface)trayIterator.next();
                        t4Component.addSubComponent(this.buildTrayComponent(tray));
                    }
                }
                if ((volumeGroups = (volGroupsBO = new VolumeGroups()).listForArray(context, array)) != null) {
                    Iterator volumeGroupsIterator = volumeGroups.iterator();
                    while (volumeGroupsIterator.hasNext()) {
                        VolumeGroupInterface volumeGroup = (VolumeGroupInterface)volumeGroupsIterator.next();
                        t4Component.addSubComponent(this.buildVolumeGroupComponent(context, volumeGroup));
                    }
                }
                if ((initGroups = (initGroupsBO = new InitiatorGroups()).listForArray(context, array)) != null) {
                    Iterator initGroupIter = initGroups.iterator();
                    while (initGroupIter.hasNext()) {
                        InitiatorGroupInterface initGroup = (InitiatorGroupInterface)initGroupIter.next();
                        t4Component.addSubComponent(this.buildInitiatorGroupComponent(context, initGroup));
                    }
                }
                if ((initiators = (initiatorsBO = new Initiators()).listForArray(context, array)) != null) {
                    Iterator initiatorsIter = initiators.iterator();
                    while (initiatorsIter.hasNext()) {
                        InitiatorInterface initiator = (InitiatorInterface)initiatorsIter.next();
                        t4Component.addSubComponent(this.buildInitiatorsComponent(context, initiator));
                    }
                }
            } else {
                this.setBlankFiberChannelComponent(t4Component);
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)this, (String)"build t4 component exception", (Throwable)ex);
            this.setBlankFiberChannelComponent(t4Component);
            t4Component.setReportException(ex);
        }
        return t4Component;
    }

    private void setBlankFiberChannelComponent(AdminReportComponent comp) {
        comp.addAttribute(new AdminReportComponentAttribute("fc-topology", "report.array.fc.topology.label", "", true, "topology"));
        comp.addAttribute(new AdminReportComponentAttribute("fc-port-speed", "report.array.fc.portSpeed.label", "", true, "fc.speed"));
    }

    protected AdminReportComponent buildTrayComponent(TrayInterface tray) throws Exception {
        List disks;
        AdminReportComponent trayComponent = new AdminReportComponent("tray", "report.tray.title");
        trayComponent.addAttribute(new AdminReportComponentAttribute("id", "report.tray.id.label", tray.getId(), false, null));
        trayComponent.addAttribute(new AdminReportComponentAttribute("tray-type", "report.tray.type.label", tray.getTrayType(), true, "tray.type"));
        trayComponent.addAttribute(new AdminReportComponentAttribute("tray-role", "report.tray.role.label", tray.getRole(), true, "tray.role"));
        trayComponent.addAttribute(new AdminReportComponentAttribute("tray-state", "report.tray.state.label", tray.getState(), true, "tray.state"));
        trayComponent.addAttribute(new AdminReportComponentAttribute("tray-status", "report.tray.status.label", tray.getStatus(), true, "tray.status"));
        trayComponent.addAttribute(new AdminReportComponentAttribute("number-of-drives", "report.tray.numberofdrives.label", tray.getNumberOfDrives(), false, null));
        trayComponent.addAttribute(new AdminReportComponentAttribute("all-drives-healthy", "report.tray.alldriveshealthy.label", tray.areAllDisksHealthy() ? "yes" : "no", true, null));
        List pools = tray.getRaidGroups();
        if (pools != null) {
            Iterator poolIterator = pools.iterator();
            while (poolIterator.hasNext()) {
                RaidGroupInterface pool = (RaidGroupInterface)poolIterator.next();
                trayComponent.addSubComponent(this.buildPoolComponent(pool));
            }
        }
        if ((disks = tray.getDiskList()) != null) {
            Iterator diskIterator = disks.iterator();
            while (diskIterator.hasNext()) {
                DiskInterface disk = (DiskInterface)diskIterator.next();
                trayComponent.addSubComponent(this.buildDiskComponent(disk));
            }
        }
        return trayComponent;
    }

    protected AdminReportComponent buildDiskComponent(DiskInterface disk) throws Exception {
        AdminReportComponent diskComponent = new AdminReportComponent("disk", "report.disk.title");
        diskComponent.addAttribute(new AdminReportComponentAttribute("name", "report.disk.name.label", disk.getName(), false, null));
        diskComponent.addAttribute(new AdminReportComponentAttribute("capacity", "report.disk.capacity.label", Convert.bytesToGB((BigInteger)disk.getCapacity()) + this.localizedGB, false, null));
        String statusString = null;
        switch (disk.getStatus()) {
            case 2: {
                statusString = "ok";
                break;
            }
            case 6: {
                statusString = "error";
                break;
            }
            case 9: {
                statusString = "stopping";
                break;
            }
            default: {
                statusString = "unknown";
            }
        }
        diskComponent.addAttribute(new AdminReportComponentAttribute("status", "report.disk.status.label", "" + statusString, true, "disk.status"));
        String stateString = null;
        if ("disabled".equals(disk.getState())) {
            stateString = "disabled";
        } else if ("enabled".equals(disk.getState())) {
            stateString = "enabled";
        } else if ("substituted".equals(disk.getState())) {
            stateString = "substituted";
        } else if ("missing".equals(disk.getState())) {
            stateString = "missing";
        }
        diskComponent.addAttribute(new AdminReportComponentAttribute("state", "report.disk.state.label", stateString, true, "disk.state"));
        String roleString = disk.getRole();
        diskComponent.addAttribute(new AdminReportComponentAttribute("role", "report.disk.role.label", roleString, true, "disk.role"));
        return diskComponent;
    }

    protected AdminReportComponent buildPoolComponent(RaidGroupInterface pool) throws Exception {
        AdminReportComponent poolComponent = new AdminReportComponent("pool", "report.pool.title");
        poolComponent.addAttribute(new AdminReportComponentAttribute("name", "report.pool.name.label", pool.getName(), false, null));
        poolComponent.addAttribute(new AdminReportComponentAttribute("raid", "report.pool.raidlevel.label", pool.getRaidLevel(), false, null));
        poolComponent.addAttribute(new AdminReportComponentAttribute("total-capacity", "report.pool.totalcapacity.label", Convert.bytesToGB((BigInteger)pool.getTotalCapacity()) + this.localizedGB, false, null));
        poolComponent.addAttribute(new AdminReportComponentAttribute("available-capacity", "report.pool.availablecapacity.label", Convert.bytesToGB((BigInteger)pool.getAvailableCapacity()) + this.localizedGB, false, null));
        poolComponent.addAttribute(new AdminReportComponentAttribute("status", "report.pool.status.label", pool.getStatus(), true, "storage.mgmt.pool.status"));
        poolComponent.addAttribute(new AdminReportComponentAttribute("state", "report.pool.state.label", pool.getState(), true, "storage.mgmt.pool.state"));
        poolComponent.addAttribute(new AdminReportComponentAttribute("profile", "report.pool.profile.label", pool.getProfileName(), false, null));
        List volumes = pool.getVolumes();
        if (volumes != null) {
            Iterator volumeIterator = volumes.iterator();
            while (volumeIterator.hasNext()) {
                StorageVolumeInterface volume = (StorageVolumeInterface)volumeIterator.next();
                poolComponent.addSubComponent(this.buildVolumeComponent(volume));
            }
        }
        return poolComponent;
    }

    protected AdminReportComponent buildVolumeComponent(StorageVolumeInterface volume) throws Exception {
        AdminReportComponent volumeComponent = new AdminReportComponent("volume", "report.volume.title");
        volumeComponent.addAttribute(new AdminReportComponentAttribute("name", "report.volume.name.label", volume.getName(), false, null));
        String volSize = "0";
        String convertedSize = "0";
        try {
            volSize = volume.getSize() + "";
            Trace.verbose((Object)this, (String)"buildVolumeComponent", (String)("*********************size:" + volSize));
            NumberFormat nf = NumberFormat.getInstance(this.locale);
            convertedSize = nf.format(nf.parse(Convert.bytesStringToMBOrGB((String)volSize)));
            String unit = AdminReportComponentAttribute.localizeString("size." + Convert.getMBOrGBString((String)volSize), this.locale);
            convertedSize = convertedSize + " " + unit;
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"buildVolumeComponent", (Throwable)e);
        }
        volumeComponent.addAttribute(new AdminReportComponentAttribute("size", "report.volume.size.label", convertedSize, false, null));
        volumeComponent.addAttribute(new AdminReportComponentAttribute("default-permissions", "report.volume.defaultpermissions.label", volume.getVolumePermissions(), false, null));
        volumeComponent.addAttribute(new AdminReportComponentAttribute("lun", "report.volume.lun.label", volume.getLUN(), false, null));
        volumeComponent.addAttribute(new AdminReportComponentAttribute("member-of-volume-groups", "report.volume.member.of.label", "member-of-volume-groups", false, null));
        String groupName = volume.getVolumeGroup();
        volumeComponent.addAttribute(new AdminReportComponentAttribute("volume-group-name", "report.volume.group.name.label", groupName, false, null));
        return volumeComponent;
    }

    protected AdminReportComponent buildVolumeGroupComponent(ConfigContext configContext, VolumeGroupInterface group) throws Exception {
        AdminReportComponent volumeGroupComponent = new AdminReportComponent("volume-group", "report.volumegroup.title");
        volumeGroupComponent.addAttribute(new AdminReportComponentAttribute("name", "report.volumegroup.name.label", group.getName(), false, null));
        List volumes = group.getVolumes();
        AdminReportComponent volumesComponent = new AdminReportComponent("volumes", "report.volumegroup.volumes.title");
        AdminReportComponent aVolumeComponent = null;
        StorageVolumeInterface volume = null;
        Iterator volumeIterator = volumes.iterator();
        while (volumeIterator.hasNext()) {
            volume = (StorageVolumeInterface)volumeIterator.next();
            aVolumeComponent = new AdminReportComponent("volume", "report.volumegroup.volumes.volume.title");
            aVolumeComponent.addAttribute(new AdminReportComponentAttribute("name", "report.volumegroup.volume.name.label", volume.getName(), false, null));
            volumesComponent.addSubComponent(aVolumeComponent);
        }
        volumeGroupComponent.addSubComponent(volumesComponent);
        AdminReportComponent initiatorGroupsComponent = new AdminReportComponent("initiator-groups", "report.volumegroup.initiatorgroups.title");
        AdminReportComponent anInitiatorGroupComponent = null;
        ManageBindingsInterface bindingManager = ManageBindingsFactory.getManager();
        bindingManager.setScope((InstanceWrapper)group);
        bindingManager.init(configContext, null);
        List bindingObjects = bindingManager.getItemList();
        Iterator bindingObjectsIterator = bindingObjects.iterator();
        while (bindingObjectsIterator.hasNext()) {
            BindingInterface binding = (BindingInterface)bindingObjectsIterator.next();
            anInitiatorGroupComponent = new AdminReportComponent("initiator-group", "report.volumegroup.initiatorgroups.initiatorgroup.title");
            anInitiatorGroupComponent.addAttribute(new AdminReportComponentAttribute("name", "report.volumegroup.name.label", binding.getInitiatorGroup().getName(), false, null));
            anInitiatorGroupComponent.addAttribute(new AdminReportComponentAttribute("permission", "report.volumegroup.permission.label", binding.getAccess(), true, "permissions"));
            initiatorGroupsComponent.addSubComponent(anInitiatorGroupComponent);
        }
        volumeGroupComponent.addSubComponent(initiatorGroupsComponent);
        return volumeGroupComponent;
    }

    protected AdminReportComponent buildInitiatorGroupComponent(ConfigContext configContext, InitiatorGroupInterface group) throws Exception {
        AdminReportComponent initiatorGroupComponent = new AdminReportComponent("initiator-group", "report.initiatorgroup.title");
        initiatorGroupComponent.addAttribute(new AdminReportComponentAttribute("name", "report.initiatorgroup.name.label", group.getName(), false, null));
        ArrayList initiators = group.getInitiators();
        if (initiators != null) {
            AdminReportComponent initiatorComponent = null;
            Iterator initiatorIterator = initiators.iterator();
            while (initiatorIterator.hasNext()) {
                InitiatorInterface initiator = (InitiatorInterface)initiatorIterator.next();
                initiatorComponent = new AdminReportComponent("initiator", "report.initiatorgroup.initiator.title");
                initiatorComponent.addAttribute(new AdminReportComponentAttribute("wwn", "report.initiatorgroup.initiator.wwn.label", initiator.getWWN(), false, null));
                initiatorComponent.addAttribute(new AdminReportComponentAttribute("description", "report.initiatorgroup.initiator.description.label", initiator.getDescription(), false, null));
                initiatorGroupComponent.addSubComponent(initiatorComponent);
            }
        }
        ManageBindingsInterface bindingManager = ManageBindingsFactory.getManager();
        bindingManager.setScope((InstanceWrapper)group);
        bindingManager.init(configContext, null);
        List bindingObjects = bindingManager.getItemList();
        AdminReportComponent volumeGroupComponent = null;
        Iterator bindingObjectsIterator = bindingObjects.iterator();
        while (bindingObjectsIterator.hasNext()) {
            BindingInterface binding = (BindingInterface)bindingObjectsIterator.next();
            volumeGroupComponent = new AdminReportComponent("volume-group", "report.volumegroup.title");
            volumeGroupComponent.addAttribute(new AdminReportComponentAttribute("name", "report.volumegroup.name.label", binding.getVolumeGroup().getName(), false, null));
            volumeGroupComponent.addAttribute(new AdminReportComponentAttribute("permission", "report.volumegroup.permission.label", binding.getAccess(), true, "permissions"));
            initiatorGroupComponent.addSubComponent(volumeGroupComponent);
        }
        return initiatorGroupComponent;
    }

    protected AdminReportComponent buildInitiatorsComponent(ConfigContext configContext, InitiatorInterface initiator) throws Exception {
        AdminReportComponent component = new AdminReportComponent("initiator", "report.initiator.title");
        component.addAttribute(new AdminReportComponentAttribute("wwn", "report.initiator.wwn.label", initiator.getWWN(), false, null));
        component.addAttribute(new AdminReportComponentAttribute("description", "report.initiator.description.label", initiator.getDescription(), false, null));
        return component;
    }

    protected AdminReportComponent buildProfilesComponent(ConfigContext configContext) throws Exception {
        AdminReportComponent reportsComponent = new AdminReportComponent("profiles", "report.profile.title");
        List allProfiles = this.findAllProfiles(configContext);
        if (allProfiles != null) {
            Iterator profileIterator = allProfiles.iterator();
            while (profileIterator.hasNext()) {
                StorageProfile profile = (StorageProfile)profileIterator.next();
                reportsComponent.addSubComponent(this.buildProfileComponent(configContext, profile));
            }
        }
        return reportsComponent;
    }

    protected AdminReportComponent buildAdminComponent(ConfigContext configContext) throws Exception {
        AdminReportComponent adminComponent = new AdminReportComponent("admin", "report.admin.title");
        adminComponent.addSubComponent(this.buildSystemComponent(configContext));
        adminComponent.addSubComponent(this.buildNetworkComponent(configContext));
        adminComponent.addSubComponent(this.buildTimeComponent(configContext));
        adminComponent.addSubComponent(this.buildPortFilteringComponent(configContext));
        return adminComponent;
    }

    protected AdminReportComponent buildPortFilteringComponent(ConfigContext configContext) {
        AdminReportComponent portFilteringComponent = new AdminReportComponent("port-filtering", "report.admin.portfiltering.title");
        try {
            FirewallAdminInterface firewallAdmin = this.adminBizObj.getFirewallAdminInterface(configContext);
            AdminReportComponent cimHTTPServiceComponent = new AdminReportComponent("app", "report.admin.portfiltering.app.title");
            cimHTTPServiceComponent.addAttribute(new AdminReportComponentAttribute("name", "report.admin.portfiltering.app.name.label", firewallAdmin.getCimHTTP().getServiceName(), true, "report.admin.portfiltering.app"));
            cimHTTPServiceComponent.addAttribute(new AdminReportComponentAttribute("port", "report.admin.portfiltering.app.port.label", firewallAdmin.getCimHTTP().getPort(), false, null));
            String portOpen = firewallAdmin.getCimHTTP().isOpen() ? "yes" : "no";
            cimHTTPServiceComponent.addAttribute(new AdminReportComponentAttribute("port-enabled", "report.admin.portfiltering.app.portenabled.label", portOpen, true, "report.admin.portfiltering.app.portenabled"));
            cimHTTPServiceComponent.addAttribute(new AdminReportComponentAttribute("direction", "report.admin.portfiltering.app.direction.label", firewallAdmin.getCimHTTP().getDirection(), true, "report.admin.portfiltering.direction"));
            portFilteringComponent.addSubComponent(cimHTTPServiceComponent);
            AdminReportComponent ntpServiceComponent = new AdminReportComponent("app", "report.admin.portfiltering.app.title");
            ntpServiceComponent.addAttribute(new AdminReportComponentAttribute("name", "report.admin.portfiltering.app.name.label", firewallAdmin.getNtp().getServiceName(), true, "report.admin.portfiltering.app"));
            ntpServiceComponent.addAttribute(new AdminReportComponentAttribute("port", "report.admin.portfiltering.app.port.label", firewallAdmin.getNtp().getPort(), false, null));
            portOpen = firewallAdmin.getNtp().isOpen() ? "yes" : "no";
            ntpServiceComponent.addAttribute(new AdminReportComponentAttribute("port-enabled", "report.admin.portfiltering.app.portenabled.label", portOpen, true, null));
            ntpServiceComponent.addAttribute(new AdminReportComponentAttribute("direction", "report.admin.portfiltering.app.direction.label", firewallAdmin.getNtp().getDirection(), true, "report.admin.portfiltering.direction"));
            portFilteringComponent.addSubComponent(ntpServiceComponent);
            AdminReportComponent patchProServiceComponent = new AdminReportComponent("app", "report.admin.portfiltering.app.title");
            patchProServiceComponent.addAttribute(new AdminReportComponentAttribute("name", "report.admin.portfiltering.app.name.label", firewallAdmin.getPatchPro().getServiceName(), true, "report.admin.portfiltering.app"));
            patchProServiceComponent.addAttribute(new AdminReportComponentAttribute("port", "report.admin.portfiltering.app.port.label", firewallAdmin.getPatchPro().getPort(), false, null));
            portOpen = firewallAdmin.getPatchPro().isOpen() ? "yes" : "no";
            patchProServiceComponent.addAttribute(new AdminReportComponentAttribute("port-enabled", "report.admin.portfiltering.app.portenabled.label", portOpen, true, null));
            patchProServiceComponent.addAttribute(new AdminReportComponentAttribute("direction", "report.admin.portfiltering.app.direction.label", firewallAdmin.getPatchPro().getDirection(), true, "report.admin.portfiltering.direction"));
            portFilteringComponent.addSubComponent(patchProServiceComponent);
            AdminReportComponent serviceHTTPServiceComponent = new AdminReportComponent("app", "report.admin.portfiltering.app.title");
            serviceHTTPServiceComponent.addAttribute(new AdminReportComponentAttribute("name", "report.admin.portfiltering.app.name.label", firewallAdmin.getServiceHTTP().getServiceName(), true, "report.admin.portfiltering.app"));
            serviceHTTPServiceComponent.addAttribute(new AdminReportComponentAttribute("port", "report.admin.portfiltering.app.port.label", firewallAdmin.getServiceHTTP().getPort(), false, null));
            portOpen = firewallAdmin.getServiceHTTP().isOpen() ? "yes" : "no";
            serviceHTTPServiceComponent.addAttribute(new AdminReportComponentAttribute("port-enabled", "report.admin.portfiltering.app.portenabled.label", portOpen, true, null));
            serviceHTTPServiceComponent.addAttribute(new AdminReportComponentAttribute("direction", "report.admin.portfiltering.app.direction.label", firewallAdmin.getServiceHTTP().getDirection(), true, "report.admin.portfiltering.direction"));
            portFilteringComponent.addSubComponent(serviceHTTPServiceComponent);
            AdminReportComponent serviceHTTPSServiceComponent = new AdminReportComponent("app", "report.admin.portfiltering.app.title");
            serviceHTTPSServiceComponent.addAttribute(new AdminReportComponentAttribute("name", "report.admin.portfiltering.app.name.label", firewallAdmin.getServiceHTTPS().getServiceName(), true, "report.admin.portfiltering.app"));
            serviceHTTPSServiceComponent.addAttribute(new AdminReportComponentAttribute("port", "report.admin.portfiltering.app.port.label", firewallAdmin.getServiceHTTPS().getPort(), false, null));
            portOpen = firewallAdmin.getServiceHTTPS().isOpen() ? "yes" : "no";
            serviceHTTPSServiceComponent.addAttribute(new AdminReportComponentAttribute("port-enabled", "report.admin.portfiltering.app.portenabled.label", portOpen, true, null));
            serviceHTTPSServiceComponent.addAttribute(new AdminReportComponentAttribute("direction", "report.admin.portfiltering.app.direction.label", firewallAdmin.getServiceHTTPS().getDirection(), true, "report.admin.portfiltering.direction"));
            portFilteringComponent.addSubComponent(serviceHTTPSServiceComponent);
            AdminReportComponent sntpServiceComponent = new AdminReportComponent("app", "report.admin.portfiltering.app.title");
            sntpServiceComponent.addAttribute(new AdminReportComponentAttribute("name", "report.admin.portfiltering.app.name.label", firewallAdmin.getSnmp().getServiceName(), true, "report.admin.portfiltering.app"));
            sntpServiceComponent.addAttribute(new AdminReportComponentAttribute("port", "report.admin.portfiltering.app.port.label", firewallAdmin.getSnmp().getPort(), false, null));
            portOpen = firewallAdmin.getSnmp().isOpen() ? "yes" : "no";
            sntpServiceComponent.addAttribute(new AdminReportComponentAttribute("port-enabled", "report.admin.portfiltering.app.portenabled.label", portOpen, true, null));
            sntpServiceComponent.addAttribute(new AdminReportComponentAttribute("direction", "report.admin.portfiltering.app.direction.label", firewallAdmin.getSnmp().getDirection(), true, "report.admin.portfiltering.direction"));
            portFilteringComponent.addSubComponent(sntpServiceComponent);
            AdminReportComponent storMgtHTTPServiceComponent = new AdminReportComponent("app", "report.admin.portfiltering.app.title");
            storMgtHTTPServiceComponent.addAttribute(new AdminReportComponentAttribute("name", "report.admin.portfiltering.app.name.label", firewallAdmin.getStorageManagementHTTP().getServiceName(), true, "report.admin.portfiltering.app"));
            storMgtHTTPServiceComponent.addAttribute(new AdminReportComponentAttribute("port", "report.admin.portfiltering.app.port.label", firewallAdmin.getStorageManagementHTTP().getPort(), false, null));
            portOpen = firewallAdmin.getStorageManagementHTTP().isOpen() ? "yes" : "no";
            storMgtHTTPServiceComponent.addAttribute(new AdminReportComponentAttribute("port-enabled", "report.admin.portfiltering.app.portenabled.label", portOpen, true, null));
            storMgtHTTPServiceComponent.addAttribute(new AdminReportComponentAttribute("direction", "report.admin.portfiltering.app.direction.label", firewallAdmin.getStorageManagementHTTP().getDirection(), true, "report.admin.portfiltering.direction"));
            portFilteringComponent.addSubComponent(storMgtHTTPServiceComponent);
            AdminReportComponent storMgtHTTPSServiceComponent = new AdminReportComponent("app", "report.admin.portfiltering.app.title");
            storMgtHTTPSServiceComponent.addAttribute(new AdminReportComponentAttribute("name", "report.admin.portfiltering.app.name.label", firewallAdmin.getStorageManagementHTTPS().getServiceName(), true, "report.admin.portfiltering.app"));
            storMgtHTTPSServiceComponent.addAttribute(new AdminReportComponentAttribute("port", "report.admin.portfiltering.app.port.label", firewallAdmin.getStorageManagementHTTPS().getPort(), false, null));
            portOpen = firewallAdmin.getStorageManagementHTTPS().isOpen() ? "yes" : "no";
            storMgtHTTPSServiceComponent.addAttribute(new AdminReportComponentAttribute("port-enabled", "report.admin.portfiltering.app.portenabled.label", portOpen, true, null));
            storMgtHTTPSServiceComponent.addAttribute(new AdminReportComponentAttribute("direction", "report.admin.portfiltering.app.direction.label", firewallAdmin.getStorageManagementHTTPS().getDirection(), true, "report.admin.portfiltering.direction"));
            portFilteringComponent.addSubComponent(storMgtHTTPSServiceComponent);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"_buildPortFilteringComponent", (Throwable)e);
        }
        return portFilteringComponent;
    }

    protected AdminReportComponent buildTimeComponent(ConfigContext configContext) {
        AdminReportComponent timeComponent = new AdminReportComponent("time", "report.admin.time.title");
        try {
            SystemTimeAdminInterface timeAdmin = this.adminBizObj.getSystemTimeAdminInterface(configContext);
            String spDate = SPDate.getLocalizedDateString(timeAdmin.getTime(), timeAdmin.getCurrentTimeZone(), this.locale);
            timeComponent.addAttribute(new AdminReportComponentAttribute("current-system-time", "report.admin.time.currentsystemtime.label", spDate, false, null));
            timeComponent.addAttribute(new AdminReportComponentAttribute("time-zone", "report.admin.time.timezone.label", timeAdmin.getCurrentTimeZone().getID(), false, null));
            AdminReportComponent timeSettingsComponent = new AdminReportComponent("settings", "report.admin.time.settings.title");
            AdminReportComponent timeNtpSettingsComponent = new AdminReportComponent("ntp", "report.admin.time.settings.ntp.title");
            String ntpIp = timeAdmin.getNtpServerIp() != null ? timeAdmin.getNtpServerIp() : "";
            timeNtpSettingsComponent.addAttribute(new AdminReportComponentAttribute("ntp-ip", "report.admin.time.settings.ntp.ntpip.label", ntpIp, false, null));
            timeSettingsComponent.addSubComponent(timeNtpSettingsComponent);
            timeComponent.addSubComponent(timeSettingsComponent);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"_buildTimeComponent", (Throwable)e);
        }
        return timeComponent;
    }

    protected AdminReportComponent buildNetworkComponent(ConfigContext configContext) {
        AdminReportComponent networkComponent = new AdminReportComponent("network", "report.admin.network.title");
        try {
            NetworkAdminInterface networkAdmin = this.adminBizObj.getNetworkAdminInterface(configContext);
            String ipAssignment = networkAdmin.isDhcp() ? "dhcp" : "fixed";
            networkComponent.addAttribute(new AdminReportComponentAttribute("ip-assignment", "report.admin.network.ipassignment.label", ipAssignment, true, "admin.network"));
            networkComponent.addAttribute(new AdminReportComponentAttribute("ip", "report.admin.network.ip.label", networkAdmin.getIpAddress(), false, null));
            networkComponent.addAttribute(new AdminReportComponentAttribute("gateway", "report.admin.network.gateway.label", networkAdmin.getGatewayIp(), false, null));
            networkComponent.addAttribute(new AdminReportComponentAttribute("netmask", "report.admin.network.netmask.label", networkAdmin.getNetmask(), false, null));
            networkComponent.addAttribute(new AdminReportComponentAttribute("nameserver", "report.admin.network.nameserver.label", networkAdmin.getDnsAddress(), false, null));
            String domainName = networkAdmin.getDomainName();
            networkComponent.addAttribute(new AdminReportComponentAttribute("domainname", "report.admin.network.domainname.label", domainName != null ? domainName : "", false, null));
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"_buildNetworkComponent", (Throwable)e);
        }
        return networkComponent;
    }

    protected AdminReportComponent buildSystemComponent(ConfigContext configContext) {
        AdminReportComponent systemComponent = new AdminReportComponent("system", "report.admin.system.title");
        try {
            GeneralAdminInterface generalAdmin = this.adminBizObj.getGeneralAdminInterface(configContext);
            systemComponent.addAttribute(new AdminReportComponentAttribute("id", "report.admin.system.id.label", generalAdmin.getMaseratiId(), false, null));
            systemComponent.addAttribute(new AdminReportComponentAttribute("description", "report.admin.system.description.label", generalAdmin.getDescription(), false, null));
            systemComponent.addAttribute(new AdminReportComponentAttribute("vendor", "report.admin.system.vendor.label", generalAdmin.getVendor(), false, null));
            systemComponent.addAttribute(new AdminReportComponentAttribute("model", "report.admin.system.model.label", generalAdmin.getModel(), false, null));
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"_buildSystemComponent", (Throwable)e);
        }
        return systemComponent;
    }

    protected AdminReportComponentAttribute buildHealthAttribute(ConfigContext configContext) {
        AdminReportComponentAttribute healthAttribute = null;
        try {
            OverallHealth healthObject = new OverallHealth();
            String health = healthObject.getHealth(configContext);
            healthAttribute = new AdminReportComponentAttribute("health", "report.label.health", health, true, null);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"buildHealthAttribute", (Throwable)e);
        }
        return healthAttribute;
    }

    protected AdminReportComponent buildProfileComponent(ConfigContext context, StorageProfile profile) throws Exception {
        AdminReportComponent profileComponent = new AdminReportComponent("profile-component", "report.profile.profile.title");
        try {
            profileComponent.addAttribute(new AdminReportComponentAttribute("name", "report.profile.name.label", profile.getName(), false, null));
            profileComponent.addAttribute(new AdminReportComponentAttribute("description", "report.array.description.label", profile.getDescription(), false, null));
            profileComponent.addAttribute(new AdminReportComponentAttribute("raid-level", "report.profile.raidlevel.label", "" + profile.getRaidLevel(), true, "profile.raidlevel"));
            profileComponent.addAttribute(new AdminReportComponentAttribute("segment-size", "report.profile.segmentsize.label", "" + profile.getSegmentSize(), true, "profile.segmentsize"));
            String readaheadMode = profile.getReadaheadMode() != 0 ? "1" : "0";
            profileComponent.addAttribute(new AdminReportComponentAttribute("readahead", "report.profile.readahead.label", readaheadMode, true, "array.readahead"));
            profileComponent.addAttribute(new AdminReportComponentAttribute("number-drives", "report.profile.numberdrives.label", profile.getNumberOfDrives(), true, "profile.numberdrives"));
            profileComponent.addAttribute(new AdminReportComponentAttribute("array-type", "report.profile.arraytype.label", "" + profile.getArrayType(), true, "array.type"));
            profileComponent.addAttribute(new AdminReportComponentAttribute("dedicated-hotspare", "report.profile.dedicatedhotspare.label", profile.getDedicatedHotSpare(), true, "profile.dedicatedhotspare"));
        }
        catch (Exception ex) {
            Trace.verbose((Object)this, (String)"build profile component exception", (Throwable)ex);
            profileComponent.setReportException(ex);
        }
        return profileComponent;
    }

    public static void main(String[] args) {
        try {
            Repository.getRepository().setTestEnvironment(true);
            AdminReports reports = new AdminReports(Locale.getDefault());
            AdminReportComponent report = reports.buildReport(null, null, Locale.getDefault());
            String string = report.toLocalizedXml(Locale.getDefault());
        }
        catch (CoreUIBusException e) {
            e.printStackTrace();
        }
    }
}

