/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import java.math.BigInteger;
import java.util.Locale;
import java.util.ResourceBundle;

public class AdminReportComponentAttribute {
    public static final String DISPLAY_LABEL_XML_TAG = "display-label";
    public static final String DISPLAY_VALUE_XML_TAG = "display-value";
    private String _displayLabelKey;
    private String _localizedDisplayLabel;
    private String _value;
    private String _valueLocalizationKeyPreffix;
    private String _localizedValue;
    private String _xmlTag;
    private boolean _isValueLocalizable;
    public static final String RESOURCE_FILE_NAME = "ApplicationResources";

    public AdminReportComponentAttribute(String xmlTag, String labelKey, String value, boolean isValueLocalizable, String valueLocalizationKeyPreffix) {
        this._xmlTag = xmlTag;
        this._displayLabelKey = labelKey;
        this._value = value;
        this._isValueLocalizable = isValueLocalizable;
        this._valueLocalizationKeyPreffix = valueLocalizationKeyPreffix;
    }

    public AdminReportComponentAttribute(String xmlTag, String labelKey, int value, boolean isValueLocalizable, String valueLocalizationKeyPreffix) {
        this(xmlTag, labelKey, new Integer(value).toString(), isValueLocalizable, valueLocalizationKeyPreffix);
    }

    public AdminReportComponentAttribute(String xmlTag, String labelKey, BigInteger value, boolean isValueLocalizable, String valueLocalizationKeyPreffix) {
        this(xmlTag, labelKey, value.toString(), isValueLocalizable, valueLocalizationKeyPreffix);
    }

    public String toLocalizedXml(Locale locale) {
        StringBuffer xml = new StringBuffer();
        this.localize(locale);
        xml.append("\n<").append(this._xmlTag).append(">\n");
        xml.append("\t<").append(DISPLAY_LABEL_XML_TAG).append(">");
        xml.append(this._localizedDisplayLabel);
        xml.append("</").append(DISPLAY_LABEL_XML_TAG).append(">\n");
        xml.append("\t<").append(DISPLAY_VALUE_XML_TAG).append(">");
        if (this._localizedValue != null) {
            xml.append(this._localizedValue);
        } else {
            try {
                xml.append(AdminReportComponentAttribute.localizeString("report.valueUnknown", locale));
            }
            catch (Exception e) {
                xml.append("&#160;");
            }
        }
        xml.append("</").append(DISPLAY_VALUE_XML_TAG).append(">\n");
        xml.append("</").append(this._xmlTag).append(">\n");
        return xml.toString();
    }

    public void localize(Locale locale) {
        try {
            this._localizedDisplayLabel = AdminReportComponentAttribute.localizeString(this._displayLabelKey, locale);
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"localize", (String)("Unable to localize display label for key " + this._displayLabelKey));
        }
        try {
            this._localizedValue = this._isValueLocalizable ? (this._valueLocalizationKeyPreffix != null ? AdminReportComponentAttribute.localizeString(this._valueLocalizationKeyPreffix + "." + this._value, locale) : AdminReportComponentAttribute.localizeString(this._value, locale)) : this._value;
        }
        catch (Exception e) {
            if (this._valueLocalizationKeyPreffix != null) {
                Trace.error((Object)this, (String)"localize", (String)("Unable to localize value for key " + this._valueLocalizationKeyPreffix + "." + this._value));
            }
            Trace.error((Object)this, (String)"localize", (String)("Unable to localize value for key " + this._value));
        }
    }

    public static String localizeString(String key, Locale locale) throws Exception {
        return ResourceBundle.getBundle(RESOURCE_FILE_NAME, locale).getString(key);
    }

    public static String localizeString(int key, Locale locale) throws Exception {
        return AdminReportComponentAttribute.localizeString(new Integer(key).toString(), locale);
    }
}

