/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.ui.business.AdminReportComponentAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

public class AdminReportComponent {
    public static final String DISPLAY_TITLE_XML_TAG = "display-title";
    private String _xmlTag;
    private String _componentTitleKey;
    private String _localizedComponentTitle;
    private Exception exception;
    ArrayList _attributes = new ArrayList();
    ArrayList _subComponents = new ArrayList();

    public AdminReportComponent(String xmlTag, String displayLabelKey) {
        this._xmlTag = xmlTag;
        this._componentTitleKey = displayLabelKey;
    }

    public void setReportException(Exception e) {
        this.exception = e;
    }

    public Exception getReportException() {
        return this.exception;
    }

    public void addAttribute(AdminReportComponentAttribute attribute) {
        this._attributes.add(attribute);
    }

    public void addSubComponent(AdminReportComponent subComponent) {
        if (subComponent != null && subComponent.getReportException() != null) {
            this.setReportException(subComponent.getReportException());
        }
        this._subComponents.add(subComponent);
    }

    public void addSubComponents(Collection subComponents) {
        Iterator subCompunentsIterator = subComponents.iterator();
        while (subCompunentsIterator.hasNext()) {
            AdminReportComponent subComponent = (AdminReportComponent)subCompunentsIterator.next();
            this.addSubComponent(subComponent);
        }
    }

    public String toLocalizedXml(Locale locale) {
        StringBuffer xml = new StringBuffer();
        if (this._attributes.isEmpty() && this._subComponents.isEmpty()) {
            return xml.toString();
        }
        try {
            if (this._componentTitleKey != null) {
                this._localizedComponentTitle = AdminReportComponentAttribute.localizeString(this._componentTitleKey, locale);
            }
        }
        catch (Exception e) {
            Trace.error((Object)this, (String)"toLocalizedXml", (String)("Unable to localize display label for key " + this._componentTitleKey));
        }
        xml.append("\n<").append(this._xmlTag).append(">\n");
        xml.append("\t<").append(DISPLAY_TITLE_XML_TAG).append(">");
        xml.append(this._localizedComponentTitle);
        xml.append("</").append(DISPLAY_TITLE_XML_TAG).append(">\n");
        Iterator attributeIterator = this._attributes.iterator();
        while (attributeIterator.hasNext()) {
            AdminReportComponentAttribute attribute = (AdminReportComponentAttribute)attributeIterator.next();
            xml.append(attribute.toLocalizedXml(locale));
        }
        Iterator subComponentIterator = this._subComponents.iterator();
        while (subComponentIterator.hasNext()) {
            AdminReportComponent subComponent = (AdminReportComponent)subComponentIterator.next();
            xml.append(subComponent.toLocalizedXml(locale));
        }
        xml.append("</").append(this._xmlTag).append(">\n");
        return xml.toString();
    }
}

