/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.admin.business.FirewallAdminFactory;
import com.sun.netstorage.array.mgmt.cfg.admin.business.FirewallAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.GeneralAdminFactory;
import com.sun.netstorage.array.mgmt.cfg.admin.business.GeneralAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.NetworkAdminFactory;
import com.sun.netstorage.array.mgmt.cfg.admin.business.NetworkAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.PasswordsAdminFactory;
import com.sun.netstorage.array.mgmt.cfg.admin.business.PasswordsAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.PowerAndBootFactory;
import com.sun.netstorage.array.mgmt.cfg.admin.business.PowerAndBootInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.SystemTimeAdminFactory;
import com.sun.netstorage.array.mgmt.cfg.admin.business.SystemTimeAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.ActiveUserInfo;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.EventCategoryInfo;
import com.sun.netstorage.array.mgmt.logger.EventInfo;
import com.sun.netstorage.array.mgmt.logger.SOAPLogClient;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class Admin
extends CoreUIBusObject {
    public PasswordsAdminInterface getPasswordsAdminInterface(ConfigContext configContext) throws CoreUIBusException {
        try {
            PasswordsAdminInterface passwordsInterface = PasswordsAdminFactory.create((ConfigContext)configContext);
            passwordsInterface.init(configContext);
            return passwordsInterface;
        }
        catch (Exception e) {
            throw new CoreUIBusException(e.toString());
        }
    }

    public GeneralAdminInterface getGeneralAdminInterface(ConfigContext configContext) throws CoreUIBusException {
        try {
            GeneralAdminInterface generalInterface = GeneralAdminFactory.create((ConfigContext)configContext);
            generalInterface.init(configContext);
            return generalInterface;
        }
        catch (Exception e) {
            throw new CoreUIBusException(e.toString());
        }
    }

    public SystemTimeAdminInterface getSystemTimeAdminInterface(ConfigContext configContext) throws CoreUIBusException {
        try {
            SystemTimeAdminInterface systemTimeInterface = SystemTimeAdminFactory.create((ConfigContext)configContext);
            systemTimeInterface.init(configContext);
            return systemTimeInterface;
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"getSystemTimeAdminInterface", (Throwable)e);
            throw new CoreUIBusException(e.toString());
        }
    }

    public List getLogEventsNewestFirst(String locale) throws CoreUIBusException {
        Trace.methodBegin((Object)this, (String)"getLogEventsNewestFirst");
        SOAPLogClient logClient = new SOAPLogClient();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= 9; ++i) {
            String[] entries = logClient.translate(i, locale);
            Trace.verbose((Object)this, (String)"getLogEventsNewestFirst", (String)("from file " + i + ", obtained number of records: " + entries.length));
            for (int j = entries.length - 1; j >= 0; --j) {
                list.add(entries[j]);
            }
        }
        return list;
    }

    public List getLogEvents(String locale) throws CoreUIBusException {
        Trace.methodBegin((Object)this, (String)"getLogEvents");
        SOAPLogClient logClient = new SOAPLogClient();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 9; i > 0; --i) {
            String[] entries = logClient.translate(i, locale);
            Trace.verbose((Object)this, (String)"getLogEvents", (String)("from file " + i + ", obtained number of records: " + entries.length));
            for (int j = 0; j < entries.length; ++j) {
                list.add(entries[j]);
            }
        }
        return list;
    }

    public List formatLogEntries(List result, Locale locale, TimeZone timezone, boolean returnShort) {
        Vector<String> formatted = new Vector<String>();
        for (int i = 0; i < result.size(); ++i) {
            String firstToken;
            String row = (String)result.get(i);
            StringTokenizer st = new StringTokenizer(row, "|");
            String timeZoneDate = firstToken = st.nextToken();
            String secondToken = st.nextToken();
            String thirdToken = st.nextToken();
            if (!TimeZone.getDefault().hasSameRules(timezone)) {
                try {
                    Date timeZoneDateObj = Convert.stringToDateTime((String)firstToken, (TimeZone)TimeZone.getDefault(), (int)1, (Locale)locale);
                    timeZoneDate = Convert.dateTimeToString((Date)timeZoneDateObj, (TimeZone)timezone, (int)1, (Locale)locale);
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
            if (returnShort) {
                formatted.add(timeZoneDate + ":" + thirdToken);
                continue;
            }
            formatted.add(timeZoneDate + "|" + secondToken + "|" + thirdToken);
        }
        return formatted;
    }

    public List getAllSubscribers() throws ConfigMgmtException {
        String methodName = "getAllSubscribers";
        try {
            Trace.methodBegin((Object)this, (String)methodName);
            SOAPLogClient logClient = new SOAPLogClient();
            Vector<String> list = new Vector<String>();
            String[] emails = logClient.getSubscribers("all");
            if (emails == null) {
                Trace.verbose((Object)this, (String)methodName, (String)"Emails are null:");
            }
            Trace.verbose((Object)this, (String)methodName, (String)("Got " + emails.length + " emails."));
            for (int i = 0; i < emails.length; ++i) {
                list.add(emails[i]);
            }
            Trace.verbose((Object)this, (String)methodName, (String)("Returning " + list.size() + " emails."));
            Vector<String> vector = list;
            return vector;
        }
        catch (Exception e) {
            ConfigMgmtException cme = new ConfigMgmtException(e);
            Trace.error((Object)this, (ConfigMgmtException)cme);
            throw cme;
        }
        finally {
            Trace.verbose((Object)this, (String)methodName, (String)"Exiting");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getEventCategories() throws CoreUIBusException {
        try {
            Trace.methodBegin((Object)this, (String)"getEventCategories");
            SOAPLogClient logClient = new SOAPLogClient();
            Vector<EventCategoryInfo> list = new Vector<EventCategoryInfo>();
            EventCategoryInfo[] categories = logClient.getEventCategories();
            if (categories == null) {
                Trace.verbose((Object)this, (String)"getEventCategories", (String)"Categories are null:");
            }
            Trace.verbose((Object)this, (String)"getEventCategories", (String)("Got " + categories.length + " categories."));
            for (int i = 0; i < categories.length; ++i) {
                EventCategoryInfo info = categories[i];
                list.add(info);
            }
            Trace.verbose((Object)this, (String)"getEventCategories", (String)("Returning " + list.size() + " categories."));
            Vector<EventCategoryInfo> vector = list;
            return vector;
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"getEventCategories", (String)("Error in get categories:" + e));
        }
        finally {
            Trace.verbose((Object)this, (String)"getEventCategories", (String)"Exiting");
        }
        return null;
    }

    public EventCategoryInfo getEventCategory(String category) {
        SOAPLogClient logClient = new SOAPLogClient();
        return logClient.getEventCategory(category);
    }

    public EventInfo getEvent(String event) {
        SOAPLogClient logClient = new SOAPLogClient();
        return logClient.getEvent(event);
    }

    public void addSubscribers(String key, String[] subscribers) {
        SOAPLogClient logClient = new SOAPLogClient();
        logClient.addSubscribers(key, subscribers);
    }

    public void removeSubscribers(String key, String[] subscribers) {
        SOAPLogClient logClient = new SOAPLogClient();
        logClient.removeSubscribers(key, subscribers);
    }

    public FirewallAdminInterface getFirewallAdminInterface(ConfigContext configContext) throws CoreUIBusException {
        try {
            FirewallAdminInterface firewallInterface = FirewallAdminFactory.create((ConfigContext)configContext);
            firewallInterface.init(configContext, null);
            return firewallInterface;
        }
        catch (Exception e) {
            throw new CoreUIBusException(e.toString());
        }
    }

    public NetworkAdminInterface getNetworkAdminInterface(ConfigContext configContext) throws ConfigMgmtException {
        NetworkAdminInterface networkInterface = NetworkAdminFactory.create();
        networkInterface.init(configContext);
        return networkInterface;
    }

    public PowerAndBootInterface getPowerAndBootInterface(ConfigContext configContext) throws ConfigMgmtException {
        PowerAndBootInterface powerAndBootInterface = PowerAndBootFactory.create();
        powerAndBootInterface.setScope(null);
        powerAndBootInterface.init(configContext);
        return powerAndBootInterface;
    }

    public List getActiveUsersList(ConfigContext context) {
        Repository rep = Repository.getRepository();
        ArrayList<ActiveUserInfo> activeUsers = new ArrayList<ActiveUserInfo>();
        ArrayList au = (ArrayList)rep.getProperty((Object)"ActiveUsersListProperty");
        if (au == null) {
            Trace.verbose((Object)this, (String)"getActiveUsersList", (String)"Active users list property not found!! (SNH)");
            return activeUsers;
        }
        Iterator it = au.iterator();
        while (it.hasNext()) {
            String sessionId = (String)it.next();
            ActiveUserInfo aui = (ActiveUserInfo)rep.getProperty((Object)sessionId);
            if (aui != null && !aui.isLoggedOff) {
                Trace.verbose((Object)this, (String)"getActiveUsersList", (String)("found active user " + aui.username + " with role " + aui.role));
                activeUsers.add(aui);
                continue;
            }
            Trace.verbose((Object)this, (String)"getActiveUsersList", (String)("session " + sessionId + " not found in active user list!! (SNH)"));
        }
        Trace.verbose((Object)this, (String)"init", (String)"Performing sort");
        Collections.sort(activeUsers, new ActiveUserComparator(context.getLocale()));
        return activeUsers;
    }

    private class ActiveUserComparator
    implements Comparator {
        Collator collator = null;

        ActiveUserComparator(Locale loc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof ActiveUserInfo && element2 instanceof ActiveUserInfo) {
                key1 = this.collator.getCollationKey(((ActiveUserInfo)element1).username);
                key2 = this.collator.getCollationKey(((ActiveUserInfo)element2).username);
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

