/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.business;

import com.sun.netstorage.array.mgmt.cfg.access.business.BindingInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageBindingsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageBindingsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.AccessMatrixWrapper;
import com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusObject;
import com.sun.netstorage.array.mgmt.cfg.util.HttpArrayMessage;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.util.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AccessMatrix
extends CoreUIBusObject {
    private ManageStorageVolumesInterface manageVolInt = ManageStorageVolumesFactory.getManager();
    private ManageBindingsInterface bindingsManager = ManageBindingsFactory.getManager();
    private ManageInitiatorsInterface iniManager = ManageInitiatorsFactory.getManager();
    private static final String ACCESS_MATRIX_STYLE_SHEET = "permreport.xsl";
    private static final String PROP_FILE = "/opt/se6x20/resources/StorEdge_6120.properties";
    private static final String T4_FILE_KEY = "lmdataFile";

    public List generate(ConfigContext context, T4Interface array) throws ConfigMgmtException {
        ArrayList<AccessMatrixWrapper> accessMatrix = new ArrayList<AccessMatrixWrapper>();
        this.manageVolInt.setScope((InstanceWrapper)array);
        this.manageVolInt.init(context, null);
        List volumes = this.manageVolInt.getItemList();
        if (volumes != null) {
            Iterator it = volumes.iterator();
            VolumeGroups vgs = new VolumeGroups();
            while (it.hasNext()) {
                StorageVolumeInterface svi = (StorageVolumeInterface)it.next();
                AccessMatrixWrapper amw = new AccessMatrixWrapper();
                amw.setVolumeName(svi.getName());
                amw.setLunNumber("" + svi.getLUN());
                amw.setVolGroupName(svi.getVolumeGroup());
                amw.setVolumeDefPerm(this.normalizePerm(svi.getVolumePermissions()));
                amw.setIniWWN("storage.access.initiator.default");
                amw.setEffectivePermission("-");
                accessMatrix.add(amw);
                try {
                    VolumeGroupInterface vgi = vgs.getVolumeGroupInterface(context, array, svi.getVolumeGroup());
                    this.bindingsManager.setScope((InstanceWrapper)vgi);
                    this.bindingsManager.init(context, null);
                    List bindingsList = this.bindingsManager.getItemList();
                    Iterator bit = bindingsList.iterator();
                    ArrayList<InitiatorInterface> initiatorsForVol = new ArrayList<InitiatorInterface>();
                    ArrayList iniWWNsForVol = new ArrayList();
                    Hashtable<InitiatorInterface, String> igsForIni = new Hashtable<InitiatorInterface, String>();
                    Hashtable<InitiatorInterface, String> igPermForIni = new Hashtable<InitiatorInterface, String>();
                    while (bit.hasNext()) {
                        BindingInterface bi = (BindingInterface)bit.next();
                        InitiatorGroupInterface igi = bi.getInitiatorGroup();
                        ArrayList iniList = igi.getInitiators();
                        Iterator ii = iniList.iterator();
                        while (ii.hasNext()) {
                            InitiatorInterface ini = (InitiatorInterface)ii.next();
                            initiatorsForVol.add(ini);
                            igsForIni.put(ini, igi.getName());
                            igPermForIni.put(ini, bi.getAccess());
                        }
                    }
                    Collections.sort(initiatorsForVol, this.iniManager.getInitiatorComparator(context.getLocale()));
                    Iterator ii = initiatorsForVol.iterator();
                    while (ii.hasNext()) {
                        InitiatorInterface ini = (InitiatorInterface)ii.next();
                        AccessMatrixWrapper am = new AccessMatrixWrapper();
                        am.setVolumeName(svi.getName());
                        am.setLunNumber("" + svi.getLUN());
                        am.setVolGroupName(svi.getVolumeGroup());
                        am.setVolumeDefPerm(this.normalizePerm(svi.getVolumePermissions()));
                        am.setEffectivePermission("-");
                        am.setIniWWN(ini.getWWN());
                        am.setIniGroupName((String)igsForIni.get(ini));
                        am.setGroupPermission(this.normalizePerm((String)igPermForIni.get(ini)));
                        accessMatrix.add(am);
                    }
                }
                catch (ItemNotFoundException infe) {
                }
            }
        }
        if (Trace.isTraceEnabled((Object)this)) {
            for (int x = 0; x < accessMatrix.size(); ++x) {
                AccessMatrixWrapper am = (AccessMatrixWrapper)accessMatrix.get(x);
                Trace.verbose((Object)this, (String)"generate", (String)am.toString());
            }
        }
        return accessMatrix;
    }

    private String normalizePerm(String perm) {
        Trace.verbose((Object)this, (String)"normalizePerm", (String)perm);
        if (perm == null || perm.equals("None")) {
            perm = "none";
        } else if (perm.trim().equalsIgnoreCase("Read/Write")) {
            perm = "rw";
        } else if (perm.trim().equalsIgnoreCase("Read-Only")) {
            perm = "ro";
        }
        return perm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List generateDirect(ConfigContext context, T4Interface array) {
        InputStream in = null;
        Vector accessMatrix = null;
        String t4File = null;
        try {
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(PROP_FILE);
            prop.load(fis);
            t4File = "/" + prop.getProperty(T4_FILE_KEY, "lunmaskdata.htm");
        }
        catch (Exception e) {
            Trace.error((Object)this, (ConfigMgmtException)new ConfigMgmtException(e));
            t4File = "/lunmaskdata.htm";
        }
        Trace.verbose((Object)this, (String)"generateDirect", (String)"Get file from array");
        HttpArrayMessage msg = new HttpArrayMessage(array.getName(), t4File);
        String lunPermListRaw = msg.getTokenFile();
        Trace.verbose((Object)this, (String)"generateDirect", (String)"parse document");
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        byte[] bytes = lunPermListRaw.getBytes();
        in = new ByteArrayInputStream(bytes);
        Document document = builder.parse(in);
        Trace.verbose((Object)this, (String)"generateDirect", (String)"File parsed - generate objects");
        accessMatrix = this.buildListFromRawDoc(document.getDocumentElement());
        Trace.verbose((Object)this, (String)"generateDirect", (String)"DONE!");
        Object var13_14 = null;
        if (in == null) return accessMatrix;
        try {
            in.close();
            return accessMatrix;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return accessMatrix;
        {
            catch (Exception e) {
                Trace.error((Object)this, (ConfigMgmtException)new ConfigMgmtException(e));
                Object var13_15 = null;
                if (in == null) return accessMatrix;
                try {
                    in.close();
                    return accessMatrix;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return accessMatrix;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List generateDirectWithXSLT(ConfigContext context, T4Interface array) {
        InputStream in = null;
        Vector accessMatrix = null;
        String t4File = null;
        try {
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(PROP_FILE);
            prop.load(fis);
            t4File = "/" + prop.getProperty(T4_FILE_KEY, "lunmaskdata.htm");
        }
        catch (Exception e) {
            Trace.error((Object)this, (ConfigMgmtException)new ConfigMgmtException(e));
            t4File = "/lunmaskdata.htm";
        }
        Trace.verbose((Object)this, (String)"generateDirect", (String)"Get file from array");
        HttpArrayMessage msg = new HttpArrayMessage(array.getName(), t4File);
        String lunPermListRaw = msg.getTokenFile();
        String lunPermList = this.transformWithXSL(lunPermListRaw);
        Trace.verbose((Object)this, (String)"generateDirect", (String)"parse document");
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        byte[] bytes = lunPermList.getBytes();
        in = new ByteArrayInputStream(bytes);
        Document document = builder.parse(in);
        Trace.verbose((Object)this, (String)"generateDirect", (String)"File parsed - generate objects");
        accessMatrix = this.buildListFromDoc(document.getDocumentElement());
        Trace.verbose((Object)this, (String)"generateDirect", (String)"DONE!");
        Object var14_15 = null;
        if (in == null) return accessMatrix;
        try {
            in.close();
            return accessMatrix;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return accessMatrix;
        {
            catch (Exception e) {
                Trace.error((Object)this, (ConfigMgmtException)new ConfigMgmtException(e));
                Object var14_16 = null;
                if (in == null) return accessMatrix;
                try {
                    in.close();
                    return accessMatrix;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return accessMatrix;
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            throw throwable;
        }
    }

    private String transformWithXSL(String lunPermListRaw) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        Trace.verbose((Object)this, (String)"generateDirect", (String)"File retrieved - prepare  file transformation");
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslSource = new StreamSource(this.getClass().getClassLoader().getResourceAsStream(ACCESS_MATRIX_STYLE_SHEET));
        StreamSource xmlSource = new StreamSource(new StringReader(lunPermListRaw));
        Transformer transformer = factory.newTransformer(xslSource);
        StringWriter lunPermListWriter = new StringWriter();
        Trace.verbose((Object)this, (String)"generateDirect", (String)"Execute transformation");
        transformer.transform(xmlSource, new StreamResult(lunPermListWriter));
        Trace.verbose((Object)this, (String)"generateDirect", (String)"Transformation complete - get String");
        String lunPermList = lunPermListWriter.toString();
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.verbose((Object)this, (String)"generateDirect", (String)lunPermList);
        }
        return lunPermList;
    }

    private Vector buildListFromRawDoc(Element root) throws Exception {
        String methodName = "buildListFromRawDoc";
        Trace.methodBegin((Object)this, (String)methodName);
        Vector theList = new Vector();
        List volgroups = XMLUtils.listNamedChildElements((Element)root, (String)"volGroup");
        Hashtable htvgs = this.createHashOfVolumeGroups(root);
        Hashtable hlm = this.createHashOfLunMaps(root);
        Hashtable hiniIniGs = this.createHashOfIniIniGs(root);
        List volslices = XMLUtils.listNamedChildElements((Element)root, (String)"volSlice");
        for (int i = 0; i < volslices.size(); ++i) {
            Element lunMap;
            Element volslice = (Element)volslices.get(i);
            Element defaultPerm = XMLUtils.findElement((Element)volslice, (String)"perm");
            Element volsliceWWN = XMLUtils.findElement((Element)volslice, (String)"wwn");
            String lun = volslice.getAttribute("id");
            String volsliceName = volslice.getAttribute("name");
            String slice = volslice.getAttribute("slice");
            String vgName = (String)htvgs.get(lun);
            String volDefPerm = XMLUtils.getElementValue((Element)defaultPerm);
            AccessMatrixWrapper defam = new AccessMatrixWrapper();
            defam.setVolumeName(volsliceName);
            defam.setLunNumber(lun);
            defam.setVolGroupName(vgName);
            defam.setVolumeDefPerm(volDefPerm);
            defam.setEffectivePermission(volDefPerm);
            defam.setIniWWN("default");
            this.addSortedAMW(theList, defam);
            if (Trace.isTraceEnabled((Object)this)) {
                Trace.verbose((Object)this, (String)methodName, (String)defam.toString());
            }
            if ((lunMap = (Element)hlm.get(lun)) == null) continue;
            String lunMapIndex = lunMap.getAttribute("index");
            NodeList inis = lunMap.getElementsByTagName("initiator");
            if (inis == null) continue;
            for (int j = 0; j < inis.getLength(); ++j) {
                Element ini = (Element)inis.item(j);
                Element iniPerm = (Element)ini.getElementsByTagName("perm").item(0);
                String iniP = XMLUtils.getElementValue((Element)iniPerm);
                Element iniEfPerm = (Element)ini.getElementsByTagName("effective").item(0);
                String iniEfP = XMLUtils.getElementValue((Element)iniEfPerm);
                if (volDefPerm.equals(iniEfP)) continue;
                this.addInitiatorToAccessMatrix(theList, hiniIniGs, lun, volsliceName, vgName, volDefPerm, lunMapIndex, ini, iniEfP);
            }
        }
        return theList;
    }

    private void addInitiatorToAccessMatrix(Vector theList, Hashtable hiniIniGs, String lun, String volsliceName, String vgName, String volDefPerm, String lunMapIndex, Element ini, String iniEfP) {
        Element iniWWN = (Element)ini.getElementsByTagName("wwn").item(0);
        String iniName = XMLUtils.getElementValue((Element)iniWWN);
        List groups = (List)hiniIniGs.get(iniName);
        if (groups != null) {
            Iterator it = groups.iterator();
            while (it.hasNext()) {
                Element ig = (Element)it.next();
                NodeList perms = ig.getElementsByTagName("perm");
                String groupPerm = null;
                for (int k = 0; k < perms.getLength() && groupPerm == null; ++k) {
                    Element perm = (Element)perms.item(k);
                    String permInd = perm.getAttribute("index");
                    if (!lunMapIndex.equals(permInd)) continue;
                    groupPerm = XMLUtils.getElementValue((Element)perm);
                }
                AccessMatrixWrapper am = new AccessMatrixWrapper();
                am.setVolumeName(volsliceName);
                am.setLunNumber(lun);
                am.setVolGroupName(vgName);
                am.setVolumeDefPerm(volDefPerm);
                am.setEffectivePermission(iniEfP);
                am.setIniWWN(iniName);
                am.setIniGroupName(ig.getAttribute("name"));
                am.setGroupPermission(groupPerm);
                this.addSortedAMW(theList, am);
            }
        }
    }

    private Hashtable createHashOfVolumeGroups(Element root) throws Exception {
        Hashtable<String, String> hvgs = new Hashtable<String, String>();
        NodeList volGroupMemberLuns = root.getElementsByTagName("volGroupMemberLUN");
        if (volGroupMemberLuns != null) {
            for (int i = 0; i < volGroupMemberLuns.getLength(); ++i) {
                Element volGroupMemberLun = (Element)volGroupMemberLuns.item(i);
                String lun = XMLUtils.getElementValue((Element)volGroupMemberLun);
                Element volGroup = (Element)volGroupMemberLun.getParentNode();
                String vgName = volGroup.getAttribute("name");
                hvgs.put(lun, vgName);
            }
        }
        return hvgs;
    }

    private Hashtable createHashOfLunMaps(Element root) throws Exception {
        Hashtable<String, Element> hlm = new Hashtable<String, Element>();
        NodeList lunMaps = root.getElementsByTagName("lunMap");
        if (lunMaps != null) {
            for (int i = 0; i < lunMaps.getLength(); ++i) {
                Element lunMap = (Element)lunMaps.item(i);
                String lun = lunMap.getAttribute("id");
                hlm.put(lun, lunMap);
            }
        }
        return hlm;
    }

    private Hashtable createHashOfIniIniGs(Element root) throws Exception {
        Hashtable<String, ArrayList<Element>> hiniIniGs = new Hashtable<String, ArrayList<Element>>();
        NodeList iniGs = root.getElementsByTagName("lunGroup");
        if (iniGs != null) {
            for (int i = 0; i < iniGs.getLength(); ++i) {
                Element iniG = (Element)iniGs.item(i);
                NodeList inis = iniG.getElementsByTagName("wwn");
                if (inis == null) continue;
                for (int j = 0; j < inis.getLength(); ++j) {
                    Element ini = (Element)inis.item(j);
                    String iniWWN = XMLUtils.getElementValue((Element)ini);
                    ArrayList<Element> groups = (ArrayList<Element>)hiniIniGs.get(iniWWN);
                    if (groups == null) {
                        groups = new ArrayList<Element>();
                    }
                    groups.add(iniG);
                    hiniIniGs.put(iniWWN, groups);
                }
            }
        }
        return hiniIniGs;
    }

    private Vector buildListFromDoc(Element root) throws Exception {
        Vector theList = new Vector();
        List volslices = XMLUtils.listNamedChildElements((Element)root, (String)"volSlice");
        for (int i = 0; i < volslices.size(); ++i) {
            Element volslice = (Element)volslices.get(i);
            Element defaultPerm = XMLUtils.findElement((Element)volslice, (String)"default");
            Element vgName = XMLUtils.findElement((Element)volslice, (String)"volGroupName");
            AccessMatrixWrapper defam = new AccessMatrixWrapper();
            defam.setVolumeName(volslice.getAttribute("name"));
            defam.setLunNumber(volslice.getAttribute("id"));
            defam.setVolGroupName(XMLUtils.getElementValue((Element)vgName));
            defam.setVolumeDefPerm(XMLUtils.getElementValue((Element)defaultPerm));
            defam.setEffectivePermission(XMLUtils.getElementValue((Element)defaultPerm));
            defam.setIniWWN("default");
            this.addSortedAMW(theList, defam);
            List initiators = XMLUtils.listNamedChildElements((Element)volslice, (String)"initiator");
            Trace.verbose((Object)this, (String)"defam", (String)("FOR VOLUME:" + volslice.getAttribute("name") + " GOT a LIST OF INITIATORS OF SIZE:" + initiators.size()));
            for (int j = 0; j < initiators.size(); ++j) {
                Element initiator = (Element)initiators.get(j);
                Element wwn = XMLUtils.findElement((Element)initiator, (String)"wwn");
                Element effectivePerm = XMLUtils.findElement((Element)initiator, (String)"effective");
                Trace.verbose((Object)this, (String)"generateFromDoc", (String)("Initiator PERMISSION:" + XMLUtils.getElementValue((Element)effectivePerm)));
                if (XMLUtils.getElementValue((Element)effectivePerm).equals("none")) continue;
                List groups = XMLUtils.listNamedChildElements((Element)initiator, (String)"group");
                for (int k = 0; k < groups.size(); ++k) {
                    Element group = (Element)groups.get(k);
                    Element groupPerm = XMLUtils.findElement((Element)group, (String)"perm");
                    AccessMatrixWrapper am = new AccessMatrixWrapper();
                    am.setVolumeName(volslice.getAttribute("name"));
                    am.setLunNumber(volslice.getAttribute("id"));
                    am.setVolGroupName(XMLUtils.getElementValue((Element)vgName));
                    am.setVolumeDefPerm(XMLUtils.getElementValue((Element)defaultPerm));
                    am.setEffectivePermission(XMLUtils.getElementValue((Element)effectivePerm));
                    am.setIniWWN(XMLUtils.getElementValue((Element)wwn));
                    am.setIniGroupName(group.getAttribute("name"));
                    am.setGroupPermission(XMLUtils.getElementValue((Element)groupPerm));
                    Trace.verbose((Object)this, (String)"am", (String)am.toString());
                    this.addSortedAMW(theList, am);
                }
            }
        }
        return theList;
    }

    private void addSortedAMW(Vector theList, AccessMatrixWrapper am) {
        boolean inserted = false;
        for (int l = 0; l < theList.size(); ++l) {
            AccessMatrixWrapper next = (AccessMatrixWrapper)theList.get(l);
            int vncomp = am.getVolumeName().compareTo(next.getVolumeName());
            if (vncomp < 0) {
                theList.insertElementAt(am, l);
                inserted = true;
                break;
            }
            if (vncomp != 0) continue;
            if (am.getIniWWN().equals("default")) {
                theList.insertElementAt(am, l);
                inserted = true;
                break;
            }
            if (next.getIniWWN().equals("default") || am.getIniWWN().compareTo(next.getIniWWN()) > 0) continue;
            theList.insertElementAt(am, l);
            inserted = true;
            break;
        }
        if (!inserted) {
            theList.add(am);
        }
    }
}

