/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Initiators;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageMgmtCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.VolumeForm;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class VolumesAction
extends StorageMgmtCoreAction {
    private static final String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getBreadCrumbName";
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Path = " + path));
        String bcName = "storage.mgmt.volumes.title";
        if ("/root.menu.item0.item4voldelconfirm.do".equals(path)) {
            bcName = "";
        }
        return bcName;
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String methodName = "doAction";
        HttpSession session = argReq.getSession();
        String action = argAction == null ? "show" : argAction;
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Path = " + path));
        try {
            Volumes volumes = (Volumes)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes");
            if ("delete".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Final delete action");
                ArrayList<MethodCallStatus> methodCallStatuses = new ArrayList<MethodCallStatus>();
                String[] args = new String[2];
                args[1] = this.getCurrentT4(argReq).getName();
                List volsToDelete = ((VolumeForm)argForm).getVolsToDelete();
                boolean jobsGenerated = false;
                for (int i = 0; i < volsToDelete.size(); ++i) {
                    StorageVolumeInterface vol = (StorageVolumeInterface)volsToDelete.get(i);
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("name of volume to delete = " + vol.getName()));
                    args[0] = vol.getName();
                    methodCallStatuses.add(volumes.delete(vol));
                    if (!Jobs.hasJobsInMethodCallStatuses(methodCallStatuses)) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"No Jobs in status objects; log vol delete");
                        LogAPI.staticLog((String)"VOLUME_DELETE", (String[])args, (String[])new String[0]);
                        continue;
                    }
                    jobsGenerated = true;
                }
                boolean hasErrors = false;
                if (volumes.hasErrorsInMethodCallStatuses(methodCallStatuses)) {
                    UserMessages messages = new UserMessages();
                    hasErrors = true;
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.volumes.delete.error"));
                    this.saveUserMessages(argReq, messages);
                }
                this.storeMethodCallStatuses(argReq, methodCallStatuses);
                if (this.hasJobs(session)) {
                    action = "jobs_notification";
                }
                if (!hasErrors && !jobsGenerated) {
                    this.saveSingleUserMessage(argReq, 2, "storage.mgmt.volumes.delete.successful");
                } else if (!hasErrors && jobsGenerated) {
                    this.saveSingleUserMessage(argReq, 2, "storage.mgmt.volumes.delete.initiated");
                }
            } else if ("show".equals(action) && "/root.menu.item0.item4voldelconfirm.do".equals(path)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Showing vol delete confirm");
                try {
                    this.handleDeleteConfirmation(argReq, argForm);
                }
                catch (Exception ex) {
                    Trace.verbose((Object)((Object)this), (String)"Exception trying to handle delete confirmation", (Throwable)ex);
                    UserMessages messages = new UserMessages();
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, ex.getMessage()));
                    this.saveUserMessages(argReq, messages);
                    action = ((VolumeForm)argForm).getComingFrom();
                }
            } else {
                T4Interface currentT4 = this.getSelectedT4(argReq);
                if (currentT4 == null) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"No T4 in request; try from session");
                    currentT4 = this.getCurrentT4(argReq);
                }
                action = this.handlePasswordPrompt(action, argForm, argReq);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Action after handle pass = " + action));
                if ("prompt_password".equals(action)) {
                    return this.doForward(argReq, action, argMap);
                }
                this.handleList(argReq, volumes, currentT4);
            }
        }
        catch (ConfigMgmtException e) {
            this.handleSystemError(argReq, e);
        }
        catch (Exception e) {
            this.handleSystemError(argReq, e);
        }
        return this.doForward(argReq, action, argMap);
    }

    private void handleList(HttpServletRequest argReq, Volumes volumes, T4Interface currentT4) throws ConfigMgmtException {
        String methodName = "handleList";
        if (this.listRequiresRefresh(argReq, "VolumeList")) {
            Trace.verbose((Object)((Object)this), (String)"handleList", (String)"Getting NEW Volume list!");
            List volumeList = volumes.listByArray(this.getConfigContext(argReq), currentT4);
            this.setListContext(argReq, "VolumeList", volumeList);
        } else {
            this.setListContext(argReq, "VolumeList", null);
        }
    }

    private void handleDeleteConfirmation(HttpServletRequest argReq, ActionForm argForm) throws Exception {
        String methodName = "handleDeleteConfirmation";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        HttpSession session = argReq.getSession();
        ArrayList volsToDelete = new ArrayList();
        int[] itemsToDelete = Convert.stringArrayToIntArray((String[])argReq.getParameterValues("id"));
        List allVolumes = (List)session.getAttribute("VolumeList");
        if (argReq.getParameter("poolsVolumeList") != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"WE have a POOL volume list name; get list of volumes for a specific pool");
            String poolVolumeListName = argReq.getParameter("poolsVolumeList");
            allVolumes = (List)session.getAttribute(poolVolumeListName);
        }
        Volumes volBusObj = (Volumes)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes");
        Initiators iniBusObj = (Initiators)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Initiators");
        if (allVolumes != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"have list of volumes!");
            List volumesToDelete = volBusObj.list(itemsToDelete, allVolumes);
            if (volumesToDelete == null || volumesToDelete.size() < 1) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"No volumes selected to delete");
                throw new Exception("error.none.selected");
            }
            ((VolumeForm)argForm).setVolsToDelete(volumesToDelete);
            try {
                List affectedInis = iniBusObj.getInitiatorsForVolumesList(this.getConfigContext(argReq), volumesToDelete);
                if (affectedInis != null && affectedInis.size() == 0) {
                    affectedInis = null;
                }
                ((VolumeForm)argForm).setAffectedInitiators(affectedInis);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
                ((VolumeForm)argForm).setAffectedInitiators(null);
            }
        }
    }
}

