/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Bindings;
import com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroupWrapper;
import com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageAccessCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.VolumeGroupForm;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class VolumeGroupsAction
extends StorageAccessCoreAction {
    private static final String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)("Path = " + path));
        if ("/root.menu.item1.item0vgdelconfirm.do".equals(path)) {
            return "storage.access.volume.group.delete.crumb";
        }
        return "storage.access.array.selection.volgrps.button";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String action;
        block22: {
            String methodName = "doAction";
            Trace.methodBegin((Object)((Object)this), (String)methodName);
            HttpSession session = argReq.getSession();
            action = argAction == null ? "show" : argAction;
            String path = argReq.getServletPath();
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Path = " + path));
            VolumeGroups volGroups = null;
            Bindings bindingsBusObj = null;
            try {
                if (null == bindingsBusObj) {
                    bindingsBusObj = (Bindings)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Bindings");
                }
                if ("show".equals(action)) {
                    if ("/root.menu.item1.item0vgdelconfirm.do".equals(path)) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Show vg delete confirm");
                        try {
                            this.handleDeleteConfirmation(argReq, argForm);
                            break block22;
                        }
                        catch (Exception ex) {
                            UserMessages messages = new UserMessages();
                            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, ex.getMessage()));
                            this.saveUserMessages(argReq, messages);
                            action = "back";
                            ActionForward actionForward = this.doForward(argReq, action, argMap);
                            volGroups = null;
                            return actionForward;
                        }
                    }
                    T4Interface currentT4 = this.getSelectedT4(argReq);
                    if (currentT4 == null) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Couldn't get t4 selected, choose session");
                        currentT4 = this.getCurrentT4(argReq);
                        if (currentT4 == null) {
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Couldn't get session t4, get default");
                            currentT4 = this.getDefaultT4(argReq);
                        }
                    }
                    if (currentT4 != null) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Current t4 in storage access = " + currentT4.getName()));
                    }
                    action = this.handlePasswordPrompt(action, argForm, argReq);
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Action after handle pass = " + action));
                    if ("prompt_password".equals(action)) {
                        ActionForward messages = this.doForward(argReq, action, argMap);
                        return messages;
                    }
                    if (null == volGroups) {
                        volGroups = (VolumeGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups");
                    }
                    this.prepareDisplay(argForm, argReq, volGroups, bindingsBusObj, currentT4);
                    break block22;
                }
                if (!"delete".equals(action)) break block22;
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Volume delete action");
                if (volGroups == null) {
                    volGroups = (VolumeGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups");
                }
                String[] args = new String[2];
                T4Interface currentT4 = (T4Interface)session.getAttribute("CurrentT4");
                if (currentT4 == null) {
                    currentT4 = this.getDefaultT4(argReq);
                }
                args[1] = currentT4.getName();
                List deletes = ((VolumeGroupForm)argForm).getVgsToDelete();
                try {
                    for (int i = 0; i < deletes.size(); ++i) {
                        VolumeGroupInterface grp = (VolumeGroupInterface)deletes.get(i);
                        args[0] = grp.getName();
                        volGroups.delete(grp);
                        LogAPI.staticLog((String)"VOLUME_GRP_DELETE", (String[])args, (String[])new String[0]);
                    }
                    this.prepareDisplay(argForm, argReq, volGroups, bindingsBusObj, currentT4);
                }
                catch (Exception e) {
                    Trace.verbose((Object)((Object)this), (String)"Exception trying to delete vol grp", (Throwable)e);
                    UserMessages messages = new UserMessages();
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.access.volume.group.error.delete"));
                    this.saveUserMessages(argReq, messages);
                }
                UserMessages messages = new UserMessages();
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.access.volume.groups.delete.success"));
                this.saveUserMessages(argReq, messages);
            }
            catch (Exception e) {
                Trace.verbose((Object)((Object)this), (String)"Exception in doAction()", (Throwable)e);
            }
            finally {
                volGroups = null;
            }
        }
        return this.doForward(argReq, action, argMap);
    }

    public void prepareDisplay(ActionForm argForm, HttpServletRequest argReq, VolumeGroups volGroups, Bindings bindingsBusObj, T4Interface currentT4) throws ConfigMgmtException {
        String methodName = "prepareDisplay";
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("=============LIST VOLGRP FOR ARRAY:" + currentT4.getName()));
        List volGroupsList = this.listVolGroupsForArray(argForm, argReq, volGroups, bindingsBusObj, currentT4);
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("\n volume groups action; list size = " + volGroupsList.size()));
        this.setListContext(argReq, "VolumeGroupsList", volGroupsList);
    }

    public List listVolGroupsForArray(ActionForm argForm, HttpServletRequest argReq, VolumeGroups volGroups, Bindings bindingsBusObj, T4Interface currentT4) throws ConfigMgmtException {
        String methodName = "listVolGroupsForArray";
        List volGroupsList = volGroups.listForArray(this.getConfigContext(argReq), currentT4);
        if (volGroupsList != null && !volGroupsList.isEmpty()) {
            ArrayList<VolumeGroupWrapper> groupWrappers = new ArrayList<VolumeGroupWrapper>();
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Have a list of volume groups");
            for (int i = 0; i < volGroupsList.size(); ++i) {
                VolumeGroupWrapper wrapper = new VolumeGroupWrapper();
                VolumeGroupInterface volGrp = (VolumeGroupInterface)volGroupsList.get(i);
                wrapper.setVolumeGroup(volGrp);
                groupWrappers.add(wrapper);
            }
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Set volume groups in form");
            ((VolumeGroupForm)argForm).setGroupWrappers(groupWrappers);
        } else {
            ((VolumeGroupForm)argForm).setGroupWrappers(null);
        }
        return volGroupsList;
    }

    private void handleDeleteConfirmation(HttpServletRequest argReq, ActionForm argForm) throws Exception {
        String methodName = "handleDeleteConfirmation";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        HttpSession session = argReq.getSession();
        int[] intSelections = this.getSelectedIndices(argReq, "volGrpsToDelete");
        if (intSelections == null || intSelections.length <= 0) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No items selected!");
            throw new Exception("error.none.selected");
        }
        List volGroupsList = (List)session.getAttribute("VolumeGroupsList");
        ArrayList<VolumeGroupInterface> vgsToDelete = new ArrayList<VolumeGroupInterface>();
        if (volGroupsList != null) {
            for (int i = 0; i < intSelections.length; ++i) {
                VolumeGroupInterface grp = (VolumeGroupInterface)volGroupsList.get(intSelections[i]);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to delete vg = " + grp.getName()));
                vgsToDelete.add(grp);
            }
            ((VolumeGroupForm)argForm).setVgsToDelete(vgsToDelete);
        } else {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No volume groups list found in session!");
        }
    }
}

