/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.access.business.BindingInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Bindings;
import com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageAccessCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.VolumeGroupForm;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class VolumeGroupEditAction
extends StorageAccessCoreAction {
    static String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String action;
        block25: {
            String METHOD_NAME = "doAction";
            Trace.constructor((Object)((Object)this));
            Trace.methodBegin((Object)((Object)this), (String)"doAction");
            action = argAction == null ? "show" : argAction;
            Trace.verbose((Object)((Object)this), (String)"doAction", (String)("action = " + action));
            HttpSession session = argReq.getSession();
            VolumeGroupInterface volGroup = null;
            volGroup = this.getVolumeGroupInfo(argReq);
            Bindings bindingsBusObj = null;
            VolumeGroups vgBusObj = null;
            Volumes volBusObj = null;
            try {
                if (volGroup == null && (volGroup = (VolumeGroupInterface)session.getAttribute("CurrentVg")) == null) {
                    Trace.verbose((Object)((Object)this), (String)"doAction", (String)"No VOLUME Group found!");
                    UserMessages messages = new UserMessages();
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.access.volume.group.error.cannotfind"));
                    this.saveUserMessages(argReq, messages);
                    return this.doForward(argReq, action, argMap);
                }
                session.setAttribute("CurrentVg", (Object)volGroup);
                if ("show".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)"doAction", (String)"***Volume Group Edit show action****");
                    BeanUtils.copyProperties((Object)((Object)((VolumeGroupForm)argForm)), (Object)volGroup);
                    if (bindingsBusObj == null) {
                        bindingsBusObj = (Bindings)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Bindings");
                    }
                    List bindingsList = bindingsBusObj.list(this.getConfigContext(argReq), null, volGroup);
                    ArrayList<InitiatorGroupInterface> iniGrpsList = new ArrayList<InitiatorGroupInterface>();
                    if (bindingsList != null) {
                        Trace.verbose((Object)((Object)this), (String)"doAction", (String)"Have a bindings list for this vol group");
                        for (int i = 0; i < bindingsList.size(); ++i) {
                            BindingInterface bi = (BindingInterface)bindingsList.get(i);
                            iniGrpsList.add(bi.getInitiatorGroup());
                        }
                    }
                    ((VolumeGroupForm)argForm).setInitiatorGroups(iniGrpsList);
                    String path = argReq.getServletPath();
                    Trace.verbose((Object)((Object)this), (String)"doAction", (String)("servlet path = " + argReq.getServletPath()));
                    if ("/root.menu.item1.item0addvols.do".equals(path)) {
                        Trace.verbose((Object)((Object)this), (String)"doAction", (String)"Find available volumes");
                        T4Interface currentT4 = this.getCurrentT4(argReq);
                        if (currentT4 != null) {
                            List allVolumes;
                            Trace.verbose((Object)((Object)this), (String)"doAction", (String)("Trying to get volumes list for array = " + currentT4.getName()));
                            if (volBusObj == null) {
                                volBusObj = (Volumes)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes");
                            }
                            if ((allVolumes = volBusObj.getVolumesWithNoMembership(this.getConfigContext(argReq), currentT4)) != null && allVolumes.size() == 0) {
                                allVolumes = null;
                            }
                            this.setListContext(argReq, "possibleVolsForVg", allVolumes);
                            ((VolumeGroupForm)argForm).setPossibleVolumes(allVolumes);
                        }
                    } else {
                        List currentVols = volGroup.getVolumes();
                        if (currentVols != null) {
                            this.setListContext(argReq, "memeberVolsForVG", currentVols);
                        } else {
                            session.removeAttribute("memberVolsForVG");
                        }
                    }
                    break block25;
                }
                if ("add_volumes".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)"doAction", (String)"Adding volumes to volume group action");
                    List selectedVolumes = this.getSelectedVolumes(argReq, argForm);
                    try {
                        if (selectedVolumes != null && selectedVolumes.size() < 1) {
                            Trace.verbose((Object)((Object)this), (String)"doAction", (String)"No volumes selected to add");
                            UserMessages messages = new UserMessages();
                            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.access.add.volume.noneselected"));
                            this.saveUserMessages(argReq, messages);
                        } else {
                            if (vgBusObj == null) {
                                vgBusObj = (VolumeGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups");
                            }
                            Trace.verbose((Object)((Object)this), (String)"doAction", (String)("Number of volumes in volume group (before add), " + volGroup.getName() + " = " + volGroup.getVolumes().size()));
                            vgBusObj.addVolumesToGroup(volGroup, selectedVolumes);
                            Trace.verbose((Object)((Object)this), (String)"doAction", (String)("Number of volumes in volume group (after add), " + volGroup.getName() + " = " + volGroup.getVolumes().size()));
                            ((VolumeGroupForm)argForm).setVolumes((ArrayList)volGroup.getVolumes());
                            Trace.verbose((Object)((Object)this), (String)"doAction", (String)("After adding volumes to group; reset the VG in the form! number of members in form = " + ((VolumeGroupForm)argForm).getVolumes().size()));
                            UserMessages messages = new UserMessages();
                            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.access.volume.group.addvolumesuccess"));
                            this.saveUserMessages(argReq, messages);
                        }
                        action = "start";
                    }
                    catch (ConfigMgmtException cme) {
                        Trace.verbose((Object)((Object)this), (String)"Exception trying to add volume to volume group", (Throwable)cme);
                        UserMessages messages = new UserMessages();
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.access.volume.group.addvolumeerror"));
                        this.saveUserMessages(argReq, messages);
                    }
                    break block25;
                }
                if (!"remove_volumes".equals(action)) break block25;
                Trace.verbose((Object)((Object)this), (String)"doAction", (String)"Remove volumes action");
                List selectedVolumes = this.getSelectedVolumesForRemoval(argReq, argForm, volGroup);
                try {
                    if (selectedVolumes != null && selectedVolumes.size() < 1 && argReq.getParameter("remove_confirmed") == null) {
                        Trace.verbose((Object)((Object)this), (String)"doAction", (String)"No volumes selected to remove");
                        UserMessages messages = new UserMessages();
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.access.add.volume.noneselected"));
                        this.saveUserMessages(argReq, messages);
                        break block25;
                    }
                    if (argReq.getParameter("remove_confirmed") == null) {
                        ((VolumeGroupForm)argForm).setVolsToDelete(selectedVolumes);
                        return this.doForward(argReq, "confirm_remove", argMap);
                    }
                    if (vgBusObj == null) {
                        vgBusObj = (VolumeGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups");
                    }
                    vgBusObj.removeVolumesToGroup(volGroup, ((VolumeGroupForm)argForm).getVolsToDelete());
                    ((VolumeGroupForm)argForm).setVolumes((ArrayList)volGroup.getVolumes());
                    ((VolumeGroupForm)argForm).setVolsToDelete(null);
                    Trace.verbose((Object)((Object)this), (String)"doAction", (String)("After removing volumes from group; reset the VG in the form! number of members in form = " + ((VolumeGroupForm)argForm).getVolumes().size()));
                    UserMessages messages = new UserMessages();
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.access.volume.group.removevolumesuccess"));
                    this.saveUserMessages(argReq, messages);
                }
                catch (ConfigMgmtException cme) {
                    Trace.verbose((Object)((Object)this), (String)"Exception trying to add volume to volume group", (Throwable)cme);
                    UserMessages messages = new UserMessages();
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.access.volume.group.removevolumeerror"));
                    this.saveUserMessages(argReq, messages);
                }
            }
            catch (Exception e) {
                Trace.verbose((Object)((Object)this), (String)"Exception doAction", (Throwable)e);
                this.handleSystemError(argReq, e);
            }
        }
        return this.doForward(argReq, action, argMap);
    }

    private List getSelectedVolumes(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getSelectedVolumes";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ArrayList<StorageVolumeInterface> selectedVolumes = new ArrayList<StorageVolumeInterface>();
        try {
            String[] selectedIndices = argReq.getParameterValues("volumesSelected");
            int[] intIndices = Convert.stringArrayToIntArray((String[])selectedIndices);
            List volumes = ((VolumeGroupForm)argForm).getPossibleVolumes();
            if (intIndices != null) {
                for (int i = 0; i < intIndices.length; ++i) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("vol index selected = " + intIndices[i]));
                    selectedVolumes.add((StorageVolumeInterface)volumes.get(intIndices[i]));
                }
                return selectedVolumes;
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to get selected volumes", (Throwable)e);
            return null;
        }
        return selectedVolumes;
    }

    private List getSelectedVolumesForRemoval(HttpServletRequest argReq, ActionForm argForm, VolumeGroupInterface volGroup) {
        String methodName = "getSelectedVolumesForRemoval";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ArrayList<StorageVolumeInterface> selectedVolumes = new ArrayList<StorageVolumeInterface>();
        try {
            String[] selectedIndices = argReq.getParameterValues("volumesSelected");
            int[] intIndices = Convert.stringArrayToIntArray((String[])selectedIndices);
            List volumes = volGroup.getVolumes();
            if (intIndices != null) {
                for (int i = 0; i < intIndices.length; ++i) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("vol index selected = " + intIndices[i]));
                    selectedVolumes.add((StorageVolumeInterface)volumes.get(intIndices[i]));
                }
                return selectedVolumes;
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to get selected volumes", (Throwable)e);
            return null;
        }
        return selectedVolumes;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getBreadCrumbName";
        HttpSession session = argReq.getSession();
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("servlet path = " + argReq.getServletPath()));
        if ("/root.menu.item1.item0addvols.do".equals(path)) {
            return "storage.access.add.volume.title";
        }
        return "storage.access.volume.group.edit.title";
    }
}

