/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ArrayStatusNotOkException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageMgmtCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.VolumeForm;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class VolumeEditAction
extends StorageMgmtCoreAction {
    private static final String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)("path = " + path));
        String action = argReq.getParameter("action");
        Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)("action = " + action));
        if ("/root.menu.item0.item4addvoltovg.do".equals(path)) {
            return "storage.mgmt.volumes.addtogroup.crumb";
        }
        return "storage.mgmt.volumes.details";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String methodName = "doAction";
        HttpSession session = argReq.getSession();
        String action = argAction == null ? "show" : argAction;
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("ACTION = " + action));
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("PATH = " + path));
        Object svi = null;
        VolumeForm volumeForm = (VolumeForm)argForm;
        Volumes vol = null;
        UserMessages messages = new UserMessages();
        try {
            vol = (Volumes)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes");
            action = this.handleActionProcessing(argReq, action, path, volumeForm, vol, messages);
        }
        catch (ItemNotFoundException infe) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.none.selected"));
            this.saveUserMessages(argReq, messages);
        }
        catch (ConfigMgmtException e) {
            e.addExceptionContext((Object)volumeForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)e);
            this.handleSystemError(argReq, e);
        }
        catch (Exception e) {
            ConfigMgmtException cme = new ConfigMgmtException(e);
            cme.addExceptionContext((Object)volumeForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, e);
        }
        finally {
            vol = null;
        }
        return this.doForward(argReq, action, argMap);
    }

    protected String handleActionProcessing(HttpServletRequest argReq, String action, String path, VolumeForm volumeForm, Volumes vol, UserMessages messages) throws IllegalAccessException, InvocationTargetException, ConfigMgmtException, Exception {
        String methodName = "handleActionProcessing";
        StorageVolumeInterface svi = volumeForm.getStorageVolume();
        Trace.methodBegin((Object)((Object)this), (String)"handleActionProcessing");
        if ("save".equals(action)) {
            this.saveVolumeSettings(volumeForm, argReq, svi, messages);
        } else if ("removefromgroups".equals(action)) {
            this.handleRemoveFromGroups(argReq, volumeForm, svi, vol, messages);
        } else if ("addtogroups".equals(action)) {
            action = this.addToGroups(argReq, action, svi, vol, messages);
        } else if ("show".equals(action)) {
            if ("/root.menu.item0.item4addvoltovg.do".equals(path)) {
                Trace.verbose((Object)((Object)this), (String)"handleActionProcessing", (String)"Show ACTION on the add to vg page");
                VolumeGroups vgBusObj = (VolumeGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups");
                this.handlePossibleVolumeGroups(argReq, volumeForm, messages, svi, vgBusObj);
            } else {
                svi = this.getVolumeInfo(argReq, volumeForm, vol);
                volumeForm.setStorageVolume(svi);
                this.copyToForm(volumeForm, argReq, svi);
                if (svi.getLUN() == -1) {
                    Trace.verbose((Object)((Object)this), (String)"handleActionProcessing", (String)"No lun found for this volume");
                    this.saveSingleUserMessage(argReq, 1, "storage.mgmt.volumes.no.lun.warning");
                    int[] availLuns = vol.getAvailableLUNNumbers(this.getConfigContext(argReq), this.getCurrentT4(argReq));
                    volumeForm.setAvailableLUNs(Convert.intArrayToStringArray((int[])availLuns));
                }
            }
        }
        return action;
    }

    protected String addToGroups(HttpServletRequest argReq, String action, StorageVolumeInterface svi, Volumes vol, UserMessages messages) throws ConfigMgmtException {
        String methodName = "addToGroups";
        Trace.methodBegin((Object)((Object)this), (String)"addToGroups");
        String[] selectedVolumeGroups = argReq.getParameterValues("volumeGrpsToAdd");
        Trace.verbose((Object)((Object)this), (String)"addToGroups", (String)("Selected volume groups are:" + selectedVolumeGroups));
        if (selectedVolumeGroups != null) {
            this.handleAddToGroups(argReq, vol, messages, svi, selectedVolumeGroups);
        } else {
            Trace.verbose((Object)((Object)this), (String)"addToGroups", (String)"No volume groups selected to add to");
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.none.selected"));
            this.saveUserMessages(argReq, messages);
            action = "show";
        }
        return action;
    }

    protected void saveVolumeSettings(ActionForm argForm, HttpServletRequest argReq, StorageVolumeInterface svi, UserMessages messages) throws IllegalAccessException, InvocationTargetException, ConfigMgmtException {
        svi.save();
        svi.reload();
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.volumes.savesuccessful"));
        this.saveUserMessages(argReq, messages);
    }

    private void copyToForm(VolumeForm volumeForm, HttpServletRequest argReq, StorageVolumeInterface svi) throws ConfigMgmtException {
        volumeForm.setStatusString(this.getLocalizedString(argReq, "storage.mgmt.volumes.status." + svi.getStatus()));
    }

    private void handleAddToGroups(HttpServletRequest argReq, Volumes vol, UserMessages messages, StorageVolumeInterface volToAdd, String[] selectedVolumeGroups) {
        String methodName = "handleAddToGroups";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        Trace.verbose((Object)((Object)this), (String)methodName, (String)(selectedVolumeGroups.length + " volume groups selected"));
        for (int i = 0; i < selectedVolumeGroups.length; ++i) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Tyring to add volume to group = " + selectedVolumeGroups[i]));
        }
        try {
            vol.addToVolumeGroups(this.getConfigContext(argReq), volToAdd, selectedVolumeGroups);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.volumes.addsuccessful"));
            volToAdd.reload();
        }
        catch (ItemNotFoundException infe) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.volumes.addtogroup.error"));
            ConfigMgmtException cme = new ConfigMgmtException((Exception)((Object)infe));
            cme.addExceptionContext((Object)vol);
            cme.addExceptionContext((Object)selectedVolumeGroups);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
        }
        catch (ArrayStatusNotOkException anoke) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.volumes.addtogroup.error"));
            ConfigMgmtException cme = new ConfigMgmtException((Exception)((Object)anoke));
            cme.addExceptionContext((Object)vol);
            cme.addExceptionContext((Object)selectedVolumeGroups);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext((Object)vol);
            cme.addExceptionContext((Object)selectedVolumeGroups);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.volumes.addtogroup.error"));
        }
        this.saveUserMessages(argReq, messages);
    }

    private void handlePossibleVolumeGroups(HttpServletRequest argReq, VolumeForm volumeForm, UserMessages messages, StorageVolumeInterface currentVol, VolumeGroups vgBusObj) {
        String methodName = "handlePossibleVolumeGroups";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        Collection possVgs = vgBusObj.getPossibleVgsToAddTo(this.getConfigContext(argReq), this.getCurrentT4(argReq), currentVol);
        List wrappers = vgBusObj.getVgWrapperList(this.getConfigContext(argReq), possVgs);
        if (wrappers != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Have wrappers = " + wrappers.size()));
            if (wrappers.size() < 1) {
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.volumes.addtogroup.nogroups"));
                this.saveUserMessages(argReq, messages);
                volumeForm.setVgWrappers(null);
            } else {
                volumeForm.setVgWrappers(wrappers);
            }
        }
    }

    private void handleRemoveFromGroups(HttpServletRequest argReq, VolumeForm argForm, StorageVolumeInterface svi, Volumes vol, UserMessages messages) throws Exception {
        if (argForm.getVolumeGroup() != null) {
            vol.removeFromVolumeGroup(this.getConfigContext(argReq), svi, argForm.getVolumeGroup());
            svi.reload();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.volumes.removesuccessful"));
            this.saveUserMessages(argReq, messages);
        } else {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.none.selected"));
            this.saveUserMessages(argReq, messages);
        }
    }

    private StorageVolumeInterface getVolumeInfo(HttpServletRequest argReq, VolumeForm volumeForm, Volumes volBusObj) throws ConfigMgmtException, ItemNotFoundException {
        String methodName = "getVolumeInfo";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        StorageVolumeInterface svi = null;
        T4Interface currentT4interface = this.getSearchT4(argReq);
        if (currentT4interface != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"We're in search mode!");
            String volName = argReq.getParameter("name");
            svi = volBusObj.getVolumeByName(this.getConfigContext(argReq), currentT4interface, volName);
        } else {
            String selectedVolume = argReq.getParameter("index");
            String listName = argReq.getParameter("listName") == null ? "VolumeList" : argReq.getParameter("listName");
            List volumeList = (List)argReq.getSession().getAttribute(listName);
            if (selectedVolume != null && volumeList != null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Got selected volume index = " + selectedVolume));
                int volumeIndex = Integer.parseInt(selectedVolume);
                svi = (StorageVolumeInterface)volumeList.get(volumeIndex);
                svi.reload();
            } else {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Try to get volume by the name in the form");
                selectedVolume = volumeForm.getName();
                svi = volBusObj.getVolumeByName(this.getConfigContext(argReq), this.getCurrentT4(argReq), selectedVolume);
            }
        }
        return svi;
    }

    private String[] getSelectedVolumeGroups(HttpServletRequest request) {
        String[] selections = request.getParameterValues("groupid");
        if (selections != null) {
            for (int i = 0; i < selections.length; ++i) {
                Trace.verbose((Object)((Object)this), (String)"getSelectedVolumeGroups", (String)("Selected vol group = " + selections[i]));
            }
        }
        return selections;
    }
}

