/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.actions.WizardContent;
import com.sun.netstorage.array.mgmt.cfg.ui.business.CreateVolumeVGs;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.VolumeCreateForm;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class VolumeCreateWizard
extends WizardContent {
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$ui$actions$VolumeCreateWizard;

    public ActionForward openWizard(int defaultPage, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        UserMessages messages = new UserMessages();
        VolumeCreateForm volumeCreateForm = (VolumeCreateForm)argForm;
        volumeCreateForm.doReset();
        HttpSession session = argReq.getSession();
        try {
            session.removeAttribute("disableNext");
            ConfigContext configContext = this.getConfigContext(argReq);
            Volumes volumes = (Volumes)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes");
            StoragePools poolBusObj = (StoragePools)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools");
            T4Interface currentT4 = this.getCurrentT4(argReq);
            this.getRaidGroupsAndLUNs(argReq, messages, volumeCreateForm, session, configContext, currentT4, volumes);
            this.getVGs(argReq, session, configContext, currentT4);
            if (argReq.getParameter("context") != null) {
                String poolNameToPreselect = argReq.getParameter("context");
                Trace.verbose((Object)((Object)this), (String)"openWizard", (String)("pool name context = " + poolNameToPreselect));
                int poolIndex = poolBusObj.getIndexOf(poolNameToPreselect, volumeCreateForm.getRaidGroups());
                Trace.verbose((Object)((Object)this), (String)"openWizard", (String)("Setting preselected pool index = " + poolIndex));
                if (poolIndex > 0) {
                    volumeCreateForm.setSelectedRaidGroupIndex(poolIndex);
                }
            }
        }
        catch (CoreUIBusException cuie) {
            ConfigMgmtException cme = new ConfigMgmtException(cuie.getMessage(), "Open create volume wizard failed", (Exception)cuie);
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.operationfailed.noerrorcode"));
            this.saveUserMessages(argReq, messages);
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.operationfailed.noerrorcode"));
            this.saveUserMessages(argReq, messages);
        }
        catch (Exception e) {
            ConfigMgmtException cme = new ConfigMgmtException(e.getMessage(), "Open create volume wizard failed", e);
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.operationfailed.noerrorcode"));
            this.saveUserMessages(argReq, messages);
        }
        ActionForward actionForward = this.handleWizardErrors(argReq, argMapping, messages, defaultPage);
        return actionForward;
    }

    private void getRaidGroupsAndLUNs(HttpServletRequest argReq, UserMessages messages, VolumeCreateForm volumeCreateForm, HttpSession session, ConfigContext configContext, T4Interface currentT4, Volumes volumes) throws CoreUIBusException, ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"getRaidGroupsAndLUNs");
        T4s t4s = (T4s)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.T4s");
        List raidGroups = null;
        if (currentT4 != null) {
            currentT4.reload();
            raidGroups = currentT4.getRaidGroups();
        } else {
            Trace.verbose((Object)((Object)this), (String)"getRaidGroupsAndLUNs", (String)"No T4 is currently in scope!");
        }
        if (raidGroups != null && raidGroups.size() > 0) {
            session.removeAttribute("disableNext");
            volumeCreateForm.setRaidGroups(raidGroups);
        } else {
            session.setAttribute("disableNext", (Object)"true");
            volumeCreateForm.setRaidGroups(null);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.volumes.createwizard.nopools"));
            this.saveUserMessages(argReq, messages);
        }
        if (currentT4 != null) {
            int[] availLuns = volumes.getAvailableLUNNumbers(configContext, currentT4);
            int maxVolumesSupported = currentT4.getMaxNumberOfVolumes();
            Trace.verbose((Object)((Object)this), (String)"getRaidGroupsAndLUNs", (String)("Have availLuns: " + availLuns.length + " and maxVolumesSupported: " + maxVolumesSupported));
            volumeCreateForm.setNumberVolumesAvailable(availLuns.length);
            volumeCreateForm.setNumberCurrentVolumes(maxVolumesSupported - availLuns.length + 1);
            volumeCreateForm.setAvailableLUNs(Convert.intArrayToStringArray((int[])availLuns));
            if (volumeCreateForm.getNumberVolumesAvailable() <= 0) {
                this.saveSingleUserMessage(argReq, 2, "volumes.maxVolumesReached");
                session.setAttribute("disableNext", (Object)"true");
            }
        }
        Trace.verbose((Object)((Object)this), (String)"getRaidGroupsAndLUNs", (String)"METHOD END");
    }

    private void getVGs(HttpServletRequest argReq, HttpSession session, ConfigContext configContext, T4Interface currentT4) throws CoreUIBusException {
        VolumeGroups volumeGroups = (VolumeGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.VolumeGroups");
        CreateVolumeVGs vgs = new CreateVolumeVGs(volumeGroups, currentT4, configContext);
        vgs.start();
        session.setAttribute("VOLUME_GROUPS_FOR_CREATE_VOUME", (Object)vgs);
    }

    public ActionForward processInput(int pageNum, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "processInput";
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$actions$VolumeCreateWizard == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$actions$VolumeCreateWizard = VolumeCreateWizard.class$("com.sun.netstorage.array.mgmt.cfg.ui.actions.VolumeCreateWizard")) : class$com$sun$netstorage$array$mgmt$cfg$ui$actions$VolumeCreateWizard), (String)methodName);
        HttpSession session = argReq.getSession();
        Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$actions$VolumeCreateWizard == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$actions$VolumeCreateWizard = VolumeCreateWizard.class$("com.sun.netstorage.array.mgmt.cfg.ui.actions.VolumeCreateWizard")) : class$com$sun$netstorage$array$mgmt$cfg$ui$actions$VolumeCreateWizard), (String)methodName, (String)("pageNum is " + pageNum + " and selectedLUN is " + ((VolumeCreateForm)argForm).getSelectedLUN()));
        VolumeCreateForm volumeCreateForm = (VolumeCreateForm)argForm;
        Volumes volumes = null;
        UserMessages userMessages = new UserMessages();
        switch (pageNum) {
            case 1: {
                this.processPage1Input(argReq, methodName, session, volumeCreateForm, volumes, userMessages);
                break;
            }
            case 2: {
                BigInteger maxAvail = null;
                String maxAvailConverted = null;
                try {
                    maxAvail = Convert.GBStringToBytes((String)volumeCreateForm.getMaxAvailSize());
                    NumberFormat nf = NumberFormat.getInstance();
                    maxAvailConverted = nf.format(nf.parse(Convert.bytesStringToGB((String)maxAvail.toString())));
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Converted max avail size = " + maxAvailConverted));
                    String unitType = volumeCreateForm.getRequestedSizeUnit();
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Requested size unit = " + unitType));
                    BigInteger requestedSize = new BigInteger("0");
                    if ("MB".equals(unitType)) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"We have MB unit type");
                        requestedSize = Convert.MBStringToBytes((String)volumeCreateForm.getRequestedSize());
                    } else if ("GB".equals(unitType)) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"We have GB unit type");
                        requestedSize = Convert.GBStringToBytes((String)volumeCreateForm.getRequestedSize());
                    }
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Requested size = " + requestedSize.toString()));
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Max avail size = " + maxAvail.toString()));
                    try {
                        if (volumes == null) {
                            volumes = (Volumes)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes");
                        }
                        volumes.checkRequestedVolumeSize(requestedSize);
                        volumes.checkIfEnoughStorageCapacityAvailable(requestedSize, volumeCreateForm.getSelectedRaidGroup());
                        if (volumeCreateForm.getAllVolumeGroups() == null) {
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Get VGs from thread");
                            CreateVolumeVGs vgs = (CreateVolumeVGs)session.getAttribute("VOLUME_GROUPS_FOR_CREATE_VOUME");
                            while (!vgs.isThreadDone()) {
                                try {
                                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"VGs thread not done yet");
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {}
                            }
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Thread done, set VGs in form");
                            volumeCreateForm.setAllVolumeGroups(vgs.getVolumeGroups());
                            session.removeAttribute("VOLUME_GROUPS_FOR_CREATE_VOUME");
                        }
                    }
                    catch (BadParameterException bpe) {
                        userMessages.add("requestedSize", new UserMessage(0, bpe.getMessage(), volumeCreateForm.getRequestedSize()));
                    }
                    if (!"nextPage".equals(this.getWizardAction(argReq))) {
                        this.updateWizard(argReq, 1, null);
                        return argMapping.findForward("page1");
                    }
                    break;
                }
                catch (ConfigMgmtException e) {
                    userMessages.add("requestedSize", new UserMessage(0, "error.operationfailed.noerrorcode"));
                    e.addExceptionContext((Object)argForm);
                    e.addExceptionContext((Object)("Page:" + pageNum));
                    Trace.error((Object)((Object)this), (ConfigMgmtException)e);
                    break;
                }
                catch (NumberFormatException nfe) {
                    Trace.verbose((Object)((Object)this), (String)"Invalid size entered", (Throwable)nfe);
                    if (maxAvailConverted != null) {
                        userMessages.add("requestedSize", new UserMessage(0, "error.volume.create.invalidsize", maxAvailConverted));
                        break;
                    }
                    userMessages.add("requestedSize", new UserMessage(0, "error.volume.create.invalidsize.noparam"));
                    break;
                }
                catch (Exception ex) {
                    ConfigMgmtException cme = new ConfigMgmtException(ex);
                    cme.addExceptionContext((Object)argForm);
                    cme.addExceptionContext((Object)("Page:" + pageNum));
                    Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
                    userMessages.add("requestedSize", new UserMessage(0, "error.operationfailed.noerrorcode"));
                }
            }
        }
        ActionForward actionForward = this.handleWizardErrors(argReq, argMapping, userMessages, pageNum);
        return actionForward;
    }

    private void processPage1Input(HttpServletRequest argReq, String methodName, HttpSession session, VolumeCreateForm volumeCreateForm, Volumes volumes, UserMessages userMessages) {
        boolean volumeExists = true;
        try {
            StorageVolumeInterface svi;
            Validate.objectName((String)"Volume.Name", (String)volumeCreateForm.getName());
            if (volumes == null) {
                volumes = (Volumes)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes");
            }
            if ((svi = volumes.getVolumeByName(this.getConfigContext(argReq), this.getCurrentT4(argReq), volumeCreateForm.getName())) != null) {
                userMessages.add("name", new UserMessage(0, "error.resourceAlreadyExists", volumeCreateForm.getName()));
            }
        }
        catch (ItemNotFoundException ex) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Volume with this name doesn't exist yet");
            volumeExists = false;
        }
        catch (BadParameterException bpe) {
            userMessages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, bpe.getMessage(), bpe.getBadParameter()));
            this.saveUserMessages(argReq, userMessages);
            return;
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext((Object)volumeCreateForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            userMessages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, cme.getExceptionKey()));
            this.saveUserMessages(argReq, userMessages);
            return;
        }
    }

    public ActionForward finishWizard(int lastPage, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "finishWizard";
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$actions$VolumeCreateWizard == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$actions$VolumeCreateWizard = VolumeCreateWizard.class$("com.sun.netstorage.array.mgmt.cfg.ui.actions.VolumeCreateWizard")) : class$com$sun$netstorage$array$mgmt$cfg$ui$actions$VolumeCreateWizard), (String)"finishWizard");
        UserMessages messages = new UserMessages();
        String[] args = new String[3];
        String requestedSizeConverted = null;
        BigInteger requestedSize = null;
        HttpSession session = argReq.getSession();
        try {
            VolumeCreateForm volumeForm = (VolumeCreateForm)argForm;
            ConfigContext configContext = this.getConfigContext(argReq);
            Volumes volumes = (Volumes)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes");
            String currentT4 = this.getCurrentT4(argReq).getName();
            args[0] = volumeForm.getName();
            args[1] = currentT4;
            args[2] = volumeForm.getRaidName();
            String unitType = volumeForm.getRequestedSizeUnit();
            Trace.verbose((Object)((Object)this), (String)"finishWizard", (String)("Requested unit type = " + unitType));
            if ("MB".equals(volumeForm.getRequestedSizeUnit())) {
                requestedSize = Convert.MBStringToBytes((String)volumeForm.getRequestedSize());
            } else if ("GB".equals(volumeForm.getRequestedSizeUnit())) {
                requestedSize = Convert.GBStringToBytes((String)volumeForm.getRequestedSize());
            }
            NumberFormat nf = NumberFormat.getInstance();
            requestedSizeConverted = nf.format(nf.parse(Convert.bytesStringToGB((String)requestedSize.toString())));
            Trace.verbose((Object)((Object)this), (String)"finishWizard", (String)("Requested size = " + requestedSize.toString()));
            Trace.verbose((Object)((Object)this), (String)"finishWizard", (String)("permission  = " + volumeForm.getVolumePermissions()));
            MethodCallStatus callStatus = volumes.createVolume(configContext, volumeForm.getName(), currentT4, volumeForm.getRaidName(), requestedSize, volumeForm.getVolumePermissions(), Integer.parseInt(volumeForm.getSelectedLUN()), volumeForm.getSelectedVolumeGroup());
            if (volumes.hasErrorsInMethodCallStatus(callStatus)) {
                Trace.verbose((Object)((Object)this), (String)"finishWizard", (String)"Found error in return status object!");
                LogAPI.staticLog((String)"VOLUME_CREATE_ERROR", (String[])args, (String[])new String[0]);
                throw new Exception();
            }
            ArrayList<MethodCallStatus> callStatuses = new ArrayList<MethodCallStatus>(1);
            callStatuses.add(callStatus);
            if (!Jobs.hasJobsInMethodCallStatuses(callStatuses)) {
                LogAPI.staticLog((String)"VOLUME_CREATE", (String[])args, (String[])new String[0]);
            }
            this.storeMethodCallStatuses(argReq, callStatuses);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.volumes.createwizard.successful"));
            argReq.getSession().removeAttribute("PoolVolumeList");
            argReq.getSession().removeAttribute("VolumeList");
            argReq.getSession().removeAttribute("VolumeCreate");
        }
        catch (BadParameterException bpe) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, bpe.getMessage(), requestedSizeConverted));
            this.saveUserMessages(argReq, messages);
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to create volume", (Throwable)cme);
            String error = cme.getExceptionKey();
            if (error.equals("VOLUME_CREATE_ERROR")) {
                LogAPI.staticLog((String)cme.getExceptionKey(), (String[])args, (String[])new String[0]);
            } else if (error.equals("VOLUME_CREATE_ERROR_DEGRADED")) {
                LogAPI.staticLog((String)cme.getExceptionKey(), (String[])args, (String[])new String[0]);
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"General exception trying to create volume", (Throwable)e);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.operationfailed.noerrorcode"));
            this.saveUserMessages(argReq, messages);
        }
        this.saveUserMessages(argReq, messages);
        ActionForward actionForward = this.handleWizardErrors(argReq, argMapping, messages, lastPage);
        return actionForward;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

