/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.ArrayLoadThread;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.CoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.TreeForm;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class Tree
extends CoreAction {
    static final int MAX_AGE = 63072000;
    static final int MAX_THREAD_WAIT = 120000;
    static final int MAX_THREADS = 75;

    protected String getMenuItemId() {
        return "";
    }

    protected String getMenuSubItemId() {
        return "";
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        TreeForm form = (TreeForm)argForm;
        String action = this.getRequestAction(argMap, argReq);
        if (!form.isInitialized()) {
            this.initForm(form, argReq);
            action = "refresh";
        }
        action = action == null ? "show" : action;
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("ACTION IS:" + action));
        try {
            if ("save".equals(action)) {
                this.saveSettings(argReq, argRes, form);
            } else if ("refresh".equals(action)) {
                action = "show";
            }
            if ("show".equals(action) || "save".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)"doAction", (String)"LOAD LIST START");
                this.loadLists(argReq, form);
                Trace.verbose((Object)((Object)this), (String)"doAction", (String)"LOAD LIST COMPLETED");
            }
            Trace.verbose((Object)((Object)this), (String)"doAction", (String)action);
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)((Object)this), (ConfigMgmtException)e);
        }
        return this.doForward(argReq, action, argMap);
    }

    private void initForm(TreeForm form, HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                try {
                    if ("se6x20ui_tree_pool_option".equals(cookies[i].getName())) {
                        form.setSelectedPoolOption(Convert.commaStringToArray((String)cookies[i].getValue()));
                    } else if ("se6x20ui_tree_vols_option".equals(cookies[i].getName())) {
                        form.setSelectedVolumeOption(Convert.commaStringToArray((String)cookies[i].getValue()));
                    } else if ("se6x20ui_tree_ini_option".equals(cookies[i].getName())) {
                        form.setSelectedIniOption(Convert.commaStringToArray((String)cookies[i].getValue()));
                    } else if ("se6x20ui_tree_inig_option".equals(cookies[i].getName())) {
                        Trace.verbose((Object)((Object)this), (String)"initForm", (String)("Options for initiator Group:" + cookies[i].getValue()));
                        form.setSelectedIniGrpOption(Convert.commaStringToArray((String)cookies[i].getValue()));
                    } else if ("se6x20ui_tree_vgs_option".equals(cookies[i].getName())) {
                        form.setSelectedVolumeGrpOption(Convert.commaStringToArray((String)cookies[i].getValue()));
                    }
                }
                catch (Exception e) {
                    Trace.verbose((Object)((Object)this), (String)"initForm", (Throwable)e);
                }
                form.setInitialized(true);
            }
        }
    }

    private void saveSettings(HttpServletRequest request, HttpServletResponse response, TreeForm form) throws ConfigMgmtException {
        Cookie poolC = new Cookie("se6x20ui_tree_pool_option", Convert.arrayToCommaString((String[])form.getSelectedPoolOption()));
        poolC.setMaxAge(63072000);
        response.addCookie(poolC);
        Cookie volsC = new Cookie("se6x20ui_tree_vols_option", Convert.arrayToCommaString((String[])form.getSelectedVolumeOption()));
        volsC.setMaxAge(63072000);
        response.addCookie(volsC);
        Cookie vgsC = new Cookie("se6x20ui_tree_vgs_option", Convert.arrayToCommaString((String[])form.getSelectedVolumeGrpOption()));
        vgsC.setMaxAge(63072000);
        response.addCookie(vgsC);
        Cookie inisC = new Cookie("se6x20ui_tree_ini_option", Convert.arrayToCommaString((String[])form.getSelectedIniOption()));
        inisC.setMaxAge(63072000);
        response.addCookie(inisC);
        Cookie inigC = new Cookie("se6x20ui_tree_inig_option", Convert.arrayToCommaString((String[])form.getSelectedIniGrpOption()));
        Trace.verbose((Object)((Object)this), (String)"saveSettings", (String)("IniG settings:" + Convert.arrayToCommaString((String[])form.getSelectedIniGrpOption())));
        inigC.setMaxAge(63072000);
        response.addCookie(inigC);
        this.loadLists(request, form);
    }

    private void clearListsFromSession(HttpServletRequest request) throws ConfigMgmtException {
        HttpSession session = request.getSession();
        List t4List = (List)session.getAttribute("_tree_arrays");
        session.removeAttribute("_tree_arrays");
        if (t4List != null) {
            for (int i = 0; i < t4List.size(); ++i) {
                T4Interface t4 = (T4Interface)t4List.get(i);
                session.removeAttribute("_tree_igs_" + t4.getName());
                session.removeAttribute("_tree_initiators_" + t4.getName());
                session.removeAttribute("_tree_pools_under_array_" + t4.getName());
                session.removeAttribute("_tree_trays_" + t4.getName());
                session.removeAttribute("_tree_volumes_" + t4.getName());
                session.removeAttribute("_tree_vgs_" + t4.getName());
            }
        }
    }

    private void loadLists(HttpServletRequest request, TreeForm form) throws ConfigMgmtException {
        Trace.verbose((Object)((Object)this), (String)"loadLists", (String)"LOAD ALL ARRAYS");
        List allArrays = this.loadArrays(request);
        ArrayList<ArrayLoadThread> arrayLoadThreads = new ArrayList<ArrayLoadThread>();
        int arraySize = allArrays.size();
        boolean loadedArrays = false;
        int runs = 0;
        while (runs * 75 < arraySize && arraySize > 0) {
            for (int i = runs * 75; i < 75 && i < arraySize; ++i) {
                ArrayLoadThread alt = new ArrayLoadThread((T4Interface)allArrays.get(i), request);
                alt.start();
                arrayLoadThreads.add(alt);
            }
            while (arrayLoadThreads.size() > 0) {
                ArrayLoadThread alt = (ArrayLoadThread)((Object)arrayLoadThreads.get(0));
                if (!alt.isComplete()) {
                    try {
                        alt.join(120000L);
                    }
                    catch (InterruptedException e) {
                        Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException((Exception)e));
                    }
                }
                arrayLoadThreads.remove(0);
            }
            ++runs;
        }
    }

    private List loadArrays(HttpServletRequest request) throws ConfigMgmtException {
        List allArrays = new ArrayList();
        T4s t4s = new T4s();
        ConfigContext configContext = (ConfigContext)request.getSession().getAttribute("ConfigContext");
        allArrays = t4s.list(configContext, null);
        request.setAttribute("_tree_arrays", allArrays);
        return allArrays;
    }

    protected boolean limitExecution() {
        return false;
    }
}

