/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Trays;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageMgmtCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.TrayForm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class TrayEditAction
extends StorageMgmtCoreAction {
    static final String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String methodName = "doAction";
        Trace.methodBegin((Object)((Object)this), (String)"doAction");
        String action = argAction == null ? "show" : argAction;
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("action = " + action));
        TrayForm form = (TrayForm)argForm;
        TrayInterface tray = this.getTrayInfo(argReq, form);
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("servlet path = " + argReq.getServletPath()));
        try {
            if ("show".equals(action) && "/root.menu.item0.item0trayedit.do".equals(path)) {
                Trace.verbose((Object)((Object)this), (String)"doAction", (String)"***TrayEditAction show action****");
                if (tray == null) {
                    if (!form.isInitialized()) {
                        UserMessages messages = new UserMessages();
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "tray.detail.error.cannotfind"));
                        this.saveUserMessages(argReq, messages);
                    }
                    return this.doForward(argReq, action, argMap);
                }
                BeanUtils.copyProperties((Object)((Object)form), (Object)tray);
                form.setAllDrivesHealthy(tray.areAllDisksHealthy());
                form.setState(tray.getState());
                form.setNumberOfArrayHotsparesOnTray(tray.getNumberOfDisksInRole("globalStandbyDisk"));
                if (form.getSubReportFilter() == 1) {
                    this.handlePoolListingForTray(argReq, tray);
                } else {
                    this.handleDiskListingForTray(argReq, tray);
                }
                form.setInitialized(true);
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"Exception in doAction", (Throwable)e);
            this.handleSystemError(argReq, e);
        }
        return this.doForward(argReq, action, argMap);
    }

    private void handleDiskListingForTray(HttpServletRequest request, TrayInterface tray) throws ConfigMgmtException {
        List diskList = tray.getDiskList();
        HttpSession session = request.getSession();
        if (diskList != null && !diskList.isEmpty()) {
            session.setAttribute("TrayDiskList", (Object)diskList);
        } else {
            session.removeAttribute("TrayDiskList");
        }
        request.setAttribute("diskTableTitle", (Object)"tray.detail.disk.header");
        request.setAttribute("diskTableTitleObject", (Object)tray.getId());
    }

    private void handlePoolListingForTray(HttpServletRequest request, TrayInterface tray) throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"handlePoolListing");
        HttpSession session = request.getSession();
        List poolList = tray.getRaidGroups();
        if (poolList != null && !poolList.isEmpty()) {
            Trace.verbose((Object)((Object)this), (String)"handlePoolListing", (String)("Got list of size:" + poolList.size()));
            session.setAttribute("PoolList", (Object)poolList);
        } else {
            Trace.verbose((Object)((Object)this), (String)"handlePoolListing", (String)"No pools found");
            session.removeAttribute("PoolList");
        }
        request.setAttribute("poolTableTitle", (Object)"tray.detail.pool.header");
        request.setAttribute("poolTableTitleObject", (Object)tray.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TrayInterface getTrayInfo(HttpServletRequest argReq, TrayForm form) {
        String methodName = "getTrayInfo";
        int trayIndex = -1;
        try {
            trayIndex = Integer.parseInt(argReq.getParameter("index"));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        HttpSession session = argReq.getSession();
        TrayInterface currentTrayInterface = null;
        T4Interface currentT4interface = null;
        String t4Name = argReq.getParameter("t4Name");
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("T4 Name for search results = " + t4Name));
        if (t4Name != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"We're in search mode!");
            try {
                T4s t4BusObj = (T4s)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.T4s");
                currentT4interface = t4BusObj.getArrayByName(this.getConfigContext(argReq), t4Name);
                if (currentT4interface != null) {
                    session.setAttribute("CurrentT4", (Object)currentT4interface);
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Got array from search mode = " + currentT4interface));
                    String trayId = argReq.getParameter("name");
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to look for tray id = " + trayId));
                    Trays trayBusObj = (Trays)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Trays");
                    return trayBusObj.getTrayByName(this.getConfigContext(argReq), currentT4interface, trayId);
                }
            }
            catch (Exception ex) {
                Trace.verbose((Object)((Object)this), (String)"Exception trying to get search results obj", (Throwable)ex);
                return null;
            }
        }
        if ((currentT4interface = (T4Interface)session.getAttribute("CurrentT4")) == null) return currentTrayInterface;
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Current T4 NAME (from session) = " + currentT4interface.getName()));
        ArrayList trayList = null;
        try {
            trayList = (ArrayList)currentT4interface.getTrays();
        }
        catch (ConfigMgmtException ce) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to get the tray list", (Throwable)ce);
        }
        if (trayList == null) return currentTrayInterface;
        if (trayIndex < 0) {
            if (form.getId() == null) return currentTrayInterface;
        }
        try {
            try {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Tray list size from T4 in session = " + trayList.size()));
                if (trayIndex >= 0) {
                    currentTrayInterface = (TrayInterface)trayList.get(trayIndex);
                } else {
                    currentTrayInterface = null;
                    for (int i = 0; i < trayList.size() && currentTrayInterface == null; ++i) {
                        if (!form.getId().equals(((TrayInterface)trayList.get(i)).getId())) continue;
                        currentTrayInterface = (TrayInterface)trayList.get(i);
                    }
                }
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("current tray id = " + currentTrayInterface.getId()));
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("current tray # drives = " + currentTrayInterface.getNumberOfDrives()));
            }
            catch (Exception e) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Can't find index of selected T4");
                Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(e));
                Object var13_18 = null;
                if (null != currentTrayInterface) return currentTrayInterface;
                ActionErrors ae = new ActionErrors();
                ae.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.t4.cannotfind"));
                this.saveErrors(argReq, ae);
                return currentTrayInterface;
            }
            Object var13_17 = null;
            if (null != currentTrayInterface) return currentTrayInterface;
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            if (null != currentTrayInterface) throw throwable;
            ActionErrors ae = new ActionErrors();
            ae.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.t4.cannotfind"));
            this.saveErrors(argReq, ae);
            throw throwable;
        }
        ActionErrors ae = new ActionErrors();
        ae.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.t4.cannotfind"));
        this.saveErrors(argReq, ae);
        return currentTrayInterface;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getBreadCrumbName";
        HttpSession session = argReq.getSession();
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("servlet path = " + argReq.getServletPath()));
        if ("/root.menu.item0.item0trayvolumes.do".equals(path)) {
            return "storage.mgmt.volumes.volumes";
        }
        return "storage.mgmt.system.tray.details.section";
    }
}

