/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.FiberChannelPortInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfiles;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.AffectedPool;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageMgmtCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.ActiveUserInfo;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.T4Form;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SystemAction
extends StorageMgmtCoreAction {
    static final String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String methodName = "doAction";
        Trace.constructor((Object)((Object)this));
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        String action = argAction == null ? "show" : argAction;
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
        HttpSession session = argReq.getSession();
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("session is:" + session));
        T4s t4s = null;
        StoragePools poolBusObj = null;
        try {
            T4Form form = (T4Form)argForm;
            if (poolBusObj == null) {
                poolBusObj = (StoragePools)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools");
            }
            if ("/root.menu.item0.item1.do".equals(path)) {
                if (null == t4s) {
                    t4s = (T4s)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.T4s");
                }
                if ("refresh".equals(action)) {
                    this.handleRefreshAction(argReq, argForm);
                } else {
                    try {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Trying to get config type...");
                        Repository repository = Repository.getRepository();
                        int configType = repository.getConfigInteger();
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Config type = " + configType));
                        ((T4Form)argForm).setConfigType(configType);
                    }
                    catch (Exception ex) {
                        Trace.verbose((Object)((Object)this), (String)"Exception trying to get config type", (Throwable)ex);
                    }
                    if (this.listRequiresRefresh(argReq, "T4List")) {
                        List t4List = this.generateT4List(argForm, argReq, t4s);
                    } else {
                        this.setListContext(argReq, "T4List", null);
                    }
                }
            }
            T4Interface currentT4interface = this.checkT4(argReq);
            if ("/root.menu.item0.item1fcconfig.do".equals(path)) {
                if ("save".equals(action)) {
                    this.saveFC(argReq, form, this.checkT4(argReq));
                } else {
                    FiberChannelPortInterface fc = currentT4interface.getFiberChannelPort();
                    if (fc != null) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Have fiber channel port");
                        form.setPreferredSpeed(fc.getPreferredSpeed());
                        form.setTopology(fc.getTopology());
                    }
                }
            } else if ("/root.menu.item0.item1express.do".equals(path)) {
                int oldBlockSize = currentT4interface.getBlockSize();
                int oldReadahead = currentT4interface.getReadaheadMode();
                if (null == t4s) {
                    t4s = (T4s)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.T4s");
                }
                if ("show".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"***show action for the express config page ****");
                    action = this.handlePasswordPrompt(action, argForm, argReq);
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Action after handle pass = " + action));
                    if ("prompt_password".equals(action)) {
                        return this.doForward(argReq, action, argMap);
                    }
                    this.handleCustomShow(form, currentT4interface);
                    this.refreshSubReports(argReq, form, currentT4interface);
                } else if ("save".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"SAVE ACTION!!!");
                    if (form.getFormType() == 0) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Saving LESS array properties");
                        this.handleSaveAction(argReq, form, t4s, currentT4interface);
                    } else if (form.getFormType() == 1) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Saving MORE array properties");
                        action = this.handleCustomSave(argReq, action, t4s, form, currentT4interface, currentT4interface.getBlockSize());
                    }
                } else if ("more_for_custom".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Trying to get MORE array properties");
                    form.setFormType(1);
                } else if ("less_for_express".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Trying to get LESS array properties");
                    form.setFormType(0);
                } else if ("confirm_save".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)">>>>>>>>>>>>>>>call handleConfirmSave");
                    action = this.handleConfirmedSave(argReq, t4s, form, currentT4interface, oldBlockSize, oldReadahead);
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)">>>>>>>>>>>handleConfirmSave returned, check jobs");
                    if (action == null) {
                        action = "show";
                    }
                    if (this.hasJobs(session)) {
                        action = "jobs_notification";
                    }
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)(">>>>>>>>>>>Final action:" + action));
                }
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"Exception in doAction", (Throwable)e);
            this.handleSystemError(argReq, e);
        }
        return this.doForward(argReq, action, argMap);
    }

    private void refreshSubReports(HttpServletRequest argReq, T4Form form, T4Interface currentT4interface) throws Exception {
        String methodName = "refreshSubReports";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        int subReportFilter = form.getSubReportFilter();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Sub report filter = " + subReportFilter));
        switch (subReportFilter) {
            case 0: {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Showing pools subreport");
                this.handlePoolListing(argReq);
                break;
            }
            case 1: {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Showing volumes subreport");
                this.handleVolumesListing(argReq, currentT4interface);
                break;
            }
            default: {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Showing trays subreport");
                if (currentT4interface == null) break;
                form.setTrays(currentT4interface.getTrays());
            }
        }
    }

    private void handleCustomShow(T4Form form, T4Interface currentT4interface) throws ConfigMgmtException {
        String METHOD_NAME = "handleCustomShow";
        Trace.methodBegin((Object)((Object)this), (String)"handleCustomShow");
        form.setBlockSize(currentT4interface.getBlockSize());
        form.setReadaheadMode(currentT4interface.getReadaheadMode());
        form.setDiskReconRate(currentT4interface.getDiskReconRate());
        form.setFailoverMode(currentT4interface.getFailoverMode());
        form.setCacheMode(currentT4interface.getCacheMode());
        form.setDescription(currentT4interface.getDescription());
        form.setName(currentT4interface.getName());
        if (currentT4interface.isFeatureSupported(3)) {
            form.setArrayHotSparePoolSize(currentT4interface.getAhsPoolSize());
        }
        if (currentT4interface.isFeatureSupported(1)) {
            form.setDiskScrubbing(currentT4interface.isDiskScrubbing() ? "enabled" : "disabled");
        }
    }

    protected List generateT4List(ActionForm argForm, HttpServletRequest argReq, T4s t4s) throws ConfigMgmtException {
        String methodName = "generateT4List";
        HttpSession session = argReq.getSession();
        List t4List = t4s.list(this.getConfigContext(argReq), null);
        if (t4List != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("\n array list size = " + t4List.size()));
            ArrayList healthList = new ArrayList();
            boolean allUnhealthy = t4s.areAllArraysUnhealthy(t4List, healthList);
            ((T4Form)argForm).setAllUnhealthy(allUnhealthy);
            session.setAttribute("HealthStatusList", healthList);
            session.setAttribute("T4List", (Object)t4List);
            this.setListContext(argReq, "T4List", t4List);
            T4Interface currentT4 = (T4Interface)session.getAttribute("CurrentT4");
            if ((currentT4 == null || currentT4.getHealthStatus() != 2) && t4List != null && t4List.size() > 0) {
                int healthyIdx = t4s.getFirstHealthyArrayIndex(t4List);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"setting the default T4");
                if (healthyIdx != -1) {
                    session.setAttribute("CurrentT4", t4List.get(healthyIdx));
                }
            }
        }
        return t4List;
    }

    private void handleRefreshAction(HttpServletRequest argReq, ActionForm argForm) throws Exception {
        String methodName = "handleRefreshAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        HttpSession session = argReq.getSession();
        T4s t4s = new T4s();
        session.removeAttribute("com.sun.netstorage.array.mgmt.cfg.ui.business.T4s");
        session.setAttribute("com.sun.netstorage.array.mgmt.cfg.ui.business.T4s", (Object)t4s);
        List allArrays = this.generateT4List(argForm, argReq, t4s);
        ActiveUserInfo aui = (ActiveUserInfo)session.getAttribute("UserInfo");
        if (aui != null && !"guest".equals(aui.role)) {
            t4s.refreshArrays(this.getConfigContext(argReq), allArrays);
            T4Interface currentT4 = (T4Interface)session.getAttribute("CurrentT4");
            if (currentT4 != null) {
                session.removeAttribute("CurrentT4");
                String name = currentT4.getName();
                int ind = t4s.indexFromName(name, allArrays);
                currentT4 = (T4Interface)allArrays.get(ind);
                if (currentT4.getHealthStatus() == 2) {
                    session.setAttribute("CurrentT4", (Object)currentT4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleSaveAction(HttpServletRequest argReq, T4Form form, T4s t4s, T4Interface currentT4interface) {
        block25: {
            List mcs;
            String methodName = "handleSaveAction";
            Trace.methodBegin((Object)((Object)this), (String)methodName);
            int oldBlockSize = currentT4interface.getBlockSize();
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Old Block Size = " + oldBlockSize));
            currentT4interface.setDescription(form.getDescription());
            if (currentT4interface.isFeatureSupported(3)) {
                int hotspareSize = form.getArrayHotSparePoolSize();
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("hot spare pool size to save from form  = " + hotspareSize));
                currentT4interface.setAhsPoolSize(hotspareSize);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("hot spare pool size after setting in t4 = " + currentT4interface.getAhsPoolSize()));
            }
            if (form.getFormType() == 1) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"set additional properties for a custom save");
                currentT4interface.setBlockSize(form.getBlockSize());
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Block size in FORM = " + form.getBlockSize()));
                currentT4interface.setReadaheadMode(form.getReadaheadMode());
                currentT4interface.setDiskReconRate(form.getDiskReconRate());
                currentT4interface.setFailoverMode(form.getFailoverMode());
                currentT4interface.setCacheMode(form.getCacheMode());
                if (currentT4interface.isFeatureSupported(1)) {
                    currentT4interface.setDiskScrubbing("enabled".equals(form.getDiskScrubbing()));
                }
            }
            if ((mcs = t4s.save(oldBlockSize, currentT4interface)) != null) {
                this.storeMethodCallStatuses(argReq, mcs);
            }
            this.setConfirmationMessage(argReq, "storage.mgmt.system.confirmmsg");
            Object var9_15 = null;
            try {
                this.resetArray(argReq, currentT4interface);
                this.refreshSubReports(argReq, form, currentT4interface);
                this.handleCustomShow(form, currentT4interface);
            }
            catch (ConfigMgmtException e) {
                this.handleCme(argReq, e);
            }
            catch (Exception e) {
                Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(e));
                this.saveSingleUserMessage(argReq, 0, "storage.mgmt.system.error.save");
            }
            break block25;
            {
                catch (BadParameterException bpe) {
                    UserMessages messages = new UserMessages();
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, bpe.getMessage(), bpe.getBadParameter()));
                    this.saveUserMessages(argReq, messages);
                    Object var9_16 = null;
                    try {
                        this.resetArray(argReq, currentT4interface);
                        this.refreshSubReports(argReq, form, currentT4interface);
                        this.handleCustomShow(form, currentT4interface);
                    }
                    catch (ConfigMgmtException e) {
                        this.handleCme(argReq, e);
                    }
                    catch (Exception e) {
                        Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(e));
                        this.saveSingleUserMessage(argReq, 0, "storage.mgmt.system.error.save");
                    }
                    break block25;
                }
                catch (ConfigMgmtException cme) {
                    try {
                        currentT4interface.reload();
                    }
                    catch (ConfigMgmtException e) {
                        // empty catch block
                    }
                    this.handleCme(argReq, cme);
                    Object var9_17 = null;
                    try {
                        this.resetArray(argReq, currentT4interface);
                        this.refreshSubReports(argReq, form, currentT4interface);
                        this.handleCustomShow(form, currentT4interface);
                    }
                    catch (ConfigMgmtException e) {
                        this.handleCme(argReq, e);
                    }
                    catch (Exception e) {
                        Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(e));
                        this.saveSingleUserMessage(argReq, 0, "storage.mgmt.system.error.save");
                    }
                    break block25;
                }
                catch (Exception ex) {
                    try {
                        currentT4interface.reload();
                    }
                    catch (ConfigMgmtException e) {
                        // empty catch block
                    }
                    Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(ex));
                    this.saveSingleUserMessage(argReq, 0, "storage.mgmt.system.error.save");
                    Object var9_18 = null;
                    try {
                        this.resetArray(argReq, currentT4interface);
                        this.refreshSubReports(argReq, form, currentT4interface);
                        this.handleCustomShow(form, currentT4interface);
                    }
                    catch (ConfigMgmtException e) {
                        this.handleCme(argReq, e);
                    }
                    catch (Exception e) {
                        Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(e));
                        this.saveSingleUserMessage(argReq, 0, "storage.mgmt.system.error.save");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_19 = null;
                try {
                    this.resetArray(argReq, currentT4interface);
                    this.refreshSubReports(argReq, form, currentT4interface);
                    this.handleCustomShow(form, currentT4interface);
                }
                catch (ConfigMgmtException e) {
                    this.handleCme(argReq, e);
                }
                catch (Exception e) {
                    Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(e));
                    this.saveSingleUserMessage(argReq, 0, "storage.mgmt.system.error.save");
                }
                throw throwable;
            }
        }
    }

    private void handleCme(HttpServletRequest argReq, ConfigMgmtException cme) {
        Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
        String key = "storage.mgmt.system.error.save";
        if (cme.getExceptionKey() != null && !cme.getExceptionKey().trim().equals("")) {
            key = cme.getExceptionKey();
        }
        this.saveSingleUserMessage(argReq, 0, key);
    }

    protected String handleCustomSave(HttpServletRequest argReq, String action, T4s t4BusObj, T4Form form, T4Interface currentT4interface, int oldBlockSize) throws ConfigMgmtException {
        String methodName = "handleCustomSave";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        boolean isArrayDiskScrubbing = "enabled".equals(form.getDiskScrubbing());
        if (currentT4interface.isFeatureSupported(1)) {
            form.setDiskScrubbingChanging(currentT4interface.isDiskScrubbing() && !isArrayDiskScrubbing || !currentT4interface.isDiskScrubbing() && isArrayDiskScrubbing);
        }
        form.setDestructiveSave(t4BusObj.isDestructiveSave(currentT4interface.getBlockSize(), form.getBlockSize()));
        form.setReadAheadChanging(t4BusObj.isReadaheadChange(currentT4interface.getReadaheadMode(), form.getReadaheadMode()));
        if (form.getDestructiveSave() || form.isReadAheadChanging()) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"This is a DESTRUCTIVE or READAHEAD save; get impact");
            this.handleImpact(argReq, form, currentT4interface, t4BusObj);
            action = "confirm";
        } else if (form.isDiskScrubbingChanging() && !isArrayDiskScrubbing) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Disk scrubbing IS CHANGING go to confirm page");
            action = "confirm";
        } else {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"This is NOT destructive; just save array settings");
            this.handleConfirmedSave(argReq, t4BusObj, form, currentT4interface, oldBlockSize, currentT4interface.getReadaheadMode());
        }
        return action;
    }

    private void handleImpact(HttpServletRequest argReq, T4Form form, T4Interface currentT4interface, T4s t4BusObj) throws ConfigMgmtException {
        String methodName = "handleImpact";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        List affectedPools = null;
        ArrayList<AffectedPool> affectedPoolObjects = new ArrayList<AffectedPool>();
        affectedPools = currentT4interface.getRaidGroups();
        if (affectedPools != null && !affectedPools.isEmpty()) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"We have affected pools");
            Iterator it = affectedPools.iterator();
            while (it.hasNext()) {
                RaidGroupInterface pool = (RaidGroupInterface)it.next();
                AffectedPool af = new AffectedPool();
                try {
                    StorageProfile currentProfile = ManageStorageProfiles.getInstance().getProfile(pool.getProfileName());
                    af.setAffectedPool(pool);
                    List matchingProfiles = ManageStorageProfiles.getInstance().getMatchingProfilesForReadaheadChange(currentProfile, currentT4interface);
                    if (matchingProfiles == null || matchingProfiles.isEmpty()) {
                        af.setMatchingProfiles(null);
                    } else {
                        af.setMatchingProfiles(matchingProfiles);
                    }
                }
                catch (ItemNotFoundException infe) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"An error occured trying to get the list of matching profiles; just display 'None'");
                }
                affectedPoolObjects.add(af);
            }
            form.setAffectedPoolObjects(affectedPoolObjects);
        } else {
            form.setAffectedPoolObjects(null);
        }
        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Got pools, get volumes");
        List affectedVolumes = t4BusObj.getVolumesOnT4(currentT4interface);
        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Got volumes");
        form.setAffectedPools(affectedPools);
        form.setAffectedVolumes(affectedVolumes);
        if (affectedVolumes == null || affectedVolumes.isEmpty()) {
            argReq.getSession().removeAttribute("affectedVolsDestructiveSave");
        } else {
            this.setListContext(argReq, "affectedVolsDestructiveSave", affectedVolumes);
        }
    }

    protected String handleConfirmedSave(HttpServletRequest argReq, T4s t4BusObj, T4Form form, T4Interface currentT4interface, int oldBlockSize, int oldReadahead) throws ConfigMgmtException {
        String METHOD_NAME = "handleConfirmedSave";
        Trace.methodBegin((Object)((Object)this), (String)"handleConfirmedSave");
        UserMessages messages = new UserMessages();
        boolean isReadaheadChange = t4BusObj.isReadaheadChange(currentT4interface.getReadaheadMode(), form.getReadaheadMode());
        String action = null;
        if (isReadaheadChange) {
            Trace.verbose((Object)((Object)this), (String)"handleConfirmedSave", (String)"Peform pre processing to get ready for changing pool profiles");
            try {
                action = this.validateInputsForChangingProfile(argReq, form, currentT4interface);
                if (action != null) {
                    return action;
                }
            }
            catch (Exception ex) {
                Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(ex));
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.system.changereadahead.error"));
                this.saveUserMessages(argReq, messages);
                Trace.verbose((Object)((Object)this), (String)"handleConfirmedSave", (String)"An error occured trying to get the new profiles; return with no save");
                return action;
            }
        }
        this.handleSaveAction(argReq, form, t4BusObj, currentT4interface);
        if (isReadaheadChange) {
            Trace.verbose((Object)((Object)this), (String)"handleConfirmedSave", (String)"after save: Trying to change all the profiles for impacted pools");
            try {
                this.handleChangingProfile(form);
                this.refreshSubReports(argReq, form, currentT4interface);
            }
            catch (Exception ex) {
                Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(ex));
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.system.changeprofile.error"));
                this.saveUserMessages(argReq, messages);
            }
        }
        return action;
    }

    private void handleVolumesListing(HttpServletRequest argReq, T4Interface currentT4interface) throws Exception {
        String methodName = "handleVolumesListing";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        Volumes volBusObj = (Volumes)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes");
        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Getting NEW Volume list!");
        List volumeList = volBusObj.listByArray(this.getConfigContext(argReq), currentT4interface);
        if (volumeList != null && !volumeList.isEmpty()) {
            this.setListContext(argReq, "VolumeList", volumeList);
        } else {
            argReq.getSession().removeAttribute("VolumeList");
        }
    }

    private String validateInputsForChangingProfile(HttpServletRequest argReq, T4Form form, T4Interface currentT4) throws Exception {
        String methodName = "validateInputsForChangingProfile";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        String action = null;
        List affectedPoolObjs = form.getAffectedPoolObjects();
        UserMessages messages = new UserMessages();
        HashMap duplicates = new HashMap();
        Profiles profilesBusObj = (Profiles)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles");
        Enumeration e = argReq.getParameterNames();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            if (str.indexOf("newProfileName") == -1) continue;
            String value = argReq.getParameter(str);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("***** NEW PROFILE NAME VALUE = " + value));
            String profileNameIndexStr = str.substring(str.length() - 1);
            int profileNameIdx = Integer.parseInt(profileNameIndexStr);
            AffectedPool apo = (AffectedPool)affectedPoolObjs.get(profileNameIdx);
            RaidGroupInterface pool = apo.getAffectedPool();
            try {
                StorageProfile newProfile;
                block11: {
                    if (value == null || "".equals(value)) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"NO profile name given!");
                        throw new BadParameterException("", "storage.mgmt.system.changeprofile.noname");
                    }
                    if (duplicates.get(value) == null) {
                        Vector<AffectedPool> poolsWithSame = new Vector<AffectedPool>();
                        poolsWithSame.add(apo);
                        duplicates.put(value, poolsWithSame);
                    } else {
                        Vector v = (Vector)duplicates.get(value);
                        v.add(apo);
                    }
                    newProfile = null;
                    try {
                        newProfile = profilesBusObj.getOrCreateMatchingProfile(this.getConfigContext(argReq), pool.getProfileName(), value, currentT4);
                    }
                    catch (ConfigMgmtException cme) {
                        if (!cme.getExceptionKey().equals("error.objectAlreadyExists")) break block11;
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.profile.create.error.exists"));
                        this.saveUserMessages(argReq, messages);
                        action = "confirm";
                        return action;
                    }
                }
                apo.setNewProfile(newProfile);
                if (!Trace.isTraceEnabled((Object)((Object)this)) || pool == null || newProfile == null) continue;
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to change pool (" + pool.getName() + ") to profile (" + newProfile.getName() + ")"));
            }
            catch (BadParameterException bpe) {
                Trace.verbose((Object)((Object)this), (String)"Error trying to get or create match profile", (Throwable)bpe);
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, bpe.getMessage(), bpe.getBadParameter()));
                this.saveUserMessages(argReq, messages);
                action = "confirm";
                return action;
            }
        }
        try {
            this.checkForIdenticalProfileNames(duplicates);
        }
        catch (Exception ex) {
            Trace.verbose((Object)((Object)this), (String)"Error checking for identical profile names", (Throwable)ex);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.system.changeprofile.identicalnames"));
        }
        if (!messages.empty()) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Forward to confirm action");
            this.saveUserMessages(argReq, messages);
            action = "confirm";
        }
        return action;
    }

    private void checkForIdenticalProfileNames(HashMap duplicates) throws Exception {
        String methodName = "checkForIdenticalProfileNames";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        Collection duplicateVectors = duplicates.values();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Number of profile names with duplicates = " + duplicateVectors.size()));
        Iterator it = duplicateVectors.iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Number of pools with same profile name = " + v.size()));
            if (v == null || v.size() <= 1) continue;
            AffectedPool firstPool = (AffectedPool)v.get(0);
            RaidGroupInterface pool1 = firstPool.getAffectedPool();
            boolean pool1HS = pool1.getUseHotSpare() == 1;
            for (int j = 1; j < v.size(); ++j) {
                boolean poolHS;
                AffectedPool ap = (AffectedPool)v.get(j);
                RaidGroupInterface pool = ap.getAffectedPool();
                boolean bl = poolHS = pool.getUseHotSpare() == 1;
                if (Trace.isTraceEnabled((Object)((Object)this))) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("/n**** POOL ONE's raid level: " + pool1.getRaidLevel()));
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("/n**** POOL TWO's raid level: " + pool.getRaidLevel()));
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("/n**** POOL ONE's USE HS: " + pool1HS));
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("/n**** POOL TWO's USE HS: " + poolHS));
                }
                if (pool1.getRaidLevel() != pool.getRaidLevel() || (pool1HS || poolHS) && (!pool1HS || !poolHS)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Pools with same profile name are not valid");
                    throw new BadParameterException(firstPool.getNewProfile().getName(), "ACTION_NOT_SUPPORTED");
                }
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Found pools with same profile name, but they have  the same raid level and HS usage; so they are ok");
            }
        }
    }

    private void handleChangingProfile(T4Form form) throws ConfigMgmtException {
        String methodName = "handleChangingProfile";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        if (form.getAffectedPoolObjects() != null) {
            Iterator it = form.getAffectedPoolObjects().iterator();
            while (it.hasNext()) {
                AffectedPool ap = (AffectedPool)it.next();
                RaidGroupInterface pool = ap.getAffectedPool();
                pool.reload();
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("APPLYING NEW PROFILE for pool (" + pool.getName() + ") to profile (" + ap.getNewProfile().getName() + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFC(HttpServletRequest argReq, T4Form form, T4Interface currentT4interface) throws ConfigMgmtException {
        String METHOD_NAME = "saveFC";
        Trace.methodBegin((Object)((Object)this), (String)"saveFC");
        FiberChannelPortInterface fc = currentT4interface.getFiberChannelPort();
        try {
            Trace.verbose((Object)((Object)this), (String)"saveFC", (String)"Saving fiber channel port props...");
            Trace.verbose((Object)((Object)this), (String)"saveFC", (String)("speed = " + form.getPreferredSpeed()));
            Trace.verbose((Object)((Object)this), (String)"saveFC", (String)("topology = " + form.getTopology()));
            fc.setPreferredSpeed(form.getPreferredSpeed());
            fc.setTopology(form.getTopology());
            fc.save();
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.system.confirmmsg"));
            this.saveUserMessages(argReq, messages);
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext((Object)"SAVE FIBER CHANNEL");
            cme.addExceptionContext((Object)("NEW SPEED:" + form.getPreferredSpeed()));
            cme.addExceptionContext((Object)("NEW TOPOLOGY:" + form.getTopology()));
            cme.addExceptionContext((Object)("ARRAY:" + currentT4interface));
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.system.error.save"));
            this.saveUserMessages(argReq, messages);
        }
        finally {
            fc.reload();
        }
    }

    protected T4Interface checkT4(HttpServletRequest argReq) {
        String METHOD_NAME = "checkT4";
        T4Interface currentT4interface = this.getSelectedT4(argReq);
        if (currentT4interface != null) {
            Trace.verbose((Object)((Object)this), (String)"checkT4", (String)("Got selected T4 = " + currentT4interface.getName()));
        } else {
            Trace.verbose((Object)((Object)this), (String)"checkT4", (String)"Couldn't get T4 from request try from session!");
            currentT4interface = this.getCurrentT4(argReq);
        }
        return currentT4interface;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String path = argReq.getServletPath();
        String methodName = "getBreadCrumbName";
        String action = (String)argReq.getAttribute("action");
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("action as request attribute :" + action));
        if (action == null || action.length() == 0) {
            action = argReq.getParameter("request_action");
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Action as request_action:" + action));
            if (null == action || action.length() == 0) {
                action = argReq.getParameter("action");
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Action as action:" + action));
            }
        }
        if (null == action) {
            action = "show";
        }
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("servlet path = " + argReq.getServletPath()));
        if ("confirm".equals(action)) {
            return "storage.mgmt.system.expert.confirm";
        }
        if ("/root.menu.item0.item1fcconfig.do".equals(path)) {
            return "storage.mgmt.fc.title";
        }
        if ("/root.menu.item0.item1express.do".equals(path)) {
            return "storage.mgmt.system.configure";
        }
        return "storage.mgmt.system.individual.crumb";
    }
}

