/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageMgmtCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.PoolInitializationException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.PoolForm;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class StoragePoolsAction
extends StorageMgmtCoreAction {
    private static final String MENU_SUB_ITEM = ".item0";

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        HttpSession session = argReq.getSession();
        String action = argAction == null ? "show" : argAction;
        String methodName = "doAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        StoragePools poolBusObj = null;
        String path = argReq.getServletPath();
        try {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
            if (poolBusObj == null) {
                poolBusObj = (StoragePools)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools");
            }
            if ("/root.menu.item0.item2poolsinit.do".equals(path)) {
                if ("show".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"INITIALIZE confirmation page");
                    action = this.handlePreInitializeAction(argForm, argReq, action, poolBusObj);
                } else if ("confirm_init".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"INITIALIZE confirmed");
                    this.handleInitializeAction(argForm, argReq, poolBusObj);
                    action = ((PoolForm)argForm).getComingFrom();
                }
            } else if ("/root.menu.item0.item2pooldetails.do".equals(path)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Pool Details Action");
                List allPools = (List)argReq.getSession().getAttribute("PoolList");
                if (allPools == null || argReq.getParameter("t4Name") != null) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"We might not have the full list of pools yet");
                    this.handleShowAction(argForm, argReq, action, poolBusObj);
                    allPools = (List)argReq.getSession().getAttribute("PoolList");
                }
                String detailedPoolName = argReq.getParameter("name");
                RaidGroupInterface detailedPool = null;
                if (detailedPoolName == null) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"No pool name in the request, show pool from form");
                    detailedPool = ((PoolForm)argForm).getDetailedPool();
                    detailedPoolName = detailedPool.getName();
                } else {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Have a pool name in the request");
                    detailedPool = poolBusObj.findPool(detailedPoolName, allPools);
                    ((PoolForm)argForm).setDetailedPool(detailedPool);
                }
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Pool to show details of = " + detailedPool.getName()));
                detailedPool.reload();
                argReq.setAttribute("poolsVolumeList", (Object)"PoolVolumeList");
                argReq.setAttribute("detailedPoolName", (Object)detailedPoolName);
                if (this.listRequiresRefresh(argReq, "PoolVolumeList")) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Getting new list of volumes for pool");
                    List volsForPool = detailedPool.getVolumes();
                    if (volsForPool == null || volsForPool.isEmpty()) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"No volume found for this pool; remove list in session");
                        argReq.getSession().removeAttribute("PoolVolumeList");
                    } else {
                        this.setListContext(argReq, "PoolVolumeList", volsForPool);
                    }
                } else {
                    this.setListContext(argReq, "PoolVolumeList", null);
                }
            } else if ("show".equals(action) || "start".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"SHOW ACTION");
                this.handleShowAction(argForm, argReq, action, poolBusObj);
            } else if ("online".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"ONLINE Action");
                action = this.handleOnlineAction(argForm, argReq, poolBusObj, action);
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"General Exception in doAction", (Throwable)e);
            this.handleSystemError(argReq, e);
        }
        return this.doForward(argReq, action, argMap);
    }

    protected void handleShowAction(ActionForm argForm, HttpServletRequest argReq, String action, StoragePools poolBusObj) throws CoreUIBusException, ConfigMgmtException {
        this.handlePoolListing(argReq);
    }

    private String handleOnlineAction(ActionForm argForm, HttpServletRequest argReq, StoragePools poolBusObj, String action) throws CoreUIBusException, ConfigMgmtException {
        String methodName = "handleOnlineAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        List selectedPools = this.getSelectedPools(argReq, argForm);
        action = ((PoolForm)argForm).getComingFrom();
        if (this.havePoolSelections(argForm, argReq, "storage.mgmt.system.expert.pools.online.error")) {
            String[] args = new String[1];
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Tyring to place " + selectedPools.size() + " selected pools online"));
            try {
                for (int i = 0; i < selectedPools.size(); ++i) {
                    RaidGroupInterface pool = (RaidGroupInterface)selectedPools.get(i);
                    args[0] = pool.getName();
                    poolBusObj.changeStatus(pool, "online");
                    LogAPI.staticLog((String)"POOL_ONLINE", (String[])args, (String[])new String[0]);
                }
                this.setConfirmationMessage(argReq, "storage.mgmt.system.expert.pools.online.confirm");
            }
            catch (ConfigMgmtException cme) {
                Trace.verbose((Object)((Object)this), (String)"ConfigMgmtException trying to change pool online", (Throwable)cme);
                cme.addExceptionContext((Object)argForm);
                Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
                this.handleSystemError(argReq, cme);
            }
            catch (Exception ex) {
                Trace.verbose((Object)((Object)this), (String)"General Exception trying to change pool online", (Throwable)ex);
                this.handleSystemError(argReq, ex);
            }
        }
        return action;
    }

    private String handlePreInitializeAction(ActionForm argForm, HttpServletRequest argReq, String action, StoragePools poolBusObj) throws CoreUIBusException, ConfigMgmtException {
        String methodName = "handlePreInitializeAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        List selectedPools = this.getSelectedPools(argReq, argForm);
        if (!this.havePoolSelections(argForm, argReq, "storage.mgmt.system.expert.pools.init.error")) {
            action = ((PoolForm)argForm).getComingFrom();
        } else {
            List onlines = null;
            try {
                onlines = poolBusObj.getOnlinePoolNames(selectedPools);
            }
            catch (Exception e) {
                Trace.verbose((Object)((Object)this), (String)"Unable to get online pool names", (Throwable)e);
            }
            if (onlines.isEmpty()) {
                ((PoolForm)argForm).setOnlinePoolNames(null);
            } else {
                ((PoolForm)argForm).setOnlinePoolNames(onlines);
            }
            ((PoolForm)argForm).setSelectedPools(selectedPools);
            this.setAffectedVolumes(argReq, selectedPools, argForm);
        }
        return action;
    }

    private void handleInitializeAction(ActionForm argForm, HttpServletRequest argReq, StoragePools poolBusObj) throws PoolInitializationException {
        block9: {
            String methodName = "handleInitializeAction";
            Trace.methodBegin((Object)((Object)this), (String)methodName);
            try {
                List returnStatuses = new ArrayList();
                List onlinePoolsNames = ((PoolForm)argForm).getOnlinePoolNames();
                List<RaidGroupInterface> onlyOfflinePools = new ArrayList();
                List selectedPools = ((PoolForm)argForm).getSelectedPools();
                if (selectedPools == null) break block9;
                if (onlinePoolsNames != null) {
                    Iterator poolsIterator = selectedPools.iterator();
                    while (poolsIterator.hasNext()) {
                        RaidGroupInterface pool = (RaidGroupInterface)poolsIterator.next();
                        if (onlinePoolsNames.contains(pool.getName())) continue;
                        onlyOfflinePools.add(pool);
                    }
                } else {
                    onlyOfflinePools = selectedPools;
                }
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Tyring to initialize " + onlyOfflinePools.size() + " selected pools"));
                if (onlyOfflinePools.size() > 0) {
                    block10: {
                        try {
                            returnStatuses = poolBusObj.initializePools(this.getCurrentT4(argReq), onlyOfflinePools);
                        }
                        catch (PoolInitializationException pie) {
                            List errors = pie.getFailedPools();
                            if (errors == null || errors.isEmpty()) break block10;
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Got pool init exception with failed pools in list");
                            this.saveSingleUserMessage(argReq, 0, "storage.mgmt.system.expert.pools.initaction.error");
                        }
                    }
                    if (poolBusObj.hasErrorsInMethodCallStatuses(returnStatuses)) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Found errors in method call statuses for initialization");
                        throw new Exception("initialize pool exception.");
                    }
                    this.storeMethodCallStatuses(argReq, returnStatuses);
                    this.setConfirmationMessage(argReq, "storage.mgmt.system.expert.pools.init.confirm");
                    break block9;
                }
                this.saveSingleUserMessage(argReq, 1, "storage.mgmt.system.expert.pools.init.confirm.none");
            }
            catch (Exception e) {
                Trace.verbose((Object)((Object)this), (String)"Exception trying to initialize pools", (Throwable)e);
                this.saveSingleUserMessage(argReq, 0, "storage.mgmt.system.expert.pools.initaction.error");
            }
        }
    }

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)("PATH in bread crumb = " + path));
        if (path != null) {
            if ("/root.menu.item0.item2pools.do".equals(path)) {
                return "storage.mgmt.system.expert.pools";
            }
            if ("/root.menu.item0.item2poolsinit.do".equals(path)) {
                return "storage.mgmt.system.expert.pools.init.header";
            }
            if ("/root.menu.item0.item2pooldetails.do".equals(path)) {
                return "pool.details.crumb";
            }
        }
        return "storage.mgmt.system.expert.pools";
    }

    protected List getSelectedPools(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getSelectedPools";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ArrayList selectedPools = new ArrayList();
        try {
            List allPools = (List)argReq.getSession().getAttribute("PoolList");
            if (allPools == null || argReq.getParameter("t4Name") != null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"No pool in form or direct access; trying to get pools list from backend");
                this.handlePoolListing(argReq);
                allPools = (List)argReq.getSession().getAttribute("PoolList");
            }
            if (argReq.getParameter("t4Name") == null) {
                this.findPoolsFromSelections(argReq, selectedPools, allPools);
            } else {
                this.findPoolFromName(argReq, selectedPools, allPools);
            }
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (String)"getSelectedPools", (String)ex.toString());
            Trace.verbose((Object)((Object)this), (String)"Exception trying to get the selected pools", (Throwable)ex);
        }
        return selectedPools;
    }

    private void findPoolFromName(HttpServletRequest argReq, List selectedPools, List allPools) {
        boolean foundPool = false;
        String poolName = argReq.getParameter("name");
        for (int i = 0; i < allPools.size() && !foundPool; ++i) {
            if (!((RaidGroupInterface)allPools.get(i)).getName().equals(poolName)) continue;
            foundPool = true;
            selectedPools.add(allPools.get(i));
        }
    }

    private void findPoolsFromSelections(HttpServletRequest argReq, List selectedPools, List allPools) {
        String methodName = "findPoolsFromSelections";
        Enumeration e = argReq.getParameterNames();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            Trace.verbose((Object)((Object)this), (String)"findPoolsFromSelections", (String)("\nparameter name = " + str));
            Trace.verbose((Object)((Object)this), (String)"findPoolsFromSelections", (String)("parameter value = " + argReq.getParameter(str)));
            if (str.indexOf("pools") == -1) continue;
            try {
                int idx = Integer.parseInt(argReq.getParameter(str));
                selectedPools.add((RaidGroupInterface)allPools.get(idx));
            }
            catch (NumberFormatException nfe) {
                Trace.verbose((Object)((Object)this), (String)"Exception trying to get selected pools", (Throwable)nfe);
            }
        }
    }

    protected boolean havePoolSelections(ActionForm argForm, HttpServletRequest argReq, String messageKey) throws CoreUIBusException, ConfigMgmtException {
        String methodName = "havePoolSelections";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        List selectedPools = this.getSelectedPools(argReq, argForm);
        if (selectedPools.size() <= 0) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No pools were selected to perform an action on!");
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, messageKey));
            this.saveUserMessages(argReq, messages);
            return false;
        }
        ((PoolForm)argForm).setSelectedPools(selectedPools);
        return true;
    }

    protected void setAffectedVolumes(HttpServletRequest argReq, List pools, ActionForm form) {
        String methodName = "setAffectedVolumes";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        try {
            ArrayList affectedVolumes = new ArrayList();
            ((PoolForm)form).setAffectedVolumes(null);
            for (int i = 0; i < pools.size(); ++i) {
                List volumes = ((RaidGroupInterface)pools.get(i)).getVolumes();
                affectedVolumes.addAll(volumes);
            }
            if (affectedVolumes.size() > 0) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Setting affected volumes size = " + affectedVolumes.size()));
                ((PoolForm)form).setAffectedVolumes(affectedVolumes);
                this.setListContext(argReq, "AffectedVolumeList", affectedVolumes);
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to get affected volumes", (Throwable)e);
            ((PoolForm)form).setAffectedVolumes(null);
        }
    }
}

