/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Search;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.CoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.SearchForm;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SearchAction
extends CoreAction {
    static final String MENU_ITEM = ".item5";
    static final String MENU_SUB_ITEM = ".item0";

    protected String getMenuItemId() {
        return MENU_ITEM;
    }

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String methodName = "doAction";
        Trace.constructor((Object)((Object)this));
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        String action = argAction == null ? "show" : argAction;
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
        HttpSession session = argReq.getSession();
        String path = argReq.getServletPath();
        Object volBusObj = null;
        Object vgBusObj = null;
        Object igBusObj = null;
        Object iniBusObj = null;
        Object trayBusObj = null;
        Object t4BusObj = null;
        Object poolBusObj = null;
        try {
            SearchForm form = (SearchForm)argForm;
            List results = null;
            if ("show".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"SHOW action");
                results = form.getResults();
            }
            if ("search".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"SEARCH action");
                results = this.handleSearch(argReq, form);
                action = this.handleSearchResult(argReq, action, form, results);
                form.setResults(results);
            }
            this.setListContext(argReq, form.getListName()[form.getObjectType()], results);
        }
        catch (Exception e) {
            ConfigMgmtException cme = new ConfigMgmtException();
            cme.addExceptionContext((Object)e);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, e);
        }
        return this.doForward(argReq, action, argMap);
    }

    private String handleSearchResult(HttpServletRequest argReq, String action, SearchForm form, List results) {
        String methodName = "handleSearchResult";
        if (results == null || results.size() < 1) {
            Trace.verbose((Object)((Object)this), (String)"handleSearchResult", (String)"No search results found!");
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "search.results.none"));
            this.saveUserMessages(argReq, messages);
        } else {
            Trace.verbose((Object)((Object)this), (String)"handleSearchResult", (String)("Results size:" + results.size()));
            action = form.getTypes()[form.getObjectType()];
        }
        return action;
    }

    private List handleSearch(HttpServletRequest argReq, SearchForm form) {
        String methodName = "handleSearch";
        int objectType = form.getObjectType();
        Trace.verbose((Object)((Object)this), (String)"handleSearch", (String)("Trying to search for obj type = " + objectType));
        String searchField = argReq.getParameter("" + objectType) == null ? "Name" : argReq.getParameter("" + objectType);
        Trace.verbose((Object)((Object)this), (String)"handleSearch", (String)("Search field = " + searchField));
        form.setCriteria(searchField);
        String searchText = form.getSearchText();
        Trace.verbose((Object)((Object)this), (String)"handleSearch", (String)("Tyring to search string = " + searchText));
        String searchType = form.getStringType();
        Trace.verbose((Object)((Object)this), (String)"handleSearch", (String)("Tyring to search string type = " + searchType));
        boolean isExact = false;
        boolean isCaseSensitive = false;
        if ("Exact".equals(searchType)) {
            isExact = true;
        }
        Search searchBusObj = (Search)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Search");
        return searchBusObj.search(this.getConfigContext(argReq), objectType, searchField, searchText, isExact, isCaseSensitive);
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getBreadCrumbName";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        String path = argReq.getServletPath();
        String action = argReq.getParameter("action");
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("path = " + path));
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
        if ("/root.menu.item5.item0arrayresults.do".equals(path)) {
            return "search.results.header.array";
        }
        if ("/trayresults.do".equals(path)) {
            return "search.results.header.tray";
        }
        if ("/poolresults.do".equals(path)) {
            return "search.results.header.pool";
        }
        if ("/volumeresults.do".equals(path)) {
            return "search.results.header.volume";
        }
        if ("/vgresults.do".equals(path)) {
            return "search.results.header.volumegroup";
        }
        if ("/initiatorresults.do".equals(path)) {
            return "search.results.header.initiator";
        }
        if ("/igresults.do".equals(path)) {
            return "search.results.header.initiatorgroup";
        }
        return "search.title";
    }
}

