/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageMgmtCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.ImportProfileForm;
import com.sun.netstorage.array.mgmt.cfg.util.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.xml.sax.SAXParseException;

public class ProfileImportAction
extends StorageMgmtCoreAction {
    private static final String MENU_SUB_ITEM = ".item3";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String methodName = "doAction";
        Trace.constructor((Object)((Object)this));
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ConfigContext context = this.getConfigContext(argReq);
        ImportProfileForm form = (ImportProfileForm)argForm;
        HttpSession session = argReq.getSession();
        Profiles profiles = (Profiles)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles");
        String action = argAction == null ? "show" : argAction;
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
        Trace.verbose((Object)((Object)this), (String)methodName, (String)(" path " + argReq.getServletPath()));
        UserMessages messages = new UserMessages();
        try {
            if ("show".equals(action)) {
                if (argReq.getServletPath().equals("/root.menu.item0.item3importconfirm.do")) {
                    List foundProfiles = form.getProfilesToImport();
                    int foundProfileCount = foundProfiles != null ? foundProfiles.size() : 0;
                    List profilesToPresent = this.extractProfilesToPresent(foundProfiles);
                    int presentableProfilesCount = profilesToPresent != null ? profilesToPresent.size() : 0;
                    int numberExisting = foundProfileCount - presentableProfilesCount;
                    messages = this.setMessages(numberExisting, foundProfileCount, messages);
                    form.setProfilesToImport(profilesToPresent);
                } else if ("/root.menu.item0.item3import.do".equals(argReq.getServletPath())) {
                    form.doReset();
                }
            } else if ("importprofiles".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)" importing profiles ");
                int successfull = this.handleProfileImport(argReq, form);
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.profile.import.info.msg.success", new Integer(successfull)));
                form.setProfilesToImport(new ArrayList());
            } else if ("load".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)" loading file ");
                String content = "";
                FormFile location = form.getLoadedFile();
                content = new String(location.getFileData());
                if (content.length() == 0) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)" NO CONTENT ");
                    action = "show";
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.profile.import.error.nofile"));
                } else {
                    List foundProfiles = profiles.getProfilesToImport(this.getConfigContext(argReq), content);
                    Iterator iterator = foundProfiles.iterator();
                    while (iterator.hasNext()) {
                        StorageProfile theProfile = (StorageProfile)iterator.next();
                        try {
                            theProfile.validateProfileIntegrity();
                        }
                        catch (ConfigMgmtException e) {
                            String value = "";
                            if (e.getSubstitutions() != null && e.getSubstitutions().length >= 1) {
                                value = e.getSubstitutions()[0];
                            }
                            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, e.getExceptionKey(), value));
                            action = "show";
                        }
                    }
                    form.setProfilesToImport(foundProfiles);
                }
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"Exception in doAction", (Throwable)e);
            messages = this.handleException(e, messages);
            action = "show";
        }
        if (messages.getErrorMessages().size() > 0 || messages.getWarningMessages().size() > 0 || messages.getInfoMessages().size() > 0) {
            this.saveUserMessages(argReq, messages);
        }
        return this.doForward(argReq, action, argMap);
    }

    private UserMessages setMessages(int existing, int all, UserMessages messages) {
        String methodName = "setMessages";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        if (existing < 0) {
            existing = 0;
        }
        if (existing == 0) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.profile.import.info.msg.noexists", new Integer(all)));
        } else if (existing >= all) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.profile.import.info.msg.exists.all", new Integer(all)));
        } else if (existing == 1) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.profile.import.info.msg.exists.one", new Integer(all)));
        } else {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.profile.import.info.msg.exists.more", new Integer(all), new Integer(existing)));
        }
        return messages;
    }

    public List extractProfilesToPresent(List allProfiles) {
        String methodName = "extractProfilesToPresent";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ArrayList<StorageProfile> result = new ArrayList<StorageProfile>();
        for (int i = 0; i < allProfiles.size(); ++i) {
            StorageProfile theProfile = (StorageProfile)allProfiles.get(i);
            if (theProfile.getImportStatus() == 4) continue;
            result.add(theProfile);
        }
        return result;
    }

    private UserMessages handleException(Exception e, UserMessages messages) {
        String methodName = "handleException";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        if (e instanceof SAXParseException) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.profile.import.error.parse"));
        } else if (e instanceof ConfigMgmtException) {
            ConfigMgmtException cme = (ConfigMgmtException)((Object)e);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, cme.getExceptionKey()));
        } else if (e instanceof ParseException) {
            ParseException pe = (ParseException)e;
            List list = pe.getParseErrors();
            StringBuffer errorMsg = new StringBuffer("");
            for (int i = 0; i < list.size(); ++i) {
                errorMsg.append("<br>" + list.get(i));
            }
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "profile.import.parseErrors", errorMsg.toString()));
        } else {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.profile.import.error"));
        }
        return messages;
    }

    public int handleProfileImport(HttpServletRequest argReq, ImportProfileForm form) throws ConfigMgmtException {
        String methodName = "handleProfileImport";
        int[] intSelections = this.getSelectedIndices(argReq, "selectedIndices");
        int successfull = 0;
        if (intSelections == null || intSelections.length <= 0) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No items selected!");
            throw new ConfigMgmtException("error.none.selected", "No profile is selected.");
        }
        if (intSelections != null && intSelections.length > 0) {
            List profileList = form.getProfilesToImport();
            if (profileList == null) {
                throw new ConfigMgmtException("storage.mgmt.profile.import.error.nomatch", "No profiles available for import.");
            }
            for (int i = 0; i < intSelections.length; ++i) {
                StorageProfile profile = (StorageProfile)profileList.get(intSelections[i]);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to import profile = " + profile.getName()));
                profile.save(this.getConfigContext(argReq));
                ++successfull;
            }
        }
        return successfull;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String result = "storage.mgmt.profile.import.crumb";
        if (argReq.getServletPath().equals("/root.menu.item0.item3importconfirm.do")) {
            result = "storage.mgmt.profile.import.confirm.crumb";
        }
        return result;
    }
}

