/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfiles;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageMgmtCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.StorageProfileForm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ProfileDetailsAction
extends StorageMgmtCoreAction {
    private static final String MENU_SUB_ITEM = ".item3";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getBreadCrumbName";
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Path = " + path));
        String result = null;
        if ("/root.menu.item0.item3profiledetails.do".equals(path)) {
            result = argReq.getParameter("profileName");
        } else if ("/root.menu.item0.item3createprofile.do".equals(path)) {
            result = "storage.mgmt.profile.create.crumb";
        } else if ("/root.menu.item0.item3duplicateconfirm.do".equals(path)) {
            result = "storage.mgmt.profile.duplicateconfirm.crumb";
        } else if ("/root.menu.item0.item3deleteconfirm.do".equals(path)) {
            result = "storage.mgmt.profile.deleteconfirm.crumb";
        }
        return result;
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String methodName = "doAction";
        HttpSession session = argReq.getSession();
        ConfigContext configContext = this.getConfigContext(argReq);
        String action = argAction == null ? "show" : argAction;
        String profileName = argReq.getParameter("profileName");
        String path = argReq.getServletPath();
        StorageProfile currentProfile = null;
        StorageProfileForm form = (StorageProfileForm)argForm;
        Trace.verbose((Object)((Object)this), (String)" profile details ", (String)("action is " + action + "\n path is " + path + " name in form is " + form.getName()));
        Profiles profiles = (Profiles)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles");
        form.setHealth(profiles.areAllArraysHealthy(configContext));
        UserMessages messages = new UserMessages();
        if ("/root.menu.item0.item3profiledetails.do".equals(path) && !form.isHealth()) {
            this.saveSingleUserMessage(argReq, 2, "storage.mgmt.profile.details.info.noallhealthy");
        }
        try {
            if ("show".equals(action)) {
                if ("/root.menu.item0.item3profiledetails.do".equals(path)) {
                    currentProfile = ManageStorageProfiles.getInstance().getProfile(profileName);
                    if (currentProfile != null) {
                        BeanUtils.copyProperties((Object)((Object)form), (Object)currentProfile);
                        form.setCurrentProfile(currentProfile);
                        form.setInUse(currentProfile.inUse(configContext));
                        if (form.isInUse()) {
                            this.saveSingleUserMessage(argReq, 2, "storage.mgmt.profile.details.info.inuse");
                        }
                    } else {
                        form.doReset();
                    }
                } else if ("/root.menu.item0.item3deleteconfirm.do".equals(path)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Confirm profile removal");
                    try {
                        this.handleDeleteConfirmation(argReq, argForm);
                    }
                    catch (Exception ex) {
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, ex.getMessage()));
                        action = "cancel";
                    }
                } else if ("/root.menu.item0.item3createprofile.do".equals(path)) {
                    this.removeAllUserMessages(argReq);
                }
            } else if ("createprofile".equals(action)) {
                action = this.handleProfileCreation(argReq, form, session);
                if (!"show".equals(action)) {
                    form.doReset();
                }
            } else if ("createduplicateprofile".equals(action)) {
                this.handleDuplicateProfileCreation(argReq, form, session);
            } else if ("modifyprofile".equals(action)) {
                StorageProfile modifiedProfile = (StorageProfile)form.getCurrentProfile().clone();
                String originalName = modifiedProfile.getName();
                if (!form.isInUse()) {
                    BeanUtils.copyProperties((Object)modifiedProfile, (Object)((Object)form));
                } else {
                    modifiedProfile.setName(form.getName());
                    modifiedProfile.setDescription(form.getDescription());
                }
                action = this.handleProfileModification(argReq, form, session, action, modifiedProfile, originalName);
            } else if ("deleteprofile".equals(action)) {
                this.handleProfileDelete(argReq, argForm);
                form.setProfilesToDelete(new ArrayList());
                form.setCantDeleteInUse(new ArrayList());
            } else if ("saveas".equals(action)) {
                if (path.equals("/root.menu.item0.item3profiledetails.do")) {
                    argReq.setAttribute("request_action", (Object)"saveas");
                } else {
                    form.setDescription("");
                    form.setName("");
                    if (path.equals("/root.menu.item0.item3createprofile.do")) {
                        this.removeAllUserMessages(argReq);
                    }
                }
            }
        }
        catch (Exception e) {
            messages = this.handleException(e, messages);
            action = "show";
        }
        if (messages.getErrorMessages().size() > 0 || messages.getWarningMessages().size() > 0 || messages.getInfoMessages().size() > 0) {
            this.saveUserMessages(argReq, messages);
        }
        return this.doForward(argReq, action, argMap);
    }

    private UserMessages handleException(Exception e, UserMessages messages) {
        String methodName = "handleException";
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Exception in doAction() = " + e.getMessage()));
        if (e instanceof BadParameterException) {
            BadParameterException bpe = (BadParameterException)((Object)e);
            if (bpe.getBadParameter() != null) {
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, bpe.getMessage(), bpe.getBadParameter()));
            } else if (bpe.getMsgParams() != null && bpe.getMsgParams().length > 1) {
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, bpe.getMessage(), bpe.getMsgParams()[0], bpe.getMsgParams()[1]));
            } else {
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.operationfailed.noerrorcode"));
            }
        } else if (e instanceof ConfigMgmtException) {
            ConfigMgmtException cme = (ConfigMgmtException)((Object)e);
            String[] substitutions = cme.getSubstitutions();
            if (substitutions != null && substitutions.length > 0) {
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, cme.getExceptionKey(), substitutions[0]));
            } else {
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, cme.getExceptionKey()));
            }
        } else {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.operationfailed.noerrorcode"));
        }
        return messages;
    }

    private void handleDuplicateProfileCreation(HttpServletRequest argReq, StorageProfileForm storageProfileForm, HttpSession session) throws ConfigMgmtException, BadParameterException {
        String methodName = "handleDuplicateProfileCreation";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        Profiles profiles = (Profiles)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles");
        StorageProfile profile = new StorageProfile(storageProfileForm.getName(), storageProfileForm.getDescription(), storageProfileForm.getRaidLevel(), storageProfileForm.getSegmentSize(), storageProfileForm.getReadaheadMode(), storageProfileForm.getNumberOfDrives(), storageProfileForm.getDedicatedHotSpare(), storageProfileForm.getArrayType());
        profiles.createProfile(this.getConfigContext(argReq), profile);
    }

    protected String handleProfileCreation(HttpServletRequest argReq, StorageProfileForm storageProfileForm, HttpSession session) throws ConfigMgmtException, BadParameterException {
        String methodName = "handleProfileCreation";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        String action = "start";
        Profiles profiles = (Profiles)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles");
        StorageProfile profile = new StorageProfile(storageProfileForm.getName(), storageProfileForm.getDescription(), storageProfileForm.getRaidLevel(), storageProfileForm.getSegmentSize(), storageProfileForm.getReadaheadMode(), storageProfileForm.getNumberOfDrives(), storageProfileForm.getDedicatedHotSpare(), storageProfileForm.getArrayType());
        profiles.validateNameAndDesc(profile);
        List listOfDuplicates = new ArrayList();
        try {
            listOfDuplicates = profiles.getDuplicateProfiles(this.getConfigContext(argReq), profile);
            if (listOfDuplicates != null && listOfDuplicates.size() > 0) {
                storageProfileForm.setDuplicateProfiles(listOfDuplicates);
                action = "duplicateconfirm";
                return action;
            }
        }
        catch (Exception e) {
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.profile.create.error.exists"));
            this.saveUserMessages(argReq, messages);
            return "show";
        }
        profiles.createProfile(this.getConfigContext(argReq), profile);
        Trace.verbose((Object)((Object)this), (String)"handleProfileCreation - details", (String)(" returning action " + action));
        return action;
    }

    protected String handleProfileModification(HttpServletRequest argReq, StorageProfileForm storageProfileForm, HttpSession session, String action, StorageProfile modifiedProfile, String originalName) throws ConfigMgmtException, BadParameterException {
        String methodName = "handleProfileModification";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        Profiles profiles = (Profiles)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles");
        if (!originalName.equals(modifiedProfile.getName())) {
            try {
                profiles.getDuplicateProfiles(this.getConfigContext(argReq), modifiedProfile);
            }
            catch (Exception e) {
                UserMessages messages = new UserMessages();
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.profile.create.error.exists"));
                this.saveUserMessages(argReq, messages);
                return "show";
            }
        }
        profiles.createProfile(this.getConfigContext(argReq), modifiedProfile);
        storageProfileForm.setCurrentProfile(modifiedProfile);
        this.saveSingleUserMessage(argReq, 2, "storage.mgmt.profile.details.info.save.success");
        Trace.verbose((Object)((Object)this), (String)"handleProfileModification - details", (String)(" returning action " + action));
        return action;
    }

    private void handleDeleteConfirmation(HttpServletRequest argReq, ActionForm argForm) throws Exception {
        String methodName = "handleDeleteConfirmation";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        StorageProfileForm form = (StorageProfileForm)argForm;
        boolean bothListsEmpty = !(form.getCantDeleteInUse() != null && form.getCantDeleteInUse().size() != 0 || form.getProfilesToDelete() != null && form.getProfilesToDelete().size() != 0);
        int[] intSelections = this.getSelectedIndices(argReq, "selectedIndices");
        if ((intSelections == null || intSelections.length <= 0) && bothListsEmpty) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No items selected!");
            throw new Exception("error.none.selected");
        }
        if (intSelections != null && intSelections.length > 0) {
            List profileList = (List)argReq.getSession().getAttribute("AllProfilesList");
            if (profileList == null) {
                throw new Exception("storage.mgmt.profile.deleteconfirm.error.nomatch");
            }
            ArrayList<StorageProfile> profilesToRemove = new ArrayList<StorageProfile>();
            ArrayList<StorageProfile> profilesInUse = new ArrayList<StorageProfile>();
            for (int i = 0; i < intSelections.length; ++i) {
                StorageProfile profileToRmv = (StorageProfile)profileList.get(intSelections[i]);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to remove profile = " + profileToRmv.getName()));
                if (profileToRmv.inUse(this.getConfigContext(argReq))) {
                    profilesInUse.add(profileToRmv);
                    continue;
                }
                profilesToRemove.add(profileToRmv);
            }
            form.setProfilesToDelete(profilesToRemove);
            form.setCantDeleteInUse(profilesInUse);
            if (profilesToRemove == null || profilesToRemove.isEmpty()) {
                this.saveSingleUserMessage(argReq, 2, "storage.mgmt.profile.deleteconfirm.disabled");
            }
        }
    }

    private void handleProfileDelete(HttpServletRequest argReq, ActionForm argForm) throws ConfigMgmtException {
        String methodName = "handleProfileDelete";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        StorageProfileForm form = (StorageProfileForm)argForm;
        Profiles profiles = (Profiles)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles");
        List listOfProfiles = form.getProfilesToDelete();
        Iterator iterator = listOfProfiles.iterator();
        while (iterator.hasNext()) {
            StorageProfile profile = (StorageProfile)iterator.next();
            profiles.deleteProfile(this.getConfigContext(argReq), profile);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)(" deleting " + profile.getName()));
        }
        this.saveSingleUserMessage(argReq, 2, "storage.mgmt.profile.deleteconfirm.info.delete.success");
    }
}

