/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.AdminCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.AdminPowerAndBootForm;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PowerAndBootAction
extends AdminCoreAction {
    static String MENU_SUB_ITEM = ".item0.m1m2";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        Trace.methodBegin((Object)((Object)this), (String)"getBreadCrumbName");
        String path = argReq.getServletPath();
        if ("/root.menu.item3.item0.m1m2.powerrebootconfirm.do".equals(path)) {
            return "admin.general.confirm.confirmrebootbutton";
        }
        if ("/root.menu.item3.item0.m1m2.powershutdownconfirm.do".equals(path)) {
            return "admin.general.confirm.confirmbutton";
        }
        if ("/root.menu.item3.item0.m1m2.resetlabelsconfirm.do".equals(path)) {
            return "admin.general.individualarray.resetlabels.confirm";
        }
        return "";
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        Trace.methodBegin((Object)((Object)this), (String)"doAction");
        String action = argAction == null ? "show" : argAction;
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("Path = " + path));
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("Selected T4 INDEX = " + argReq.getParameter("index")));
        T4Interface currentT4 = this.getCurrentT4(argReq);
        if (currentT4 != null) {
            Trace.verbose((Object)((Object)this), (String)"doAction", (String)("Got current t4 from session = " + currentT4.getName()));
        }
        if (argReq.getParameter("index") != null) {
            Trace.verbose((Object)((Object)this), (String)"doAction", (String)"setting default T4 for power and boot");
            currentT4 = this.getSelectedT4(argReq);
            if (currentT4 != null) {
                Trace.verbose((Object)((Object)this), (String)"doAction", (String)("Got selected T4= " + currentT4.getName()));
            }
        }
        if (currentT4 == null) {
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(1, "admin.general.powerandboot.noarray.worning"));
            this.saveUserMessages(argReq, messages);
            return this.doForward(argReq, action, argMap);
        }
        action = this.handlePasswordPrompt(action, argForm, argReq);
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("Action after handle pass = " + action));
        if ("prompt_password".equals(action)) {
            return this.doForward(argReq, action, argMap);
        }
        HttpSession session = argReq.getSession();
        ConfigContext configContext = this.getConfigContext(argReq);
        try {
            Admin adminBusObj = (Admin)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Admin");
            AdminPowerAndBootForm form = (AdminPowerAndBootForm)argForm;
            if ("shutdown".equals(action)) {
                this.doShutdown(argReq, currentT4);
            } else if ("reboot".equals(action)) {
                this.doReboot(argReq, currentT4);
            } else if ("resetlabels".equals(action)) {
                this.doResetLabels(argReq, currentT4);
            } else if (action.indexOf("cancel") < 0) {
                if ("/root.menu.item3.item0.m1m2.powerrebootconfirm.do".equals(path)) {
                    Trace.verbose((Object)((Object)this), (String)"doActon", (String)"Confirm reboot path");
                    String message = "admin.general.individualarray.restart.mr12.warning";
                    this.prepareConfirm(argReq, currentT4.getName(), message, false);
                } else if ("/root.menu.item3.item0.m1m2.powershutdownconfirm.do".equals(path)) {
                    Trace.verbose((Object)((Object)this), (String)"doActon", (String)"Confirm shutdown path");
                    String message = "admin.general.individualarray.shutdown.mr12.warning";
                    this.prepareConfirm(argReq, currentT4.getName(), message, false);
                } else if ("/root.menu.item3.item0.m1m2.resetlabelsconfirm.do".equals(path)) {
                    Trace.verbose((Object)((Object)this), (String)"doActon", (String)"Confirm reset labels path");
                    String message = "admin.general.individualarray.resetlabels.mr12.bootw.warning";
                    if (currentT4.isFeatureSupported(6)) {
                        message = "admin.general.individualarray.resetlabels.mr12.bootr.warning";
                    }
                    this.prepareConfirm(argReq, currentT4.getName(), message, true);
                }
            }
        }
        catch (ConfigMgmtException e) {
            this.handleConfigMgmtException(argReq, e, currentT4, action);
        }
        catch (Exception e) {
            this.handleSystemError(argReq, e);
        }
        return this.doForward(argReq, action, argMap);
    }

    public void prepareConfirm(HttpServletRequest argReq, String t4Name, String msg, boolean insertArrayInfo) {
        Trace.methodBegin((Object)((Object)this), (String)"prepareConfirm");
        UserMessages messages = new UserMessages();
        UserMessage message = null;
        message = insertArrayInfo ? new UserMessage(1, msg, t4Name, IPUtil.lookUpIP((String)t4Name)) : new UserMessage(1, msg);
        messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
        ArrayList<String> arrays = new ArrayList<String>();
        arrays.add(t4Name);
        this.checkForActiveJobs(argReq, messages, arrays);
        this.saveUserMessages(argReq, messages);
    }

    public void handleConfigMgmtException(HttpServletRequest argReq, ConfigMgmtException e, T4Interface currentT4, String action) {
        Trace.methodBegin((Object)((Object)this), (String)"handleConfigMgmtException");
        if ("shutdown".equals(action)) {
            LogAPI.staticLog((String)"ARRAY_SHUTDOWN_ERROR", (String[])new String[]{currentT4.getName()}, (String[])new String[0]);
        } else if ("reboot".equals(action)) {
            LogAPI.staticLog((String)"ARRAY_REBOOT_ERROR", (String[])new String[]{currentT4.getName()}, (String[])new String[0]);
        } else if ("resetlabels".equals(action)) {
            LogAPI.staticLog((String)"ARRAY_RESET_LABELS_ERROR", (String[])new String[]{currentT4.getName()}, (String[])new String[0]);
        }
        this.handleSystemError(argReq, e);
    }

    public void doReboot(HttpServletRequest argReq, T4Interface array) throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"doReboot");
        String arrayName = array.getName();
        Trace.verbose((Object)((Object)this), (String)"doReboot", (String)("Trying to reboot array: " + arrayName));
        array.reboot();
        array.reload();
        LogAPI.staticLog((String)"ARRAY_REBOOT_INITIATED", (String[])new String[]{arrayName}, (String[])new String[0]);
        UserMessages messages = new UserMessages();
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "admin.general.individualarray.reset.done"));
        this.saveUserMessages(argReq, messages);
    }

    public void doShutdown(HttpServletRequest argReq, T4Interface array) throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"doShutdown");
        String arrayName = array.getName();
        Trace.verbose((Object)((Object)this), (String)"doShutdown", (String)("Trying to shutdown array: " + arrayName));
        array.shutdown();
        array.reload();
        LogAPI.staticLog((String)"ARRAY_SHUTDOWN_INITIATED", (String[])new String[]{arrayName}, (String[])new String[0]);
        UserMessages messages = new UserMessages();
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "admin.general.individualarray.shutdown.done"));
        this.saveUserMessages(argReq, messages);
    }

    public void doResetLabels(HttpServletRequest argReq, T4Interface array) throws ConfigMgmtException {
        Trace.methodBegin((Object)((Object)this), (String)"doResetLabels");
        array.resetLabels(false);
        array.reload();
        String arrayName = array.getName();
        Trace.verbose((Object)((Object)this), (String)"doResetLabels", (String)("Trying to reset labels on the array: " + arrayName));
        LogAPI.staticLog((String)"ARRAY_RESET_LABELS_INITIATED", (String[])new String[]{arrayName}, (String[])new String[0]);
        UserMessages messages = new UserMessages();
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "admin.general.individualarray.resetlabels.done"));
        this.saveUserMessages(argReq, messages);
    }
}

