/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.actions.StoragePoolsAction;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.PoolForm;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class OfflinePoolAction
extends StoragePoolsAction {
    private static final String MENU_SUB_ITEM = ".item0";

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        HttpSession session = argReq.getSession();
        String action = argAction == null ? "show" : argAction;
        String methodName = "doAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        try {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
            if ("show".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Show offline confirmation action");
                action = this.performPreOfflineAction(argForm, argReq, action);
            } else if ("confirm_offline".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Confirm offline action; perform status change to offline");
                action = this.handleOfflineConfirmation(argForm, argReq);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("After offline; change action = " + action));
            }
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext((Object)"ConfigMgmtException in doAction");
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, cme);
        }
        catch (Exception e) {
            ConfigMgmtException cme = new ConfigMgmtException(e);
            cme.addExceptionContext((Object)"General Exception in doAction");
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, e);
        }
        return this.doForward(argReq, action, argMap);
    }

    private String performPreOfflineAction(ActionForm argForm, HttpServletRequest argReq, String action) throws CoreUIBusException, ConfigMgmtException {
        String methodName = "performPreOfflineAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        List selectedPools = this.getSelectedPools(argReq, argForm);
        if (!this.havePoolSelections(argForm, argReq, "storage.mgmt.system.expert.pools.offline.error")) {
            action = ((PoolForm)argForm).getComingFrom();
        } else {
            ((PoolForm)argForm).setSelectedPools(selectedPools);
            this.setAffectedVolumes(argReq, selectedPools, argForm);
        }
        return action;
    }

    private String handleOfflineConfirmation(ActionForm argForm, HttpServletRequest argReq) {
        String methodName = "handleOfflineConfirmation";
        List selectedPools = ((PoolForm)argForm).getSelectedPools();
        String action = ((PoolForm)argForm).getComingFrom();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Tyring to place selected pools offline...");
        String[] args = new String[1];
        try {
            StoragePools poolBusObj = (StoragePools)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools");
            T4Interface currentT4 = this.getCurrentT4(argReq);
            for (int i = 0; i < selectedPools.size(); ++i) {
                RaidGroupInterface pool = (RaidGroupInterface)selectedPools.get(i);
                args[0] = pool.getName();
                poolBusObj.changeStatus(pool, "offline");
                LogAPI.staticLog((String)"POOL_OFFLINE", (String[])args, (String[])new String[0]);
            }
            this.setConfirmationMessage(argReq, "storage.mgmt.system.expert.pools.offline.confirm");
            currentT4.reload();
            this.resetArray(argReq, currentT4);
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext((Object)"ConfigMgmtException trying to change pool offline");
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, cme);
        }
        catch (Exception ex) {
            ConfigMgmtException cme = new ConfigMgmtException(ex);
            cme.addExceptionContext((Object)"General Exception trying to change pool offline");
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, ex);
        }
        return action;
    }

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)("PATH in bread crumb = " + path));
        if (path != null && "/root.menu.item0.item2poolsoffline.do".equals(path)) {
            return "storage.mgmt.system.expert.pools.offline";
        }
        return "storage.mgmt.system.expert.pools";
    }
}

