/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.CoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.JobsForm;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class JobsAction
extends CoreAction {
    static String MENU_ITEM = ".item4";
    static String MENU_SUB_ITEM = ".item0";

    protected String getMenuItemId() {
        return MENU_ITEM;
    }

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String path = argReq.getServletPath();
        if ("/root.menu.item4.item0cancelconfirm.do".equals(path)) {
            return "jobs.general.killjob.confirm.header";
        }
        if ("/root.menu.item4.item0deleteconfirm.do".equals(path)) {
            return "jobs.general.deletejobs.confirm.header";
        }
        return "jobs.general.jobsgeneral";
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String methodName = "doAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        HttpSession session = argReq.getSession();
        JobsForm jobsForm = (JobsForm)argForm;
        ConfigContext configContext = this.getConfigContext(argReq);
        String action = argAction == null ? "show" : argAction;
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("JOBS action = " + action));
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Servlet PATH = " + path));
        try {
            session.removeAttribute("jobsProcessed");
            Jobs jobs = (Jobs)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs");
            if ("deletejobsconfirm".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Delete Jobs Confirmation");
                action = this.handleDeleteJobsConfirmation(argReq, jobsForm, session, action);
            } else if ("killjobsconfirm".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Kill Jobs Confirmation");
                action = this.handleKillJobsConfirmation(argReq, jobsForm, session, action);
            } else if ("killjobs".equals(action)) {
                action = this.handleKillJobs(argReq, jobsForm, session, action, jobs);
            } else if ("deletejobs".equals(action)) {
                action = this.handleDeleteJobs(argReq, jobsForm, session, action, jobs);
            } else if ("save_job_email".equals(action)) {
                action = this.handleSaveJobEmail(argReq, session, jobsForm);
            }
            if (("show".equals(action) || "save_job_email".equals(action)) && "/root.menu.item4.item0.do".equals(path)) {
                jobsForm.doReset();
                action = this.handleShowJobs(argReq, jobsForm, configContext, action, jobs);
            }
        }
        catch (Exception e) {
            ConfigMgmtException cme = new ConfigMgmtException(e);
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            action = "show";
        }
        return this.doForward(argReq, action, argMap);
    }

    protected String handleShowJobs(HttpServletRequest argReq, JobsForm jobsForm, ConfigContext configContext, String action, Jobs jobs) throws ConfigMgmtException {
        String methodName = "handleShowJobs";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        int jobListFilter = jobsForm.getJobListFilter();
        List jobList = null;
        if (argReq.getParameter("prev_next_pressed") != null && argReq.getParameter("prev_next_pressed").equals("true") && argReq.getSession().getAttribute("JobsList") != null) {
            jobList = (List)argReq.getSession().getAttribute("JobsList");
            this.setListContext(argReq, "JobsList", jobList);
            return "show";
        }
        Trace.verbose((Object)((Object)this), (String)methodName, (String)"remove list from session");
        argReq.getSession().removeAttribute("JobsList");
        Trace.verbose((Object)((Object)this), (String)methodName, (String)"list removed");
        jobs = new Jobs();
        if (jobListFilter == 0) {
            jobList = jobs.getOutstandingJobsList(configContext, null);
            if ((jobList == null || jobList.size() == 0) && "save_job_email".equals(action)) {
                jobListFilter = 1;
                jobsForm.setJobListFilter(jobListFilter);
                jobList = jobs.getAllJobsList(configContext, null);
            }
        } else {
            jobList = jobs.getAllJobsList(configContext, null);
        }
        this.setListContext(argReq, "JobsList", jobList);
        action = "show";
        return action;
    }

    protected String handleSaveJobEmail(HttpServletRequest argReq, HttpSession session, JobsForm jobsForm) {
        String methodName = "handleSaveJobEmail";
        String action = "show";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        action = "show";
        String email = jobsForm.getNotificationEmail();
        jobsForm.setJobListFilter(0);
        jobsForm.setNotificationEmail(null);
        List callStatuses = this.getMethodCallStatuses(argReq);
        session.removeAttribute("MethodCallStatusList");
        session.removeAttribute("org.apache.struts.action.ERROR");
        session.removeAttribute("WarningUserMessages");
        session.removeAttribute("InfoUserMessages");
        try {
            if (email != null && email.indexOf("@") > 0) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("THE EMAIL TO SAVE IS [" + email + "]"));
                Jobs.saveNotificationEmail(callStatuses, email, (ConfigContext)session.getAttribute("ConfigContext"));
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Saved notification email; go to show action");
            } else {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("No email addresses to save, so not saving: " + email));
            }
            argReq.setAttribute("displayErrors", (Object)"false");
        }
        catch (ConfigMgmtException ex) {
            ex.addExceptionContext((Object)"Failed saving notification email");
            ex.addExceptionContext((Object)jobsForm);
            ex.addExceptionContext((Object)("Have jobs:" + Jobs.hasJobsInMethodCallStatuses(callStatuses)));
            Trace.error((Object)((Object)this), (ConfigMgmtException)ex);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Removing jobs list from session");
            argReq.getSession().removeAttribute("MethodCallStatusList");
            argReq.setAttribute("displayErrors", (Object)"false");
            action = "show";
        }
        return action;
    }

    protected String handleDeleteJobsConfirmation(HttpServletRequest argReq, JobsForm jobForm, HttpSession session, String action) {
        String methodName = "handleDeleteJobsConfirmation";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        List jobsToDelete = this.getSelectedJobs(argReq, "jobs.general.delete.error.select");
        if (null == jobsToDelete || jobsToDelete.size() == 0) {
            action = "show";
        } else {
            ArrayList<JobInterface> deleteCompletedJobs = new ArrayList<JobInterface>();
            ArrayList<JobInterface> cannotDeleteActiveJobs = null;
            for (int i = 0; i < jobsToDelete.size(); ++i) {
                JobInterface ji = (JobInterface)jobsToDelete.get(i);
                if (!ji.isActive()) {
                    deleteCompletedJobs.add(ji);
                    continue;
                }
                if (cannotDeleteActiveJobs == null) {
                    cannotDeleteActiveJobs = new ArrayList<JobInterface>();
                }
                cannotDeleteActiveJobs.add(ji);
            }
            jobForm.setJobsToDelete(deleteCompletedJobs);
            jobForm.setCantDeleteActive(cannotDeleteActiveJobs);
        }
        return action;
    }

    protected String handleDeleteJobs(HttpServletRequest argReq, JobsForm jobForm, HttpSession session, String action, Jobs jobs) {
        List failures = jobs.deleteJobs(jobForm.getJobsToDelete());
        if (failures == null || failures.size() == 0) {
            UserMessages userMessages = new UserMessages();
            UserMessage message = new UserMessage(2, "jobs.general.delete.success");
            userMessages.add("org.apache.struts.action.GLOBAL_ERROR", message);
            this.saveUserMessages(argReq, userMessages);
        } else {
            this.reportFailures(argReq, "jobs.general.delete.errror", failures);
        }
        action = "return";
        return action;
    }

    protected String handleKillJobsConfirmation(HttpServletRequest argReq, JobsForm jobForm, HttpSession session, String action) {
        String methodName = "handleKillJobsConfirmation";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        List jobsToKill = this.getSelectedJobs(argReq, "jobs.general.kill.error.select");
        if (null == jobsToKill || jobsToKill.size() == 0) {
            action = "show";
        } else {
            ArrayList<JobInterface> activeJobsToKill = new ArrayList<JobInterface>();
            ArrayList<JobInterface> cantCancelCompleted = null;
            for (int i = 0; i < jobsToKill.size(); ++i) {
                JobInterface ji = (JobInterface)jobsToKill.get(i);
                if (ji.isActive()) {
                    activeJobsToKill.add(ji);
                    continue;
                }
                if (cantCancelCompleted == null) {
                    cantCancelCompleted = new ArrayList<JobInterface>();
                }
                cantCancelCompleted.add(ji);
            }
            jobForm.setJobsToKill(activeJobsToKill);
            jobForm.setCantCancelCompleted(cantCancelCompleted);
        }
        return action;
    }

    protected String handleKillJobs(HttpServletRequest argReq, JobsForm jobForm, HttpSession session, String action, Jobs jobs) {
        String methodName = "handleKillJobs";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        List failures = jobs.killJobs(jobForm.getJobsToKill());
        if (failures == null || failures.size() == 0) {
            UserMessages userMessages = new UserMessages();
            UserMessage message = new UserMessage(2, "jobs.general.kill.success");
            userMessages.add("org.apache.struts.action.GLOBAL_ERROR", message);
            this.saveUserMessages(argReq, userMessages);
        } else {
            this.reportFailures(argReq, "jobs.general.kill.errror", failures);
        }
        action = "return";
        return action;
    }

    private void reportFailures(HttpServletRequest request, String messageKey, List jobs) {
        if (null == jobs || jobs.size() == 0) {
            return;
        }
        UserMessages userMessages = new UserMessages();
        for (int i = 0; i < jobs.size(); ++i) {
            int msgType = 0;
            JobInterface job = (JobInterface)jobs.get(i);
            try {
                job.reload();
                if (!(job.getDescription() == null || job.getDescription().indexOf("job.description.createvolume") < 0 && job.getDescription().indexOf("job.description.deletevolume") < 0 || job.isActive() && job.getStatus().intValue() != Constants.JobProperties.JOB_STATUS_RUNNING.intValue() || !messageKey.equals("jobs.general.kill.errror"))) {
                    messageKey = "jobs.general.cannotkillstage";
                    msgType = 2;
                }
            }
            catch (Exception e) {
                Trace.verbose((Object)((Object)this), (String)"reportFailures", (Throwable)e);
            }
            UserMessage message = new UserMessage(msgType, messageKey, job.getId());
            userMessages.add("org.apache.struts.action.GLOBAL_ERROR", message);
        }
        this.saveUserMessages(request, userMessages);
    }

    private List getSelectedJobs(HttpServletRequest argReq, String messageKey) {
        String methodName = "getSelectedJobs";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ArrayList<JobInterface> jobObjsSelected = new ArrayList<JobInterface>();
        int[] jobsSelected = Convert.stringArrayToIntArray((String[])argReq.getParameterValues("id"));
        if (null == jobsSelected || jobsSelected.length == 0) {
            UserMessages userMessages = new UserMessages();
            userMessages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(1, messageKey));
            this.saveUserMessages(argReq, userMessages);
        } else {
            List allJobs = (List)argReq.getSession().getAttribute("JobsList");
            for (int i = 0; i < jobsSelected.length; ++i) {
                JobInterface job = (JobInterface)allJobs.get(jobsSelected[i]);
                jobObjsSelected.add(job);
            }
            Trace.verbose((Object)((Object)this), (String)methodName, (String)(jobObjsSelected.size() + " jobs selected"));
        }
        return jobObjsSelected;
    }
}

