/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Initiators;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageAccessCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.InitiatorForm;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class InitiatorsAction
extends StorageAccessCoreAction {
    private static final String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)("Path = " + path));
        if ("/root.menu.item1.item0deliniconfirm.do".equals(path)) {
            return "storage.access.initiator.confirm.delete.crumb";
        }
        if ("/root.menu.item1.item0newini.do".equals(path)) {
            return "storage.access.new.initiator.crumb";
        }
        return "storage.access.manage.initiators";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String methodName = "doAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        HttpSession session = argReq.getSession();
        String action = argAction == null ? "show" : argAction;
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Path = " + path));
        Object initiators = null;
        UserMessages messages = new UserMessages();
        Initiators iniBusObj = (Initiators)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Initiators");
        try {
            if ("show".equals(action)) {
                if ("/root.menu.item1.item0deliniconfirm.do".equals(path)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Delete initiator confirmation path");
                    action = this.handleDeleteConfirmation(argReq, argForm, action, messages, iniBusObj);
                } else if ("/root.menu.item1.item0newini.do".equals(path)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"New initiator action path");
                    action = this.handleNewInitiatorPage(argReq, argForm, action, messages);
                } else {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Show all initiators");
                    action = this.handleShowInitiators(argReq, argForm, path, action, messages, iniBusObj);
                }
            } else if ("create".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Create new initiator action");
                action = this.handleCreateNewInitiator(argReq, argForm, action, messages, iniBusObj);
            } else if ("delete".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Initiator delete action");
                this.handleDeleteAction(argForm, argReq, action, messages, iniBusObj);
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Exception in doAction() = " + e.getMessage()));
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.operationfailed.noerrorcode"));
        }
        finally {
            initiators = null;
        }
        if (messages.getErrorMessages().size() > 0 || messages.getWarningMessages().size() > 0 || messages.getInfoMessages().size() > 0) {
            this.saveUserMessages(argReq, messages);
        }
        return this.doForward(argReq, action, argMap);
    }

    private String handleShowInitiators(HttpServletRequest argReq, ActionForm argForm, String path, String action, UserMessages messages, Initiators initiators) {
        block8: {
            String methodName = "handleShowInitiatorPage";
            Trace.methodBegin((Object)((Object)this), (String)methodName);
            T4Interface currentT4 = null;
            if (path != null && path.equals("/root.menu.item1.item0ini.do")) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Comming from array selection");
                currentT4 = this.getSelectedT4(argReq);
            }
            if (currentT4 == null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"No T4 in request; try session");
                currentT4 = this.getCurrentT4(argReq);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Working on current T4 = " + currentT4.getName()));
            }
            action = this.handlePasswordPrompt(action, argForm, argReq);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Action after handle pass = " + action));
            if ("prompt_password".equals(action)) {
                return action;
            }
            if (this.listRequiresRefresh(argReq, "InitiatorsList")) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Getting initiator list for array = " + currentT4.getName()));
                List initiatorList = null;
                try {
                    initiatorList = initiators.listForArray(this.getConfigContext(argReq), currentT4);
                    if (initiatorList != null && initiatorList.size() > 0) {
                        this.setListContext(argReq, "InitiatorsList", initiatorList);
                        break block8;
                    }
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"No initiators in list!; removing list from session");
                    argReq.getSession().removeAttribute("InitiatorsList");
                    this.setListContext(argReq, "InitiatorsList", null);
                }
                catch (ConfigMgmtException cme) {
                    cme.addExceptionContext((Object)argForm);
                    cme.addExceptionContext((Object)initiators);
                    cme.addExceptionContext((Object)currentT4);
                    Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, cme.getExceptionKey()));
                }
            } else {
                this.setListContext(argReq, "InitiatorsList", null);
            }
        }
        return action;
    }

    private void handleDeleteAction(ActionForm argForm, HttpServletRequest argReq, String action, UserMessages messages, Initiators initiators) throws CoreUIBusException {
        String methodName = "handleDeleteAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        List deletes = ((InitiatorForm)argForm).getInitiatorsToDelete();
        if (deletes != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"We have initiators to delete");
            try {
                for (int i = 0; i < deletes.size(); ++i) {
                    InitiatorInterface iniToRemove = (InitiatorInterface)deletes.get(i);
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to remove initiator = " + iniToRemove.getWWN()));
                    initiators.delete(iniToRemove);
                }
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.access.initiator.success.delete"));
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext((Object)argForm);
                cme.addExceptionContext((Object)action);
                cme.addExceptionContext((Object)initiators);
                cme.addExceptionContext(deletes);
                Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.access.initiator.error.delete"));
            }
        }
    }

    private String handleNewInitiatorPage(HttpServletRequest argReq, ActionForm argForm, String action, UserMessages messages) {
        String methodName = "handleNewInitiatorPage";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        InitiatorGroups igBusObj = (InitiatorGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups");
        List allIgs = null;
        try {
            allIgs = igBusObj.listForArray(this.getConfigContext(argReq), this.getCurrentT4(argReq));
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, cme.getExceptionKey()));
        }
        ((InitiatorForm)argForm).setInitiatorGroups(allIgs);
        return action;
    }

    private String handleCreateNewInitiator(HttpServletRequest argReq, ActionForm argForm, String action, UserMessages messages, Initiators iniBusObj) {
        String methodName = "handleCreateNewInitiator";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        InitiatorForm form = (InitiatorForm)argForm;
        ArrayList<InitiatorGroupInterface> igsToAddTo = new ArrayList<InitiatorGroupInterface>();
        String[] selections = argReq.getParameterValues("selections");
        if (selections != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Number of ig selected = " + selections.length));
            int[] intSels = Convert.stringArrayToIntArray((String[])selections);
            if (intSels != null) {
                List allIgs = form.getInitiatorGroups();
                for (int i = 0; i < intSels.length; ++i) {
                    InitiatorGroupInterface ig = (InitiatorGroupInterface)allIgs.get(intSels[i]);
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Adding new initiator to group = " + ig.getName()));
                    igsToAddTo.add(ig);
                }
            }
        }
        String[] args = new String[]{form.getNewName(), this.getCurrentT4(argReq).getName()};
        try {
            iniBusObj.createInitiator(this.getConfigContext(argReq), this.getCurrentT4(argReq), form.getNewName(), form.getNewDescription(), igsToAddTo);
            action = "start";
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.access.new.initiator.success"));
            LogAPI.staticLog((String)"INITIATOR_CREATE", (String[])args, (String[])new String[0]);
        }
        catch (BadParameterException bpe) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, bpe.getMessage(), bpe.getBadParameter()));
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext((Object)argForm);
            cme.addExceptionContext((Object)("action:" + action));
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            if ("error.initiatorCreateError".equals(cme.getExceptionKey())) {
                LogAPI.staticLog((String)"INITIATOR_CREATE_ERROR", (String[])args, (String[])new String[0]);
            }
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.access.new.initiator.error"));
        }
        return action;
    }

    private String handleDeleteConfirmation(HttpServletRequest argReq, ActionForm argForm, String action, UserMessages messages, Initiators initiators) throws BadParameterException, IllegalStateException, ConfigMgmtException {
        String methodName = "handleDeleteConfirmation";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        HttpSession session = argReq.getSession();
        List initiatorList = (List)session.getAttribute("InitiatorsList");
        String[] inisToDelete = argReq.getParameterValues("iniIndicesToDelete");
        try {
            List ds = initiators.extractDeleteSelection(initiatorList, inisToDelete, this.getCurrentT4(argReq), this.getConfigContext(argReq));
            ((InitiatorForm)argForm).setInitiatorsToDelete(ds);
        }
        catch (BadParameterException bpe) {
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, bpe.getMessage()));
            action = "back";
        }
        catch (IllegalStateException ise) {
            ConfigMgmtException cme = new ConfigMgmtException((Exception)ise);
            cme.addExceptionContext(initiatorList);
            cme.addExceptionContext((Object)inisToDelete);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, ise.getMessage()));
            action = "back";
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(initiatorList);
            cme.addExceptionContext((Object)inisToDelete);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, cme.getExceptionKey()));
            action = "back";
        }
        return action;
    }
}

