/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Bindings;
import com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Initiators;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageAccessCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.InitiatorGroupForm;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class InitiatorGroupsAction
extends StorageAccessCoreAction {
    private static final String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)("Path = " + path));
        String action = argReq.getParameter("action");
        Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)("action = " + action));
        if ("/root.menu.item1.item0igdelconfirm.do".equals(path)) {
            return "sa.ig.delete.crumb";
        }
        if ("/root.menu.item1.item0newinigrp.do".equals(path)) {
            return "storage.access.initiator.groups.create.crumb";
        }
        return "storage.access.initiator.groups";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String action;
        block23: {
            String methodName = "doAction";
            Trace.methodBegin((Object)((Object)this), (String)methodName);
            HttpSession session = argReq.getSession();
            action = argAction == null ? "show" : argAction;
            String path = argReq.getServletPath();
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Path = " + path));
            InitiatorGroups iniGroups = null;
            Bindings bindingBusObj = null;
            Initiators iniBusObj = null;
            try {
                T4Interface currentT4 = this.getSelectedT4(argReq);
                if (currentT4 == null) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"No T4 in request; try session");
                    currentT4 = this.getCurrentT4(argReq);
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Working on current T4 = " + currentT4.getName()));
                }
                if ("show".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"SHOW action");
                    if ("/root.menu.item1.item0igdelconfirm.do".equals(path)) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Show ig delete confirm");
                        try {
                            this.handleDeleteConfirmation(argReq, argForm);
                            break block23;
                        }
                        catch (Exception ex) {
                            UserMessages messages = new UserMessages();
                            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, ex.getMessage()));
                            this.saveUserMessages(argReq, messages);
                            action = "back";
                            ActionForward actionForward = this.doForward(argReq, action, argMap);
                            iniGroups = null;
                            return actionForward;
                        }
                    }
                    if ("/root.menu.item1.item0newinigrp.do".equals(path)) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Show create new ig path");
                        if (iniBusObj == null) {
                            iniBusObj = (Initiators)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Initiators");
                        }
                        List allInis = iniBusObj.listForArray(this.getConfigContext(argReq), currentT4);
                        ((InitiatorGroupForm)argForm).setInitiators(allInis);
                    } else {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Resetting the selected indices");
                        ((InitiatorGroupForm)argForm).reset(argMap, argReq);
                        action = this.handlePasswordPrompt(action, argForm, argReq);
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Action after handle pass = " + action));
                        if ("prompt_password".equals(action)) {
                            ActionForward allInis = this.doForward(argReq, action, argMap);
                            return allInis;
                        }
                        if (bindingBusObj == null) {
                            bindingBusObj = (Bindings)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Bindings");
                        }
                        if (iniGroups == null) {
                            iniGroups = (InitiatorGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups");
                        }
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Trying to get NEW ig list");
                        List igList = iniGroups.listForArray(this.getConfigContext(argReq), currentT4);
                        if (igList != null && igList.size() > 0) {
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Have an IG list; size = " + igList.size()));
                            ((InitiatorGroupForm)argForm).setInitiatorGroups(igList);
                        } else {
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No igList; reset list in form");
                            ((InitiatorGroupForm)argForm).setInitiatorGroups(null);
                        }
                        this.setListContext(argReq, "InitiatorGroupsList", igList);
                    }
                    break block23;
                }
                if ("delete".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Delete action");
                    this.handleDeleteAction(argForm, argReq);
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"After delete action; going to BACK action");
                    action = "back";
                } else if ("create".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Create IG action");
                    action = this.handleCreateAction(argForm, argReq);
                }
            }
            catch (Exception e) {
                Trace.verbose((Object)((Object)this), (String)"Exception in doAction()", (Throwable)e);
            }
            finally {
                iniGroups = null;
            }
        }
        return this.doForward(argReq, action, argMap);
    }

    private String handleCreateAction(ActionForm argForm, HttpServletRequest argReq) throws Exception {
        String methodName = "handleCreateAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        String action = "start";
        T4Interface currentT4 = this.getCurrentT4(argReq);
        String[] args = new String[2];
        args[1] = currentT4.getName();
        InitiatorGroups iniGroups = (InitiatorGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups");
        try {
            String newIgName;
            args[0] = newIgName = ((InitiatorGroupForm)argForm).getNewIgName();
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to create new ig; name = " + newIgName));
            ArrayList<InitiatorInterface> inisToAdd = new ArrayList<InitiatorInterface>();
            int[] selectedInis = this.getSelectedIndices(argReq, "selectedIndices");
            if (selectedInis != null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Have initiators to add to the new group");
                List allInis = ((InitiatorGroupForm)argForm).getInitiators();
                for (int i = 0; i < selectedInis.length; ++i) {
                    InitiatorInterface ini = (InitiatorInterface)allInis.get(selectedInis[i]);
                    inisToAdd.add(ini);
                }
            }
            iniGroups.createInitiatorGroup(this.getConfigContext(argReq), newIgName, currentT4, inisToAdd);
            LogAPI.staticLog((String)"INITIATOR_GRP_CREATE", (String[])args, (String[])new String[0]);
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.access.initiator.groups.create.success"));
            this.saveUserMessages(argReq, messages);
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)((Object)this), (String)"ConfigMgmtException trying to create new ig", (Throwable)cme);
            if (cme.getExceptionKey().equals("INITIATOR_GRP_CREATE_ERROR")) {
                LogAPI.staticLog((String)cme.getExceptionKey(), (String[])args, (String[])new String[0]);
            }
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.access.initiator.groups.create.error"));
            this.saveUserMessages(argReq, messages);
            action = "show";
        }
        catch (Exception ex) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"General exception creating volume");
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.access.initiator.groups.create.error"));
            this.saveUserMessages(argReq, messages);
            action = "show";
        }
        return action;
    }

    private void handleDeleteAction(ActionForm argForm, HttpServletRequest argReq) throws CoreUIBusException {
        String methodName = "handleDeleteAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        InitiatorGroups iniGroups = (InitiatorGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups");
        T4Interface currentT4 = this.getCurrentT4(argReq);
        String[] args = new String[2];
        args[1] = currentT4.getName();
        try {
            List deletes = ((InitiatorGroupForm)argForm).getIgsToDelete();
            for (int i = 0; i < deletes.size(); ++i) {
                InitiatorGroupInterface grp = (InitiatorGroupInterface)deletes.get(i);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to delete ig = " + grp.getName()));
                args[0] = grp.getName();
                iniGroups.delete(grp);
                LogAPI.staticLog((String)"INITIATOR_GRP_DELETE", (String[])args, (String[])new String[0]);
            }
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.access.initiator.group.error.delete.ok"));
            this.saveUserMessages(argReq, messages);
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to delete initiator groups", (Throwable)cme);
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.access.initiator.group.error.delete"));
            this.saveUserMessages(argReq, messages);
        }
    }

    private void handleDeleteConfirmation(HttpServletRequest argReq, ActionForm argForm) throws Exception {
        String methodName = "handleDeleteConfirmation";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        int[] intSelections = this.getSelectedIndices(argReq, "selectedIndices");
        if (intSelections == null || intSelections.length <= 0) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No items selected!");
            throw new Exception("error.none.selected");
        }
        List igList = ((InitiatorGroupForm)argForm).getInitiatorGroups();
        ArrayList<InitiatorGroupInterface> igsToDelete = new ArrayList<InitiatorGroupInterface>();
        for (int i = 0; i < intSelections.length; ++i) {
            InitiatorGroupInterface grp = (InitiatorGroupInterface)igList.get(intSelections[i]);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to delete ig = " + grp.getName()));
            igsToDelete.add(grp);
        }
        ((InitiatorGroupForm)argForm).setIgsToDelete(igsToDelete);
        Initiators iniBusObj = (Initiators)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Initiators");
        List affectedInitiators = null;
        try {
            affectedInitiators = iniBusObj.getInitiatorsInGroups(igsToDelete);
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to get initiators in the list of groups", (Throwable)cme);
        }
        ((InitiatorGroupForm)argForm).setAffectedInitiators(affectedInitiators);
    }
}

