/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.access.business.BindingInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Bindings;
import com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Initiators;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageAccessCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.InitiatorGroupForm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class InitiatorGroupEditAction
extends StorageAccessCoreAction {
    private static final String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String methodName = "doAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        String action = argAction == null ? "show" : argAction;
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
        HttpSession session = argReq.getSession();
        InitiatorGroupInterface currentIg = null;
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Path = " + path));
        Volumes volBusObj = null;
        Initiators iniBusObj = null;
        InitiatorGroups igBusObj = null;
        Object bindingsBusObj = null;
        try {
            T4Interface currentT4 = this.getCurrentT4(argReq);
            if ("show".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"SHOW Action");
                if ("/root.menu.item1.item0editig.do".equals(path)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Show action; edit ig page");
                    try {
                        session.removeAttribute("_remove_sel_init_from_G");
                        this.handleIgDetails(argReq, argForm);
                    }
                    catch (Exception ex) {
                        Trace.verbose((Object)((Object)this), (String)"Exception handling details action", (Throwable)ex);
                        UserMessages messages = new UserMessages();
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, ex.getMessage()));
                        this.saveUserMessages(argReq, messages);
                    }
                } else if ("/root.menu.item1.item0confirminirmv.do".equals(path)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Remove confirmation page path");
                    int[] selectedInis = this.getSelectedIndices(argReq, "selectedIndices");
                    if (selectedInis == null || selectedInis.length <= 0) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"No items selected!");
                        session.removeAttribute("_remove_sel_init_from_G");
                        UserMessages messages = new UserMessages();
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.none.selected"));
                        this.saveUserMessages(argReq, messages);
                        action = "edit_ig";
                        return this.doForward(argReq, action, argMap);
                    }
                    session.setAttribute("_remove_sel_init_from_G", (Object)selectedInis);
                    action = "show";
                    String[] selected = argReq.getParameterValues("selectedIndices");
                    ((InitiatorGroupForm)argForm).setSelectedIndices(selected);
                    if (volBusObj == null) {
                        volBusObj = (Volumes)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Volumes");
                    }
                    if (currentIg == null) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Current IG is null; get from session...");
                        currentIg = (InitiatorGroupInterface)session.getAttribute("CurrentIg");
                    }
                    this.handleAffectedVolumes(argForm, argReq, volBusObj, currentIg);
                } else if ("/root.menu.item1.item0addinis.do".equals(path)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Add initiators to IG action");
                    if (iniBusObj == null) {
                        iniBusObj = (Initiators)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Initiators");
                    }
                    this.handleAddInitiatorsAction(argForm, argReq, iniBusObj);
                }
            } else if ("remove".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Final REMOVE action");
                Object initiators = null;
                try {
                    if (currentIg == null) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Current IG is null; get from session...");
                        currentIg = (InitiatorGroupInterface)session.getAttribute("CurrentIg");
                    }
                    this.handleRemoveAction(argForm, currentIg, session);
                    UserMessages messages = new UserMessages();
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.access.initiator.group.removeok"));
                    this.saveUserMessages(argReq, messages);
                    action = "edit_ig";
                }
                catch (Exception e) {
                    Trace.verbose((Object)((Object)this), (String)"Unable to remove initiatorfrom initiator group.", (Throwable)e);
                    UserMessages messages = new UserMessages();
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, e.getMessage()));
                    this.saveUserMessages(argReq, messages);
                }
            } else if ("add_initiators".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Adding initiators to initiator group action");
                currentIg = (InitiatorGroupInterface)session.getAttribute("CurrentIg");
                this.handleFinalAddAction(argForm, argReq, currentIg, igBusObj);
                action = "start";
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"General Exception ", (Throwable)e);
        }
        return this.doForward(argReq, action, argMap);
    }

    private void handleRemoveAction(ActionForm argForm, InitiatorGroupInterface currentIg, HttpSession session) throws Exception {
        String methodName = "handleRemoveAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ArrayList initiators = null;
        if (currentIg != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to remove vgs from ig = " + currentIg.getName()));
            initiators = currentIg.getInitiators();
            int[] selectedInis = (int[])session.getAttribute("_remove_sel_init_from_G");
            session.removeAttribute("_remove_sel_init_from_G");
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Number of selections:" + selectedInis.length));
            try {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Go in loop:");
                for (int i = 0; i < selectedInis.length; ++i) {
                    InitiatorInterface iniToRemove = (InitiatorInterface)initiators.get(selectedInis[i]);
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to remove initiator = " + iniToRemove.getWWN()));
                    currentIg.deleteInitiatorFromGroup(iniToRemove);
                }
            }
            catch (Exception e) {
                Trace.verbose((Object)((Object)this), (String)methodName, (Throwable)e);
                throw new Exception("storage.access.initiator.group.error.remove");
            }
        }
    }

    private void handleFinalAddAction(ActionForm argForm, HttpServletRequest argReq, InitiatorGroupInterface currentIg, InitiatorGroups igBusObj) throws CoreUIBusException {
        String methodName = "handleFinalAddAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        List selectedInitiators = this.getSelectedInitiators(argReq, argForm);
        try {
            if (selectedInitiators != null && selectedInitiators.size() < 1) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"No initiators selected to add");
                UserMessages messages = new UserMessages();
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.access.add.initiator.noneselected"));
                this.saveUserMessages(argReq, messages);
            } else {
                if (igBusObj == null) {
                    igBusObj = (InitiatorGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups");
                }
                igBusObj.addInitiatorsToGroup(currentIg, selectedInitiators);
                UserMessages messages = new UserMessages();
                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.access.initiator.group.addinitiatorsuccess"));
                this.saveUserMessages(argReq, messages);
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to add initiator to initiator group", (Throwable)cme);
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.access.initiator.group.addinitiatorerror"));
            this.saveUserMessages(argReq, messages);
        }
    }

    private void handleAddInitiatorsAction(ActionForm argForm, HttpServletRequest argReq, Initiators iniBusObj) throws CoreUIBusException, ConfigMgmtException {
        String methodName = "handleAddInitiatorsAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        T4Interface currentT4 = this.getCurrentT4(argReq);
        HttpSession session = argReq.getSession();
        if (currentT4 != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to get initiators list for array = " + currentT4.getName()));
            List allInitiators = iniBusObj.listForArray(this.getConfigContext(argReq), currentT4);
            if (allInitiators != null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Got list of all initiators; size = " + allInitiators.size()));
                InitiatorGroupInterface currentIg = (InitiatorGroupInterface)session.getAttribute("CurrentIg");
                ArrayList currentInis = currentIg.getInitiators();
                if (currentInis != null) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("the current ig has initiators; size = " + currentInis.size()));
                }
                for (int i = allInitiators.size() - 1; i >= 0; --i) {
                    InitiatorInterface ini = (InitiatorInterface)allInitiators.get(i);
                    for (int j = 0; j < currentInis.size(); ++j) {
                        InitiatorInterface currini = (InitiatorInterface)currentInis.get(j);
                        if (!ini.getWWN().equals(currini.getWWN()) || !allInitiators.remove(ini)) continue;
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Removed ini since it's already in the group = " + ini.getWWN()));
                    }
                }
            }
            ((InitiatorGroupForm)argForm).setPossibleInitiators(allInitiators);
            this.setListContext(argReq, "possibleInisForIg", allInitiators);
        }
    }

    private void handleAffectedVolumes(ActionForm argForm, HttpServletRequest argReq, Volumes volBusObj, InitiatorGroupInterface currentIg) throws Exception {
        String methodName = "handleAffectedVolumes";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        T4Interface currentT4 = this.getCurrentT4(argReq);
        if (currentIg != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to get affected volumes for ig = " + currentIg.getName()));
            Enumeration affectedVolNames = volBusObj.getAffectedVolumesForInitiatorRemoval(this.getConfigContext(argReq), currentT4, currentIg);
            ArrayList volNames = new ArrayList();
            Enumeration e = affectedVolNames;
            while (e.hasMoreElements()) {
                volNames.add(e.nextElement());
            }
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Found " + volNames.size() + " affected volumes"));
            if (volNames.size() > 0) {
                ((InitiatorGroupForm)argForm).setAffectedVolumeNames(volNames);
            }
        } else {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No ig to get affected volume for");
        }
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String path = argReq.getServletPath();
        String action = argReq.getParameter("action");
        HttpSession session = argReq.getSession();
        if ("/root.menu.item1.item0confirminirmv.do".equals(path) && !"edit_ig".equals(action)) {
            return "storage.access.group.remove.title";
        }
        if ("/root.menu.item1.item0addinis.do".equals(path)) {
            return "storage.access.add.initiator.title";
        }
        try {
            return ((InitiatorGroupInterface)session.getAttribute("CurrentIg")).getName();
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)"Exception trying to get crumb name.");
            return "";
        }
    }

    private List getSelectedInitiators(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getSelectedInitiators";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ArrayList<InitiatorInterface> selectedInitiators = new ArrayList<InitiatorInterface>();
        try {
            int[] selectedIndices = this.getSelectedIndices(argReq, "selectedIndices");
            List initiators = ((InitiatorGroupForm)argForm).getPossibleInitiators();
            if (selectedIndices != null) {
                for (int i = 0; i < selectedIndices.length; ++i) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("ini index selected = " + selectedIndices[i]));
                    selectedInitiators.add((InitiatorInterface)initiators.get(selectedIndices[i]));
                }
                return selectedInitiators;
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to get selected initiators", (Throwable)e);
            return null;
        }
        return selectedInitiators;
    }

    private void handleIgDetails(HttpServletRequest argReq, ActionForm argForm) throws Exception {
        String methodName = "handleIgDetails";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        HttpSession session = argReq.getSession();
        InitiatorGroupInterface currentIg = this.getInitiatorGroupInfo(argReq);
        Bindings bindingsBusObj = (Bindings)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Bindings");
        if (currentIg != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to view details on ig = " + currentIg.getName()));
            session.setAttribute("CurrentIg", (Object)currentIg);
        } else {
            currentIg = (InitiatorGroupInterface)session.getAttribute("CurrentIg");
            if (currentIg == null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"IG is null; can't show details");
                throw new Exception("storage.access.initiator.group.error.cannotfind");
            }
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Got current IG from session = " + currentIg.getName()));
        }
        ((InitiatorGroupForm)argForm).setCurrentIg(currentIg);
        this.setListContext(argReq, "memberInisForIg", currentIg.getInitiators());
        if (currentIg != null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Trying to get bindings for this ig");
            List bindingsList = bindingsBusObj.listForIg(this.getConfigContext(argReq), null, currentIg);
            ArrayList<VolumeGroupInterface> volGrpsList = new ArrayList<VolumeGroupInterface>();
            if (bindingsList != null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Have a bindings list for this ini group");
                for (int i = 0; i < bindingsList.size(); ++i) {
                    BindingInterface bi = (BindingInterface)bindingsList.get(i);
                    volGrpsList.add(bi.getVolumeGroup());
                }
            }
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Saving associated vgs in form; size = " + volGrpsList.size()));
            ((InitiatorGroupForm)argForm).setVolumeGroups(volGrpsList);
        }
    }
}

