/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups;
import com.sun.netstorage.array.mgmt.cfg.ui.business.ProductInfo;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageAccessCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.ImportForm;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ImportAction
extends StorageAccessCoreAction {
    static final String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String action;
        block20: {
            String methodName = "doAction";
            Trace.constructor((Object)((Object)this));
            Trace.methodBegin((Object)((Object)this), (String)methodName);
            action = argAction == null ? "show" : argAction;
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
            HttpSession session = argReq.getSession();
            String path = argReq.getServletPath();
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("PATH = " + path));
            T4s t4BusObj = null;
            ProductInfo product = null;
            ImportForm form = (ImportForm)argForm;
            try {
                if (null == t4BusObj) {
                    t4BusObj = (T4s)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.T4s");
                }
                if ("show".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Import SHOW action");
                    if ("/root.menu.item1.item1seligs.do".equals(path)) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Handle IG to import page action");
                        try {
                            String productInfo;
                            List allArrays = t4BusObj.list(this.getConfigContext(argReq), null);
                            if (allArrays != null && allArrays.size() > 1) {
                                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Have arrays list; size = " + allArrays.size()));
                                form.setArrays(allArrays);
                                if (t4BusObj.getNumberOfHealthyArrays(allArrays) < 2) {
                                    UserMessages messages = new UserMessages();
                                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "sa.multiple.array.notenoughhealthyarrays"));
                                    this.saveUserMessages(argReq, messages);
                                    action = "back";
                                    return this.doForward(argReq, action, argMap);
                                }
                            } else {
                                UserMessages messages = new UserMessages();
                                messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "sa.multiple.array.notenougharrays"));
                                this.saveUserMessages(argReq, messages);
                                action = "back";
                            }
                            if ((productInfo = form.getProductName()) == null) {
                                if (product == null) {
                                    product = (ProductInfo)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.ProductInfo");
                                }
                                try {
                                    productInfo = product.getProductName(this.getConfigContext(argReq));
                                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("product info = " + productInfo));
                                    form.setProductName(productInfo);
                                }
                                catch (Exception e) {
                                    form.setProductName(null);
                                    Trace.verbose((Object)((Object)this), (String)"Exception getting product info", (Throwable)e);
                                    UserMessages messages = new UserMessages();
                                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(1, "error.productinfo"));
                                    this.saveUserMessages(argReq, messages);
                                }
                            }
                            this.handleIGSelectionDisplay(argReq, argForm);
                            form.setHasErrors(false);
                        }
                        catch (Exception e) {
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Exception trying to handle import page; go back");
                            action = "back";
                            form.setHasErrors(true);
                            UserMessages messages = new UserMessages();
                            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, e.getMessage()));
                            this.saveUserMessages(argReq, messages);
                        }
                        break block20;
                    }
                    if ("/root.menu.item1.item1seltargets.do".equals(path)) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Handle target selection page display action");
                        try {
                            this.handleTargetSelectionDisplay(argReq, argForm);
                            form.setHasErrors(false);
                        }
                        catch (Exception e) {
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Exception trying to handle target selection page display action; go back");
                            action = "back";
                            form.setHasErrors(true);
                            UserMessages messages = new UserMessages();
                            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, e.getMessage()));
                            this.saveUserMessages(argReq, messages);
                        }
                    }
                    break block20;
                }
                if ("import".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Import action!");
                    try {
                        this.handleImport(argReq, argForm);
                        UserMessages messages = new UserMessages();
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "sa.import.success"));
                        this.saveUserMessages(argReq, messages);
                        form.setHasErrors(false);
                    }
                    catch (Exception e) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Exception trying to handle import");
                        action = "show";
                        form.setHasErrors(true);
                        UserMessages messages = new UserMessages();
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, e.getMessage()));
                        this.saveUserMessages(argReq, messages);
                    }
                }
            }
            catch (Exception e) {
                Trace.verbose((Object)((Object)this), (String)"Exception in doAction", (Throwable)e);
                this.handleSystemError(argReq, e);
            }
        }
        return this.doForward(argReq, action, argMap);
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getBreadCrumbName";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        String path = argReq.getServletPath();
        String action = argReq.getParameter("action");
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Path = " + path));
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
        ImportForm form = (ImportForm)argForm;
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Form has errors?  " + form.getHasErrors()));
        if ("/root.menu.item1.item1seligs.do".equals(path) && !form.getHasErrors()) {
            return "sa.import.ig.select.crumb";
        }
        if ("/root.menu.item1.item1seltargets.do".equals(path) && !form.getHasErrors()) {
            return "sa.import.target.crumb";
        }
        return "sa.multiple.array.crumb";
    }

    private void handleIGSelectionDisplay(HttpServletRequest argReq, ActionForm argForm) throws Exception {
        String methodName = "handleIgSelectionDisplay";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ImportForm form = (ImportForm)argForm;
        try {
            T4Interface source = this.getSelectedT4(argReq);
            if (source == null) {
                if (form.getSourceArray() == null) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Unable to get source array");
                    throw new Exception("sa.import.ig.error.sourcenotfound");
                }
                source = form.getSourceArray();
            }
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Got source array = " + source.getName()));
            form.setSourceArray(source);
            InitiatorGroups igBusObj = (InitiatorGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups");
            List possibleIgs = igBusObj.listForArray(this.getConfigContext(argReq), source);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Got list of igs to import = " + possibleIgs.size()));
            form.setPossibleIgs(possibleIgs);
            if (possibleIgs == null || possibleIgs.size() < 1) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"No possible igs to import");
                throw new Exception("sa.import.ig.error.noigstoimport");
            }
        }
        catch (NumberFormatException nfe) {
            Trace.verbose((Object)((Object)this), (String)"Exception parsing the selected index", (Throwable)nfe);
        }
    }

    private void handleTargetSelectionDisplay(HttpServletRequest argReq, ActionForm argForm) throws Exception {
        String methodName = "handleTargetSelectionDisplay";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ImportForm form = (ImportForm)argForm;
        List allArrays = form.getArrays();
        if (allArrays == null) {
            throw new ConfigMgmtException("sa.multiple.array.notenoughhealthyarrays", "sa.multiple.array.notenoughhealthyarrays");
        }
        T4Interface source = form.getSourceArray();
        for (int i = 0; i < allArrays.size(); ++i) {
            T4Interface t4 = (T4Interface)allArrays.get(i);
            if (!t4.getName().equals(source.getName())) continue;
            allArrays.remove(t4);
        }
        int[] selections = this.getSelectedIndices(argReq, "igsSelected");
        if (selections == null || selections.length < 1) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No igs selected to import");
            throw new Exception("error.none.selected");
        }
        List possibleIgs = form.getPossibleIgs();
        ArrayList<InitiatorGroupInterface> igsToImport = new ArrayList<InitiatorGroupInterface>();
        for (int i = 0; i < selections.length; ++i) {
            InitiatorGroupInterface ig = (InitiatorGroupInterface)possibleIgs.get(selections[i]);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Selected ig to import = " + ig.getName()));
            igsToImport.add(ig);
        }
        form.setIgsToImport(igsToImport);
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Number of IGS to import:" + form.getIgsToImport().size()));
    }

    private void handleImport(HttpServletRequest argReq, ActionForm argForm) throws Exception {
        String methodName = "handleImport";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ImportForm form = (ImportForm)argForm;
        int[] selections = this.getSelectedIndices(argReq, "selectedDests");
        if (selections == null || selections.length < 1) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No destinations selected");
            throw new Exception("error.none.selected");
        }
        ArrayList<T4Interface> destinations = new ArrayList<T4Interface>();
        List allArrays = form.getArrays();
        for (int i = 0; i < selections.length; ++i) {
            T4Interface t4 = (T4Interface)allArrays.get(selections[i]);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Selected destination array = " + t4.getName()));
            destinations.add(t4);
        }
        String[] args = new String[3];
        args[1] = form.getSourceArray().getName();
        try {
            InitiatorGroups igBusObj = (InitiatorGroups)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.InitiatorGroups");
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Number of IGS to import:" + form.getIgsToImport().size()));
            igBusObj.importInitiatorGroups(this.getConfigContext(argReq), destinations, form.getSourceArray(), form.getIgsToImport());
            List igsToImport = form.getIgsToImport();
            for (int j = 0; j < destinations.size(); ++j) {
                T4Interface dest = (T4Interface)destinations.get(j);
                args[2] = dest.getName();
                for (int k = 0; k < igsToImport.size(); ++k) {
                    InitiatorGroupInterface ig = (InitiatorGroupInterface)igsToImport.get(k);
                    args[0] = ig.getName();
                    LogAPI.staticLog((String)"INITIATOR_GRP_IMPORT", (String[])args, (String[])new String[0]);
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to import ig", (Throwable)cme);
            if ("INITIATOR_GRP_IMPORT_ERROR".equals(cme.getExceptionKey())) {
                LogAPI.staticLog((String)"INITIATOR_GRP_IMPORT_ERROR", (String[])args, (String[])new String[0]);
            }
            throw new Exception("sa.import.error");
        }
    }
}

