/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.actions.StoragePoolsAction;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.PoolForm;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class DeletePoolsAction
extends StoragePoolsAction {
    private static final String MENU_SUB_ITEM = ".item0";

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        HttpSession session = argReq.getSession();
        String action = argAction == null ? "show" : argAction;
        String methodName = "doAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        try {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
            if ("show".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Show Delete confirmation action");
                action = this.performPreDeleteAction(argForm, argReq, action);
            } else if ("confirm_delete".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Confirm Delete action; perform delete");
                action = this.handleDeleteConfirmation(argForm, argReq);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("After delete; change action = " + action));
            }
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext((Object)"ConfigMgmtException in doAction");
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, cme);
        }
        catch (Exception e) {
            ConfigMgmtException cme = new ConfigMgmtException(e);
            cme.addExceptionContext((Object)"General exception in doAction");
            this.handleSystemError(argReq, e);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
        }
        return this.doForward(argReq, action, argMap);
    }

    private String performPreDeleteAction(ActionForm argForm, HttpServletRequest argReq, String action) throws CoreUIBusException, ConfigMgmtException {
        String methodName = "performPreDeleteAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        if (!this.havePoolSelections(argForm, argReq, "storage.mgmt.system.expert.pools.delete.noneselectederror")) {
            String comingFrom = ((PoolForm)argForm).getComingFrom();
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("PAGE COMING FROM = " + comingFrom));
            action = comingFrom;
        } else {
            this.setAffectedVolumes(argReq, ((PoolForm)argForm).getSelectedPools(), argForm);
        }
        return action;
    }

    private String handleDeleteConfirmation(ActionForm argForm, HttpServletRequest argReq) {
        String methodName = "handleDeleteConfirmation";
        List selectedPools = ((PoolForm)argForm).getSelectedPools();
        String action = ((PoolForm)argForm).getComingFrom();
        try {
            StoragePools poolBusObj = (StoragePools)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools");
            T4Interface currentT4 = this.getCurrentT4(argReq);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to delete selected pools..." + selectedPools.size()));
            String[] args = new String[2];
            args[1] = currentT4.getName();
            ArrayList methodCallStatuses = new ArrayList();
            for (int i = 0; i < selectedPools.size(); ++i) {
                RaidGroupInterface poolToDelete = (RaidGroupInterface)selectedPools.get(i);
                args[0] = poolToDelete.getName();
                args[1] = currentT4.getName();
                methodCallStatuses.addAll(poolBusObj.delete(poolToDelete));
                if (poolBusObj.hasErrorsInMethodCallStatus((MethodCallStatus)methodCallStatuses.get(i))) {
                    LogAPI.staticLog((String)"POOL_DELETE_ERROR", (String[])args, (String[])new String[0]);
                    continue;
                }
                if (Jobs.hasJobsInMethodCallStatuses(methodCallStatuses)) continue;
                LogAPI.staticLog((String)"POOL_DELETE", (String[])args, (String[])new String[0]);
            }
            currentT4.reload();
            this.resetArray(argReq, currentT4);
            if (poolBusObj.hasErrorsInMethodCallStatuses(methodCallStatuses)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Found errors in method call statuses");
                throw new Exception("Exception trying to delete pool.");
            }
            this.storeMethodCallStatuses(argReq, methodCallStatuses);
            this.setConfirmationMessage(argReq, "storage.mgmt.system.expert.pools.delete.confirm");
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext((Object)"ConfigMgmtException trying to delete pools");
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.system.expert.pools.delete.error"));
            this.saveUserMessages(argReq, messages);
        }
        catch (Exception ex) {
            ConfigMgmtException cme = new ConfigMgmtException(ex);
            cme.addExceptionContext((Object)"Exception trying to delete storage pool");
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.system.expert.pools.delete.error"));
            this.saveUserMessages(argReq, messages);
        }
        return action;
    }

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)("PATH in bread crumb = " + path));
        if (path != null && "/root.menu.item0.item2poolsdelete.do".equals(path)) {
            return "storage.mgmt.system.expert.pools.delete.crumb";
        }
        return "storage.mgmt.system.expert.pools";
    }
}

