/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfiles;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import com.sun.netstorage.array.mgmt.cfg.ui.actions.WizardContent;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Jobs;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Trays;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.PoolCreateForm;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CreatePoolWizard
extends WizardContent
implements Constants.Exceptions {
    public ActionForward openWizard(int defaultPage, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "openWizard";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ((PoolCreateForm)argForm).doReset();
        this.handleTrayListing(argReq, argForm);
        return null;
    }

    protected void handleTrayListing(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "handleTrayListing";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        T4Interface currentT4 = this.getCurrentT4(argReq);
        Trays trayBusObj = (Trays)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Trays");
        List traysWithSpace = trayBusObj.getTraysWithSpace(currentT4);
        if (traysWithSpace == null || traysWithSpace.isEmpty()) {
            this.saveSingleUserMessage(argReq, 0, "pool.creation.error.notrays.withspace");
            argReq.getSession().setAttribute("disableNext", (Object)"true");
            ((PoolCreateForm)argForm).setTraysWithSpace(null);
        } else {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Have some trays with space; storing in form...");
            ((PoolCreateForm)argForm).setTraysWithSpace(traysWithSpace);
            if (argReq.getParameter("context") != null) {
                String trayId = argReq.getParameter("context");
                Trace.verbose((Object)((Object)this), (String)"handleTrayListing", (String)("TRAY TO MODIFY:" + trayId));
                TrayInterface tray = null;
                for (int i = 0; i < traysWithSpace.size() && tray == null; ++i) {
                    if (!trayId.equals(((TrayInterface)traysWithSpace.get(i)).getId())) continue;
                    tray = (TrayInterface)traysWithSpace.get(i);
                    Trace.verbose((Object)((Object)this), (String)"handleTrayListing", (String)"FOUND TRAY TO MODIFY");
                    ((PoolCreateForm)argForm).setTrayToModify(tray);
                }
            }
        }
    }

    protected void handleProfileList(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "handleProfileList";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        try {
            PoolCreateForm form = (PoolCreateForm)argForm;
            Profiles profilesBusObj = (Profiles)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles");
            List allProfiles = new ArrayList();
            if (form.getTrayToModify() != null) {
                ArrayList<TrayInterface> traysTmpList = new ArrayList<TrayInterface>();
                traysTmpList.add(form.getTrayToModify());
                allProfiles = ManageStorageProfiles.getInstance().getEligibleProfilesForTrays(traysTmpList, this.getCurrentT4(argReq));
            } else {
                allProfiles = ManageStorageProfiles.getInstance().getEligibleProfilesForTrays(form.getTraysWithSpace(), this.getCurrentT4(argReq));
            }
            form.setAllProfiles(allProfiles);
            int arrayConfigurationType = this.getCurrentT4(argReq).getArrayConfigurationType();
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to get array types for configuration = " + arrayConfigurationType));
            form.setPossibleArrayTypes(ManageStorageProfiles.getInstance().getPossibleArrayTypesForArray(arrayConfigurationType));
            form.setNewArrayType(ManageStorageProfiles.getInstance().getBestMatchArrayTypeForArray(arrayConfigurationType));
        }
        catch (Exception e) {
            this.saveSingleUserMessage(argReq, 0, "storage.mgmt.profile.summary.error");
            argReq.getSession().setAttribute("disableNext", (Object)"true");
        }
    }

    public ActionForward prepareDisplay(int pageNum, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "prepareDisplay";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        PoolCreateForm form = (PoolCreateForm)argForm;
        try {
            switch (pageNum) {
                case 2: {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Preparing Display for PAGE 2");
                    this.handleProfileList(argReq, form);
                    break;
                }
                case 3: {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"PrepareDisplay for page 3");
                    StorageProfile selProfile = form.getSelectedProfileObject();
                    if (!"variable".equals(selProfile.getNumberOfDrives())) break;
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Profile has variable number of drives; calculate the disks numbers to choose from");
                    Trays trayBusObj = (Trays)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Trays");
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Trying to get disk number list");
                    boolean profileUsesDedHS = selProfile.getDedicatedHotSpare() == 1;
                    List diskList = trayBusObj.createDiskNumberList(selProfile.getMinNeededDataDrives(), form.getTrayToModify().getDisksAvailableForPool(profileUsesDedHS).size());
                    if (diskList == null || diskList.isEmpty()) {
                        UserMessages messages = new UserMessages();
                        UserMessage message = new UserMessage(0, "pool.createwiz.notenoughdisks.message");
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
                        this.saveUserMessages(argReq, messages);
                        this.updateWizard(argReq, 2, null);
                        return argMapping.findForward("page2");
                    }
                    form.setPossibleDisksToAssign(diskList);
                    form.setDisksToAssign((Integer)diskList.get(diskList.size() - 1));
                    break;
                }
                case 4: {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Preparing page 4 display (confirmation page)");
                    this.handleWastedDisks(argReq, form.getPoolBreakdowns());
                }
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)("Exception trying to prepare display for page = " + pageNum), (Throwable)e);
        }
        return null;
    }

    public ActionForward processInput(int pageNum, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "processInput";
        UserMessages messages = new UserMessages();
        try {
            HttpSession session = argReq.getSession();
            PoolCreateForm form = (PoolCreateForm)argForm;
            switch (pageNum) {
                case 1: {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"process input for page 1");
                    return this.processInputForPage1(argReq, form, argMapping);
                }
                case 2: {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Process input for page 2");
                    return this.processProfileSelection(argReq, form, argMapping, pageNum);
                }
                case 3: {
                    PoolBreakdownForTray breakdownObj;
                    boolean hotspareValue;
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Process input for page 3");
                    if (!"nextPage".equals(this.getWizardAction(argReq))) break;
                    int disksSelected = form.getDisksToAssign();
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Selected disks = " + disksSelected));
                    boolean bl = hotspareValue = form.getSelectedProfileObject().getDedicatedHotSpare() == 1;
                    if (!this.getCurrentT4(argReq).isFeatureSupported(4)) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Dedicated hot spare is NOT supported; use value from form");
                        boolean bl2 = hotspareValue = form.getHotSpare() == 1;
                    }
                    if ((breakdownObj = form.getTrayToModify().getPoolBreakdownForTray(1, disksSelected, form.getSelectedProfileObject().getRaidLevel(), hotspareValue)) != null && breakdownObj.canBeSupported()) {
                        breakdownObj.setSuggestedName(0, form.getNewPoolName());
                    }
                    ArrayList<PoolBreakdownForTray> breakdowns = new ArrayList<PoolBreakdownForTray>();
                    breakdowns.add(breakdownObj);
                    form.setPoolBreakdowns(breakdowns);
                    ActionForward af = this.validateAllNewPoolNames(argReq, argMapping, breakdowns, 3);
                    if (af != null) {
                        return af;
                    }
                    return this.validateAndForwardBreakdowns(argReq, argMapping, breakdowns, 3);
                }
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)((Object)this), (String)"Exception processing input", (Throwable)ex);
        }
        ActionForward actionForward = this.handleWizardErrors(argReq, argMapping, messages, pageNum);
        return actionForward;
    }

    protected void handleWastedDisks(HttpServletRequest argReq, List breakdowns) {
        String methodName = "handleWastedDisks";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        UserMessages messages = new UserMessages();
        Iterator it = breakdowns.iterator();
        while (it.hasNext()) {
            PoolBreakdownForTray pb = (PoolBreakdownForTray)it.next();
            if (pb.getNumWastedDisks() <= 0) continue;
            if (Trace.isTraceEnabled((Object)((Object)this))) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("found wasted disks (" + pb.getNumWastedDisks() + ") for tray id (" + pb.getTrayId() + ")"));
            }
            T4Interface currentT4 = this.getCurrentT4(argReq);
            try {
                if (currentT4 != null && currentT4.isFeatureSupported(3)) {
                    int tempAhsPoolSize = currentT4.getAhsPoolSize() + pb.getNumWastedDisks();
                    if (tempAhsPoolSize <= currentT4.getMaxAhsPoolSizeAllowed()) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"The current AHS pool size is less than the max ahs size allowed");
                        UserMessage message = new UserMessage(1, "pool.creation.wasted.disks.ahs", "" + pb.getNumWastedDisks(), pb.getTrayId());
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
                        continue;
                    }
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"We have more wasted disks than what is allowed for an ahs pool");
                    int disksLeftForAhs = currentT4.getMaxAhsPoolSizeAllowed() - currentT4.getAhsPoolSize();
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Number of disks left for ahs = " + disksLeftForAhs));
                    int wasteWithAhs = pb.getNumWastedDisks() - disksLeftForAhs;
                    UserMessage message = new UserMessage(1, "pool.creation.wasted.disks.ahs.withwasted", "" + pb.getNumWastedDisks(), pb.getTrayId(), "" + disksLeftForAhs, "" + wasteWithAhs);
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
                    continue;
                }
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Showing wasted message for no AHS");
                UserMessage message = new UserMessage(1, "pool.creation.wasted.disks", "" + pb.getNumWastedDisks(), pb.getTrayId());
                messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
            }
            catch (Exception e) {
                Trace.verbose((Object)((Object)this), (String)"An error occured trying to get ahs info", (Throwable)e);
            }
        }
        if (!messages.empty()) {
            this.saveUserMessages(argReq, messages);
        }
    }

    protected ActionForward validateAllNewPoolNames(HttpServletRequest argReq, ActionMapping argMapping, List breakdowns, int pageNumber) {
        String methodName = "validateAllNewPoolNames";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        UserMessages messages = new UserMessages();
        StoragePools poolsBusObj = (StoragePools)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools");
        T4Interface currentT4 = this.getCurrentT4(argReq);
        List currentPools = null;
        try {
            currentPools = poolsBusObj.getPoolsInT4(this.getConfigContext(argReq), currentT4);
        }
        catch (CoreUIBusException cbe) {
            Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException((Exception)cbe));
            this.handleSystemError(argReq, cbe);
        }
        Iterator it = breakdowns.iterator();
        while (it.hasNext()) {
            PoolBreakdownForTray pb = (PoolBreakdownForTray)it.next();
            for (int i = 0; i < pb.getNumPools(); ++i) {
                try {
                    poolsBusObj.validateName(pb.getSuggestedName(i), currentT4, this.getConfigContext(argReq), currentPools);
                    continue;
                }
                catch (BadParameterException bpe) {
                    UserMessage message;
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Invalid pool name");
                    if ("error.resourceAlreadyExists".equals(bpe.getMessage())) {
                        message = new UserMessage(0, "pool.createwiz.alreadyexists.message", pb.getTrayId());
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
                        continue;
                    }
                    message = new UserMessage(0, "pool.createwiz.invalidname.message", bpe.getBadParameter());
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
                    continue;
                }
                catch (ConfigMgmtException cme) {
                    this.handleSystemError(argReq, cme);
                }
            }
        }
        if (!messages.empty()) {
            this.saveUserMessages(argReq, messages);
            this.updateWizard(argReq, pageNumber, null);
            return argMapping.findForward("page" + pageNumber);
        }
        return null;
    }

    protected ActionForward validateAndForwardBreakdowns(HttpServletRequest argReq, ActionMapping argMapping, List breakdowns, int pageNumber) {
        String methodName = "validateAndForwardBreakdowns";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        UserMessages messages = new UserMessages();
        Iterator it = breakdowns.iterator();
        while (it.hasNext()) {
            PoolBreakdownForTray pb = (PoolBreakdownForTray)it.next();
            if (pb.canBeSupported()) continue;
            int failure = pb.getFailureReason();
            if (Trace.isTraceEnabled((Object)((Object)this))) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Can not create pool with the selected values reason code: " + failure));
            }
            UserMessage message = new UserMessage(0, "pool.creation.error." + failure, pb.getTrayId());
            messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
        }
        if (!messages.empty()) {
            this.saveUserMessages(argReq, messages);
            this.updateWizard(argReq, pageNumber, null);
            return argMapping.findForward("page" + pageNumber);
        }
        return null;
    }

    private ActionForward processInputForPage1(HttpServletRequest argReq, PoolCreateForm form, ActionMapping argMapping) throws ConfigMgmtException, ItemNotFoundException {
        String methodName = "processInputForPage1";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        UserMessages messages = new UserMessages();
        List spaceTrays = form.getTraysWithSpace();
        String selectedTrayIndex = argReq.getParameter("index");
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("selected tray index from parameter = " + selectedTrayIndex));
        if (selectedTrayIndex == null) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No tray was selected");
            UserMessage message = new UserMessage(0, "pool.creation.notraysselected");
            messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
            this.saveUserMessages(argReq, messages);
            this.updateWizard(argReq, 1, null);
            return argMapping.findForward("page1");
        }
        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Trying to find tray object at the index selected");
        int trayIndex = Integer.parseInt(selectedTrayIndex);
        TrayInterface trayToModify = (TrayInterface)spaceTrays.get(trayIndex);
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Got tray to modify = " + trayToModify.getId()));
        form.setTrayToModify(trayToModify);
        return null;
    }

    public ActionForward processProfileSelection(HttpServletRequest argReq, PoolCreateForm form, ActionMapping argMapping, int pageNum) throws Exception {
        String methodName = "processProfileSelection";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        UserMessages messages = new UserMessages();
        String newProfileName = form.getNewProfileName();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("get new profile = " + newProfileName));
        if (newProfileName == null && "nextPage".equals(this.getWizardAction(argReq))) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No profile selected");
            UserMessage message = new UserMessage(0, "configure.storage.wizard.noprofileselected");
            messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
            this.saveUserMessages(argReq, messages);
            this.updateWizard(argReq, pageNum, null);
            return argMapping.findForward("page" + pageNum);
        }
        if ("< Create New Profile >".equals(newProfileName)) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Selecting to create a new profile...");
            form.setNewProfileName(newProfileName);
            this.handleReadonlyFields(argReq, form);
            if ("nextPage".equals(this.getWizardAction(argReq))) {
                int newArrayType = Integer.parseInt(argReq.getParameter("newArrayType"));
                form.setNewArrayType(newArrayType);
                StorageProfile newProfileObject = new StorageProfile(form.getNewName(), form.getNewDescription(), form.getNewRaidLevel(), form.getNewSegmentSize(), form.getNewReadaheadMode(), "variable", form.getNewDedicatedHotSpare(), form.getNewArrayType());
                form.setNewProfileName(form.getNewName());
                Profiles profileBusObj = (Profiles)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles");
                try {
                    form.setSelectedProfileObject(newProfileObject);
                    newProfileObject.validateProfileIntegrity();
                    profileBusObj.getDuplicateProfiles(this.getConfigContext(argReq), newProfileObject);
                    profileBusObj.validateNameAndDesc(newProfileObject);
                }
                catch (BadParameterException bpe) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Invalid profile name or description entered");
                    if (bpe.getBadParameter() != null) {
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, bpe.getMessage(), bpe.getBadParameter()));
                    } else if (bpe.getMsgParams() != null && bpe.getMsgParams().length > 1) {
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, bpe.getMessage(), bpe.getMsgParams()[0], bpe.getMsgParams()[1]));
                    } else {
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.operationfailed.noerrorcode"));
                    }
                }
                catch (ConfigMgmtException cme) {
                    if ("error.objectAlreadyExists".equals(cme.getExceptionKey())) {
                        form.setNewProfileName("< Create New Profile >");
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Found profile with given name that already exists");
                        UserMessage message = new UserMessage(0, "configure.storage.wizard.create.new.alreadyexists");
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
                    }
                    UserMessage message = new UserMessage(0, cme.getExceptionKey(), form.getNewName());
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
                }
                if (!messages.empty()) {
                    this.saveUserMessages(argReq, messages);
                    this.updateWizard(argReq, pageNum, null);
                    return argMapping.findForward("page" + pageNum);
                }
            }
        } else {
            form.setNewName(null);
            StorageProfile selectedProfile = ManageStorageProfiles.getInstance().getProfile(newProfileName);
            form.setSelectedProfileObject(selectedProfile);
        }
        return null;
    }

    protected void handleReadonlyFields(HttpServletRequest argReq, PoolCreateForm form) throws Exception {
        String methodName = "handleReadonlyFields in create pool";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        Trays trayBusObj = (Trays)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Trays");
        StoragePools poolsBusObj = (StoragePools)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools");
        if (form.getTrayToModify() != null) {
            ArrayList<TrayInterface> traysTmpList = new ArrayList<TrayInterface>();
            traysTmpList.add(form.getTrayToModify());
            form.setCanHaveRaid5(trayBusObj.isRaid5ValidForAllTrays(traysTmpList));
            form.setCanHaveDedicatedHs(trayBusObj.canAnyTrayHaveDedicatedHs(traysTmpList));
        } else {
            form.setCanHaveRaid5(trayBusObj.isRaid5ValidForAllTrays(form.getTraysWithSpace()));
            form.setCanHaveDedicatedHs(trayBusObj.canAnyTrayHaveDedicatedHs(form.getTraysWithSpace()));
        }
        List allPools = poolsBusObj.getPoolsInT4(this.getConfigContext(argReq), this.getCurrentT4(argReq));
        form.setCanChangeSegmentSize(allPools != null && allPools.isEmpty());
        if (form.canChangeSegmentSize()) {
            try {
                form.setNewSegmentSize(this.getCurrentT4(argReq).getBlockSize());
                form.setNewReadaheadMode(this.getCurrentT4(argReq).getReadaheadMode() > 0 ? 1 : 0);
            }
            catch (Exception ex) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Swallowing exception; will not have default values");
            }
        }
    }

    public ActionForward finishWizard(int lastPage, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "finishWizard";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        return this.handlePoolCreation(lastPage, argReq, argMapping, (PoolCreateForm)argForm);
    }

    protected ActionForward handlePoolCreation(int pageNum, HttpServletRequest argReq, ActionMapping argMapping, PoolCreateForm form) {
        String methodName = "handlePoolCreation";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        UserMessages messages = new UserMessages();
        String[] args = new String[2];
        args[1] = this.getCurrentT4(argReq).getName();
        try {
            if (form.getNewName() != null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"We have to create a new profile before pool");
                try {
                    Profiles profileBusObj = (Profiles)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Profiles");
                    profileBusObj.createProfile(this.getConfigContext(argReq), form.getSelectedProfileObject());
                }
                catch (Exception ex) {
                    Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(ex));
                    messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.profile.create.error"));
                    return null;
                }
            }
            List breakdowns = form.getPoolBreakdowns();
            ArrayList<MethodCallStatus> results = new ArrayList<MethodCallStatus>();
            StoragePools poolsBusObj = (StoragePools)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools");
            Iterator it = breakdowns.iterator();
            while (it.hasNext()) {
                PoolBreakdownForTray pb = (PoolBreakdownForTray)it.next();
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("\n Creating pool on tray = " + pb.getTrayId()));
                for (int i = 0; i < pb.getNumPools(); ++i) {
                    if (Trace.isTraceEnabled((Object)((Object)this))) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Creating pool (" + i + ")" + " with number of disks (" + pb.getNumDisks(i) + ")" + " with name (" + pb.getSuggestedName(i) + ")"));
                    }
                    int spare = pb.getUseSpare() ? 1 : 0;
                    MethodCallStatus result = poolsBusObj.createRaidGroup(this.getConfigContext(argReq), this.getCurrentT4(argReq), pb.getTray(), pb.getSuggestedName(i), pb.getDisksForPool(i), form.getSelectedProfileObject(), spare);
                    results.add(result);
                    args[0] = pb.getSuggestedName(i);
                    this.handleStatusLogging(poolsBusObj, result, args);
                }
            }
            this.storeMethodCallStatuses(argReq, results);
        }
        catch (ConfigMgmtException cme) {
            String exceptionKey = cme.getExceptionKey();
            if (exceptionKey.equals("POOL_CREATE_ERROR") || exceptionKey.equals("POOL_CREATE_DISK_OFFLINE_ERROR")) {
                LogAPI.staticLog((String)"POOL_CREATE_ERROR", (String[])args, (String[])new String[0]);
            } else if (exceptionKey.equals("POOL_CREATE_ERROR_DEGRADED")) {
                LogAPI.staticLog((String)exceptionKey, (String[])args, (String[])new String[0]);
            }
            String message = "pool.creation.error";
            if ("POOL_CREATE_DISK_OFFLINE_ERROR".equals(exceptionKey)) {
                message = "pool.creation.error.5";
            }
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, message));
            cme.addExceptionContext((Object)form);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
        }
        catch (Exception ex) {
            Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(ex));
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "pool.creation.error"));
        }
        if (!messages.empty()) {
            this.saveUserMessages(argReq, messages);
            return this.handleWizardErrors(argReq, argMapping, messages, pageNum);
        }
        return null;
    }

    private void handleStatusLogging(StoragePools poolBusObj, MethodCallStatus callStatus, String[] args) {
        String methodName = "handlesStatusLogging";
        if (poolBusObj.hasErrorsInMethodCallStatus(callStatus)) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Found error in return status object!");
            LogAPI.staticLog((String)"POOL_CREATE_ERROR", (String[])args, (String[])new String[0]);
        } else {
            ArrayList<MethodCallStatus> statuses = new ArrayList<MethodCallStatus>();
            statuses.add(callStatus);
            if (!Jobs.hasJobsInMethodCallStatuses(statuses)) {
                LogAPI.staticLog((String)"POOL_CREATE", (String[])args, (String[])new String[0]);
            }
        }
    }
}

