/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import com.sun.netstorage.array.mgmt.cfg.ui.actions.CreatePoolWizard;
import com.sun.netstorage.array.mgmt.cfg.ui.business.TrayForProfile;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Trays;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.PoolCreateForm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ConfigStorageByProfileWizard
extends CreatePoolWizard {
    public ActionForward openWizard(int defaultPage, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "openWizard";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        ((PoolCreateForm)argForm).doReset();
        this.handleTrayListing(argReq, argForm);
        List trays = ((PoolCreateForm)argForm).getTraysWithSpace();
        if (trays != null && !trays.isEmpty()) {
            this.handleProfileList(argReq, argForm);
        }
        return null;
    }

    public ActionForward prepareDisplay(int pageNum, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "prepareDisplay";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        PoolCreateForm form = (PoolCreateForm)argForm;
        try {
            switch (pageNum) {
                case 2: {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Preparing Display for PAGE 2");
                    Trays trayBusObj = (Trays)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Trays");
                    List traysForProfile = trayBusObj.getTraysForProfile(form.getTraysWithSpace(), form.getSelectedProfileObject());
                    if (traysForProfile != null && !traysForProfile.isEmpty()) {
                        form.setTraysForProfile(traysForProfile);
                        break;
                    }
                    argReq.getSession().setAttribute("disableNext", (Object)"true");
                    form.setTraysForProfile(null);
                    break;
                }
                case 4: {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Preparing page 4 display (confirmation page)");
                    this.handleWastedDisks(argReq, form.getPoolBreakdowns());
                }
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)("Exception trying to prepare display for page = " + pageNum), (Throwable)e);
        }
        return null;
    }

    public ActionForward processInput(int pageNum, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "processInput";
        UserMessages messages = new UserMessages();
        try {
            PoolCreateForm form = (PoolCreateForm)argForm;
            switch (pageNum) {
                case 1: {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"process input for page 1");
                    return this.processProfileSelection(argReq, form, argMapping, pageNum);
                }
                case 2: {
                    if (!"nextPage".equals(this.getWizardAction(argReq))) break;
                    boolean isDedicatedSupported = this.getCurrentT4(argReq).isFeatureSupported(3);
                    String[] checkboxesSelected = argReq.getParameterValues("checkboxid");
                    String[] allhotspares = null;
                    if (!isDedicatedSupported) {
                        allhotspares = argReq.getParameterValues("hotspare");
                    }
                    String[] alldisks = argReq.getParameterValues("numdisks");
                    String[] allpools = argReq.getParameterValues("numpools");
                    if (checkboxesSelected == null || checkboxesSelected.length == 0) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"No trays selected");
                        UserMessage message = new UserMessage(0, "pool.creation.notraysselected");
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", message);
                        this.saveUserMessages(argReq, messages);
                        this.updateWizard(argReq, 2, null);
                        return argMapping.findForward("page2");
                    }
                    boolean isVariable = "variable".equals(form.getSelectedProfileObject().getNumberOfDrives());
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("Is profile variable = " + isVariable));
                    ArrayList<PoolBreakdownForTray> breakdowns = new ArrayList<PoolBreakdownForTray>();
                    try {
                        List traysForProfile = form.getTraysForProfile();
                        for (int i = 0; i < checkboxesSelected.length; ++i) {
                            boolean hotspareValue;
                            int selectedIndex = Integer.parseInt(checkboxesSelected[i]);
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)("selected index = " + selectedIndex));
                            TrayForProfile trayOkForProfile = (TrayForProfile)traysForProfile.get(selectedIndex);
                            int numberOfPoolsToCreate = Integer.parseInt(allpools[selectedIndex]);
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)("number of pools to create = " + numberOfPoolsToCreate));
                            boolean bl = hotspareValue = form.getSelectedProfileObject().getDedicatedHotSpare() == 1;
                            if (!isDedicatedSupported) {
                                int hotspareSelection = Integer.parseInt(allhotspares[selectedIndex]);
                                hotspareValue = hotspareSelection == 1;
                                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Use Hot SPARE SELECTION since dedicated is not supported: " + hotspareSelection));
                            }
                            int disksToAssign = Integer.parseInt(alldisks[selectedIndex]);
                            if (!isVariable) {
                                disksToAssign *= numberOfPoolsToCreate;
                            }
                            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Get breakdown for (" + disksToAssign + ") disks"));
                            PoolBreakdownForTray breakdownObj = trayOkForProfile.getTray().getPoolBreakdownForTray(numberOfPoolsToCreate, disksToAssign, form.getSelectedProfileObject().getRaidLevel(), hotspareValue);
                            breakdowns.add(breakdownObj);
                        }
                        form.setPoolBreakdowns(breakdowns);
                        return this.validateAndForwardBreakdowns(argReq, argMapping, breakdowns, 2);
                    }
                    catch (IndexOutOfBoundsException ibe) {
                        Trace.verbose((Object)((Object)this), (String)"Error trying to get input values", (Throwable)ibe);
                        break;
                    }
                }
                case 3: {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Process input for page 3");
                    List poolBreakdowns = form.getPoolBreakdowns();
                    Enumeration e = argReq.getParameterNames();
                    while (e.hasMoreElements()) {
                        String str = (String)e.nextElement();
                        String value = argReq.getParameter(str);
                        if (str.indexOf("poolName") == -1) continue;
                        int trayIdIndex = str.indexOf("_") + 1;
                        int poolNumIndex = str.lastIndexOf("_") + 1;
                        String trayId = str.substring(trayIdIndex, poolNumIndex - 1);
                        int poolNumber = Integer.parseInt(str.substring(poolNumIndex));
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Tray ids to set pool names for = " + trayId));
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)("pool number to set pool names for = " + poolNumber));
                        Iterator it = poolBreakdowns.iterator();
                        while (it.hasNext()) {
                            PoolBreakdownForTray pb = (PoolBreakdownForTray)it.next();
                            if (!pb.getTrayId().equals(trayId)) continue;
                            pb.setSuggestedName(poolNumber, value);
                        }
                    }
                    return this.validateAllNewPoolNames(argReq, argMapping, poolBreakdowns, pageNum);
                }
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)((Object)this), (String)"Exception processing input", (Throwable)ex);
        }
        ActionForward actionForward = this.handleWizardErrors(argReq, argMapping, messages, pageNum);
        return actionForward;
    }

    public ActionForward finishWizard(int lastPage, String argAction, ActionMapping argMapping, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argResp) throws IOException, ServletException {
        String methodName = "finishWizard";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        return this.handlePoolCreation(lastPage, argReq, argMapping, (PoolCreateForm)argForm);
    }
}

