/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.admin.business.ArrayRegistration;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageMgmtCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.ArrayRegistrationForm;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ChangePasswordAction
extends StorageMgmtCoreAction {
    private static final String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String methodName = "doAction";
        Trace.constructor((Object)((Object)this));
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        String action = argAction == null ? "show" : argAction;
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Path = " + path));
        T4s t4s = null;
        try {
            ArrayRegistrationForm form = (ArrayRegistrationForm)argForm;
            if ("change".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Change Password Action");
                if (t4s == null) {
                    t4s = (T4s)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.T4s");
                }
                action = this.handleChangePassword(argReq, form, t4s);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("action after change password = " + action));
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"General exception in doAction", (Throwable)e);
        }
        finally {
            t4s = null;
        }
        return this.doForward(argReq, action, argMap);
    }

    public String handleChangePassword(HttpServletRequest argReq, ArrayRegistrationForm form, T4s t4s) {
        String methodName = "handleChangePassword";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        String action = "show";
        try {
            ArrayRegistration currentReg = form.getCurrentArrayReg();
            String oldPassword = form.getOldPassword();
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Old password = " + oldPassword));
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to change password to " + form.getRootPassword()));
            if (!t4s.isPasswordValid(this.getConfigContext(argReq), form.getCorrespondingT4(), oldPassword)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"Old password was invalid; unable to change password");
                throw new BadParameterException(oldPassword, "error.array.password.invalid");
            }
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"Old password is valid; ok to change password");
            t4s.changePassword(this.getConfigContext(argReq), null, currentReg, form.getRootPassword());
            action = "change";
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.change.password.success"));
            this.saveUserMessages(argReq, messages);
        }
        catch (ItemNotFoundException infe) {
            Trace.verbose((Object)((Object)this), (String)"ItemNotFoundException trying to change reg password", (Throwable)infe);
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "error.account.invalidIPAddress"));
            this.saveUserMessages(argReq, messages);
        }
        catch (BadParameterException bpe) {
            Trace.verbose((Object)((Object)this), (String)"BadParamException trying to change reg password", (Throwable)bpe);
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, bpe.getMessage(), bpe.getBadParameter()));
            this.saveUserMessages(argReq, messages);
        }
        catch (Exception ex) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to change reg password", (Throwable)ex);
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.change.password.error"));
            this.saveUserMessages(argReq, messages);
        }
        return action;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getBreadCrumbName";
        return "storage.mgmt.edit.array.reg.chgpassword.button";
    }
}

