/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.admin.business.ArrayRegistration;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.ui.business.T4s;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageMgmtCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.ArrayRegistrationForm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ArrayRegistrationAction
extends StorageMgmtCoreAction {
    private static final String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String action;
        block18: {
            String methodName = "doAction";
            HttpSession session = argReq.getSession();
            Trace.constructor((Object)((Object)this));
            Trace.methodBegin((Object)((Object)this), (String)methodName);
            action = argAction == null ? "show" : argAction;
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
            String path = argReq.getServletPath();
            T4s t4s = null;
            Object health = null;
            Object product = null;
            try {
                ArrayRegistrationForm form = (ArrayRegistrationForm)argForm;
                if ("show".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"ArrayRegistration SHOW");
                    if ("/root.menu.item0arrayreg.do".equals(path)) {
                        Trace.verbose((Object)((Object)this), (String)methodName, (String)"Show listing path");
                        form.doReset();
                        if (t4s == null) {
                            t4s = (T4s)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.T4s");
                        }
                        try {
                            List registeredArrays = t4s.listRegistration(this.getConfigContext(argReq), null);
                            if (registeredArrays != null) {
                                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Got arrays = " + registeredArrays.size()));
                                form.setRegisteredArrays(registeredArrays);
                            }
                            break block18;
                        }
                        catch (Exception e) {
                            Trace.verbose((Object)((Object)this), (String)"Exception getting registered arrays", (Throwable)e);
                        }
                        break block18;
                    }
                    if (!"/root.menu.item0.item3rmvregconfirm.do".equals(path)) break block18;
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Confirm reg removal");
                    try {
                        this.handleRemoveConfirmation(argReq, argForm);
                        break block18;
                    }
                    catch (Exception ex) {
                        UserMessages messages = new UserMessages();
                        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, ex.getMessage()));
                        this.saveUserMessages(argReq, messages);
                        action = "back";
                        ActionForward actionForward = this.doForward(argReq, action, argMap);
                        t4s = null;
                        return actionForward;
                    }
                }
                if ("create".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Create action");
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"New array reg: ");
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("ip addr = " + form.getIPAddress()));
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("root password = " + form.getRootPassword()));
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)("verified pass = " + form.getVerifiedPassword()));
                    if (t4s == null) {
                        t4s = (T4s)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.T4s");
                    }
                    this.handleCreate(argReq, form, t4s);
                    argReq.getSession().removeAttribute("T4List");
                } else if ("remove".equals(action)) {
                    Trace.verbose((Object)((Object)this), (String)methodName, (String)"Final Remove ");
                    this.handleRemoveAction(argForm, argReq);
                    argReq.getSession().removeAttribute("T4List");
                }
            }
            catch (Exception e) {
                Trace.verbose((Object)((Object)this), (String)"General exception in doAction", (Throwable)e);
            }
            finally {
                t4s = null;
            }
        }
        return this.doForward(argReq, action, argMap);
    }

    public void handleCreate(HttpServletRequest argReq, ArrayRegistrationForm form, T4s t4s) {
        String methodName = "handleCreate";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        try {
            t4s.createRegistration(this.getConfigContext(argReq), null, form.getIPAddress(), form.getRootPassword(), form.getPersistPassword());
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.new.array.reg.success"));
            this.saveUserMessages(argReq, messages);
        }
        catch (BadParameterException bpe) {
            Trace.verbose((Object)((Object)this), (String)"Invalid registration data", (Throwable)bpe);
            this.setMessage(argReq, bpe.getMessage(), 0);
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext((Object)"ConfigMgmtException trying to create reg");
            cme.addExceptionContext((Object)form);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            if (cme.getExceptionKey() == "INVALID_STORAGE_ARRAY_PASSWORD_EXCEPTION") {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"INVALID_STORAGE_ARRAY_PASSWORD_EXCEPTION key");
                this.setMessage(argReq, "storage.mgmt.new.array.reg.error.invalidpasswd", 0);
            } else if (cme.getExceptionKey() == "array.already.exists") {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"array already exists exception key");
                this.setMessage(argReq, "storage.mgmt.new.array.reg.error.duplicate", 0);
            } else {
                this.setMessage(argReq, "storage.mgmt.new.array.reg.error", 0);
            }
        }
        catch (Exception ex) {
            ConfigMgmtException cme = new ConfigMgmtException(ex);
            cme.addExceptionContext((Object)"General exception trying to create reg");
            cme.addExceptionContext((Object)form);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.setMessage(argReq, "storage.mgmt.new.array.reg.error", 0);
        }
    }

    private void setMessage(HttpServletRequest argReq, String message, int type) {
        UserMessages messages = new UserMessages();
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(type, message));
        this.saveUserMessages(argReq, messages);
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getBreadCrumbName";
        String path = argReq.getServletPath();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Path = " + path));
        if ("/root.menu.item0.item3registernew.do".equals(path)) {
            return "storage.mgmt.new.array.reg";
        }
        if ("/root.menu.item0.item3rmvregconfirm.do".equals(path)) {
            return "storage.mgmt.remove.reg.crumb";
        }
        return "main.menu.array.reg.button";
    }

    private void handleRemoveConfirmation(HttpServletRequest argReq, ActionForm argForm) throws Exception {
        String methodName = "handleRemoveConfirmation";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        int[] intSelections = this.getSelectedIndices(argReq, "selectedIndices");
        if (intSelections == null || intSelections.length <= 0) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"No items selected!");
            throw new Exception("error.none.selected");
        }
        List arrayList = ((ArrayRegistrationForm)argForm).getRegisteredArrays();
        if (arrayList == null) {
            throw new Exception("storage.mgmt.new.array.reg.nomatch");
        }
        ArrayList<ArrayRegistration> arraysToRemove = new ArrayList<ArrayRegistration>();
        for (int i = 0; i < intSelections.length; ++i) {
            ArrayRegistration arrayToRmv = (ArrayRegistration)arrayList.get(intSelections[i]);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to remove array = " + arrayToRmv.getIPAddress()));
            arraysToRemove.add(arrayToRmv);
        }
        ((ArrayRegistrationForm)argForm).setRemovals(arraysToRemove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoveAction(ActionForm argForm, HttpServletRequest argReq) {
        String methodName = "handleRemoveAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        T4s t4BusObj = null;
        try {
            t4BusObj = (T4s)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.T4s");
            List removals = ((ArrayRegistrationForm)argForm).getRemovals();
            t4BusObj.removeRegistration(this.getConfigContext(argReq), removals);
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "storage.mgmt.remove.success"));
            this.saveUserMessages(argReq, messages);
        }
        catch (Exception cme) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to remove array from reg.", (Throwable)cme);
            UserMessages messages = new UserMessages();
            messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, "storage.mgmt.remove.error"));
            this.saveUserMessages(argReq, messages);
        }
        finally {
            t4BusObj = null;
        }
    }
}

