/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfiles;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.StorageMgmtCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.PoolForm;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ApplyDifferentProfileAction
extends StorageMgmtCoreAction {
    private static final String MENU_SUB_ITEM = ".item0";

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        HttpSession session = argReq.getSession();
        String action = argAction == null ? "show" : argAction;
        String methodName = "doAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        StoragePools poolBusObj = null;
        String path = argReq.getServletPath();
        try {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
            if (poolBusObj == null) {
                poolBusObj = (StoragePools)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.StoragePools");
            }
            if ("show".equals(action)) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"SHOW ACTION");
                this.handleShowAction(argReq, argForm);
            } else if ("save".equals(action)) {
                StorageProfile selectedProfile = this.getSelectedProfile(argReq, argForm);
                Trace.verbose((Object)((Object)this), (String)methodName, (String)("Trying to change profile to = " + selectedProfile.getName()));
                try {
                    poolBusObj.applyDifferentProfile(this.getConfigContext(argReq), this.getCurrentT4(argReq), ((PoolForm)argForm).getDetailedPool(), selectedProfile);
                    this.handlePoolListing(argReq);
                    this.saveSingleUserMessage(argReq, 2, "pool.details.applydiff.success");
                }
                catch (Exception ex) {
                    Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(ex));
                    this.saveSingleUserMessage(argReq, 0, "pool.details.applydiff.failure");
                    action = "show";
                }
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"General Exception in doAction", (Throwable)e);
            this.handleSystemError(argReq, e);
        }
        return this.doForward(argReq, action, argMap);
    }

    protected void handleShowAction(HttpServletRequest argReq, ActionForm argForm) throws CoreUIBusException, ConfigMgmtException {
        String methodName = "handleShowAction";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        RaidGroupInterface detailedPool = ((PoolForm)argForm).getDetailedPool();
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("Tyring to get non destructive profiles for pool = " + detailedPool.getName()));
        List allProfiles = ManageStorageProfiles.getInstance().getNonDestructiveProfilesForPool(detailedPool, this.getCurrentT4(argReq));
        if (allProfiles != null && !allProfiles.isEmpty()) {
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("Got (" + allProfiles.size() + ") destructive profiles"));
            argReq.getSession().setAttribute("NonDestructiveProfiles", (Object)allProfiles);
        } else {
            argReq.getSession().removeAttribute("NonDestructiveProfiles");
        }
    }

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        return "pool.details.applydiffprofile.button";
    }

    protected StorageProfile getSelectedProfile(HttpServletRequest argReq, ActionForm argForm) {
        String methodName = "getSelectedProfile";
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        StorageProfile selectedProfile = null;
        try {
            List allPools = (List)argReq.getSession().getAttribute("NonDestructiveProfiles");
            if (allPools == null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"No pool in session; trying to get pools list from backend");
                allPools = ManageStorageProfiles.getInstance().getNonDestructiveProfilesForPool(((PoolForm)argForm).getDetailedPool(), this.getCurrentT4(argReq));
            }
            String selectedIndexStr = argReq.getParameter("profileindex");
            Trace.verbose((Object)((Object)this), (String)methodName, (String)("selected profile index = " + selectedIndexStr));
            try {
                int idx = Integer.parseInt(selectedIndexStr);
                selectedProfile = (StorageProfile)allPools.get(idx);
            }
            catch (NumberFormatException nfe) {
                Trace.verbose((Object)((Object)this), (String)"Exception trying to get selected profile", (Throwable)nfe);
            }
        }
        catch (Exception ex) {
            Trace.verbose((Object)((Object)this), (String)"Exception trying to get the selected profile", (Throwable)ex);
        }
        return selectedProfile;
    }
}

