/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.admin.business.SystemTimeAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.AdminCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.AdminSystemTimeForm;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class AdminSystemTimeAction
extends AdminCoreAction {
    static String MENU_SUB_ITEM_MR3 = ".item2";
    static String MENU_SUB_ITEM_M1M2 = ".item0.m1m2";
    static String PRIVATE_SAVE_TIME_FAILED_STRING = "PRIVATE_SAVE_TIME_FAILED_STRING";

    protected String getMenuSubItemId() {
        switch (Repository.getRepository().getConfigInteger()) {
            case 1: 
            case 2: {
                return MENU_SUB_ITEM_M1M2;
            }
            case 3: {
                return MENU_SUB_ITEM_MR3;
            }
        }
        return MENU_SUB_ITEM_MR3;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        boolean isM1M2;
        boolean isTimeZonePage = argReq.getRequestURI().indexOf("timezone") != -1;
        boolean bl = isM1M2 = Repository.getRepository().getConfigInteger() < 3;
        String bc = isTimeZonePage ? MenuData.ROOT_MENU + this.getMenuItemId() + this.getMenuSubItemId() + ".timezone" : (isM1M2 ? MenuData.ROOT_MENU + this.getMenuItemId() + this.getMenuSubItemId() + ".time" : MenuData.ROOT_MENU + this.getMenuItemId() + this.getMenuSubItemId());
        Trace.verbose((Object)((Object)this), (String)"getBreadCrumbName", (String)("the bread crumb is " + bc));
        return bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        HttpSession session = argReq.getSession();
        AdminSystemTimeForm systemTimeForm = (AdminSystemTimeForm)argForm;
        ConfigContext configContext = this.getConfigContext(argReq);
        String action = argAction == null ? "show" : argAction;
        String failureKey = null;
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("action is " + action));
        Admin adminBusObj = new Admin();
        UserMessages messages = new UserMessages();
        T4Interface theT4 = null;
        String arrayName = null;
        String timeValueBeforeSave = null;
        boolean isMR3 = Repository.getRepository().getConfigInteger() >= 3;
        boolean ntpWasEnabled = false;
        try {
            SystemTimeAdminInterface systemTimeInterface = adminBusObj.getSystemTimeAdminInterface(configContext);
            if (!isMR3) {
                theT4 = argReq.getParameter("index") != null ? this.getSelectedT4(argReq) : this.getCurrentT4(argReq);
                arrayName = theT4.getName();
                systemTimeInterface.setScope((InstanceWrapper)theT4);
                systemTimeInterface.init(configContext);
                action = this.handlePasswordPrompt(action, argForm, argReq);
                Trace.verbose((Object)((Object)this), (String)"doAction", (String)("Action after handle pass = " + action));
            }
            if (!"prompt_password".equals(action)) {
                ntpWasEnabled = systemTimeInterface.getUseNTPServer();
            }
            if ("save".equals(action)) {
                failureKey = PRIVATE_SAVE_TIME_FAILED_STRING;
                timeValueBeforeSave = systemTimeForm.getCurrentTime();
                action = this.handleSaveAction(argReq, systemTimeForm, messages, systemTimeInterface, arrayName, ntpWasEnabled);
                systemTimeInterface = adminBusObj.getSystemTimeAdminInterface(configContext);
                if (!isMR3) {
                    systemTimeInterface.setScope((InstanceWrapper)theT4);
                    systemTimeInterface.init(configContext);
                }
            } else if ("savetimezone".equals(action)) {
                failureKey = isMR3 ? "SP_TIME_ZONE_SET_FAILED" : "ARRAY_TIME_ZONE_SET_FAILED";
                action = this.handleSaveTimeZone(argReq, systemTimeForm, messages, arrayName, systemTimeInterface);
                systemTimeInterface = adminBusObj.getSystemTimeAdminInterface(configContext);
                if (!isMR3) {
                    systemTimeInterface.setScope((InstanceWrapper)theT4);
                    systemTimeInterface.init(configContext);
                }
            } else if ("showtimezone".equals(action)) {
                systemTimeForm.setCurrentTimeZone(systemTimeForm.getCurrentTimeZone(), argReq, this.getLocale(argReq));
            } else if ("changeoffset".equals(action)) {
                systemTimeForm.setTimeZoneOffset(argReq, systemTimeForm.getTimeZoneOffset());
            }
            if ("show".equals(action)) {
                this.handleShowPage(argReq, systemTimeForm, systemTimeInterface);
            }
        }
        catch (ParseException pe) {
            ActionErrors ae = new ActionErrors();
            ae.add("time", new ActionError("error.admin.systemtime.timeformat"));
            this.saveErrors(argReq, ae);
        }
        catch (BadParameterException bpe) {
            this.reportError(argReq, bpe.getMessage());
        }
        catch (ConfigMgmtException e) {
            this.logFailure(e.getExceptionKey(), failureKey, systemTimeForm, ntpWasEnabled, arrayName, timeValueBeforeSave);
            e.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)e);
            this.handleSystemError(argReq, e);
        }
        catch (CoreUIBusException e) {
            ConfigMgmtException cme = new ConfigMgmtException((Exception)e);
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, e);
        }
        catch (Exception e) {
            ConfigMgmtException cme = new ConfigMgmtException(e);
            cme.addExceptionContext((Object)argForm);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, e);
        }
        return this.doForward(argReq, action, argMap);
    }

    protected void logFailure(String exceptionKey, String failureKey, AdminSystemTimeForm systemTimeForm, boolean ntpWasEnabled, String arrayName, String timeValueBeforeSave) {
        String[] args = new String[2];
        String logMsg = exceptionKey;
        if (PRIVATE_SAVE_TIME_FAILED_STRING.equals(failureKey)) {
            this.logSaveTime(false, systemTimeForm, arrayName, ntpWasEnabled);
        } else {
            if ("SP_TIME_ZONE_SET_FAILED".equals(failureKey)) {
                args[0] = systemTimeForm.getTimeZoneID();
                logMsg = "SP_TIME_ZONE_SET_FAILED";
            } else if ("ARRAY_TIME_ZONE_SET_FAILED".equals(failureKey)) {
                args[0] = systemTimeForm.getTimeZoneID();
                args[1] = arrayName;
                logMsg = "ARRAY_TIME_ZONE_SET_FAILED";
            }
            LogAPI.staticLog((String)logMsg, (String[])args, (String[])new String[0]);
        }
    }

    protected String handleSaveAction(HttpServletRequest argReq, AdminSystemTimeForm systemTimeForm, UserMessages messages, SystemTimeAdminInterface systemTimeInterface, String arrayName, boolean ntpWasEnabled) throws ParseException, ConfigMgmtException, BadParameterException {
        this.saveSetValuesFromForm(argReq, systemTimeForm, systemTimeInterface);
        systemTimeInterface.save();
        systemTimeInterface.reload();
        String action = "show";
        this.logSaveTime(true, systemTimeForm, arrayName, ntpWasEnabled);
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "admin.systemtime.timesettingssaved"));
        this.saveUserMessages(argReq, messages);
        return action;
    }

    protected void logSaveTime(boolean success, AdminSystemTimeForm systemTimeForm, String arrayName, boolean ntpWasEnabled) {
        String logMsg = null;
        String[] args = new String[6];
        if (systemTimeForm.getUseNTPServer().booleanValue()) {
            args[0] = systemTimeForm.getNtpServerIp();
            if (arrayName != null) {
                logMsg = success ? "ARRAY_TIME_NTP_ENABLED" : "ARRAY_TIME_NTP_ENABLED_ERROR";
                args[1] = arrayName;
            } else {
                logMsg = success ? "SP_TIME_NTP_ENABLED" : "SP_TIME_NTP_ENABLED_ERROR";
            }
            LogAPI.staticLog((String)logMsg, (String[])args, (String[])new String[0]);
        } else {
            if (ntpWasEnabled) {
                if (arrayName != null) {
                    logMsg = success ? "ARRAY_TIME_NTP_DISABLED" : "ARRAY_TIME_NTP_DISABLED_ERROR";
                    args[0] = arrayName;
                } else {
                    logMsg = success ? "SP_TIME_NTP_DISABLED" : "SP_TIME_NTP_DISABLED_ERROR";
                }
                LogAPI.staticLog((String)logMsg, (String[])args, (String[])new String[0]);
            }
            if (arrayName != null) {
                args[0] = systemTimeForm.getMonth();
                args[1] = systemTimeForm.getDay();
                args[2] = systemTimeForm.getYear();
                args[3] = systemTimeForm.getTime();
                args[4] = systemTimeForm.getTimeZoneID();
                try {
                    DateFormat dateFormat = DateFormat.getTimeInstance(3);
                    Date newDate = dateFormat.parse(args[3]);
                    args[3] = new SimpleDateFormat("HH:mm").format(newDate);
                    TimeZone tz = TimeZone.getTimeZone(systemTimeForm.getTimeZoneID());
                    args[4] = tz.getDisplayName(tz.inDaylightTime(newDate), 0);
                }
                catch (Exception e) {
                    // empty catch block
                }
                logMsg = success ? "ARRAY_TIME_TIME_SET" : "ARRAY_TIME_SET_FAILED";
                args[5] = arrayName;
            } else {
                args[0] = this.getFormTimeString(systemTimeForm);
                logMsg = success ? "SP_TIME_TIME_SET" : "SP_TIME_TIME_SET_FAILED";
            }
            LogAPI.staticLog((String)logMsg, (String[])args, (String[])new String[0]);
        }
    }

    private String getFormTimeString(AdminSystemTimeForm systemTimeForm) {
        return systemTimeForm.getTime() + ", " + systemTimeForm.getMonth() + "-" + systemTimeForm.getDay() + "-" + systemTimeForm.getYear();
    }

    protected void saveSetValuesFromForm(HttpServletRequest argReq, AdminSystemTimeForm systemTimeForm, SystemTimeAdminInterface systemTimeInterface) throws ParseException, BadParameterException {
        systemTimeInterface.setUseNTPServer(systemTimeForm.getUseNTPServer());
        if (systemTimeForm.getUseNTPServer().booleanValue()) {
            if (!Validate.ipAddress((String)systemTimeForm.getNtpServerIp())) {
                throw new BadParameterException(systemTimeForm.getNtpServerIp(), "error.admin.general.ipaddressformat");
            }
            systemTimeInterface.setNtpServerIp(systemTimeForm.getNtpServerIp());
        } else {
            boolean isM1M2 = Repository.getRepository().getConfigInteger() < 3;
            Date newTime = Convert.fieldsToDateTime((String)systemTimeForm.getYear(), (String)systemTimeForm.getMonth(), (String)systemTimeForm.getDay(), (String)systemTimeForm.getTime(), (int)3, (Locale)this.getLocale(argReq), (TimeZone)(isM1M2 ? null : systemTimeInterface.getCurrentTimeZone()));
            systemTimeInterface.setTime(newTime);
            if (!isM1M2) {
                systemTimeForm.setDateTime(systemTimeInterface.getTime(), systemTimeInterface.getCurrentTimeZone(), this.getLocale(argReq));
            }
            systemTimeInterface.setCurrentTimeZone(systemTimeForm.getCurrentTimeZone());
        }
    }

    protected void handleShowPage(HttpServletRequest argReq, AdminSystemTimeForm systemTimeForm, SystemTimeAdminInterface systemTimeInterface) {
        systemTimeForm.setUseNTPServer(systemTimeInterface.getUseNTPServer());
        systemTimeForm.setNtpServerIp(systemTimeInterface.getNtpServerIp());
        Trace.verbose((Object)((Object)this), (String)"show", (String)("time is " + systemTimeInterface.getTime()));
        Trace.verbose((Object)((Object)this), (String)"show", (String)("timezone is " + systemTimeInterface.getCurrentTimeZone()));
        if (Repository.getRepository().getConfigInteger() < 3) {
            systemTimeForm.setDateTime(systemTimeInterface.getTime(), TimeZone.getDefault(), this.getLocale(argReq));
        } else {
            systemTimeForm.setDateTime(systemTimeInterface.getTime(), systemTimeInterface.getCurrentTimeZone(), this.getLocale(argReq));
        }
        systemTimeForm.setCurrentTimeZone(systemTimeInterface.getCurrentTimeZone(), argReq, this.getLocale(argReq));
    }

    protected String handleSaveTimeZone(HttpServletRequest argReq, AdminSystemTimeForm systemTimeForm, UserMessages messages, String arrayName, SystemTimeAdminInterface systemTimeInterface) throws ConfigMgmtException {
        String logMsg = null;
        String[] args = new String[2];
        String action = "savetimezone";
        TimeZone newTimeZone = TimeZone.getTimeZone(systemTimeForm.getTimeZoneID());
        Trace.verbose((Object)((Object)this), (String)"savetimezone", (String)("new timezone is " + newTimeZone));
        systemTimeInterface.setCurrentTimeZone(newTimeZone);
        Trace.verbose((Object)((Object)this), (String)"savetimezone", (String)"set time to null when updating only timezone!");
        systemTimeInterface.setTime(null);
        systemTimeInterface.save();
        systemTimeInterface.reload();
        if (Repository.getRepository().getConfigInteger() < 3) {
            logMsg = "ARRAY_TIME_ZONE_SET";
        } else {
            action = "show";
            logMsg = "SP_TIME_ZONE_SET";
            Repository.getRepository().setProperty((Object)"SPTimeZone", (Object)newTimeZone);
        }
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "admin.systemtime.timezonesaved"));
        args[0] = systemTimeForm.getTimeZoneID();
        args[1] = arrayName;
        LogAPI.staticLog((String)logMsg, (String[])args, (String[])new String[0]);
        this.saveUserMessages(argReq, messages);
        return action;
    }

    public void reportError(HttpServletRequest argReq, String errorMsgProp) {
        UserMessages messages = new UserMessages();
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(0, errorMsgProp));
        this.saveUserMessages(argReq, messages);
    }
}

