/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.ui.business.AdminReportComponent;
import com.sun.netstorage.array.mgmt.cfg.ui.business.AdminReports;
import com.sun.netstorage.array.mgmt.cfg.ui.business.M1M2AdminReports;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.AdminCoreAction;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class AdminReportsAction
extends AdminCoreAction {
    static String MENU_SUB_ITEM = ".item7";
    private static final String MR3_STYLE_SHEET = "report.xsl";
    private static final String MR12_STYLE_SHEET = "report-mr12.xsl";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        String methodName = "doAction";
        Trace.constructor((Object)((Object)this));
        Trace.methodBegin((Object)((Object)this), (String)methodName);
        HttpSession session = argReq.getSession();
        ConfigContext configContext = this.getConfigContext(argReq);
        String action = argAction == null ? "show" : argAction;
        Trace.verbose((Object)((Object)this), (String)methodName, (String)("action = " + action));
        AdminReports reportBizObject = null;
        String styleSheetName = null;
        if (Repository.getRepository().getConfigInteger() == 3) {
            reportBizObject = new AdminReports(argReq.getLocale());
            styleSheetName = MR3_STYLE_SHEET;
        } else {
            reportBizObject = new M1M2AdminReports(argReq.getLocale());
            styleSheetName = MR12_STYLE_SHEET;
        }
        AdminReportComponent report = null;
        String reportString = "";
        try {
            report = reportBizObject.buildReport(configContext, null, argReq.getLocale());
            Exception reportEx = report.getReportException();
            if (reportEx != null) {
                Trace.verbose((Object)((Object)this), (String)methodName, (String)"The report generated an exception");
                Trace.error((Object)((Object)this), (ConfigMgmtException)new ConfigMgmtException(reportEx));
                this.saveSingleUserMessage(argReq, 1, "admin.reports.create.warning");
            }
            String localizedXml = report.toLocalizedXml(argReq.getLocale());
            String xslRenderedReport = this._applyXslStylesheet(localizedXml, styleSheetName);
            Trace.verbose((Object)((Object)this), (String)methodName, (String)"XSL Stylesheet applied ok");
            reportString = xslRenderedReport.toString();
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"General doForward Exception", (Throwable)e);
            this.handleSystemError(argReq, e);
        }
        session.setAttribute("adminReport", (Object)reportString);
        return this.doForward(argReq, action, argMap);
    }

    private String _applyXslStylesheet(String xmlString, String xslSheetName) throws Exception {
        if (xmlString == null || xmlString.trim().equals("")) {
            return "";
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslSource = new StreamSource(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(xslSheetName));
        StreamSource xmlSource = new StreamSource(new StringReader(xmlString));
        Transformer transformer = factory.newTransformer(xslSource);
        StringWriter output = new StringWriter();
        transformer.transform(xmlSource, new StreamResult(output));
        return output.toString();
    }
}

