/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.actions;

import com.sun.netstorage.array.mgmt.cfg.admin.business.GeneralAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.ui.business.Admin;
import com.sun.netstorage.array.mgmt.cfg.ui.core.action.AdminCoreAction;
import com.sun.netstorage.array.mgmt.cfg.ui.core.business.CoreUIBusException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessage;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.UserMessages;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class AdminM3PowerConfirmAction
extends AdminCoreAction {
    static String MENU_SUB_ITEM = ".item0";

    protected String getMenuSubItemId() {
        return MENU_SUB_ITEM;
    }

    protected String getBreadCrumbName(HttpServletRequest argReq, ActionForm argForm) {
        return "admin.general.confirm.confirmbutton";
    }

    public ActionForward doAction(String argAction, ActionMapping argMap, ActionForm argForm, HttpServletRequest argReq, HttpServletResponse argRes) throws IOException, ServletException {
        Trace.methodBegin((Object)((Object)this), (String)"doAction");
        HttpSession session = argReq.getSession();
        boolean isFullShutdown = argReq.getRequestURI().indexOf("full") != -1;
        boolean isPartialShutdown = argReq.getRequestURI().indexOf("partial") != -1;
        ConfigContext configContext = this.getConfigContext(argReq);
        String action = argAction;
        if ("show".equals(action)) {
            action = null;
        }
        if (action == null && isFullShutdown) {
            action = "confirmfullshutdown";
        }
        if (action == null && isPartialShutdown) {
            action = "confirmpartialshutdown";
        }
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)("action=" + action));
        try {
            switch (Repository.getRepository().getConfigInteger()) {
                case 1: 
                case 2: {
                    action = "arrayselection";
                    return this.doForward(argReq, action, argMap);
                }
            }
            action = this.processInput(argForm, argReq, configContext, action);
        }
        catch (ConfigMgmtException e) {
            this.handleConfigMgmtExc(argReq, e);
        }
        catch (CoreUIBusException e) {
            ConfigMgmtException cme = new ConfigMgmtException((Exception)e);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, e);
        }
        catch (Exception e) {
            ConfigMgmtException cme = new ConfigMgmtException(e);
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            this.handleSystemError(argReq, e);
        }
        return this.doForward(argReq, action, argMap);
    }

    private String processInput(ActionForm argForm, HttpServletRequest argReq, ConfigContext configContext, String action) throws CoreUIBusException, IllegalAccessException, InvocationTargetException, ConfigMgmtException {
        Admin adminBusObj = (Admin)this.getUIBusinessObj(argReq, "com.sun.netstorage.array.mgmt.cfg.ui.business.Admin");
        GeneralAdminInterface adminInterface = adminBusObj.getGeneralAdminInterface(configContext);
        if ("fullshutdown".equals(action)) {
            this.doFullShutdown(argReq, adminInterface);
        } else if ("partialshutdown".equals(action)) {
            this.doPartialShutdown(argReq, adminInterface);
        } else if ("confirmfullshutdown".equals(action)) {
            String message = "admin.general.confirm.fullshutdownwarning";
            this.prepareConfirm(argReq, message);
        } else if ("confirmpartialshutdown".equals(action)) {
            String message = "admin.general.confirm.partialshutdownwarning";
            this.prepareConfirm(argReq, message);
        }
        return action;
    }

    protected void prepareConfirm(HttpServletRequest argReq, String message) {
        UserMessages messages = new UserMessages();
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(1, message));
        this.checkForActiveJobs(argReq, messages, null);
        this.checkForActiveUsers(argReq, messages);
        this.saveUserMessages(argReq, messages);
    }

    private void handleConfigMgmtExc(HttpServletRequest argReq, ConfigMgmtException e) {
        String exceptionKey = e.getExceptionKey();
        if ("POWER_SERVICE_FULL_SHUTDOWN_ERROR".equals(exceptionKey)) {
            LogAPI.staticLog((String)"POWER_SERVICE_FULL_SHUTDOWN_ERROR", (String[])new String[0], (String[])new String[0]);
        } else if ("POWER_SERVICE_PARTIAL_SHUTDOWN_ERROR".equals(exceptionKey)) {
            LogAPI.staticLog((String)"POWER_SERVICE_PARTIAL_SHUTDOWN_ERROR", (String[])new String[0], (String[])new String[0]);
        }
        this.handleSystemError(argReq, e);
    }

    protected void doFullShutdown(HttpServletRequest argReq, GeneralAdminInterface adminInterface) throws ConfigMgmtException {
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)"FullShutdown");
        adminInterface.fullShutDown();
        LogAPI.staticLog((String)"POWER_SERVICE_FULL_SHUTDOWN_INITIATED", (String[])new String[0], (String[])new String[0]);
        UserMessages messages = new UserMessages();
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "admin.general.fullshutdowndone"));
        this.saveUserMessages(argReq, messages);
    }

    protected void doPartialShutdown(HttpServletRequest argReq, GeneralAdminInterface adminInterface) throws ConfigMgmtException {
        Trace.verbose((Object)((Object)this), (String)"doAction", (String)"PartialShutdown");
        adminInterface.partialShutdown();
        LogAPI.staticLog((String)"POWER_SERVICE_PARTIAL_SHUTDOWN_INITIATED", (String[])new String[0], (String[])new String[0]);
        UserMessages messages = new UserMessages();
        messages.add("org.apache.struts.action.GLOBAL_ERROR", new UserMessage(2, "admin.general.partialshutdowndone"));
        this.saveUserMessages(argReq, messages);
    }
}

